/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.BaseLanguageModel;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ConfusionPair;
import org.languagetool.rules.ConfusionSetLoader;
import org.languagetool.rules.ConfusionString;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanSpellerRule;
import org.languagetool.tools.StringTools;

public class ProhibitedCompoundRule
extends Rule {
    public static final String RULE_ID = "DE_PROHIBITED_COMPOUNDS";
    private static final List<Pair> lowercasePairs = Arrays.asList(new Pair("traum", "Erleben w\u00e4hrend des Schlafes", "trauma", "Verletzung"), new Pair("name", "Bezeichnung (z.B. 'Vorname')", "nahme", "zu 'nehmen' (z.B. 'Teilnahme')"), new Pair("bart", "Haarbewuchs im Gesicht", "dart", "Wurfpfeil"), new Pair("hart", "fest", "dart", "Wurfpfeil"), new Pair("speiche", "Verbindung zwischen Nabe und Felge beim Rad", "speicher", "Lagerraum"), new Pair("speichen", "Verbindung zwischen Nabe und Felge beim Rad", "speicher", "Lagerraum"), new Pair("kart", "Gokart (Fahrzeug)", "karte", "Fahrkarte, Postkarte, Landkarte, ..."), new Pair("karts", "Kart = Gokart (Fahrzeug)", "karte", "Fahrkarte, Postkarte, Landkarte, ..."), new Pair("kurz", "Gegenteil von 'lang'", "kur", "medizinische Vorsorge und Rehabilitation"), new Pair("kiefer", "kn\u00f6cherner Teil des Sch\u00e4dels", "kiefern", "Kieferngew\u00e4chse (Baum)"), new Pair("gel", "dickfl\u00fcssige Masse", "geld", "Zahlungsmittel"), new Pair("flucht", "Entkommen, Fliehen", "frucht", "Ummantelung des Samens einer Pflanze"), new Pair("kamp", "Flurname f\u00fcr ein St\u00fcck Land", "kampf", "Auseinandersetzung"), new Pair("obst", "Frucht", "ost", "Himmelsrichtung"), new Pair("beeren", "Fr\u00fcchte", "b\u00e4ren", "Raubtiere"), new Pair("laus", "Insekt", "lauf", "Bewegungsart"), new Pair("l\u00e4use", "Insekt", "l\u00e4ufe", "Bewegungsart"), new Pair("l\u00e4usen", "Insekt", "l\u00e4ufen", "Bewegungsart"), new Pair("ruck", "pl\u00f6tzliche Bewegung", "druck", "Belastung"), new Pair("br\u00fcste", "Plural von Brust", "b\u00fcrste", "Ger\u00e4t mit Borsten, z.B. zum Reinigen"), new Pair("attraktion", "Sehensw\u00fcrdigkeit", "akttaktion", "vermutlicher Tippfehler"), new Pair("nah", "zu 'nah' (wenig entfernt)", "n\u00e4h", "zu 'n\u00e4hen' (mit einem Faden verbinden)"), new Pair("turn", "zu 'turnen'", "turm", "hohes Bauwerk"), new Pair("mit", "Pr\u00e4position", "miet", "zu 'Miete' (\u00dcberlassung gegen Bezahlung)"), new Pair("bart", "Behaarung im Gesicht", "brat", "zu 'braten', z.B. 'Bratkartoffel'"), new Pair("uhr", "Instrument zur Zeitmessung", "ur", "urspr\u00fcnglich"), new Pair("abschluss", "Ende", "abschuss", "Vorgang des Abschie\u00dfens, z.B. mit einer Waffe"), new Pair("brache", "verlassenes Grundst\u00fcck", "branche", "Wirtschaftszweig"), new Pair("wieder", "erneut, wiederholt, nochmal (Wiederholung, Wiedervorlage, ...)", "wider", "gegen, entgegen (Widerwille, Widerstand, Widerspruch, ...)"), new Pair("leer", "ohne Inhalt", "lehr", "bezogen auf Ausbildung und Wissen"), new Pair("gewerbe", "wirtschaftliche T\u00e4tigkeit", "gewebe", "gewebter Stoff; Verbund \u00e4hnlicher Zellen"), new Pair("schuh", "Fu\u00dfbekleidung", "schul", "auf die Schule bezogen"), new Pair("klima", "langfristige Wetterzust\u00e4nde", "lima", "Hauptstadt von Peru"), new Pair("modell", "vereinfachtes Abbild der Wirklichkeit", "model", "Fotomodell"), new Pair("treppen", "Folge von Stufen (Mehrzahl)", "truppen", "Armee oder Teil einer Armee (Mehrzahl)"), new Pair("h\u00e4ufigkeit", "Anzahl von Ereignissen", "h\u00e4utigkeit", "z.B. in Dunkelh\u00e4utigkeit"), new Pair("hin", "in Richtung", "hirn", "Gehirn, Denkapparat"), new Pair("verkl\u00e4rung", "Besch\u00f6nigung, Darstellung in einem besseren Licht", "erkl\u00e4rung", "Darstellung, Erl\u00e4uterung"), new Pair("spitze", "spitzes Ende eines Gegenstandes", "spritze", "medizinisches Instrument zur Injektion"), new Pair("punk", "Jugendkultur", "punkt", "Satzzeichen"), new Pair("reis", "Nahrungsmittel", "eis", "gefrorenes Wasser"), new Pair("balkan", "Region in S\u00fcdosteuropa", "balkon", "Plattform, die aus einem Geb\u00e4ude herausragt"), new Pair("haft", "Freiheitsentzug", "schaft", "-schaft (Element zur Wortbildung)"), new Pair("stande", "zu 'Stand'", "stange", "l\u00e4nglicher Gegenstand"));
    public static final GermanyGerman german = new GermanyGerman();
    private static GermanSpellerRule spellerRule;
    private static LinguServices linguServices;
    private static final List<String> ignoreWords;
    private static final List<String> blacklistRegex;
    private static final Set<String> blacklist;
    protected AhoCorasickDoubleArrayTrie<String> ahoCorasickDoubleArrayTrie;
    protected Map<String, List<Pair>> pairMap;
    private static final AhoCorasickDoubleArrayTrie<String> prohibitedCompoundRuleSearcher;
    private static final Map<String, List<Pair>> prohibitedCompoundRulePairMap;
    private final BaseLanguageModel lm;
    private Pair confusionPair = null;

    private static void addAllCaseVariants(List<Pair> candidatePairs, Pair lcPair) {
        candidatePairs.add(new Pair(lcPair.part1, lcPair.part1Desc, lcPair.part2, lcPair.part2Desc));
        String ucPart1 = StringTools.uppercaseFirstChar((String)lcPair.part1);
        String ucPart2 = StringTools.uppercaseFirstChar((String)lcPair.part2);
        if (!lcPair.part1.equals(ucPart1) || !lcPair.part2.equals(ucPart2)) {
            candidatePairs.add(new Pair(ucPart1, lcPair.part1Desc, ucPart2, lcPair.part2Desc));
        }
    }

    private static void addUpperCaseVariants(List<Pair> pairs) {
        for (Pair lcPair : lowercasePairs) {
            if (StringTools.startsWithUppercase((String)lcPair.part1)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part1);
            }
            if (StringTools.startsWithUppercase((String)lcPair.part2)) {
                throw new IllegalArgumentException("Use all-lowercase word in " + ProhibitedCompoundRule.class + ": " + lcPair.part2);
            }
            ProhibitedCompoundRule.addAllCaseVariants(pairs, lcPair);
        }
    }

    protected static void addItemsFromConfusionSets(List<Pair> pairs, String confusionSetsFile, boolean isUpperCase) {
        try {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            try (InputStream confusionSetStream = dataBroker.getFromResourceDirAsStream(confusionSetsFile);){
                ConfusionSetLoader loader = new ConfusionSetLoader((Language)german);
                Map confusionPairs = loader.loadConfusionPairs(confusionSetStream);
                for (Map.Entry entry : confusionPairs.entrySet()) {
                    for (ConfusionPair pair : (List)entry.getValue()) {
                        boolean allUpper = pair.getTerms().stream().allMatch(k -> StringTools.startsWithUppercase((String)k.getString()) && !ignoreWords.contains(k.getString()));
                        if (!allUpper && isUpperCase) continue;
                        List cSet = pair.getTerms();
                        if (cSet.size() != 2) {
                            throw new RuntimeException("Got confusion set with != 2 items: " + cSet);
                        }
                        Iterator it = cSet.iterator();
                        ConfusionString part1 = (ConfusionString)it.next();
                        ConfusionString part2 = (ConfusionString)it.next();
                        pairs.add(new Pair(part1.getString(), part1.getDescription(), part2.getString(), part2.getDescription()));
                        if (isUpperCase) {
                            pairs.add(new Pair(StringTools.lowercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.lowercaseFirstChar((String)part2.getString()), part2.getDescription()));
                            continue;
                        }
                        pairs.add(new Pair(StringTools.uppercaseFirstChar((String)part1.getString()), part1.getDescription(), StringTools.uppercaseFirstChar((String)part2.getString()), part2.getDescription()));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected static AhoCorasickDoubleArrayTrie<String> setupAhoCorasickSearch(List<Pair> pairs, Map<String, List<Pair>> pairMap) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Pair pair : pairs) {
            map.put(pair.part1, pair.part1);
            map.put(pair.part2, pair.part2);
            pairMap.putIfAbsent(pair.part1, new LinkedList());
            pairMap.putIfAbsent(pair.part2, new LinkedList());
            pairMap.get(pair.part1).add(pair);
            pairMap.get(pair.part2).add(pair);
        }
        AhoCorasickDoubleArrayTrie ahoCorasickDoubleArrayTrie = new AhoCorasickDoubleArrayTrie();
        ahoCorasickDoubleArrayTrie.build(map);
        return ahoCorasickDoubleArrayTrie;
    }

    public ProhibitedCompoundRule(ResourceBundle messages, LanguageModel lm, UserConfig userConfig) {
        super(messages);
        this.lm = (BaseLanguageModel)Objects.requireNonNull(lm);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.ahoCorasickDoubleArrayTrie = prohibitedCompoundRuleSearcher;
        this.pairMap = prohibitedCompoundRulePairMap;
        linguServices = userConfig != null ? userConfig.getLinguServices() : null;
        spellerRule = linguServices == null ? new GermanSpellerRule(JLanguageTool.getMessageBundle(), german, null, null) : null;
        this.addExamplePair(Example.wrong((String)"Da steht eine <marker>Lehrzeile</marker> zu viel."), Example.fixed((String)"Da steht eine <marker>Leerzeile</marker> zu viel."));
    }

    public String getId() {
        return RULE_ID;
    }

    public String getDescription() {
        return "Markiert wahrscheinlich falsche Komposita wie 'Lehrzeile', wenn 'Leerzeile' h\u00e4ufiger vorkommt.";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (AnalyzedTokenReadings readings : sentence.getTokensWithoutWhitespace()) {
            String tmpWord = readings.getToken();
            ArrayList<String> wordsParts = new ArrayList<String>(Arrays.asList(tmpWord.split("-")));
            int partsStartPos = 0;
            for (String wordPart : wordsParts) {
                partsStartPos = this.getMatches(sentence, ruleMatches, readings, partsStartPos, wordPart, 0);
            }
            String noHyphens = this.removeHyphensAndAdaptCase(tmpWord);
            if (noHyphens == null) continue;
            this.getMatches(sentence, ruleMatches, readings, 0, noHyphens, tmpWord.length() - noHyphens.length());
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isMisspelled(String word) {
        return linguServices == null ? spellerRule.isMisspelled(word) : !linguServices.isCorrectSpell(word, (Language)german);
    }

    private int getMatches(AnalyzedSentence sentence, List<RuleMatch> ruleMatches, AnalyzedTokenReadings readings, int partsStartPos, String wordPart, int toPosCorrection) {
        if (readings.isTagged() && !readings.hasPartialPosTag("SUB") && !readings.hasPosTagStartingWith("EIG:") || wordPart.length() <= 6) {
            return partsStartPos += wordPart.length() + 1;
        }
        ArrayList<Pair> candidatePairs = new ArrayList<Pair>();
        if (this.confusionPair == null) {
            List wordList = this.ahoCorasickDoubleArrayTrie.parseText((CharSequence)wordPart);
            for (AhoCorasickDoubleArrayTrie.Hit hit : wordList) {
                List<Pair> pair = this.pairMap.get(hit.value);
                if (pair == null) continue;
                candidatePairs.addAll(pair);
            }
        } else {
            ProhibitedCompoundRule.addAllCaseVariants(candidatePairs, this.confusionPair);
        }
        ArrayList<WeightedRuleMatch> weightedMatches = new ArrayList<WeightedRuleMatch>();
        for (Pair pair : candidatePairs) {
            String variant = null;
            if (wordPart.contains(pair.part1)) {
                variant = wordPart.replaceFirst(pair.part1, pair.part2);
            } else if (wordPart.contains(pair.part2)) {
                variant = wordPart.replaceFirst(pair.part2, pair.part1);
            }
            if (variant == null) {
                partsStartPos += wordPart.length() + 1;
                continue;
            }
            long wordCount = this.lm.getCount(wordPart);
            long variantCount = this.lm.getCount(variant);
            if (variantCount <= 0L || wordCount != 0L || blacklist.contains(wordPart) || this.isMisspelled(variant) || !blacklistRegex.stream().noneMatch(k -> wordPart.matches(".*" + k + ".*"))) continue;
            String msg = pair.part1Desc != null && pair.part2Desc != null ? "M\u00f6glicher Tippfehler. " + StringTools.uppercaseFirstChar((String)pair.part1) + ": " + pair.part1Desc + ", " + StringTools.uppercaseFirstChar((String)pair.part2) + ": " + pair.part2Desc : "M\u00f6glicher Tippfehler: " + pair.part1 + "/" + pair.part2;
            int fromPos = readings.getStartPos() + partsStartPos;
            int toPos = fromPos + wordPart.length() + toPosCorrection;
            String id = this.getId() + "_" + this.cleanId(pair.part1) + "_" + this.cleanId(pair.part2);
            RuleMatch match = new RuleMatch((Rule)new SpecificIdRule(id, pair.part1, pair.part2, this.messages, (LanguageModel)this.lm), sentence, fromPos, toPos, msg);
            match.setSuggestedReplacement(variant);
            weightedMatches.add(new WeightedRuleMatch(variantCount, match));
        }
        if (weightedMatches.size() > 0) {
            Collections.sort(weightedMatches);
            ruleMatches.add(((WeightedRuleMatch)weightedMatches.get((int)0)).match);
        }
        return partsStartPos += wordPart.length() + 1;
    }

    private String cleanId(String id) {
        return id.toUpperCase().replace("\u00c4", "AE").replace("\u00dc", "UE").replace("\u00d6", "OE");
    }

    public void setConfusionPair(Pair confusionPair) {
        this.confusionPair = confusionPair;
    }

    @Nullable
    String removeHyphensAndAdaptCase(String word) {
        String[] parts = word.split("-");
        if (parts.length > 1) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String part : parts) {
                if (part.length() <= 1) {
                    return null;
                }
                sb.append(i == 0 ? part : StringTools.lowercaseFirstChar((String)part));
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    static {
        ignoreWords = Arrays.asList("Die", "De");
        blacklistRegex = Arrays.asList("gra(ph|f)ische?", "gra(ph|f)ische[rsnm]", "gra(ph|f)s?$", "gra(ph|f)en", "gra(ph|f)ik", "gra(ph|f)ie", "Gra(ph|f)it");
        blacklist = new HashSet<String>(Arrays.asList("Schutzname", "Schutznamen", "Gebrauchsname", "Gebrauchsnamen", "Erbname", "Erbnamen", "Datenname", "Datennamen", "Geldnahme", "Geldnahmen", "Kreispokal", "Gr\u00fcndertag", "Korrekturl\u00f6sung", "Regelschreiber", "Glasreinigern", "Holzstele", "Brandschutz", "Testbahn", "Testbahnen", "Startglocke", "Startglocken", "Ladepunkte", "Kinderpreise", "Kinderpreisen", "Belegungsoptionen", "Brandgebiete", "Brandgebieten", "Innenfell", "Innenfelle", "Batteriepreis", "Alltagsschuhe", "Alltagsschuhen", "Arbeiterschuhe", "Arbeiterschuhen", "Bartvogel", "Abschiedsmail", "Abschiedsmails", "Wohnindex", "Entwicklungsstudio", "Ermittlungsgesetz", "Lindeverfahren", "Stromspender", "Turmverlag", "B\u00e4ckerlunge", "Reisbeutel", "Reisbeuteln", "Reisbeutels", "Fellnase", "Fellnasen", "Kletterwald", "Kletterwalds", "Lusth\u00f6hle", "Lusth\u00f6hlen", "Abschlagswert", "Schuhfach", "Schuhf\u00e4cher", "Sp\u00fclkan\u00fcle", "Sp\u00fclkan\u00fclen", "Tankkosten", "Hangout", "Hangouts", "Kassenloser", "kassenloser", "Reisnadel", "Reisnadeln", "stielloses", "stielloser", "stiellosen", "Beiratsregelung", "Beiratsregelungen", "Kreiskongress", "Lagekosten", "hineinfeiern", "Maskenhersteller", "Wabendesign", "Maskenherstellers", "Maskenherstellern", "Firmenvokabular", "Maskenproduktion", "Maskenpflicht", "Nachmiete", "Ringseil", "Ringseilen", "Jagdschule", "Tachograf", "Tachografs", "Tachografen", "Grafitpulver", "Grafitmine", "Grafitminen", "Nesselstra\u00dfe", "Reitsachen", "Mehrfachabrechnung", "Stuhlrolle", "Stuhlrollen", "neugestartet", "Vertragskonto", "M\u00e4nnerding", "Restwoche", "Startpakete", "Startpaketen", "Suchintention", "Wettgl\u00fcck", "Wettprogramm", "Wettprogramme", "Z\u00e4hlerwechsel", "Z\u00e4hlerwechsels", "N\u00e4hrstoffleitungen", "Verhandlungskreise", "Verhandlungskreisen", "Mietsuchenden", "Mietsuchende", "Mietsuchender", "Autoboss", "Autobossen", "Testmonat", "Testmonats", "Testmonate", "Naturseife", "Naturseifen", "Ankerkraut", "Ankerkrauts", "Bewerbungstool", "Bewerbungstools", "Elektromarke", "Elektromarken", "Ankerkraut", "Testuser", "Testangeboten", "Testangebots", "Testangebotes", "verkeimt", "verkeimte", "verkeimter", "verkeimtes", "verkeimten", "verkeimtem", "Flugscham", "Kurseinf\u00fchrung", "Januar-Miete", "Februar-Miete", "M\u00e4rz-Miete", "April-Miete", "Mai-Miete", "Juni-Miete", "Juli-Miete", "August-Miete", "September-Miete", "Oktober-Miete", "November-Miete", "Dezember-Miete", "Suchindices", "Kirchenfreizeit", "Kirchenfreizeiten", "Erkl\u00e4rb\u00e4r", "Wettart", "Wettarten", "Einzelwette", "Einzelwetten", "Artikelzeile", "Artikelzeilen", "Echtgeld", "Kartenansicht", "Kartenansichten", "Systemwette", "Systemwetten", "Dachzelt", "Dachzelte", "Badeloch", "Bonusaktion", "Bonusaktionen", "Projektannahme", "Pollenbelastung", "Fastenfenster", "Bauchtasche", "Bauchtaschen", "Zahloption", "Zahloptionen", "Zeckenschutz", "Vertragskonto", "Zeichengrenze", "Zeichengrenzen", "Kartontasche", "Kartontaschen", "Mietbest\u00e4tigung", "Mietbest\u00e4tigungen", "Tunnelzelt", "Tunnelzelts", "Tunnelzelte", "Dichtleistung", "Dichtleistungen", "Testkonto", "Testkontos", "Konzernnummer", "Konzernnummern", "Vertragsstunde", "Vertragsstunden", "Zauntr\u00e4ger", "Zauntr\u00e4gern", "Zauntr\u00e4gers", "Hallenschuh", "Hallenschuhs", "Hallenschuhe", "Rekrutierungsausgabe", "Rekrutierungsausgaben", "geruchsfreies", "Tafelfolie", "Gartenservice", "Gartenservices", "Rollger\u00fcste", "Rollger\u00fcsten", "Grasabfall", "Grasabf\u00e4llen", "Ketogrippe", "Ger\u00e4teh\u00fclle", "kaltwei\u00df", "Maskenbefreiung", "Lusttropfen", "Kundenstimme", "Deichschafen", "Industriehefe", "Freizeitschuhe", "Freizeitschuhen", "Trainingsschuhe", "Trainingsschuhen", "Schuhblatt", "Nachbacken", "Wassermelder", "Schutzsegen", "Fischversteigerung", "Fischversteigerungen", "Konfigurationsteile", "Konfigurationsteilen", "Wasserbauch", "Wasserbauchs", "Stadtrad", "Stadtrads", "Seniorenrad", "Seniorenrads", "Bodenplane", "Schwimmschuhe", "Familienstrand", "versiegelbaren", "\u00dcberraschungsfeier", "\u00dcberraschungsfeiern", "ballseitig", "Genussgarten", "Genussgartens", "Edelsteingarten", "Edelsteingartens", "Insektengarten", "Insektengartens", "Klimakurs", "Klimakurses", "Kursperioden", "Musikreise", "Musikreisen", "Ziegenhof", "Ziegenhofs", "Au\u00dfendecke", "Au\u00dfendecken", "Bewegungsbarriere", "Bewegungsbarrieren", "Gerichtsantrag", "Gerichtsantrags", "Gerichtsantr\u00e4ge", "Spezialwette", "Spezialwetten", "Geldmagnet", "Testartikel", "Testartikeln", "Testartikels", "folierte", "foliert", "folierten", "foliertes", "foliertem", "Implementierungsvorgaben", "B\u00fccherzelle", "B\u00fccherzellen", "Cuttermesser", "Cuttermessern", "Cuttermessers", "Kabelsammlung", "Kabelsammlungen", "Schleifschwamm", "Schleifschwamms", "Schleifschw\u00e4mme", "Teemarke", "Teemarken", "Vorzelt", "Vorzelte", "Supportleitung", "Kursname", "Schmucksorte", "Schmucksorten", "Farbsorte", "Farbsorten", "Donaublick", "Feuchtmann"));
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        HashMap<String, List<Pair>> pairMap = new HashMap<String, List<Pair>>();
        ProhibitedCompoundRule.addUpperCaseVariants(pairs);
        ProhibitedCompoundRule.addItemsFromConfusionSets(pairs, "/de/confusion_sets.txt", true);
        prohibitedCompoundRuleSearcher = ProhibitedCompoundRule.setupAhoCorasickSearch(pairs, pairMap);
        prohibitedCompoundRulePairMap = pairMap;
    }

    static class SpecificIdRule
    extends ProhibitedCompoundRule {
        private final String id;
        private final String desc;

        SpecificIdRule(String id, String part1, String part2, ResourceBundle messages, LanguageModel lm) {
            super(messages, lm, null);
            this.id = Objects.requireNonNull(id);
            this.desc = "Markiert wahrscheinlich falsche Komposita mit Teilwort '" + StringTools.uppercaseFirstChar((String)part1) + "' statt '" + StringTools.uppercaseFirstChar((String)part2) + "' und umgekehrt";
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }
    }

    public static class Pair {
        private final String part1;
        private final String part1Desc;
        private final String part2;
        private final String part2Desc;

        public Pair(String part1, String part1Desc, String part2, String part2Desc) {
            this.part1 = part1;
            this.part1Desc = part1Desc;
            this.part2 = part2;
            this.part2Desc = part2Desc;
        }

        public String toString() {
            return this.part1 + "/" + this.part2;
        }
    }

    static class WeightedRuleMatch
    implements Comparable<WeightedRuleMatch> {
        long weight;
        RuleMatch match;

        WeightedRuleMatch(long weight, RuleMatch match) {
            this.weight = weight;
            this.match = match;
        }

        @Override
        public int compareTo(@NotNull WeightedRuleMatch other) {
            return Long.compare(other.weight, this.weight);
        }
    }
}

