/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.GermanChunker;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.language.GermanyGerman;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.AgreementRule2;
import org.languagetool.rules.de.CaseRule;
import org.languagetool.rules.de.CompoundCoherencyRule;
import org.languagetool.rules.de.CompoundInfinitivRule;
import org.languagetool.rules.de.DashRule;
import org.languagetool.rules.de.DuUpperLowerCaseRule;
import org.languagetool.rules.de.GermanConfusionProbabilityRule;
import org.languagetool.rules.de.GermanDoublePunctuationRule;
import org.languagetool.rules.de.GermanFillerWordsRule;
import org.languagetool.rules.de.GermanParagraphRepeatBeginningRule;
import org.languagetool.rules.de.GermanReadabilityRule;
import org.languagetool.rules.de.GermanStyleRepeatedWordRule;
import org.languagetool.rules.de.GermanWordRepeatBeginningRule;
import org.languagetool.rules.de.GermanWordRepeatRule;
import org.languagetool.rules.de.GermanWrongWordInContextRule;
import org.languagetool.rules.de.LongSentenceRule;
import org.languagetool.rules.de.MissingCommaRelativeClauseRule;
import org.languagetool.rules.de.MissingVerbRule;
import org.languagetool.rules.de.OldSpellingRule;
import org.languagetool.rules.de.ProhibitedCompoundRule;
import org.languagetool.rules.de.SentenceWhitespaceRule;
import org.languagetool.rules.de.SimilarNameRule;
import org.languagetool.rules.de.SimpleReplaceRule;
import org.languagetool.rules.de.SubjectVerbAgreementRule;
import org.languagetool.rules.de.UnitConversionRule;
import org.languagetool.rules.de.UpperCaseNgramRule;
import org.languagetool.rules.de.VerbAgreementRule;
import org.languagetool.rules.de.WiederVsWiderRule;
import org.languagetool.rules.de.WordCoherencyRule;
import org.languagetool.rules.neuralnetwork.NeuralNetworkRuleCreator;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.de.GermanRuleDisambiguator;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;

public class German
extends Language
implements AutoCloseable {
    private static final Language GERMANY_GERMAN = new GermanyGerman();
    private CompoundWordTokenizer compoundTokenizer;
    private GermanCompoundTokenizer strictCompoundTokenizer;
    private LanguageModel languageModel;
    private List<Rule> nnRules;
    private Word2VecModel word2VecModel;

    @Deprecated
    public German() {
    }

    public Language getDefaultLanguageVariant() {
        return GERMANY_GERMAN;
    }

    public Disambiguator createDefaultDisambiguator() {
        return new GermanRuleDisambiguator();
    }

    @Nullable
    public Chunker createDefaultPostDisambiguationChunker() {
        return new GermanChunker();
    }

    public String getName() {
        return "German";
    }

    public String getShortCode() {
        return "de";
    }

    public String[] getCountries() {
        return new String[]{"LU", "LI", "BE"};
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return new GermanTagger();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new GermanSynthesizer(this);
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jan Schreiber"), Contributors.DANIEL_NABER};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"Die Partei<marker> ,</marker> die die letzte Wahl gewann."), Example.fixed((String)"Die Partei<marker>,</marker> die die letzte Wahl gewann.")), new GenericUnpairedBracketsRule(messages, Arrays.asList("[", "(", "{", "\u201e", "\u00bb", "\u00ab", "\""), Arrays.asList("]", ")", "}", "\u201c", "\u00ab", "\u00bb", "\"")), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Das Haus ist alt. <marker>es</marker> wurde 1950 gebaut."), Example.fixed((String)"Das Haus ist alt. <marker>Es</marker> wurde 1950 gebaut.")), new MultipleWhitespaceRule(messages, (Language)this), new SimpleReplaceRule(messages), new OldSpellingRule(messages), new SentenceWhitespaceRule(messages), new GermanDoublePunctuationRule(messages), new MissingVerbRule(messages, this), new GermanWordRepeatRule(messages, this), new GermanWordRepeatBeginningRule(messages, this), new GermanWrongWordInContextRule(messages), new AgreementRule(messages, this), new AgreementRule2(messages, this), new CaseRule(messages, this), new DashRule(messages), new VerbAgreementRule(messages, this), new SubjectVerbAgreementRule(messages, this), new WordCoherencyRule(messages), new SimilarNameRule(messages), new WiederVsWiderRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new GermanStyleRepeatedWordRule(messages, this, userConfig), new CompoundCoherencyRule(messages), new LongSentenceRule(messages, userConfig, 35, true, true), new LongParagraphRule(messages, (Language)this, userConfig), new GermanFillerWordsRule(messages, this, userConfig), new GermanParagraphRepeatBeginningRule(messages, this), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new DuUpperLowerCaseRule(messages), new UnitConversionRule(messages), new MissingCommaRelativeClauseRule(messages), new MissingCommaRelativeClauseRule(messages, true), new GermanReadabilityRule(messages, this, userConfig, true), new GermanReadabilityRule(messages, this, userConfig, false), new CompoundInfinitivRule(messages, this, userConfig)});
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new UpperCaseNgramRule(messages, languageModel, this), new GermanConfusionProbabilityRule(messages, languageModel, this), new ProhibitedCompoundRule(messages, languageModel, userConfig)});
    }

    public List<Rule> getRelevantWord2VecModelRules(ResourceBundle messages, Word2VecModel word2vecModel) throws IOException {
        if (this.nnRules == null) {
            this.nnRules = NeuralNetworkRuleCreator.createRules((ResourceBundle)messages, (Language)this, (Word2VecModel)word2vecModel);
        }
        return this.nnRules;
    }

    public CompoundWordTokenizer getNonStrictCompoundSplitter() {
        if (this.compoundTokenizer == null) {
            try {
                GermanCompoundTokenizer tokenizer = new GermanCompoundTokenizer(false);
                this.compoundTokenizer = word -> new ArrayList<String>(tokenizer.tokenize(word));
            }
            catch (IOException e) {
                throw new RuntimeException("Could not set up German compound splitter", e);
            }
        }
        return this.compoundTokenizer;
    }

    public GermanCompoundTokenizer getStrictCompoundTokenizer() {
        if (this.strictCompoundTokenizer == null) {
            try {
                this.strictCompoundTokenizer = new GermanCompoundTokenizer();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not set up strict German compound splitter", e);
            }
        }
        return this.strictCompoundTokenizer;
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public synchronized Word2VecModel getWord2VecModel(File indexDir) throws IOException {
        if (this.word2VecModel == null) {
            this.word2VecModel = new Word2VecModel(indexDir + File.separator + this.getShortCode());
        }
        return this.word2VecModel;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    public String getOpeningDoubleQuote() {
        return "\u201e";
    }

    public String getClosingDoubleQuote() {
        return "\u201c";
    }

    public String getOpeningSingleQuote() {
        return "\u201a";
    }

    public String getClosingSingleQuote() {
        return "\u2018";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        output = output.replaceAll("\\b([a-zA-Z]\\.)([a-zA-Z]\\.)", "$1\u00a0$2");
        return output;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "OLD_SPELLING_INTERNAL": {
                return 10;
            }
            case "ROCK_N_ROLL": {
                return 1;
            }
            case "DE_PROHIBITED_COMPOUNDS": {
                return 1;
            }
            case "ANS_OHNE_APOSTROPH": {
                return 1;
            }
            case "DIESEN_JAHRES": {
                return 1;
            }
            case "EBEN_FALLS": {
                return 1;
            }
            case "UST_ID": {
                return 1;
            }
            case "DASS_MIT_VERB": {
                return 1;
            }
            case "AB_TEST": {
                return 1;
            }
            case "BZGL_ABK": {
                return 1;
            }
            case "DURCH_WACHSEN": {
                return 1;
            }
            case "RUNDUM_SORGLOS_PAKET": {
                return 1;
            }
            case "DE_AGREEMENT": {
                return -1;
            }
            case "COMMA_IN_FRONT_RELATIVE_CLAUSE": {
                return -1;
            }
            case "MODALVERB_FLEKT_VERB": {
                return -1;
            }
            case "AKZENT_STATT_APOSTROPH": {
                return -1;
            }
            case "GERMAN_WORD_REPEAT_RULE": {
                return -1;
            }
            case "GERMAN_SPELLER_RULE": {
                return -3;
            }
            case "AUSTRIAN_GERMAN_SPELLER_RULE": {
                return -3;
            }
            case "SWISS_GERMAN_SPELLER_RULE": {
                return -3;
            }
            case "PUNCTUATION_PARAGRAPH_END": {
                return -4;
            }
            case "PUNKT_ENDE_ABSATZ": {
                return -10;
            }
            case "KOMMA_ZWISCHEN_HAUPT_UND_NEBENSATZ": {
                return -10;
            }
            case "KOMMA_VOR_RELATIVSATZ": {
                return -10;
            }
            case "COMMA_BEHIND_RELATIVE_CLAUSE": {
                return -10;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -15;
            }
            case "COLLOQUIALISMS": {
                return -15;
            }
            case "REDUNDANCY": {
                return -15;
            }
            case "GENDER_NEUTRALITY": {
                return -15;
            }
            case "TYPOGRAPHY": {
                return -15;
            }
        }
        if (id.startsWith("CONFUSION_RULE_")) {
            return -1;
        }
        return super.getPriorityForId(id);
    }
}

