/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class MissingCommaRelativeClauseRule
extends Rule {
    private static final Pattern MARKS_REGEX = Pattern.compile("[,;.:?!-\u2013\u2014\u2019'\"\u201e\u201c\u201d\u00bb\u00ab\u201a\u2018\u203a\u2039()\\[\\]]");
    private final boolean behind;
    private static final German GERMAN = new GermanyGerman();
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.csToken((String)"mit"), PatternRuleBuilderHelper.regex((String)"de[mr]"), PatternRuleBuilderHelper.regex((String)"de[mrs]"), PatternRuleBuilderHelper.posRegex((String)"SUB:.+"), PatternRuleBuilderHelper.csToken((String)"verbindet")));

    public MissingCommaRelativeClauseRule(ResourceBundle messages) {
        this(messages, false);
    }

    public MissingCommaRelativeClauseRule(ResourceBundle messages, boolean behind) {
        super(messages);
        super.setCategory(new Category(new CategoryId("HILFESTELLUNG_KOMMASETZUNG"), "Hilfestellung f\u00fcr Kommasetzung", Category.Location.INTERNAL, true));
        super.makeAntiPatterns(ANTI_PATTERNS, (Language)GERMAN);
        this.behind = behind;
    }

    public String getId() {
        return this.behind ? "COMMA_BEHIND_RELATIVE_CLAUSE" : "COMMA_IN_FRONT_RELATIVE_CLAUSE";
    }

    public String getDescription() {
        return this.behind ? "Fehlendes Komma nach Relativsatz" : "Fehlendes Komma vor Relativsatz";
    }

    private static boolean isSeparator(String token) {
        return MARKS_REGEX.matcher(token).matches() || token.equals("und") || token.equals("oder");
    }

    private static int nextSeparator(AnalyzedTokenReadings[] tokens, int start) {
        for (int i = start; i < tokens.length; ++i) {
            if (!MissingCommaRelativeClauseRule.isSeparator(tokens[i].getToken())) continue;
            return i;
        }
        return tokens.length - 1;
    }

    private static boolean isPrp(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("PRP:") && !token.isImmunized();
    }

    private static boolean isVerb(AnalyzedTokenReadings[] tokens, int n) {
        return tokens[n].matchesPosTagRegex("(VER:[1-3]:|VER:.*:[1-3]:).*") && !tokens[n].matchesPosTagRegex("(ZAL|ADJ|ADV|ART|SUB|PRO:POS).*") && (!tokens[n].hasPosTagStartingWith("VER:INF:") || !tokens[n - 1].getToken().equals("zu")) && !tokens[n].isImmunized();
    }

    private static boolean isAnyVerb(AnalyzedTokenReadings[] tokens, int n) {
        return tokens[n].hasPosTagStartingWith("VER:") || n < tokens.length - 1 && (tokens[n].getToken().equals("zu") && tokens[n + 1].hasPosTagStartingWith("VER:INF:") || tokens[n].hasPosTag("NEG") && tokens[n + 1].hasPosTagStartingWith("VER:"));
    }

    static boolean isVerbBehind(AnalyzedTokenReadings[] tokens, int end) {
        return end < tokens.length - 1 && tokens[end].getToken().equals(",") && tokens[end + 1].hasPosTagStartingWith("VER:");
    }

    private static List<Integer> verbPos(AnalyzedTokenReadings[] tokens, int start, int end) {
        ArrayList<Integer> verbs = new ArrayList<Integer>();
        for (int i = start; i < end; ++i) {
            if (!MissingCommaRelativeClauseRule.isVerb(tokens, i)) continue;
            if (tokens[i].matchesPosTagRegex("PA[12]:.*")) {
                int j;
                String gender = MissingCommaRelativeClauseRule.getGender(tokens[i]);
                String sStr = "(ADJ|PA[12]):.*" + gender + ".*";
                for (j = i + 1; j < end && tokens[j].matchesPosTagRegex(sStr); ++j) {
                }
                if (tokens[j].matchesPosTagRegex("(SUB|EIG):.*" + gender + ".*") || tokens[j].isPosTagUnknown()) continue;
                verbs.add(i);
                continue;
            }
            verbs.add(i);
        }
        return verbs;
    }

    private static boolean isKonUnt(AnalyzedTokenReadings token) {
        return token.hasPosTag("KON:UNT") || StringUtils.equalsAnyIgnoreCase((CharSequence)token.getToken(), (CharSequence[])new CharSequence[]{"wer", "wo", "wohin"});
    }

    private static int hasPotentialSubclause(AnalyzedTokenReadings[] tokens, int start, int end) {
        List<Integer> verbs = MissingCommaRelativeClauseRule.verbPos(tokens, start, end);
        if (verbs.size() == 1 && end < tokens.length - 2 && verbs.get(0) == end - 1) {
            int nextEnd = MissingCommaRelativeClauseRule.nextSeparator(tokens, end + 1);
            List<Integer> nextVerbs = MissingCommaRelativeClauseRule.verbPos(tokens, end + 1, nextEnd);
            if (MissingCommaRelativeClauseRule.isKonUnt(tokens[start]) ? nextVerbs.size() > 1 || nextVerbs.size() == 1 && nextVerbs.get(0) == end - 1 : nextVerbs.size() > 0) {
                return verbs.get(0);
            }
            return -1;
        }
        if (verbs.size() == 2) {
            if (tokens[verbs.get(0)].matchesPosTagRegex("VER:(MOD|AUX):.*") && tokens[verbs.get(1)].hasPosTagStartingWith("VER:INF:")) {
                return verbs.get(0);
            }
            if (tokens[verbs.get(0)].hasPosTagStartingWith("VER:AUX:") && tokens[verbs.get(1)].hasPosTagStartingWith("VER:PA2:")) {
                return -1;
            }
            if (end == tokens.length - 1 && verbs.get(0) == end - 2 && tokens[verbs.get(0)].hasPosTagStartingWith("VER:INF:") && tokens[verbs.get(1)].hasPosTagStartingWith("VER:MOD:")) {
                return -1;
            }
        }
        if (verbs.size() == 3 && tokens[verbs.get(0)].hasPosTagStartingWith("VER:MOD:") && (tokens[verbs.get(2) - 1].matchesPosTagRegex("VER:(INF|PA2):.*") && tokens[verbs.get(2)].hasPosTagStartingWith("VER:INF:") || tokens[verbs.get(1) - 1].getToken().equals("weder") && tokens[verbs.get(1)].hasPosTagStartingWith("VER:INF:") && tokens[verbs.get(2) - 1].getToken().equals("noch") && tokens[verbs.get(1)].hasPosTagStartingWith("VER:INF:"))) {
            return -1;
        }
        if (verbs.size() > 1) {
            return verbs.get(verbs.size() - 1);
        }
        return -1;
    }

    private static boolean isPronoun(AnalyzedTokenReadings[] tokens, int n) {
        return tokens[n].getToken().matches("(d(e[mnr]|ie|as|e([nr]|ss)en)|welche[mrs]?|wessen|was)") && !tokens[n - 1].getToken().equals("sowie");
    }

    private static String getGender(AnalyzedTokenReadings token) {
        int nMatches = 0;
        String ret = "";
        if (token.matchesPosTagRegex(".*:SIN:FEM.*")) {
            ret = ret + "SIN:FEM";
            ++nMatches;
        }
        if (token.matchesPosTagRegex(".*:SIN:MAS.*")) {
            if (nMatches > 0) {
                ret = ret + "|";
            }
            ret = ret + "SIN:MAS";
            ++nMatches;
        }
        if (token.matchesPosTagRegex(".*:SIN:NEU.*")) {
            if (nMatches > 0) {
                ret = ret + "|";
            }
            ret = ret + "SIN:NEU";
            ++nMatches;
        }
        if (token.matchesPosTagRegex(".*:PLU.*")) {
            if (nMatches > 0) {
                ret = ret + "|";
            }
            ret = ret + "PLU";
            ++nMatches;
        }
        if (nMatches > 1) {
            ret = "(" + ret + ")";
        }
        return ret;
    }

    private static boolean matchesGender(String gender, AnalyzedTokenReadings[] tokens, int from, int to) {
        String mStr = gender.isEmpty() ? "PRO:DEM:.*SIN:NEU.*" : "(SUB|EIG):.*" + gender + ".*";
        for (int i = to - 1; i >= from; --i) {
            if (!tokens[i].matchesPosTagRegex(mStr) || i == 1 && tokens[i].hasPosTagStartingWith("VER:")) continue;
            return true;
        }
        return false;
    }

    private static boolean isArticleWithoutSub(String gender, AnalyzedTokenReadings[] tokens, int n) {
        if (gender.isEmpty()) {
            return false;
        }
        return tokens[n].hasPosTagStartingWith("VER:") && tokens[n - 1].matchesPosTagRegex("(ADJ|PRO:POS):.*" + gender + ".*");
    }

    private static int skipSub(AnalyzedTokenReadings[] tokens, int n, int to) {
        String gender = MissingCommaRelativeClauseRule.getGender(tokens[n]);
        for (int i = n + 1; i < to; ++i) {
            if (!tokens[i].matchesPosTagRegex("(SUB|EIG):.*" + gender + ".*")) continue;
            return i;
        }
        return -1;
    }

    private static int skipToSub(String gender, AnalyzedTokenReadings[] tokens, int n, int to) {
        if (tokens[n + 1].matchesPosTagRegex("PA[12]:.*" + gender + ".*")) {
            return n + 1;
        }
        for (int i = n + 1; i < to; ++i) {
            if (tokens[i].matchesPosTagRegex("(ADJ|PA[12]):.*" + gender + ".*") || tokens[i].isPosTagUnknown()) {
                return i;
            }
            if (!tokens[i].hasPosTagStartingWith("ART") || (i = MissingCommaRelativeClauseRule.skipSub(tokens, i, to)) >= 0) continue;
            return i;
        }
        return -1;
    }

    private static boolean isArticle(String gender, AnalyzedTokenReadings[] tokens, int from, int to) {
        if (gender.isEmpty()) {
            return false;
        }
        String sSub = "(SUB|EIG):.*" + gender + ".*";
        String sAdj = "(ZAL|PRP:|KON:|ADV:|ADJ:PRD:|(ADJ|PA[12]|PRO:(POS|DEM|IND)):.*" + gender + ").*";
        for (int i = from + 1; i < to; ++i) {
            if (tokens[i].matchesPosTagRegex(sSub) || tokens[i].isPosTagUnknown()) {
                return true;
            }
            if (!tokens[i].hasPosTagStartingWith("ART") && tokens[i].matchesPosTagRegex(sAdj)) continue;
            if (MissingCommaRelativeClauseRule.isArticleWithoutSub(gender, tokens, i)) {
                return true;
            }
            int skipTo = MissingCommaRelativeClauseRule.skipToSub(gender, tokens, i, to);
            if (skipTo > 0) {
                i = skipTo;
                continue;
            }
            return false;
        }
        return to < tokens.length && MissingCommaRelativeClauseRule.isArticleWithoutSub(gender, tokens, to);
    }

    private static int missedCommaInFront(AnalyzedTokenReadings[] tokens, int start, int end, int lastVerb) {
        for (int i = start; i < lastVerb - 1; ++i) {
            String gender;
            if (!MissingCommaRelativeClauseRule.isPronoun(tokens, i) || (gender = MissingCommaRelativeClauseRule.getGender(tokens[i])) == null || MissingCommaRelativeClauseRule.isAnyVerb(tokens, i + 1) || !MissingCommaRelativeClauseRule.matchesGender(gender, tokens, start, i) || MissingCommaRelativeClauseRule.isArticle(gender, tokens, i, lastVerb)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isTwoCombinedVerbs(AnalyzedTokenReadings first, AnalyzedTokenReadings second) {
        return first.matchesPosTagRegex("(VER:.*INF|.*PA[12]:).*") && second.hasPosTagStartingWith("VER:");
    }

    private static boolean isThreeCombinedVerbs(AnalyzedTokenReadings[] tokens, int first, int last) {
        return tokens[first].matchesPosTagRegex("VER:(AUX|INF|PA[12]).*") && tokens[first + 1].matchesPosTagRegex("VER:(.*INF|PA[12]).*") && tokens[last].matchesPosTagRegex("VER:(MOD|AUX).*");
    }

    private static boolean isFourCombinedVerbs(AnalyzedTokenReadings[] tokens, int first, int last) {
        return tokens[first].hasPartialPosTag("KJ2") && tokens[first + 1].hasPosTagStartingWith("PA2") && tokens[first + 2].matchesPosTagRegex("VER:(.*INF|PA[12]).*") && tokens[last].matchesPosTagRegex("VER:(MOD|AUX).*");
    }

    private static boolean isPar(AnalyzedTokenReadings token) {
        return token.hasPosTagStartingWith("PA2:");
    }

    private static boolean isInfinitivZu(AnalyzedTokenReadings[] tokens, int last) {
        return tokens[last - 1].getToken().equals("zu") && tokens[last].matchesPosTagRegex("VER:.*INF.*");
    }

    private static boolean isTwoPlusCombinedVerbs(AnalyzedTokenReadings[] tokens, int first, int last) {
        return tokens[first].matchesPosTagRegex(".*PA[12]:.*") && tokens[last - 1].matchesPosTagRegex("VER:.*INF.*");
    }

    private static boolean isKonAfterVerb(AnalyzedTokenReadings[] tokens, int start, int end) {
        if (tokens[start].matchesPosTagRegex("VER:(MOD|AUX).*") && tokens[start + 1].matchesPosTagRegex("(KON|PRP).*")) {
            if (start + 3 == end) {
                return true;
            }
            for (int i = start + 2; i < end; ++i) {
                if (!tokens[i].matchesPosTagRegex("(SUB|PRO:PER).*")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSpecialPair(AnalyzedTokenReadings[] tokens, int first, int second) {
        if (first + 3 >= second && tokens[first].matchesPosTagRegex("VER:.*INF.*") && StringUtils.equalsAny((CharSequence)tokens[first + 1].getToken(), (CharSequence[])new CharSequence[]{"als", "noch"}) && tokens[first + 2].matchesPosTagRegex("VER:.*INF.*")) {
            if (first + 2 == second) {
                return true;
            }
            return MissingCommaRelativeClauseRule.isTwoCombinedVerbs(tokens[second - 1], tokens[second]);
        }
        return false;
    }

    private static boolean isPerfect(AnalyzedTokenReadings[] tokens, int first, int second) {
        return tokens[first].hasPosTagStartingWith("VER:AUX:") && tokens[second].matchesPosTagRegex("VER:.*(INF|PA2).*");
    }

    private static boolean isSpecialInf(AnalyzedTokenReadings[] tokens, int first, int second, int start) {
        if (!tokens[first].hasPosTagStartingWith("VER:INF")) {
            return false;
        }
        for (int i = first - 1; i > start; --i) {
            if (!tokens[i].hasPosTagStartingWith("ART")) continue;
            return (i = MissingCommaRelativeClauseRule.skipSub(tokens, i, second)) > 0;
        }
        return false;
    }

    private static boolean isPerfect(AnalyzedTokenReadings[] tokens, int first, int second, int third) {
        return tokens[second].matchesPosTagRegex("VER:.*INF.*") && MissingCommaRelativeClauseRule.isPerfect(tokens, first, third);
    }

    private static boolean isSeparatorOrInf(AnalyzedTokenReadings[] tokens, int n) {
        return MissingCommaRelativeClauseRule.isSeparator(tokens[n].getToken()) || tokens[n].hasPosTagStartingWith("VER:INF") || tokens.length > n + 1 && tokens[n].getToken().equals("zu") && tokens[n + 1].matchesPosTagRegex("VER:.*INF.*");
    }

    private static int getCommaBehind(AnalyzedTokenReadings[] tokens, List<Integer> verbs, int start, int end) {
        if (verbs.size() == 1) {
            if (MissingCommaRelativeClauseRule.isSeparator(tokens[verbs.get(0) + 1].getToken())) {
                return -1;
            }
            return verbs.get(0);
        }
        if (verbs.size() == 2) {
            if (MissingCommaRelativeClauseRule.isSpecialPair(tokens, verbs.get(0), verbs.get(1))) {
                if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(1) + 1)) {
                    return -1;
                }
                return verbs.get(1);
            }
            if (verbs.get(0) + 1 == verbs.get(1)) {
                if (MissingCommaRelativeClauseRule.isTwoCombinedVerbs(tokens[verbs.get(0)], tokens[verbs.get(1)])) {
                    if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(1) + 1) || MissingCommaRelativeClauseRule.isKonAfterVerb(tokens, verbs.get(1), end)) {
                        return -1;
                    }
                    return verbs.get(1);
                }
            } else if (verbs.get(0) + 2 == verbs.get(1) && MissingCommaRelativeClauseRule.isThreeCombinedVerbs(tokens, verbs.get(0), verbs.get(1))) {
                if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(1) + 1)) {
                    return -1;
                }
                return verbs.get(1);
            }
            if (MissingCommaRelativeClauseRule.isPar(tokens[verbs.get(0)]) || MissingCommaRelativeClauseRule.isPerfect(tokens, verbs.get(0), verbs.get(1)) || MissingCommaRelativeClauseRule.isInfinitivZu(tokens, verbs.get(1)) || MissingCommaRelativeClauseRule.isSpecialInf(tokens, verbs.get(0), verbs.get(1), start)) {
                if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(1) + 1)) {
                    return -1;
                }
                return verbs.get(1);
            }
        } else if (verbs.size() == 3) {
            if (MissingCommaRelativeClauseRule.isTwoPlusCombinedVerbs(tokens, verbs.get(0), verbs.get(2))) {
                if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(2) + 1)) {
                    return -1;
                }
                return verbs.get(2);
            }
            if (verbs.get(0) + 2 == verbs.get(2)) {
                if (verbs.get(0) + 1 == verbs.get(1) && MissingCommaRelativeClauseRule.isThreeCombinedVerbs(tokens, verbs.get(0), verbs.get(2))) {
                    if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(2) + 1)) {
                        return -1;
                    }
                    return verbs.get(2);
                }
            } else {
                if (verbs.get(0) + 3 == verbs.get(2) && MissingCommaRelativeClauseRule.isFourCombinedVerbs(tokens, verbs.get(0), verbs.get(2))) {
                    if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(2) + 1)) {
                        return -1;
                    }
                    return verbs.get(2);
                }
                if (tokens[verbs.get(2)].hasPosTagStartingWith("VER:MOD:") && MissingCommaRelativeClauseRule.isSpecialPair(tokens, verbs.get(0), verbs.get(1))) {
                    if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(2) + 1)) {
                        return -1;
                    }
                    return verbs.get(2);
                }
            }
            if (MissingCommaRelativeClauseRule.isPerfect(tokens, verbs.get(0), verbs.get(1), verbs.get(2))) {
                if (MissingCommaRelativeClauseRule.isSeparatorOrInf(tokens, verbs.get(2) + 1)) {
                    return -1;
                }
                return verbs.get(1);
            }
        }
        return verbs.get(0);
    }

    private static int missedCommaBehind(AnalyzedTokenReadings[] tokens, int inFront, int start, int end) {
        for (int i = start; i < end; ++i) {
            String gender;
            List<Integer> verbs;
            if (!MissingCommaRelativeClauseRule.isPronoun(tokens, i) || (verbs = MissingCommaRelativeClauseRule.verbPos(tokens, i, end)).size() <= 0 || (gender = MissingCommaRelativeClauseRule.getGender(tokens[i])) == null || MissingCommaRelativeClauseRule.isAnyVerb(tokens, i + 1) || !MissingCommaRelativeClauseRule.matchesGender(gender, tokens, inFront, i - 1) || MissingCommaRelativeClauseRule.isArticle(gender, tokens, i, verbs.get(verbs.size() - 1))) continue;
            return MissingCommaRelativeClauseRule.getCommaBehind(tokens, verbs, i, end);
        }
        return -1;
    }

    private static String getSinOrPluOfPro(AnalyzedTokenReadings token) {
        if (!token.hasPartialPosTag("PRO:PER:") && !token.hasPosTagStartingWith("IND:")) {
            return null;
        }
        String ret = "";
        int nMatches = 0;
        if (token.matchesPosTagRegex(".*:SIN.*")) {
            ret = ret + "SIN";
            ++nMatches;
        }
        if (token.matchesPosTagRegex(".*:PLU.*")) {
            if (!ret.isEmpty()) {
                ret = ret + "|";
            }
            ret = ret + "PLU";
            ++nMatches;
        }
        if (nMatches > 1) {
            ret = "(" + ret + ")";
        }
        return ret;
    }

    private static boolean isVerbProPair(AnalyzedTokenReadings[] tokens, int n) {
        String sinOrPlu = MissingCommaRelativeClauseRule.getSinOrPluOfPro(tokens[n + 1]);
        if (sinOrPlu == null) {
            return false;
        }
        return tokens[n].matchesPosTagRegex("VER:.*" + sinOrPlu + ".*");
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (tokens.length <= 1) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int subStart = 1;
        if (MissingCommaRelativeClauseRule.isSeparator(tokens[subStart].getToken())) {
            ++subStart;
        }
        if (this.behind) {
            int subInFront = subStart;
            subStart = MissingCommaRelativeClauseRule.nextSeparator(tokens, subInFront) + 1;
            while (subStart < tokens.length) {
                int nToken;
                int subEnd = MissingCommaRelativeClauseRule.nextSeparator(tokens, subStart);
                int lastVerb = MissingCommaRelativeClauseRule.hasPotentialSubclause(tokens, subStart, subEnd);
                if (lastVerb > 0 && (nToken = MissingCommaRelativeClauseRule.missedCommaBehind(tokens, subInFront, subStart, subEnd)) > 0) {
                    RuleMatch match;
                    if (MissingCommaRelativeClauseRule.isVerbProPair(tokens, nToken)) {
                        match = new RuleMatch((Rule)this, sentence, tokens[nToken - 1].getStartPos(), tokens[nToken + 1].getEndPos(), "Sollten Sie hier ein Komma einf\u00fcgen oder zwei?");
                        ArrayList<String> suggestedReplacements = new ArrayList<String>();
                        suggestedReplacements.add(tokens[nToken - 1].getToken() + ", " + tokens[nToken].getToken() + " " + tokens[nToken + 1].getToken() + ",");
                        suggestedReplacements.add(tokens[nToken - 1].getToken() + " " + tokens[nToken].getToken() + " " + tokens[nToken + 1].getToken() + ",");
                        suggestedReplacements.add(tokens[nToken - 1].getToken() + " " + tokens[nToken].getToken() + ", " + tokens[nToken + 1].getToken());
                        match.setSuggestedReplacements(suggestedReplacements);
                        ruleMatches.add(match);
                    } else {
                        match = new RuleMatch((Rule)this, sentence, tokens[nToken].getStartPos(), tokens[nToken + 1].getEndPos(), "Sollten Sie hier ein Komma einf\u00fcgen?");
                        match.setSuggestedReplacement(tokens[nToken].getToken() + ", " + tokens[nToken + 1].getToken());
                        ruleMatches.add(match);
                    }
                }
                subInFront = subStart;
                subStart = subEnd + 1;
            }
        } else {
            while (subStart < tokens.length) {
                int nToken;
                int subEnd = MissingCommaRelativeClauseRule.nextSeparator(tokens, subStart);
                int lastVerb = MissingCommaRelativeClauseRule.hasPotentialSubclause(tokens, subStart, subEnd);
                if (lastVerb > 0 && (nToken = MissingCommaRelativeClauseRule.missedCommaInFront(tokens, subStart, subEnd, lastVerb)) > 0) {
                    int startToken = nToken - (MissingCommaRelativeClauseRule.isPrp(tokens[nToken - 1]) ? 2 : 1);
                    RuleMatch match = new RuleMatch((Rule)this, sentence, tokens[startToken].getStartPos(), tokens[nToken].getEndPos(), "Sollten Sie hier ein Komma einf\u00fcgen?");
                    if (nToken - startToken > 1) {
                        match.setSuggestedReplacement(tokens[startToken].getToken() + ", " + tokens[nToken - 1].getToken() + " " + tokens[nToken].getToken());
                    } else {
                        match.setSuggestedReplacement(tokens[startToken].getToken() + ", " + tokens[nToken].getToken());
                    }
                    ruleMatches.add(match);
                }
                subStart = subEnd + 1;
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, GERMAN);
    }
}

