/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.AgreementTools;
import org.languagetool.rules.patterns.PatternRuleBuilderHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class AgreementRule2
extends Rule {
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(PatternRuleBuilderHelper.token((String)"Ernst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Anders")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wirklich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wenig")), Arrays.asList(PatternRuleBuilderHelper.token((String)"richtig")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wei\u00df")), Arrays.asList(PatternRuleBuilderHelper.token((String)"speziell")), Arrays.asList(PatternRuleBuilderHelper.token((String)"halb")), Arrays.asList(PatternRuleBuilderHelper.token((String)"hinter")), Arrays.asList(PatternRuleBuilderHelper.token((String)"vermutlich")), Arrays.asList(PatternRuleBuilderHelper.token((String)"wohl")), Arrays.asList(PatternRuleBuilderHelper.token((String)"erst")), Arrays.asList(PatternRuleBuilderHelper.token((String)"lieber")), Arrays.asList(PatternRuleBuilderHelper.token((String)"besser")), Arrays.asList(PatternRuleBuilderHelper.token((String)"laut")), Arrays.asList(PatternRuleBuilderHelper.token((String)"research")), Arrays.asList(PatternRuleBuilderHelper.token((String)"researchs")), Arrays.asList(PatternRuleBuilderHelper.token((String)"security")), Arrays.asList(PatternRuleBuilderHelper.token((String)"business")), Arrays.asList(PatternRuleBuilderHelper.token((String)"voll"), PatternRuleBuilderHelper.token((String)"Sorge")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Personal"), PatternRuleBuilderHelper.token((String)"Computer")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Ganz"), PatternRuleBuilderHelper.token((String)"Gentleman")), Arrays.asList(PatternRuleBuilderHelper.token((String)"Russisch"), PatternRuleBuilderHelper.token((String)"Roulette")));
    private final Language language;

    public AgreementRule2(ResourceBundle messages, Language language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>Kleiner Haus</marker> am Waldrand"), Example.fixed((String)"<marker>Kleines Haus</marker> am Waldrand"));
    }

    public String getId() {
        return "DE_AGREEMENT2";
    }

    public String getDescription() {
        return "Kongruenz von Adjektiv und Nomen (unvollst\u00e4ndig!), z.B. 'kleiner(kleines) Haus'";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.language);
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        for (int i = 0; i < tokens.length; ++i) {
            AnalyzedTokenReadings nextToken;
            if (tokens[i].isSentenceStart() || tokens[i].getToken().matches("[\"\u201e\u00bb\u00ab]")) continue;
            if (i + 1 >= tokens.length || !tokens[i].hasPosTagStartingWith("ADJ:") || !tokens[i + 1].hasPosTagStartingWith("SUB:")) break;
            if (tokens[i].isImmunized() || tokens[i + 1].isImmunized()) continue;
            AnalyzedTokenReadings analyzedTokenReadings = nextToken = i + 2 < tokens.length ? tokens[i + 2] : null;
            if (nextToken != null && nextToken.hasPosTagStartingWith("SUB:")) break;
            RuleMatch ruleMatch = this.checkAdjNounAgreement(tokens[i], tokens[i + 1], sentence);
            if (ruleMatch == null) continue;
            ruleMatches.add(ruleMatch);
            break;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private RuleMatch checkAdjNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedSentence sentence) {
        Set<String> set = this.retainCommonCategories(token1, token2);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Adjektiv und Nomen bez\u00fcglich Kasus, Numerus oder Genus. Beispiel: 'kleiner Haus' statt 'kleines Haus'";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich Kasus, Numerus oder Genus";
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token2.getEndPos(), msg, shortMsg);
        }
        return ruleMatch;
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        Set<AgreementRule.GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        Set<String> set1 = AgreementTools.getAgreementCategories(token1, categoryToRelaxSet, false);
        Set<String> set2 = AgreementTools.getAgreementCategories(token2, categoryToRelaxSet, false);
        set1.retainAll(set2);
        return set1;
    }
}

