/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.languagetool.AnalyzedSentence;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.SpellingData;

class SpellingRuleWithSuggestions {
    private final Rule rule;
    private final String alternative;
    private final List<String> suggestions;
    private final boolean skipIfAfterQuote;

    SpellingRuleWithSuggestions(Rule rule, String alternative, String suggestion) {
        this(rule, alternative, Collections.singletonList(suggestion));
    }

    SpellingRuleWithSuggestions(Rule rule, String alternative, List<String> suggestions) {
        this(rule, alternative, suggestions, false);
    }

    SpellingRuleWithSuggestions(Rule rule, String alternative, List<String> suggestions, boolean skipIfAfterQuote) {
        this.rule = Objects.requireNonNull(rule);
        this.alternative = Objects.requireNonNull(alternative);
        this.suggestions = Objects.requireNonNull(suggestions);
        this.skipIfAfterQuote = skipIfAfterQuote;
    }

    static List<RuleMatch> computeMatches(AnalyzedSentence sentence, SpellingData data, String[] exceptions) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        for (SpellingRuleWithSuggestions ruleWithSuggestion : data.get()) {
            RuleMatch[] matches;
            Rule rule = ruleWithSuggestion.rule;
            for (RuleMatch match : matches = rule.match(sentence)) {
                String matchedText = sentence.getText().substring(match.getFromPos(), match.getToPos());
                String textFromMatch = sentence.getText().substring(match.getFromPos());
                boolean isException = false;
                for (String exception : exceptions) {
                    if (!textFromMatch.startsWith(exception)) continue;
                    isException = true;
                    break;
                }
                if (isException) continue;
                ArrayList<String> suggestions = new ArrayList<String>();
                for (String s : ruleWithSuggestion.suggestions) {
                    String suggestion = matchedText.replace(ruleWithSuggestion.alternative, s);
                    if (suggestion.equals(matchedText)) continue;
                    suggestions.add(suggestion);
                }
                if (suggestions.size() <= 0) continue;
                match.setSuggestedReplacements(suggestions);
                if (ruleWithSuggestion.skipIfAfterQuote && match.getFromPos() > 0 && sentence.getText().substring(match.getFromPos() - 1, match.getFromPos()).matches("['\"\u201e\u00ab\u00bb]")) continue;
                ruleMatches.add(match);
            }
        }
        return ruleMatches;
    }
}

