/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementSuggestor;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;
import org.languagetool.tools.Tools;

public class AgreementRule
extends Rule {
    private final German language;
    private JLanguageTool lt;
    private static final AnalyzedToken[] INS_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("das", "ART:DEF:AKK:SIN:NEU", "das")};
    private static final AnalyzedToken[] ZUR_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("der", "ART:DEF:DAT:SIN:FEM", "der")};
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(AgreementRule.token("das"), AgreementRule.token("schwere"), AgreementRule.token("Konsequenzen")), Arrays.asList(AgreementRule.token("der"), AgreementRule.token("Chaos"), AgreementRule.token("Computer"), AgreementRule.token("Club")), Arrays.asList(AgreementRule.token("dem"), AgreementRule.token("einen"), AgreementRule.pos("SUB:NOM:SIN:NEU")), Arrays.asList(AgreementRule.posRegex("PRO:DEM:.+"), AgreementRule.posRegex("PA2:.+"), AgreementRule.posRegex("SUB:.*:PLU.*")), Arrays.asList(AgreementRule.posRegex("VER:.*|UNKNOWN"), AgreementRule.token("das"), AgreementRule.tokenRegex("(\u00fcber)?n\u00e4chste[ns]?|kommende[ns]?|(vor)?letzten"), AgreementRule.tokenRegex("Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Montag|D(ien|onner)stag|Mittwoch|Freitag|S(ams|onn)tag|Sonnabend|Woche|Monat|Jahr|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?")), Arrays.asList(AgreementRule.posRegex("VER:.*|UNKNOWN"), AgreementRule.token("das"), AgreementRule.tokenRegex("Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Montags?|D(ien|onner)stags?|Mittwochs?|Freitags?|S(ams|onn)tags?|Sonnabends?|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?")), Arrays.asList(AgreementRule.token("das"), AgreementRule.tokenRegex("Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Montags?|D(ien|onner)stags?|Mittwochs?|Freitags?|S(ams|onn)tags?|Sonnabends?|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?"), AgreementRule.posRegex("VER:.*|UNKNOWN")), Arrays.asList(AgreementRule.token("das"), AgreementRule.tokenRegex("(\u00fcber)?n\u00e4chste[ns]?|kommende[ns]?|(vor)?letzten"), AgreementRule.tokenRegex("Januar|Februar|M\u00e4rz|April|Mai|Juni|Juli|August|September|Oktober|November|Dezember|Montag|D(ien|onner)stag|Mittwoch|Freitag|S(ams|onn)tag|Sonnabend|Woche|Monat|Jahr|Morgens?|Abends|\u00dcbermorgen|Mittags?|Nachmittags?|Vormittags?|Sp\u00e4tabends?|Nachts?"), AgreementRule.posRegex("VER:.*|UNKNOWN")), Arrays.asList(AgreementRule.token("das"), AgreementRule.tokenRegex("Zufall|Sinn|Spa\u00df"), AgreementRule.token("?")), Arrays.asList(AgreementRule.token("in"), AgreementRule.tokenRegex("d(ies)?em"), AgreementRule.token("Fall"), AgreementRule.tokenRegex("(?i:hat(te)?)"), AgreementRule.token("das")), Arrays.asList(AgreementRule.posRegex("ADV:.+"), AgreementRule.tokenRegex("(?i:hat(te)?)"), AgreementRule.token("das")), Arrays.asList(AgreementRule.tokenRegex("von|bei"), AgreementRule.tokenRegex("(vielen|allen)"), AgreementRule.posRegex("PA2:.*|ADJ:AKK:PLU:.*")), Arrays.asList(AgreementRule.token("f\u00fcr"), AgreementRule.tokenRegex("(viele|alle|[dm]ich|ihn|sie|uns)"), AgreementRule.posRegex("ADJ:AKK:.*")), Arrays.asList(new PatternTokenBuilder().tokenRegex("fl\u00f6\u00dfen|machen|jagen").matchInflectedForms().build(), AgreementRule.token("einem"), AgreementRule.token("Angst")), Arrays.asList(AgreementRule.token("einem"), AgreementRule.token("Angst"), new PatternTokenBuilder().tokenRegex("machen|ein(fl\u00f6\u00dfen|jagen)").matchInflectedForms().build()), Arrays.asList(AgreementRule.token("einem"), AgreementRule.token("geschenkten"), AgreementRule.token("Gaul")), Arrays.asList(AgreementRule.token("kein"), AgreementRule.token("sch\u00f6ner"), AgreementRule.token("Land")), Arrays.asList(AgreementRule.tokenRegex("die|der|das"), AgreementRule.tokenRegex("Anfang|Ende"), AgreementRule.tokenRegex("Januar|J\u00e4nner|Februar|M\u00e4rz|April|Mai|Ju[ln]i|August|September|Oktober|November|Dezember|[12][0-9]{3}")), Arrays.asList(AgreementRule.pos("SENT_START"), AgreementRule.tokenRegex("Ist|Sind|Macht|Wird"), AgreementRule.token("das"), AgreementRule.posRegex("SUB:.*"), AgreementRule.posRegex("PKT|KON:NEB|ZUS")), Arrays.asList(AgreementRule.token(":"), AgreementRule.tokenRegex("Ist|Sind|Macht|Wird"), AgreementRule.token("das"), AgreementRule.posRegex("SUB:.*"), AgreementRule.posRegex("PKT|KON:NEB|ZUS")), Arrays.asList(AgreementRule.pos("SENT_START"), AgreementRule.tokenRegex("Meist(ens)?|Oft(mals)?|H\u00e4ufig|Selten"), AgreementRule.tokenRegex("sind|waren|ist"), AgreementRule.token("das"), AgreementRule.posRegex("SUB:.*")), Arrays.asList(AgreementRule.token(":"), AgreementRule.tokenRegex("Meist(ens)?|Oft(mals)?|H\u00e4ufig|Selten"), AgreementRule.tokenRegex("sind|waren|ist"), AgreementRule.token("das"), AgreementRule.posRegex("SUB:.*")), Arrays.asList(AgreementRule.token("des"), AgreementRule.token("Lied"), AgreementRule.token("ich")), Arrays.asList(AgreementRule.pos("SENT_START"), AgreementRule.tokenRegex("D(a|ie)s"), AgreementRule.posRegex("VER:[123]:.*"), AgreementRule.posRegex("SUB:NOM:.*")), Arrays.asList(AgreementRule.token(":"), AgreementRule.tokenRegex("D(a|ie)s"), AgreementRule.posRegex("VER:[123]:.*"), AgreementRule.posRegex("SUB:NOM:.*")), Arrays.asList(AgreementRule.posRegex("ART:.+"), AgreementRule.posRegex("ADJ:.+"), AgreementRule.tokenRegex("(Kilo|Zenti|Milli)?meter|Jahre|Monate|Wochen|Tage|Stunden|Minuten|Sekunden")), Arrays.asList(AgreementRule.token("Van"), AgreementRule.token("der"), AgreementRule.tokenRegex("Bellens?")), Arrays.asList(AgreementRule.token("mehrere"), AgreementRule.pos("SUB:NOM:SIN:FEM:ADJ")), Arrays.asList(AgreementRule.token("allen"), AgreementRule.tokenRegex("Besitz|Mut")), Arrays.asList(AgreementRule.tokenRegex("d(ie|e[nr])|[md]eine[nr]?"), AgreementRule.token("Top"), AgreementRule.tokenRegex("\\d+")), Arrays.asList(AgreementRule.posRegex("VER:3:SIN:.*"), AgreementRule.token("das"), AgreementRule.posRegex("ADJ:AKK:.*"), AgreementRule.posRegex("SUB:AKK:.*"), AgreementRule.pos("ZUS"), AgreementRule.pos("SENT_END")), Arrays.asList(AgreementRule.posRegex("VER:3:SIN:.+"), AgreementRule.token("das"), AgreementRule.posRegex("SUB:AKK:.+"), AgreementRule.pos("ZUS"), AgreementRule.pos("SENT_END")), Arrays.asList(AgreementRule.token("Au\u00dfenring"), AgreementRule.token("Autobahn")), Arrays.asList(AgreementRule.tokenRegex("[dw]em"), AgreementRule.csToken("Ehre"), AgreementRule.csToken("geb\u00fchrt")), Arrays.asList(AgreementRule.token("Eurovision"), AgreementRule.token("Song"), AgreementRule.token("Contest")), Arrays.asList(AgreementRule.posRegex("ART:.+"), AgreementRule.posRegex("SUB:.+"), AgreementRule.pos("UNKNOWN")), Arrays.asList(AgreementRule.csToken(","), AgreementRule.posRegex("KON:UNT|ADV:INR"), AgreementRule.csToken("das"), AgreementRule.posRegex("SUB:.+"), AgreementRule.posRegex("VER:3:SIN.*")), Arrays.asList(AgreementRule.tokenRegex("viele|wenige|einige|mehrere"), AgreementRule.csToken("solcher"), AgreementRule.posRegex("SUB:GEN:PLU:.*")), Arrays.asList(AgreementRule.tokenRegex("[dD](ie|er)"), AgreementRule.csToken("First"), AgreementRule.csToken("Lady")), Arrays.asList(AgreementRule.tokenRegex("[dD](ie|er)"), AgreementRule.posRegex("ADJ:.*"), AgreementRule.csToken("First"), AgreementRule.csToken("Lady")), Arrays.asList(AgreementRule.tokenRegex("[dD](ie|er)"), AgreementRule.csToken("Super"), AgreementRule.csToken("Nintendo")), Arrays.asList(AgreementRule.csToken(","), AgreementRule.csToken("beides"), AgreementRule.posRegex("ADJ:NOM:PLU.+"), AgreementRule.posRegex("SUB:NOM:PLU.+"), AgreementRule.csToken(",")), Arrays.asList(AgreementRule.tokenRegex("[dD]e[rn]"), AgreementRule.csToken("Gold"), AgreementRule.csToken("Cup")), Arrays.asList(AgreementRule.token("das"), AgreementRule.tokenRegex("viele|wenige"), AgreementRule.posRegex("SUB:.*")), Arrays.asList(AgreementRule.tokenRegex("allen|(nieman|je(man)?)dem"), AgreementRule.posRegex("ADJ:AKK:PLU:.*"), AgreementRule.posRegex("SUB:AKK:PLU:.*")), Arrays.asList(AgreementRule.tokenRegex("allen|(nieman|je(man)?)dem"), AgreementRule.posRegex("SUB:AKK:PLU:.*")), Arrays.asList(new PatternTokenBuilder().posRegex("PRP:.+|ADV:MOD").setSkip(2).build(), new PatternTokenBuilder().token("sein").matchInflectedForms().build(), AgreementRule.csToken("das"), AgreementRule.posRegex("SUB:NOM:.*"), AgreementRule.posRegex("PKT|SENT_END|KON.*")), Arrays.asList(AgreementRule.pos("KON:UNT"), AgreementRule.csToken("das"), AgreementRule.posRegex("SUB:.+"), new PatternTokenBuilder().tokenRegex("bedeuten|sein").matchInflectedForms().build()), Arrays.asList(AgreementRule.pos("KON:UNT"), AgreementRule.csToken("das"), AgreementRule.pos("ADV:MOD"), AgreementRule.posRegex("SUB:.+"), new PatternTokenBuilder().tokenRegex("bedeuten|sein").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().token("niemand").matchInflectedForms().build(), AgreementRule.posRegex("SUB:.+")), Arrays.asList(AgreementRule.token("alles"), AgreementRule.csToken("Walzer")), Arrays.asList(AgreementRule.csToken("der"), AgreementRule.csToken("Daus")), Arrays.asList(AgreementRule.posRegex("PRO:...:...:SIN:NEU.*"), AgreementRule.csToken("Orange")), Arrays.asList(AgreementRule.posRegex("PRO:...:...:SIN:NEU.*"), AgreementRule.posRegex("ADJ:.+"), AgreementRule.csToken("Orange")), Arrays.asList(AgreementRule.csToken("dem"), new PatternTokenBuilder().csToken("Achtung").setSkip(1).build(), new PatternTokenBuilder().csToken("schenken").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("schenken").matchInflectedForms().build(), AgreementRule.csToken("dem"), AgreementRule.csToken("Achtung")), Arrays.asList(AgreementRule.csToken("dem"), new PatternTokenBuilder().csToken("Rechnung").setSkip(1).build(), new PatternTokenBuilder().csToken("tragen").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("tragen").matchInflectedForms().build(), AgreementRule.csToken("dem"), AgreementRule.csToken("Rechnung")), Arrays.asList(AgreementRule.csToken("zum"), AgreementRule.csToken("einen"), AgreementRule.posRegex("ADJ:.+")), Arrays.asList(AgreementRule.token("auf"), AgreementRule.csToken("die"), AgreementRule.csToken("Lauer")), Arrays.asList(AgreementRule.token("dieser"), AgreementRule.csToken("eine"), AgreementRule.pos("SUB:NOM:SIN:MAS")), Arrays.asList(AgreementRule.token("das"), AgreementRule.posRegex("SUB:DAT:.+"), AgreementRule.token("vorbehalten")), Arrays.asList(new PatternTokenBuilder().token("wenn").setSkip(1).build(), AgreementRule.csToken("einer"), AgreementRule.posRegex("SUB:AKK:.+"), AgreementRule.posRegex("VER:(MOD:)?3:SIN:.+"), AgreementRule.csToken(",")), Arrays.asList(AgreementRule.tokenRegex("eine[rs]"), AgreementRule.tokenRegex("jed(wed)?en")), Arrays.asList(AgreementRule.token("die"), AgreementRule.tokenRegex("[MDS]einen")), Arrays.asList(AgreementRule.csToken("\u00fcber"), AgreementRule.csToken("die"), AgreementRule.csToken("Ma\u00dfen")), Arrays.asList(AgreementRule.token("was"), new PatternTokenBuilder().csToken("n\u00fctzen").matchInflectedForms().build(), AgreementRule.csToken("einem"), AgreementRule.posRegex("SUB:NOM:.+")), Arrays.asList(new PatternTokenBuilder().csToken("haben").matchInflectedForms().build(), AgreementRule.csToken("sein"), AgreementRule.csToken("Gutes")), Arrays.asList(AgreementRule.csToken("Gutes"), new PatternTokenBuilder().tokenRegex("haben|tun").matchInflectedForms().build()), Arrays.asList(AgreementRule.csToken("dieser"), AgreementRule.csToken("einen"), AgreementRule.pos("SUB:DAT:SIN:FEM")), Arrays.asList(AgreementRule.posRegex("ABK:.+:SUB")), Arrays.asList(AgreementRule.tokenRegex("(all|je(d|glich))en"), AgreementRule.csToken("Reiz")), Arrays.asList(new PatternTokenBuilder().posRegex("VER:.*[1-3]:.+").setSkip(1).build(), AgreementRule.csToken("vermehrt")));
    private static final Set<String> MODIFIERS = new HashSet<String>(Arrays.asList("besonders", "fast", "ganz", "geradezu", "sehr", "\u00fcberaus", "ziemlich"));
    private static final Set<String> VIELE_WENIGE_LOWERCASE = new HashSet<String>(Arrays.asList("viele", "vieler", "wenige", "weniger", "einige", "einiger", "mehrerer", "mehrere"));
    private static final String[] REL_PRONOUN_LEMMAS = new String[]{"der", "welch"};
    private static final Set<String> PRONOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("ich", "dir", "du", "er", "sie", "es", "wir", "mir", "uns", "ihnen", "euch", "ihm", "ihr", "ihn", "dessen", "deren", "denen", "sich", "aller", "man", "beide", "beiden", "beider", "wessen", "a", "alle", "etwas", "irgendetwas", "was", "wer", "jenen", "diejenigen", "jemand", "jemandes", "niemand", "niemandes"));
    private static final Set<String> NOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("Prozent", "Gramm", "Post", "Kilogramm", "Meter", "Token", "Boots", "Taxameter", "Bild", "Uhr"));

    private static PatternToken tokenRegex(String s) {
        return new PatternTokenBuilder().tokenRegex(s).build();
    }

    private static PatternToken posRegex(String s) {
        return new PatternTokenBuilder().posRegex(s).build();
    }

    private static PatternToken csToken(String s) {
        return new PatternTokenBuilder().csToken(s).build();
    }

    private static PatternToken pos(String s) {
        return new PatternTokenBuilder().pos(s).build();
    }

    private static PatternToken token(String s) {
        return new PatternTokenBuilder().token(s).build();
    }

    public AgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>Der Haus</marker> wurde letztes Jahr gebaut."), Example.fixed((String)"<marker>Das Haus</marker> wurde letztes Jahr gebaut."));
    }

    public String getId() {
        return "DE_AGREEMENT";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public String getDescription() {
        return "Kongruenz von Nominalphrasen (unvollst\u00e4ndig!), z.B. 'mein kleiner(kleines) Haus'";
    }

    private void replacePrepositionsByArticle(AnalyzedTokenReadings[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"ins", "ans", "aufs", "vors", "durchs", "hinters", "unters", "\u00fcbers", "f\u00fcrs", "ums"})) {
                tokens[i] = new AnalyzedTokenReadings(INS_REPLACEMENT, tokens[i].getStartPos());
                continue;
            }
            if (!StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"zur"})) continue;
            tokens[i] = new AnalyzedTokenReadings(ZUR_REPLACEMENT, tokens[i].getStartPos());
        }
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        this.replacePrepositionsByArticle(tokens);
        for (int i = 0; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            boolean followingParticiple;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if ("SENT_START".equals(posToken) || tokens[i].isImmunized()) continue;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            boolean relevantPronoun = this.isRelevantPronoun(tokens, i);
            boolean ignore = this.couldBeRelativeOrDependentClause(tokens, i);
            if (i > 0) {
                String prevToken = tokens[i - 1].getToken().toLowerCase();
                if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"eine", "einen"}) && StringUtils.equalsAny((CharSequence)prevToken, (CharSequence[])new CharSequence[]{"der", "die", "das", "des", "dieses"})) {
                    ignore = true;
                }
            }
            if (StringUtils.equalsAny((CharSequence)tokenReadings.getToken(), (CharSequence[])new CharSequence[]{"nichts", "alles", "dies"})) {
                ignore = true;
            }
            boolean detAbbrev = i < tokens.length - 2 && tokens[i + 1].getToken().equals("Art") && tokens[i + 2].getToken().equals(".");
            boolean detAdjAbbrev = i < tokens.length - 3 && tokens[i + 2].getToken().equals("Art") && tokens[i + 3].getToken().equals(".");
            boolean bl = followingParticiple = i < tokens.length - 3 && (tokens[i + 2].hasPartialPosTag("PA1") || tokens[i + 2].getToken().matches("zugeschriebenen?|genannten?"));
            if (detAbbrev || detAdjAbbrev || followingParticiple) {
                ignore = true;
            }
            if (!GermanHelper.hasReadingOfType(tokenReadings, GermanToken.POSType.DETERMINER) && !relevantPronoun || ignore) continue;
            int tokenPosAfterModifier = this.getPosAfterModifier(i + 1, tokens);
            int tokenPos = tokenPosAfterModifier;
            if (tokenPos >= tokens.length) break;
            AnalyzedTokenReadings nextToken = tokens[tokenPos];
            if (this.isNonPredicativeAdjective(nextToken) || this.isParticiple(nextToken)) {
                tokenPos = tokenPosAfterModifier + 1;
                if (tokenPos >= tokens.length) break;
                if (!GermanHelper.hasReadingOfType(tokens[tokenPos], GermanToken.POSType.NOMEN) || i >= 2 && GermanHelper.hasReadingOfType(tokens[i - 2], GermanToken.POSType.ADJEKTIV) && "als".equals(tokens[i - 1].getToken()) && "das".equals(tokens[i].getToken()) || (ruleMatch = this.checkDetAdjNounAgreement(tokens[i], nextToken, tokens[tokenPos], sentence, i)) == null) continue;
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!GermanHelper.hasReadingOfType(nextToken, GermanToken.POSType.NOMEN) || "Herr".equals(nextToken.getToken()) || (ruleMatch = this.checkDetNounAgreement(tokens[i], nextToken, sentence, i)) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private int getPosAfterModifier(int startAt, AnalyzedTokenReadings[] tokens) {
        if (startAt + 1 < tokens.length && MODIFIERS.contains(tokens[startAt].getToken())) {
            ++startAt;
        }
        if (startAt + 1 < tokens.length && (StringUtils.isNumeric((CharSequence)tokens[startAt].getToken()) || tokens[startAt].hasPosTag("ZAL"))) {
            int posAfterModifier = startAt + 1;
            if (startAt + 3 < tokens.length && ",".equals(tokens[startAt + 1].getToken()) && StringUtils.isNumeric((CharSequence)tokens[startAt + 2].getToken())) {
                posAfterModifier = startAt + 3;
            }
            if (StringUtils.endsWithAny((CharSequence)tokens[posAfterModifier].getToken(), (CharSequence[])new CharSequence[]{"gramm", "Gramm", "Meter", "meter"})) {
                return posAfterModifier + 1;
            }
        }
        return startAt;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.language);
    }

    private boolean isNonPredicativeAdjective(AnalyzedTokenReadings tokensReadings) {
        for (AnalyzedToken reading : tokensReadings.getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith("ADJ") || posTag.contains("PRD")) continue;
            return true;
        }
        return false;
    }

    private boolean isParticiple(AnalyzedTokenReadings tokensReadings) {
        return tokensReadings.hasPartialPosTag("PA1") || tokensReadings.hasPartialPosTag("PA2");
    }

    private boolean isRelevantPronoun(AnalyzedTokenReadings[] tokens, int pos) {
        AnalyzedTokenReadings analyzedToken = tokens[pos];
        boolean relevantPronoun = GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PRONOMEN);
        String token = tokens[pos].getToken();
        if (PRONOUNS_TO_BE_IGNORED.contains(token.toLowerCase()) || pos > 0 && tokens[pos - 1].getToken().equalsIgnoreCase("vor") && token.equalsIgnoreCase("allem")) {
            relevantPronoun = false;
        }
        return relevantPronoun;
    }

    private boolean couldBeRelativeOrDependentClause(AnalyzedTokenReadings[] tokens, int pos) {
        boolean relPronoun;
        boolean comma;
        if (pos >= 1) {
            comma = tokens[pos - 1].getToken().equals(",");
            boolean bl = relPronoun = comma && tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            if (relPronoun && pos + 3 < tokens.length) {
                return true;
            }
        }
        if (pos >= 2 && (comma = tokens[pos - 2].getToken().equals(","))) {
            boolean prep = tokens[pos - 1].hasPosTagStartingWith("PRP:");
            relPronoun = tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            return prep && relPronoun || tokens[pos - 1].hasPosTag("KON:UNT") && (tokens[pos].hasLemma("jen") || tokens[pos].hasLemma("dies"));
        }
        return false;
    }

    @Nullable
    private RuleMatch checkDetNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedSentence sentence, int tokenPos) {
        if (token2.isImmunized() || NOUNS_TO_BE_IGNORED.contains(token2.getToken()) || "-".equals(token2.getToken())) {
            return null;
        }
        Set<String> set1 = null;
        set1 = token1.getReadings().size() == 1 && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag() != null && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag().endsWith(":STV") ? Collections.emptySet() : this.getAgreementCategories(token1);
        if (set1 == null) {
            return null;
        }
        Set<String> set2 = this.getAgreementCategories(token2);
        if (set2 == null) {
            return null;
        }
        set1.retainAll(set2);
        RuleMatch ruleMatch = null;
        if (set1.isEmpty() && !this.isException(token1, token2)) {
            RuleMatch compoundMatch = this.getCompoundError(token1, token2, tokenPos, sentence);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            List<String> errorCategories = this.getCategoriesCausingError(token1, token2);
            String errorDetails = errorCategories.isEmpty() ? "Kasus, Genus oder Numerus" : String.join((CharSequence)" und ", errorCategories);
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel und Nomen bez\u00fcglich " + errorDetails + ".";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich " + errorDetails;
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token2.getEndPos(), msg, shortMsg);
            AgreementSuggestor suggestor = new AgreementSuggestor(this.language.getSynthesizer(), token1, token2);
            List<String> suggestions = suggestor.getSuggestions();
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, int tokenPos, AnalyzedSentence sentence) {
        AnalyzedTokenReadings nextToken;
        if (tokenPos != -1 && tokenPos + 2 < sentence.getTokensWithoutWhitespace().length && StringTools.startsWithUppercase((String)(nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 2]).getToken())) {
            String potentialCompound = token2.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            String testPhrase = token1.getToken() + " " + potentialCompound;
            String hyphenPotentialCompound = token2.getToken() + "-" + nextToken.getToken();
            String hyphenTestPhrase = token1.getToken() + " " + hyphenPotentialCompound;
            return this.getRuleMatch(token1, sentence, nextToken, testPhrase, hyphenTestPhrase);
        }
        return null;
    }

    @Nullable
    private RuleMatch getCompoundError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, int tokenPos, AnalyzedSentence sentence) {
        AnalyzedTokenReadings nextToken;
        if (tokenPos != -1 && tokenPos + 3 < sentence.getTokensWithoutWhitespace().length && StringTools.startsWithUppercase((String)(nextToken = sentence.getTokensWithoutWhitespace()[tokenPos + 3]).getToken())) {
            String potentialCompound = token3.getToken() + StringTools.lowercaseFirstChar((String)nextToken.getToken());
            String testPhrase = token1.getToken() + " " + token2.getToken() + " " + potentialCompound;
            String hyphenPotentialCompound = token3.getToken() + "-" + nextToken.getToken();
            String hyphenTestPhrase = token1.getToken() + " " + token2.getToken() + " " + hyphenPotentialCompound;
            return this.getRuleMatch(token1, sentence, nextToken, testPhrase, hyphenTestPhrase);
        }
        return null;
    }

    @Nullable
    private RuleMatch getRuleMatch(AnalyzedTokenReadings token1, AnalyzedSentence sentence, AnalyzedTokenReadings nextToken, String testPhrase, String hyphenTestPhrase) {
        try {
            this.initLt();
            List matches = this.lt.check(testPhrase);
            if (matches.size() == 0) {
                String message = "Wenn es sich um ein zusammengesetztes Nomen handelt, wird es zusammengeschrieben.";
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), nextToken.getEndPos(), message);
                ruleMatch.addSuggestedReplacement(testPhrase);
                ruleMatch.addSuggestedReplacement(hyphenTestPhrase);
                ruleMatch.setUrl(Tools.getUrl((String)"http://www.canoonet.eu/services/GermanSpelling/Regeln/Getrennt-zusammen/Nomen.html#Anchor-Nomen-49575"));
                return ruleMatch;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void initLt() {
        if (this.lt == null) {
            this.lt = new JLanguageTool((Language)this.language);
            for (Rule rule : this.lt.getAllActiveRules()) {
                if (rule.getId().equals("DE_AGREEMENT") || rule.getId().equals("GERMAN_SPELLER_RULE")) continue;
                this.lt.disableRule(rule.getId());
            }
        }
    }

    private boolean isException(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        return "allen".equals(token1.getToken()) && "Grund".equals(token2.getToken());
    }

    private List<String> getCategoriesCausingError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        ArrayList<String> categories = new ArrayList<String>();
        List<GrammarCategory> categoriesToCheck = Arrays.asList(GrammarCategory.KASUS, GrammarCategory.GENUS, GrammarCategory.NUMERUS);
        for (GrammarCategory category : categoriesToCheck) {
            if (!this.agreementWithCategoryRelaxation(token1, token2, category)) continue;
            categories.add(category.displayName);
        }
        return categories;
    }

    private RuleMatch checkDetAdjNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedSentence sentence, int tokenPos) {
        if (token3 == null || token3.getToken().length() < 2) {
            return null;
        }
        Set<String> set = this.retainCommonCategories(token1, token2, token3);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            RuleMatch compoundMatch = this.getCompoundError(token1, token2, token3, tokenPos, sentence);
            if (compoundMatch != null) {
                return compoundMatch;
            }
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel, Adjektiv und Nomen bez\u00fcglich Kasus, Numerus oder Genus. Beispiel: 'mein kleiner Haus' statt 'mein kleines Haus'";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich Kasus, Numerus oder Genus";
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token3.getEndPos(), msg, shortMsg);
        }
        return ruleMatch;
    }

    private boolean agreementWithCategoryRelaxation(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, GrammarCategory categoryToRelax) {
        Set<GrammarCategory> categoryToRelaxSet = categoryToRelax != null ? Collections.singleton(categoryToRelax) : Collections.emptySet();
        Set<String> set1 = this.getAgreementCategories(token1, categoryToRelaxSet, true);
        if (set1 == null) {
            return true;
        }
        Set<String> set2 = this.getAgreementCategories(token2, categoryToRelaxSet, true);
        if (set2 == null) {
            return true;
        }
        set1.retainAll(set2);
        return set1.size() > 0;
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3) {
        Set<GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        Set<String> set1 = this.getAgreementCategories(token1, categoryToRelaxSet, true);
        if (set1 == null) {
            return Collections.emptySet();
        }
        boolean skipSol = !VIELE_WENIGE_LOWERCASE.contains(token1.getToken().toLowerCase());
        Set<String> set2 = this.getAgreementCategories(token2, categoryToRelaxSet, skipSol);
        if (set2 == null) {
            return Collections.emptySet();
        }
        Set<String> set3 = this.getAgreementCategories(token3, categoryToRelaxSet, true);
        if (set3 == null) {
            return Collections.emptySet();
        }
        set1.retainAll(set2);
        set1.retainAll(set3);
        return set1;
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken) {
        return this.getAgreementCategories(aToken, new HashSet<GrammarCategory>(), false);
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken, Set<GrammarCategory> omit, boolean skipSol) {
        HashSet<String> set = new HashSet<String>();
        List readings = aToken.getReadings();
        for (AnalyzedToken tmpReading : readings) {
            AnalyzedGermanToken reading;
            if (skipSol && tmpReading.getPOSTag() != null && tmpReading.getPOSTag().endsWith(":SOL") || (reading = new AnalyzedGermanToken(tmpReading)).getCasus() == null && reading.getNumerus() == null && reading.getGenus() == null) continue;
            if (reading.getGenus() == GermanToken.Genus.ALLGEMEIN && tmpReading.getPOSTag() != null && !tmpReading.getPOSTag().endsWith(":STV") && !this.possessiveSpecialCase(aToken, tmpReading)) {
                if (reading.getDetermination() == null) {
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, GermanToken.Determination.INDEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, GermanToken.Determination.INDEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, GermanToken.Determination.INDEFINITE, omit));
                    continue;
                }
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, reading.getDetermination(), omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, reading.getDetermination(), omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, reading.getDetermination(), omit));
                continue;
            }
            if (reading.getDetermination() == null || "jed".equals(tmpReading.getLemma()) || "manch".equals(tmpReading.getLemma())) {
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.DEFINITE, omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.INDEFINITE, omit));
                continue;
            }
            set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), reading.getDetermination(), omit));
        }
        return set;
    }

    private boolean possessiveSpecialCase(AnalyzedTokenReadings aToken, AnalyzedToken tmpReading) {
        return aToken.hasPosTagStartingWith("PRO:POS") && StringUtils.equalsAny((CharSequence)tmpReading.getLemma(), (CharSequence[])new CharSequence[]{"ich", "sich"});
    }

    private String makeString(GermanToken.Kasus casus, GermanToken.Numerus num, GermanToken.Genus gen, GermanToken.Determination determination, Set<GrammarCategory> omit) {
        ArrayList<String> l = new ArrayList<String>();
        if (casus != null && !omit.contains((Object)GrammarCategory.KASUS)) {
            l.add(casus.toString());
        }
        if (num != null && !omit.contains((Object)GrammarCategory.NUMERUS)) {
            l.add(num.toString());
        }
        if (gen != null && !omit.contains((Object)GrammarCategory.GENUS)) {
            l.add(gen.toString());
        }
        if (determination != null) {
            l.add(determination.toString());
        }
        return String.join((CharSequence)"/", l);
    }

    private static enum GrammarCategory {
        KASUS("Kasus (Fall: Wer/Was, Wessen, Wem, Wen/Was - Beispiel: 'das Fahrrads' statt 'des Fahrrads')"),
        GENUS("Genus (m\u00e4nnlich, weiblich, s\u00e4chlich - Beispiel: 'der Fahrrad' statt 'das Fahrrad')"),
        NUMERUS("Numerus (Einzahl, Mehrzahl - Beispiel: 'das Fahrr\u00e4der' statt 'die Fahrr\u00e4der')");

        private final String displayName;

        private GrammarCategory(String displayName) {
            this.displayName = displayName;
        }
    }
}

