/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementSuggestor;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

public class AgreementRule
extends Rule {
    private final German language;
    private static final AnalyzedToken[] INS_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("das", "ART:DEF:AKK:SIN:NEU", "das")};
    private static final AnalyzedToken[] ZUR_REPLACEMENT = new AnalyzedToken[]{new AnalyzedToken("der", "ART:DEF:DAT:SIN:FEM", "der")};
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().posRegex("PRO:DEM:.+").build(), new PatternTokenBuilder().posRegex("PA2:.+").build(), new PatternTokenBuilder().posRegex("SUB:.*:PLU.*").build()), Arrays.asList(new PatternTokenBuilder().posRegex("VER:.*").build(), new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().tokenRegex("(\u00fcber)?n\u00e4chste[ns]?|kommende[ns]?").build(), new PatternTokenBuilder().tokenRegex("Montag|D(ien|onner)stag|Mittwoch|Freitag|S(ams|onn)tag|Woche|Monat|Jahr").build()), Arrays.asList(new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().tokenRegex("Zufall|Sinn|Spa\u00df").build(), new PatternTokenBuilder().token("?").build()), Arrays.asList(new PatternTokenBuilder().token("in").build(), new PatternTokenBuilder().tokenRegex("d(ies)?em").build(), new PatternTokenBuilder().token("Fall").build(), new PatternTokenBuilder().tokenRegex("(?i:hat(te)?)").build(), new PatternTokenBuilder().token("das").build()), Arrays.asList(new PatternTokenBuilder().posRegex("ADV:.+").build(), new PatternTokenBuilder().tokenRegex("(?i:hat(te)?)").build(), new PatternTokenBuilder().token("das").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("von|bei").build(), new PatternTokenBuilder().tokenRegex("(vielen|allen)").build(), new PatternTokenBuilder().posRegex("PA2:.*|ADJ:AKK:PLU:.*").build()), Arrays.asList(new PatternTokenBuilder().token("f\u00fcr").build(), new PatternTokenBuilder().tokenRegex("(viele|alle|[dm]ich|ihn|sie|uns)").build(), new PatternTokenBuilder().posRegex("ADJ:AKK:.*").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("fl\u00f6\u00dfen|machen|jagen").matchInflectedForms().build(), new PatternTokenBuilder().token("einem").build(), new PatternTokenBuilder().token("Angst").build()), Arrays.asList(new PatternTokenBuilder().token("einem").build(), new PatternTokenBuilder().token("Angst").build(), new PatternTokenBuilder().tokenRegex("machen|ein(fl\u00f6\u00dfen|jagen)").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().token("einem").build(), new PatternTokenBuilder().token("geschenkten").build(), new PatternTokenBuilder().token("Gaul").build()), Arrays.asList(new PatternTokenBuilder().token("kein").build(), new PatternTokenBuilder().token("sch\u00f6ner").build(), new PatternTokenBuilder().token("Land").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("die|der|das").build(), new PatternTokenBuilder().tokenRegex("Anfang|Ende").build(), new PatternTokenBuilder().tokenRegex("Januar|J\u00e4nner|Februar|M\u00e4rz|April|Mai|Ju[ln]i|August|September|Oktober|November|Dezember|[12][0-9]{3}").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().tokenRegex("Ist|Sind|Macht|Wird").build(), new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().posRegex("SUB:.*").build(), new PatternTokenBuilder().posRegex("PKT|KON:NEB|ZUS").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().tokenRegex("Meist(ens)?|Oft(mals)?|H\u00e4ufig|Selten").build(), new PatternTokenBuilder().tokenRegex("sind|waren|ist").build(), new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().posRegex("SUB:.*").build()), Arrays.asList(new PatternTokenBuilder().token("des").build(), new PatternTokenBuilder().token("Lied").build(), new PatternTokenBuilder().token("ich").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().tokenRegex("D(a|ie)s").build(), new PatternTokenBuilder().posRegex("VER:[123]:.*").build(), new PatternTokenBuilder().posRegex("SUB:NOM:.*").build()), Arrays.asList(new PatternTokenBuilder().posRegex("ART:.+").build(), new PatternTokenBuilder().posRegex("ADJ:.+").build(), new PatternTokenBuilder().tokenRegex("(Kilo|Zenti|Milli)?meter|Jahre|Monate|Wochen|Tage|Stunden|Minuten|Sekunden").build()), Arrays.asList(new PatternTokenBuilder().token("Van").build(), new PatternTokenBuilder().token("der").build(), new PatternTokenBuilder().tokenRegex("Bellens?").build()), Arrays.asList(new PatternTokenBuilder().token("mehrere").build(), new PatternTokenBuilder().pos("SUB:NOM:SIN:FEM:ADJ").build()), Arrays.asList(new PatternTokenBuilder().token("allen").build(), new PatternTokenBuilder().tokenRegex("Besitz|Mut").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("d(ie|e[nr])|[md]eine[nr]?").build(), new PatternTokenBuilder().token("Top").build(), new PatternTokenBuilder().tokenRegex("\\d+").build()), Arrays.asList(new PatternTokenBuilder().posRegex("VER:3:SIN:.*").build(), new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().posRegex("ADJ:AKK:.*").build(), new PatternTokenBuilder().posRegex("SUB:AKK:.*").build(), new PatternTokenBuilder().pos("ZUS").build(), new PatternTokenBuilder().pos("SENT_END").build()), Arrays.asList(new PatternTokenBuilder().posRegex("VER:3:SIN:.+").build(), new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().posRegex("SUB:AKK:.+").build(), new PatternTokenBuilder().pos("ZUS").build(), new PatternTokenBuilder().pos("SENT_END").build()), Arrays.asList(new PatternTokenBuilder().token("Au\u00dfenring").build(), new PatternTokenBuilder().token("Autobahn").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[dw]em").build(), new PatternTokenBuilder().csToken("Ehre").build(), new PatternTokenBuilder().csToken("geb\u00fchrt").build()), Arrays.asList(new PatternTokenBuilder().token("Eurovision").build(), new PatternTokenBuilder().token("Song").build(), new PatternTokenBuilder().token("Contest").build()), Arrays.asList(new PatternTokenBuilder().posRegex("ART:.+").build(), new PatternTokenBuilder().posRegex("SUB:.+").build(), new PatternTokenBuilder().pos("UNKNOWN").build()), Arrays.asList(new PatternTokenBuilder().csToken(",").build(), new PatternTokenBuilder().posRegex("KON:UNT|ADV:INR").build(), new PatternTokenBuilder().csToken("das").build(), new PatternTokenBuilder().posRegex("SUB:.+").build(), new PatternTokenBuilder().posRegex("VER:3:SIN.*").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("viele|wenige|einige|mehrere").build(), new PatternTokenBuilder().csToken("solcher").build(), new PatternTokenBuilder().posRegex("SUB:GEN:PLU:.*").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[dD](ie|er)").build(), new PatternTokenBuilder().csToken("First").build(), new PatternTokenBuilder().csToken("Lady").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[dD](ie|er)").build(), new PatternTokenBuilder().posRegex("ADJ:.*").build(), new PatternTokenBuilder().csToken("First").build(), new PatternTokenBuilder().csToken("Lady").build()), Arrays.asList(new PatternTokenBuilder().csToken(",").build(), new PatternTokenBuilder().csToken("beides").build(), new PatternTokenBuilder().posRegex("ADJ:NOM:PLU.+").build(), new PatternTokenBuilder().posRegex("SUB:NOM:PLU.+").build(), new PatternTokenBuilder().csToken(",").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("[dD]e[rn]").build(), new PatternTokenBuilder().csToken("Gold").build(), new PatternTokenBuilder().csToken("Cup").build()), Arrays.asList(new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().tokenRegex("viele|wenige").build(), new PatternTokenBuilder().posRegex("SUB:.*").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("allen|(nieman|je(man)?)dem").build(), new PatternTokenBuilder().posRegex("ADJ:AKK:PLU:.*").build(), new PatternTokenBuilder().posRegex("SUB:AKK:PLU:.*").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("allen|(nieman|je(man)?)dem").build(), new PatternTokenBuilder().posRegex("SUB:AKK:PLU:.*").build()), Arrays.asList(new PatternTokenBuilder().posRegex("PRP:.+|ADV:MOD").setSkip(2).build(), new PatternTokenBuilder().token("sein").matchInflectedForms().build(), new PatternTokenBuilder().csToken("das").build(), new PatternTokenBuilder().posRegex("SUB:NOM:.*").build(), new PatternTokenBuilder().posRegex("PKT|SENT_END").build()), Arrays.asList(new PatternTokenBuilder().pos("KON:UNT").build(), new PatternTokenBuilder().csToken("das").build(), new PatternTokenBuilder().posRegex("SUB:.+").build(), new PatternTokenBuilder().tokenRegex("bedeuten|sein").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().pos("KON:UNT").build(), new PatternTokenBuilder().csToken("das").build(), new PatternTokenBuilder().pos("ADV:MOD").build(), new PatternTokenBuilder().posRegex("SUB:.+").build(), new PatternTokenBuilder().tokenRegex("bedeuten|sein").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().token("niemand").matchInflectedForms().build(), new PatternTokenBuilder().posRegex("SUB:.+").build()), Arrays.asList(new PatternTokenBuilder().token("alles").build(), new PatternTokenBuilder().csToken("Walzer").build()), Arrays.asList(new PatternTokenBuilder().csToken("der").build(), new PatternTokenBuilder().csToken("Daus").build()), Arrays.asList(new PatternTokenBuilder().csToken("dem").build(), new PatternTokenBuilder().csToken("Achtung").setSkip(1).build(), new PatternTokenBuilder().csToken("schenken").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("schenken").matchInflectedForms().build(), new PatternTokenBuilder().csToken("dem").build(), new PatternTokenBuilder().csToken("Achtung").build()), Arrays.asList(new PatternTokenBuilder().csToken("dem").build(), new PatternTokenBuilder().csToken("Rechnung").setSkip(1).build(), new PatternTokenBuilder().csToken("tragen").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("tragen").matchInflectedForms().build(), new PatternTokenBuilder().csToken("dem").build(), new PatternTokenBuilder().csToken("Rechnung").build()), Arrays.asList(new PatternTokenBuilder().csToken("zum").build(), new PatternTokenBuilder().csToken("einen").build(), new PatternTokenBuilder().posRegex("ADJ:.+").build()), Arrays.asList(new PatternTokenBuilder().token("auf").build(), new PatternTokenBuilder().csToken("die").build(), new PatternTokenBuilder().csToken("Lauer").build()), Arrays.asList(new PatternTokenBuilder().token("dieser").build(), new PatternTokenBuilder().csToken("eine").build(), new PatternTokenBuilder().pos("SUB:NOM:SIN:MAS").build()), Arrays.asList(new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().posRegex("SUB:DAT:.+").build(), new PatternTokenBuilder().token("vorbehalten").build()), Arrays.asList(new PatternTokenBuilder().token("wenn").setSkip(1).build(), new PatternTokenBuilder().csToken("einer").build(), new PatternTokenBuilder().posRegex("SUB:AKK:.+").build(), new PatternTokenBuilder().posRegex("VER:(MOD:)?3:SIN:.+").build(), new PatternTokenBuilder().csToken(",").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("eine[rs]").build(), new PatternTokenBuilder().tokenRegex("jed(wed)?en").build()), Arrays.asList(new PatternTokenBuilder().token("die").build(), new PatternTokenBuilder().tokenRegex("[MDS]einen").build()), Arrays.asList(new PatternTokenBuilder().csToken("\u00fcber").build(), new PatternTokenBuilder().csToken("die").build(), new PatternTokenBuilder().csToken("Ma\u00dfen").build()), Arrays.asList(new PatternTokenBuilder().token("was").build(), new PatternTokenBuilder().csToken("n\u00fctzen").matchInflectedForms().build(), new PatternTokenBuilder().csToken("einem").build(), new PatternTokenBuilder().posRegex("SUB:NOM:.+").build()), Arrays.asList(new PatternTokenBuilder().csToken("haben").matchInflectedForms().build(), new PatternTokenBuilder().csToken("sein").build(), new PatternTokenBuilder().csToken("Gutes").build()), Arrays.asList(new PatternTokenBuilder().csToken("Gutes").build(), new PatternTokenBuilder().tokenRegex("haben|tun").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().csToken("dieser").build(), new PatternTokenBuilder().csToken("einen").build(), new PatternTokenBuilder().pos("SUB:DAT:SIN:FEM").build()), Arrays.asList(new PatternTokenBuilder().posRegex("ABK:.+:SUB").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("(all|je(d|glich))en").build(), new PatternTokenBuilder().csToken("Reiz").build()), Arrays.asList(new PatternTokenBuilder().posRegex("VER:.*[1-3]:.+").setSkip(1).build(), new PatternTokenBuilder().csToken("vermehrt").build()));
    private static final Set<String> MODIFIERS = new HashSet<String>(Arrays.asList("besonders", "fast", "ganz", "geradezu", "sehr", "\u00fcberaus", "ziemlich"));
    private static final Set<String> VIELE_WENIGE_LOWERCASE = new HashSet<String>(Arrays.asList("viele", "vieler", "wenige", "weniger", "einige", "einiger", "mehrerer", "mehrere"));
    private static final String[] REL_PRONOUN_LEMMAS = new String[]{"der", "welch"};
    private static final Set<String> PRONOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("ich", "dir", "du", "er", "sie", "es", "wir", "mir", "uns", "ihnen", "euch", "ihm", "ihr", "ihn", "dessen", "deren", "denen", "sich", "aller", "man", "beide", "beiden", "beider", "wessen", "a", "alle", "etwas", "irgendetwas", "was", "wer", "jenen", "diejenigen", "jemand", "jemandes", "niemand", "niemandes"));
    private static final Set<String> NOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("Prozent", "Gramm", "Kilogramm", "Uhr"));

    public AgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"<marker>Der Haus</marker> wurde letztes Jahr gebaut."), Example.fixed((String)"<marker>Das Haus</marker> wurde letztes Jahr gebaut."));
    }

    public String getId() {
        return "DE_AGREEMENT";
    }

    public int estimateContextForSureMatch() {
        return ANTI_PATTERNS.stream().mapToInt(List::size).max().orElse(0);
    }

    public String getDescription() {
        return "Kongruenz von Nominalphrasen (unvollst\u00e4ndig!), z.B. 'mein kleiner(kleines) Haus'";
    }

    private void replacePrepositionsByArticle(AnalyzedTokenReadings[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"ins", "ans", "aufs", "vors", "durchs", "hinters", "unters", "\u00fcbers", "f\u00fcrs", "ums"})) {
                tokens[i] = new AnalyzedTokenReadings(INS_REPLACEMENT, tokens[i].getStartPos());
                continue;
            }
            if (!StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"zur"})) continue;
            tokens[i] = new AnalyzedTokenReadings(ZUR_REPLACEMENT, tokens[i].getStartPos());
        }
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        this.replacePrepositionsByArticle(tokens);
        for (int i = 0; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            boolean followingParticiple;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if ("SENT_START".equals(posToken) || tokens[i].isImmunized()) continue;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            boolean relevantPronoun = this.isRelevantPronoun(tokens, i);
            boolean ignore = this.couldBeRelativeOrDependentClause(tokens, i);
            if (i > 0) {
                String prevToken = tokens[i - 1].getToken().toLowerCase();
                if (StringUtils.equalsAny((CharSequence)tokens[i].getToken(), (CharSequence[])new CharSequence[]{"eine", "einen"}) && StringUtils.equalsAny((CharSequence)prevToken, (CharSequence[])new CharSequence[]{"der", "die", "das", "des", "dieses"})) {
                    ignore = true;
                }
            }
            if (StringUtils.equalsAny((CharSequence)tokenReadings.getToken(), (CharSequence[])new CharSequence[]{"nichts", "alles", "dies"})) {
                ignore = true;
            }
            boolean detAbbrev = i < tokens.length - 2 && tokens[i + 1].getToken().equals("Art") && tokens[i + 2].getToken().equals(".");
            boolean detAdjAbbrev = i < tokens.length - 3 && tokens[i + 2].getToken().equals("Art") && tokens[i + 3].getToken().equals(".");
            boolean bl = followingParticiple = i < tokens.length - 3 && (tokens[i + 2].hasPartialPosTag("PA1") || tokens[i + 2].getToken().matches("zugeschriebenen?|genannten?"));
            if (detAbbrev || detAdjAbbrev || followingParticiple) {
                ignore = true;
            }
            if (!GermanHelper.hasReadingOfType(tokenReadings, GermanToken.POSType.DETERMINER) && !relevantPronoun || ignore) continue;
            int tokenPosAfterModifier = this.getPosAfterModifier(i + 1, tokens);
            int tokenPos = tokenPosAfterModifier;
            if (tokenPos >= tokens.length) break;
            AnalyzedTokenReadings nextToken = tokens[tokenPos];
            if (this.isNonPredicativeAdjective(nextToken) || this.isParticiple(nextToken)) {
                tokenPos = tokenPosAfterModifier + 1;
                if (tokenPos >= tokens.length) break;
                if (!GermanHelper.hasReadingOfType(tokens[tokenPos], GermanToken.POSType.NOMEN) || i >= 2 && GermanHelper.hasReadingOfType(tokens[i - 2], GermanToken.POSType.ADJEKTIV) && "als".equals(tokens[i - 1].getToken()) && "das".equals(tokens[i].getToken()) || (ruleMatch = this.checkDetAdjNounAgreement(tokens[i], nextToken, tokens[tokenPos], sentence)) == null) continue;
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!GermanHelper.hasReadingOfType(nextToken, GermanToken.POSType.NOMEN) || "Herr".equals(nextToken.getToken()) || (ruleMatch = this.checkDetNounAgreement(tokens[i], nextToken, sentence)) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private int getPosAfterModifier(int startAt, AnalyzedTokenReadings[] tokens) {
        if (startAt + 1 < tokens.length && MODIFIERS.contains(tokens[startAt].getToken())) {
            ++startAt;
        }
        if (startAt + 1 < tokens.length && (StringUtils.isNumeric((CharSequence)tokens[startAt].getToken()) || tokens[startAt].hasPosTag("ZAL"))) {
            int posAfterModifier = startAt + 1;
            if (startAt + 3 < tokens.length && ",".equals(tokens[startAt + 1].getToken()) && StringUtils.isNumeric((CharSequence)tokens[startAt + 2].getToken())) {
                posAfterModifier = startAt + 3;
            }
            if (StringUtils.endsWithAny((CharSequence)tokens[posAfterModifier].getToken(), (CharSequence[])new CharSequence[]{"gramm", "Gramm", "Meter", "meter"})) {
                return posAfterModifier + 1;
            }
        }
        return startAt;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.language);
    }

    private boolean isNonPredicativeAdjective(AnalyzedTokenReadings tokensReadings) {
        for (AnalyzedToken reading : tokensReadings.getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.startsWith("ADJ") || posTag.contains("PRD")) continue;
            return true;
        }
        return false;
    }

    private boolean isParticiple(AnalyzedTokenReadings tokensReadings) {
        return tokensReadings.hasPartialPosTag("PA1") || tokensReadings.hasPartialPosTag("PA2");
    }

    private boolean isRelevantPronoun(AnalyzedTokenReadings[] tokens, int pos) {
        AnalyzedTokenReadings analyzedToken = tokens[pos];
        boolean relevantPronoun = GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PRONOMEN);
        String token = tokens[pos].getToken();
        if (PRONOUNS_TO_BE_IGNORED.contains(token.toLowerCase()) || pos > 0 && tokens[pos - 1].getToken().equalsIgnoreCase("vor") && token.equalsIgnoreCase("allem")) {
            relevantPronoun = false;
        }
        return relevantPronoun;
    }

    private boolean couldBeRelativeOrDependentClause(AnalyzedTokenReadings[] tokens, int pos) {
        boolean relPronoun;
        boolean comma;
        if (pos >= 1) {
            comma = tokens[pos - 1].getToken().equals(",");
            boolean bl = relPronoun = comma && tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            if (relPronoun && pos + 3 < tokens.length) {
                return true;
            }
        }
        if (pos >= 2 && (comma = tokens[pos - 2].getToken().equals(","))) {
            boolean prep = tokens[pos - 1].hasPosTagStartingWith("PRP:");
            relPronoun = tokens[pos].hasAnyLemma(REL_PRONOUN_LEMMAS);
            return prep && relPronoun || tokens[pos - 1].hasPosTag("KON:UNT") && (tokens[pos].hasLemma("jen") || tokens[pos].hasLemma("dies"));
        }
        return false;
    }

    @Nullable
    private RuleMatch checkDetNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedSentence sentence) {
        if (token2.isImmunized() || NOUNS_TO_BE_IGNORED.contains(token2.getToken()) || "-".equals(token2.getToken())) {
            return null;
        }
        Set<String> set1 = null;
        set1 = token1.getReadings().size() == 1 && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag() != null && ((AnalyzedToken)token1.getReadings().get(0)).getPOSTag().endsWith(":STV") ? Collections.emptySet() : this.getAgreementCategories(token1);
        if (set1 == null) {
            return null;
        }
        Set<String> set2 = this.getAgreementCategories(token2);
        if (set2 == null) {
            return null;
        }
        set1.retainAll(set2);
        RuleMatch ruleMatch = null;
        if (set1.isEmpty() && !this.isException(token1, token2)) {
            List<String> errorCategories = this.getCategoriesCausingError(token1, token2);
            String errorDetails = errorCategories.isEmpty() ? "Kasus, Genus oder Numerus" : String.join((CharSequence)" und ", errorCategories);
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel und Nomen bez\u00fcglich " + errorDetails + ".";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich " + errorDetails;
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token2.getEndPos(), msg, shortMsg);
            AgreementSuggestor suggestor = new AgreementSuggestor(this.language.getSynthesizer(), token1, token2);
            List<String> suggestions = suggestor.getSuggestions();
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    private boolean isException(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        return "allen".equals(token1.getToken()) && "Grund".equals(token2.getToken());
    }

    private List<String> getCategoriesCausingError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        ArrayList<String> categories = new ArrayList<String>();
        List<GrammarCategory> categoriesToCheck = Arrays.asList(GrammarCategory.KASUS, GrammarCategory.GENUS, GrammarCategory.NUMERUS);
        for (GrammarCategory category : categoriesToCheck) {
            if (!this.agreementWithCategoryRelaxation(token1, token2, category)) continue;
            categories.add(category.displayName);
        }
        return categories;
    }

    private RuleMatch checkDetAdjNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, AnalyzedSentence sentence) {
        if (token3 == null || token3.getToken().length() < 2) {
            return null;
        }
        Set<String> set = this.retainCommonCategories(token1, token2, token3);
        RuleMatch ruleMatch = null;
        if (set.isEmpty()) {
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel, Adjektiv und Nomen bez\u00fcglich Kasus, Numerus oder Genus. Beispiel: 'mein kleiner Haus' statt 'mein kleines Haus'";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich Kasus, Numerus oder Genus";
            ruleMatch = new RuleMatch((Rule)this, sentence, token1.getStartPos(), token3.getEndPos(), msg, shortMsg);
        }
        return ruleMatch;
    }

    private boolean agreementWithCategoryRelaxation(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, GrammarCategory categoryToRelax) {
        Set<GrammarCategory> categoryToRelaxSet = categoryToRelax != null ? Collections.singleton(categoryToRelax) : Collections.emptySet();
        Set<String> set1 = this.getAgreementCategories(token1, categoryToRelaxSet, true);
        if (set1 == null) {
            return true;
        }
        Set<String> set2 = this.getAgreementCategories(token2, categoryToRelaxSet, true);
        if (set2 == null) {
            return true;
        }
        set1.retainAll(set2);
        return set1.size() > 0;
    }

    @NotNull
    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3) {
        Set<GrammarCategory> categoryToRelaxSet = Collections.emptySet();
        Set<String> set1 = this.getAgreementCategories(token1, categoryToRelaxSet, true);
        if (set1 == null) {
            return Collections.emptySet();
        }
        boolean skipSol = !VIELE_WENIGE_LOWERCASE.contains(token1.getToken().toLowerCase());
        Set<String> set2 = this.getAgreementCategories(token2, categoryToRelaxSet, skipSol);
        if (set2 == null) {
            return Collections.emptySet();
        }
        Set<String> set3 = this.getAgreementCategories(token3, categoryToRelaxSet, true);
        if (set3 == null) {
            return Collections.emptySet();
        }
        set1.retainAll(set2);
        set1.retainAll(set3);
        return set1;
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken) {
        return this.getAgreementCategories(aToken, new HashSet<GrammarCategory>(), false);
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken, Set<GrammarCategory> omit, boolean skipSol) {
        HashSet<String> set = new HashSet<String>();
        List readings = aToken.getReadings();
        for (AnalyzedToken tmpReading : readings) {
            AnalyzedGermanToken reading;
            if (skipSol && tmpReading.getPOSTag() != null && tmpReading.getPOSTag().endsWith(":SOL") || (reading = new AnalyzedGermanToken(tmpReading)).getCasus() == null && reading.getNumerus() == null && reading.getGenus() == null) continue;
            if (reading.getGenus() == GermanToken.Genus.ALLGEMEIN && tmpReading.getPOSTag() != null && !tmpReading.getPOSTag().endsWith(":STV") && !this.possessiveSpecialCase(aToken, tmpReading)) {
                if (reading.getDetermination() == null) {
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, GermanToken.Determination.INDEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, GermanToken.Determination.INDEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, GermanToken.Determination.DEFINITE, omit));
                    set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, GermanToken.Determination.INDEFINITE, omit));
                    continue;
                }
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, reading.getDetermination(), omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, reading.getDetermination(), omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, reading.getDetermination(), omit));
                continue;
            }
            if (reading.getDetermination() == null || "jed".equals(tmpReading.getLemma()) || "manch".equals(tmpReading.getLemma())) {
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.DEFINITE, omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), GermanToken.Determination.INDEFINITE, omit));
                continue;
            }
            set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), reading.getDetermination(), omit));
        }
        return set;
    }

    private boolean possessiveSpecialCase(AnalyzedTokenReadings aToken, AnalyzedToken tmpReading) {
        return aToken.hasPosTagStartingWith("PRO:POS") && StringUtils.equalsAny((CharSequence)tmpReading.getLemma(), (CharSequence[])new CharSequence[]{"ich", "sich"});
    }

    private String makeString(GermanToken.Kasus casus, GermanToken.Numerus num, GermanToken.Genus gen, GermanToken.Determination determination, Set<GrammarCategory> omit) {
        ArrayList<String> l = new ArrayList<String>();
        if (casus != null && !omit.contains((Object)GrammarCategory.KASUS)) {
            l.add(casus.toString());
        }
        if (num != null && !omit.contains((Object)GrammarCategory.NUMERUS)) {
            l.add(num.toString());
        }
        if (gen != null && !omit.contains((Object)GrammarCategory.GENUS)) {
            l.add(gen.toString());
        }
        if (determination != null) {
            l.add(determination.toString());
        }
        return String.join((CharSequence)"/", l);
    }

    private static enum GrammarCategory {
        KASUS("Kasus (Fall: Wer/Was, Wessen, Wem, Wen/Was - Beispiel: 'das Fahrrads' statt 'des Fahrrads')"),
        GENUS("Genus (m\u00e4nnlich, weiblich, s\u00e4chlich - Beispiel: 'der Fahrrad' statt 'das Fahrrad')"),
        NUMERUS("Numerus (Einzahl, Mehrzahl - Beispiel: 'das Fahrr\u00e4der' statt 'die Fahrr\u00e4der')");

        private final String displayName;

        private GrammarCategory(String displayName) {
            this.displayName = displayName;
        }
    }
}

