/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import de.danielnaber.jwordsplitter.InputTooLongException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.German;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.de.LineExpander;
import org.languagetool.rules.ngrams.Probability;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSpellerRule
extends CompoundAwareHunspellRule {
    public static final String RULE_ID = "GERMAN_SPELLER_RULE";
    private static final int MAX_EDIT_DISTANCE = 2;
    private static final Pattern PREVENT_SUGGESTION = Pattern.compile(".*(Majon\u00e4se|Bravur|Anschovis|Belkanto|Campagne|Frott\u00e9|Grisli|Jockei|Joga|Kalvinismus|Kanossa|Kargo|Ketschup|Kollier|Kommunikee|Masurka|Negligee|Nessess\u00e4r|Poulard|Varietee|Wandalismus|kalvinist).*");
    private final Set<String> wordsToBeIgnoredInCompounds = new HashSet<String>();
    private final Set<String> wordStartsToBeProhibited = new HashSet<String>();
    private static final Map<Pattern, Function<String, List<String>>> ADDITIONAL_SUGGESTIONS = new HashMap<Pattern, Function<String, List<String>>>();
    private static final GermanWordSplitter splitter;
    private final LineExpander lineExpander = new LineExpander();
    private final GermanCompoundTokenizer compoundTokenizer;
    private final Synthesizer synthesizer;
    private final Tagger tagger;

    private static void putRepl(String wordPattern, String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(wordPattern), w -> Collections.singletonList(w.replaceFirst(pattern, replacement)));
    }

    private static void put(String pattern, String replacement) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(pattern), w -> Collections.singletonList(replacement));
    }

    private static void put(String pattern, Function<String, List<String>> f) {
        ADDITIONAL_SUGGESTIONS.put(Pattern.compile(pattern), f);
    }

    private static GermanWordSplitter getSplitter() {
        try {
            return new GermanWordSplitter(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GermanSpellerRule(ResourceBundle messages, German language) {
        this(messages, language, null, null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict) {
        this(messages, language, userConfig, languageVariantPlainTextDict, Collections.emptyList(), null);
    }

    public GermanSpellerRule(ResourceBundle messages, German language, UserConfig userConfig, String languageVariantPlainTextDict, List<Language> altLanguages, LanguageModel languageModel) {
        super(messages, (Language)language, language.getNonStrictCompoundSplitter(), GermanSpellerRule.getSpeller(language, userConfig, languageVariantPlainTextDict), userConfig, altLanguages, languageModel);
        this.addExamplePair(Example.wrong((String)"LanguageTool kann mehr als eine <marker>nromale</marker> Rechtschreibpr\u00fcfung."), Example.fixed((String)"LanguageTool kann mehr als eine <marker>normale</marker> Rechtschreibpr\u00fcfung."));
        this.compoundTokenizer = language.getStrictCompoundTokenizer();
        this.tagger = language.getTagger();
        this.synthesizer = language.getSynthesizer();
    }

    protected void init() throws IOException {
        super.init();
        this.ignoreWordsWithLength = 1;
        String pattern = "(" + this.nonWordPattern.pattern() + "|(?<=[\\d\u00b0])-|-(?=\\d+))";
        this.nonWordPattern = Pattern.compile(pattern);
        this.needsInit = false;
    }

    public String getId() {
        return RULE_ID;
    }

    public List<String> getCandidates(String word) {
        ArrayList partList;
        try {
            partList = splitter.getAllSplits(word);
        }
        catch (InputTooLongException e) {
            partList = new ArrayList();
        }
        ArrayList<String> candidates = new ArrayList<String>();
        for (List parts : partList) {
            candidates.addAll(super.getCandidates(parts));
            if (parts.size() == 2) {
                candidates.add((String)parts.get(0) + " " + StringTools.uppercaseFirstChar((String)((String)parts.get(1))));
            }
            if (parts.size() == 2 && !((String)parts.get(0)).endsWith("s")) {
                candidates.add((String)parts.get(0) + "s" + (String)parts.get(1));
            }
            if (parts.size() != 2 || !((String)parts.get(1)).startsWith("s")) continue;
            String firstPart = (String)parts.get(0);
            String secondPart = (String)parts.get(1);
            candidates.addAll(super.getCandidates(Arrays.asList(firstPart + "s", secondPart.substring(1))));
        }
        return candidates;
    }

    protected boolean isProhibited(String word) {
        return super.isProhibited(word) || this.wordStartsToBeProhibited.stream().anyMatch(w -> word.startsWith((String)w));
    }

    protected void addIgnoreWords(String origLine) {
        String line;
        String string = line = this.language.getShortCodeWithCountryAndVariant().equals("de-CH") ? origLine.replace("\u00df", "ss") : origLine;
        if (origLine.endsWith("-*")) {
            this.wordsToBeIgnoredInCompounds.add(line.substring(0, line.length() - 2));
            return;
        }
        List<String> words = this.expandLine(line);
        for (String word : words) {
            super.addIgnoreWords(word);
        }
    }

    protected List<String> expandLine(String line) {
        return this.lineExpander.expandLine(line);
    }

    public List<String> getSuggestions(String word) throws IOException {
        List<String> suggestions = super.getSuggestions(word);
        suggestions = suggestions.stream().filter(k -> !PREVENT_SUGGESTION.matcher((CharSequence)k).matches() && !k.endsWith("roulett")).collect(Collectors.toList());
        if (word.endsWith(".")) {
            suggestions.replaceAll(s -> s.endsWith(".") ? s : s + ".");
        }
        suggestions = suggestions.stream().filter(k -> !k.equals(word)).collect(Collectors.toList());
        return suggestions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MorfologikMultiSpeller getSpeller(Language language, UserConfig userConfig, String languageVariantPlainTextDict) {
        if (!language.getShortCode().equals(Locale.GERMAN.getLanguage())) {
            throw new RuntimeException("Language is not a variant of German: " + language);
        }
        try {
            String morfoFile = "/de/hunspell/de_" + language.getCountries()[0] + ".dict";
            if (!JLanguageTool.getDataBroker().resourceExists(morfoFile)) return null;
            List<String> paths = Arrays.asList("/de/hunspell/spelling.txt");
            StringBuilder concatPaths = new StringBuilder();
            ArrayList<InputStream> streams = new ArrayList<InputStream>();
            for (String path : paths) {
                concatPaths.append(path).append(";");
                streams.add(JLanguageTool.getDataBroker().getFromResourceDirAsStream(path));
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new SequenceInputStream(Collections.enumeration(streams)), StandardCharsets.UTF_8));){
                ExpandingReader variantReader = null;
                if (languageVariantPlainTextDict != null && !languageVariantPlainTextDict.isEmpty()) {
                    InputStream variantStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(languageVariantPlainTextDict);
                    variantReader = new ExpandingReader(new BufferedReader(new InputStreamReader(variantStream, StandardCharsets.UTF_8)));
                }
                MorfologikMultiSpeller morfologikMultiSpeller = new MorfologikMultiSpeller(morfoFile, (BufferedReader)new ExpandingReader(br), concatPaths.toString(), variantReader, languageVariantPlainTextDict, userConfig != null ? userConfig.getAcceptedWords() : Collections.emptyList(), 2);
                return morfologikMultiSpeller;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not set up morfologik spell checker", e);
        }
    }

    protected void filterForLanguage(List<String> suggestions) {
        if (this.language.getShortCodeWithCountryAndVariant().equals("de-CH")) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String s2 = suggestions.get(i);
                suggestions.set(i, s2.replace("\u00df", "ss"));
            }
        }
        suggestions.removeIf(s -> Arrays.stream(s.split(" ")).anyMatch(k -> k.matches("\\w\\p{Punct}?")));
        suggestions.removeIf(s -> s.length() > 1 && s.startsWith("-"));
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> topSuggestions = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (misspelling.equalsIgnoreCase(suggestion)) {
                topSuggestions.add(suggestion);
                continue;
            }
            if (suggestion.contains(" ")) {
                String[] words = suggestion.replaceFirst("\\.$", "").split(" ", 2);
                if (this.languageModel != null && words.length == 2) {
                    Probability nonSplit = this.languageModel.getPseudoProbability(Collections.singletonList(words[0] + words[1]));
                    Probability split = this.languageModel.getPseudoProbability(Arrays.asList(words));
                    if (nonSplit.getProb() > split.getProb() || split.getProb() == 0.0) {
                        result.add(suggestion);
                        continue;
                    }
                    topSuggestions.add(suggestion);
                    continue;
                }
                topSuggestions.add(suggestion);
                continue;
            }
            result.add(suggestion);
        }
        result.addAll(0, topSuggestions);
        return result;
    }

    private boolean ignoreElative(String word) {
        if (StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"bitter", "dunkel", "erz", "extra", "fr\u00fch", "gemein", "hyper", "lau", "mega", "minder", "stock", "super", "tod", "ultra", "ur"})) {
            String lastPart = RegExUtils.removePattern((String)word, (String)"^(bitter|dunkel|erz|extra|fr\u00fch|gemein|grund|hyper|lau|mega|minder|stock|super|tod|ultra|ur|voll)");
            return !this.isMisspelled(lastPart);
        }
        return false;
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreUncapitalizedWord = !ignore && idx == 0 && super.ignoreWord(StringUtils.uncapitalize((String)words.get(0)));
        boolean ignoreByHyphen = false;
        boolean ignoreHyphenatedCompound = false;
        if (!ignore && !ignoreUncapitalizedWord) {
            if (words.get(idx).contains("-")) {
                ignoreByHyphen = words.get(idx).endsWith("-") && this.ignoreByHangingHyphen(words, idx);
            }
            ignoreHyphenatedCompound = !ignoreByHyphen && this.ignoreCompoundWithIgnoredWord(words.get(idx));
        }
        return ignore || ignoreUncapitalizedWord || ignoreByHyphen || ignoreHyphenatedCompound || this.ignoreElative(words.get(0));
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        String[] words;
        String ucWord;
        String suggestion;
        if ("WIFI".equalsIgnoreCase(word)) {
            return Collections.singletonList("Wi-Fi");
        }
        if ("genomen".equals(word)) {
            return Collections.singletonList("genommen");
        }
        if ("Preis-Leistungsverh\u00e4ltnis".equals(word)) {
            return Collections.singletonList("Preis-Leistungs-Verh\u00e4ltnis");
        }
        if ("ausversehen".equals(word)) {
            return Collections.singletonList("aus Versehen");
        }
        if ("getz".equals(word)) {
            return Arrays.asList("jetzt", "geht's");
        }
        if ("Trons".equals(word)) {
            return Collections.singletonList("Trance");
        }
        if (word.matches(".*ibel[hk]eit$")) {
            suggestion = word.replaceFirst("el[hk]eit$", "ilit\u00e4t");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("aquise")) {
            suggestion = word.replaceFirst("aquise$", "akquise");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standart")) {
            suggestion = word.replaceFirst("standart$", "standard");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("standarts")) {
            suggestion = word.replaceFirst("standarts$", "standards");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tips")) {
            suggestion = word.replaceFirst("tips$", "tipps");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("tip")) {
            suggestion = word + "p";
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("entfehlung")) {
            suggestion = word.replaceFirst("ent", "emp");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.endsWith("oullie")) {
            suggestion = word.replaceFirst("oullie$", "ouille");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("[dD]urschnitt")) {
            suggestion = word.replaceFirst("^urschnitt", "urchschnitt");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.startsWith("Bundstift")) {
            suggestion = word.replaceFirst("^Bundstift", "Buntstift");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[aA]llm\u00e4hll?i(g|ch)(e[mnrs]?)?")) {
            suggestion = word.replaceFirst("llm\u00e4hll?i(g|ch)", "llm\u00e4hlich");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[mM]a[jy]onn?[\u00e4e]se.*")) {
            suggestion = word.replaceFirst("a[jy]onn?[\u00e4e]se", "ayonnaise");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[rR]es(a|er)[vw]i[he]?rung(en)?")) {
            suggestion = word.replaceFirst("es(a|er)[vw]i[he]?rung", "eservierung");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[rR]eschaschier.+")) {
            suggestion = word.replaceFirst("schaschier", "cherchier");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*[lL]aborants$")) {
            suggestion = word.replaceFirst("ts$", "ten");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[pP]roff?ess?ion([\u00e4e])h?ll?(e[mnrs]?)?")) {
            suggestion = word.replaceFirst("roff?ess?ion([\u00e4e])h?l{1,2}", "rofessionell");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("[vV]erstehendniss?(es?)?")) {
            suggestion = word.replaceFirst("[vV]erstehendnis", "Verst\u00e4ndnis");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("koregier.+")) {
            suggestion = word.replaceAll("reg", "rrig");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches("diagno[sz]ier.*")) {
            suggestion = word.replaceAll("gno[sz]ier", "gnostizier");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*eiss.*")) {
            suggestion = word.replaceAll("eiss", "ei\u00df");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else if (word.matches(".*uess.*")) {
            suggestion = word.replaceAll("uess", "\u00fc\u00df");
            if (!this.hunspellDict.misspelled(suggestion)) {
                return Collections.singletonList(suggestion);
            }
        } else {
            if (word.matches("bi[s\u00df][ij]en")) {
                return Collections.singletonList("bisschen");
            }
            if (word.equals("gin")) {
                return Collections.singletonList("ging");
            }
            if (word.equals("dh") || word.equals("dh.")) {
                return Collections.singletonList("d.\u202fh.");
            }
            if (word.equals("ua") || word.equals("ua.")) {
                return Collections.singletonList("u.\u202fa.");
            }
            if (word.matches("z[bB]") || word.matches("z[bB].")) {
                return Collections.singletonList("z.\u202fB.");
            }
            if (word.equals("uvm") || word.equals("uvm.")) {
                return Collections.singletonList("u.\u202fv.\u202fm.");
            }
            if (word.equals("udgl") || word.equals("udgl.")) {
                return Collections.singletonList("u.\u202fdgl.");
            }
            if (word.equals("Ruhigkeit")) {
                return Collections.singletonList("Ruhe");
            }
            if (word.equals("angepreist")) {
                return Collections.singletonList("angepriesen");
            }
            if (word.equals("halo")) {
                return Collections.singletonList("hallo");
            }
            if (word.equals("zumindestens")) {
                return Collections.singletonList("zumindest");
            }
            if (word.equals("ca")) {
                return Collections.singletonList("ca.");
            }
            if (word.equals("Jezt")) {
                return Collections.singletonList("Jetzt");
            }
            if (word.equals("Rolladen")) {
                return Collections.singletonList("Rollladen");
            }
            if (word.equals("Ma\u00dfname")) {
                return Collections.singletonList("Ma\u00dfnahme");
            }
            if (word.equals("Ma\u00dfnamen")) {
                return Collections.singletonList("Ma\u00dfnahmen");
            }
            if (word.equals("nanten")) {
                return Collections.singletonList("nannten");
            }
            if (word.endsWith("ies")) {
                if (word.equals("Stories")) {
                    return Collections.singletonList("Storys");
                }
                if (word.equals("Lobbies")) {
                    return Collections.singletonList("Lobbys");
                }
                if (word.equals("Hobbies")) {
                    return Collections.singletonList("Hobbys");
                }
                if (word.equals("Parties")) {
                    return Collections.singletonList("Partys");
                }
                if (word.equals("Babies")) {
                    return Collections.singletonList("Babys");
                }
                if (word.equals("Ladies")) {
                    return Collections.singletonList("Ladys");
                }
                if (word.endsWith("derbies") ? !this.hunspellDict.misspelled(suggestion = word.replaceFirst("derbies$", "derbys")) : (word.endsWith("stories") ? !this.hunspellDict.misspelled(suggestion = word.replaceFirst("stories$", "storys")) : word.endsWith("parties") && !this.hunspellDict.misspelled(suggestion = word.replaceFirst("parties$", "partys")))) {
                    return Collections.singletonList(suggestion);
                }
            } else {
                if (word.equals("Hallochen")) {
                    return Arrays.asList("Hall\u00f6chen", "hall\u00f6chen");
                }
                if (word.equals("hallochen")) {
                    return Collections.singletonList("hall\u00f6chen");
                }
                if (word.equals("ok")) {
                    return Arrays.asList("okay", "O.\u202fK.");
                }
                if (word.equals("gesuchen")) {
                    return Arrays.asList("gesuchten", "gesucht");
                }
                if (word.equals("Germanistiker")) {
                    return Arrays.asList("Germanist", "Germanisten");
                }
                if (word.equals("par")) {
                    return Collections.singletonList("paar");
                }
                if (word.equals("vllt")) {
                    return Collections.singletonList("vielleicht");
                }
                if (word.equals("iwie")) {
                    return Collections.singletonList("irgendwie");
                }
                if (word.equals("sry")) {
                    return Collections.singletonList("sorry");
                }
                if (word.equals("Zynik")) {
                    return Collections.singletonList("Zynismus");
                }
                if (word.matches("Email[a-z\u00e4\u00f6\u00fc]{5,}")) {
                    String suffix = word.substring(5);
                    if (this.hunspellDict.misspelled(suffix)) {
                        List suffixSuggestions = this.hunspellDict.suggest(suffix);
                        suffix = suffixSuggestions.isEmpty() ? suffix : (String)suffixSuggestions.get(0);
                    }
                    return Collections.singletonList("E-Mail-" + Character.toUpperCase(suffix.charAt(0)) + suffix.substring(1));
                }
                if (word.equals("wiederspiegeln")) {
                    return Collections.singletonList("widerspiegeln");
                }
                if (word.equals("ch")) {
                    return Collections.singletonList("ich");
                }
                for (Pattern p : ADDITIONAL_SUGGESTIONS.keySet()) {
                    if (!p.matcher(word).matches()) continue;
                    return ADDITIONAL_SUGGESTIONS.get(p).apply(word);
                }
            }
        }
        if (!(StringTools.startsWithUppercase((String)word) || suggestions.contains(ucWord = StringTools.uppercaseFirstChar((String)word)) || this.hunspellDict.misspelled(ucWord))) {
            return Collections.singletonList(ucWord);
        }
        String verbSuggestion = this.getPastTenseVerbSuggestion(word);
        if (verbSuggestion != null) {
            return Collections.singletonList(verbSuggestion);
        }
        String participleSuggestion = this.getParticipleSuggestion(word);
        if (participleSuggestion != null) {
            return Collections.singletonList(participleSuggestion);
        }
        String abbreviationSuggestion = this.getAbbreviationSuggestion(word);
        if (abbreviationSuggestion != null) {
            return Collections.singletonList(abbreviationSuggestion);
        }
        if (suggestions.isEmpty() && word.contains("-") && (words = word.split("-")).length > 1) {
            ArrayList<List<String>> suggestionLists = new ArrayList<List<String>>(words.length);
            int startAt = 0;
            int stopAt = words.length;
            String partialWord = words[0] + "-" + words[1];
            if (super.ignoreWord(partialWord) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                startAt = 2;
                suggestionLists.add(Collections.singletonList(words[0] + "-" + words[1]));
            }
            if (super.ignoreWord(partialWord = words[words.length - 2] + "-" + words[words.length - 1]) || this.wordsToBeIgnoredInCompounds.contains(partialWord)) {
                stopAt = words.length - 2;
            }
            for (int idx = startAt; idx < stopAt; ++idx) {
                if (this.hunspellDict.misspelled(words[idx])) {
                    List<String> list = this.sortSuggestionByQuality(words[idx], super.getSuggestions(words[idx]));
                    suggestionLists.add(list);
                    continue;
                }
                suggestionLists.add(Collections.singletonList(words[idx]));
            }
            if (stopAt < words.length - 1) {
                suggestionLists.add(Collections.singletonList(partialWord));
            }
            if (suggestionLists.size() <= 3) {
                ArrayList<String> additionalSuggestions = (ArrayList<String>)suggestionLists.get(0);
                for (int idx = 1; idx < suggestionLists.size(); ++idx) {
                    List suggestionList = (List)suggestionLists.get(idx);
                    ArrayList<String> newList = new ArrayList<String>(additionalSuggestions.size() * suggestionList.size());
                    for (String additionalSuggestion : additionalSuggestions) {
                        for (String aSuggestionList : suggestionList) {
                            newList.add(additionalSuggestion + "-" + aSuggestionList);
                        }
                    }
                    additionalSuggestions = newList;
                }
                return additionalSuggestions.subList(0, Math.min(5, additionalSuggestions.size()));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    private String getPastTenseVerbSuggestion(String word) {
        if (word.endsWith("e")) {
            String wordStem = word.substring(0, word.length() - 1);
            try {
                AnalyzedToken token;
                String[] forms;
                String lemma = this.baseForThirdPersonSingularVerb(wordStem);
                if (lemma != null && (forms = this.synthesizer.synthesize(token = new AnalyzedToken(lemma, null, lemma), "VER:3:SIN:PRT:.*", true)).length > 0) {
                    return forms[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String baseForThirdPersonSingularVerb(String word) throws IOException {
        List readings = this.tagger.tag(Collections.singletonList(word));
        for (AnalyzedTokenReadings reading : readings) {
            if (!reading.hasPosTagStartingWith("VER:3:SIN:")) continue;
            return ((AnalyzedToken)reading.getReadings().get(0)).getLemma();
        }
        return null;
    }

    @Nullable
    private String getParticipleSuggestion(String word) {
        if (word.startsWith("ge") && word.endsWith("t")) {
            String baseform = word.substring(2, word.length() - 1) + "en";
            try {
                String participle = this.getParticipleForBaseform(baseform);
                if (participle != null) {
                    return participle;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String getParticipleForBaseform(String baseform) throws IOException {
        AnalyzedToken token = new AnalyzedToken(baseform, null, baseform);
        String[] forms = this.synthesizer.synthesize(token, "VER:PA2:.*", true);
        if (forms.length > 0 && !this.hunspellDict.misspelled(forms[0])) {
            return forms[0];
        }
        return null;
    }

    private String getAbbreviationSuggestion(String word) throws IOException {
        if (word.length() < 5) {
            List readings = this.tagger.tag(Collections.singletonList(word));
            for (AnalyzedTokenReadings reading : readings) {
                if (!reading.hasPosTagStartingWith("ABK:")) continue;
                return word + ".";
            }
        }
        return null;
    }

    private boolean ignoreByHangingHyphen(List<String> words, int idx) throws IOException {
        boolean isCompound;
        String word = words.get(idx);
        String nextWord = this.getWordAfterEnumerationOrNull(words, idx + 1);
        boolean bl = isCompound = (nextWord = StringUtils.removeEnd((String)nextWord, (String)".")) != null && (this.compoundTokenizer.tokenize(nextWord).size() > 1 || nextWord.indexOf(45) > 0);
        if (isCompound) {
            boolean isMisspelled = this.hunspellDict.misspelled(word = StringUtils.removeEnd((String)word, (String)"-"));
            if (isMisspelled && (super.ignoreWord(word) || this.wordsToBeIgnoredInCompounds.contains(word))) {
                isMisspelled = false;
            } else if (isMisspelled && word.endsWith("s") && this.isNeedingFugenS(StringUtils.removeEnd((String)word, (String)"s"))) {
                isMisspelled = this.hunspellDict.misspelled(StringUtils.removeEnd((String)word, (String)"s"));
            }
            return !isMisspelled;
        }
        return false;
    }

    private boolean isNeedingFugenS(String word) {
        return StringUtils.endsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"tum", "ling", "ion", "t\u00e4t", "keit", "schaft", "sicht", "ung", "en"});
    }

    @Nullable
    private String getWordAfterEnumerationOrNull(List<String> words, int idx) {
        for (int i = idx; i < words.size(); ++i) {
            String word = words.get(i);
            if (word.endsWith("-") || StringUtils.equalsAny((CharSequence)word, (CharSequence[])new CharSequence[]{",", "und", "oder", "sowie"}) || word.trim().isEmpty()) continue;
            return word;
        }
        return null;
    }

    private boolean ignoreCompoundWithIgnoredWord(String word) throws IOException {
        if (!StringTools.startsWithUppercase((String)word) && !StringUtils.startsWithAny((CharSequence)word, (CharSequence[])new CharSequence[]{"nord", "west", "ost", "s\u00fcd"})) {
            return false;
        }
        String[] words = word.split("-");
        if (words.length < 2) {
            int end = super.startsWithIgnoredWord(word, true);
            if (end < 3) {
                if (word.startsWith("ost") || word.startsWith("s\u00fcd")) {
                    end = 3;
                } else if (word.startsWith("west") || word.startsWith("nord")) {
                    end = 4;
                } else {
                    return false;
                }
            }
            String ignoredWord = word.substring(0, end);
            String partialWord = word.substring(end);
            boolean isCandidateForNonHyphenatedCompound = !StringUtils.isAllUpperCase((CharSequence)ignoredWord) && (StringUtils.isAllLowerCase((CharSequence)partialWord) || ignoredWord.endsWith("-"));
            boolean needFugenS = this.isNeedingFugenS(ignoredWord);
            if (isCandidateForNonHyphenatedCompound && !needFugenS && partialWord.length() > 2) {
                return !this.hunspellDict.misspelled(partialWord) || !this.hunspellDict.misspelled(StringUtils.capitalize((String)partialWord));
            }
            if (isCandidateForNonHyphenatedCompound && needFugenS && partialWord.length() > 2) {
                partialWord = partialWord.startsWith("s") ? partialWord.substring(1) : partialWord;
                return !this.hunspellDict.misspelled(partialWord) || !this.hunspellDict.misspelled(StringUtils.capitalize((String)partialWord));
            }
            return false;
        }
        boolean hasIgnoredWord = false;
        ArrayList<String> toSpellCheck = new ArrayList<String>(3);
        String stripFirst = word.substring(words[0].length() + 1);
        String stripLast = word.substring(0, word.length() - words[words.length - 1].length() - 1);
        if (super.ignoreWord(stripFirst) || this.wordsToBeIgnoredInCompounds.contains(stripFirst)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[0])) {
                toSpellCheck.add(words[0]);
            }
        } else if (super.ignoreWord(stripLast) || this.wordsToBeIgnoredInCompounds.contains(stripLast)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[words.length - 1])) {
                toSpellCheck.add(words[words.length - 1]);
            }
        } else {
            for (String word1 : words) {
                if (super.ignoreWord(word1) || this.wordsToBeIgnoredInCompounds.contains(word1)) {
                    hasIgnoredWord = true;
                    continue;
                }
                toSpellCheck.add(word1);
            }
        }
        if (hasIgnoredWord) {
            for (String w : toSpellCheck) {
                if (!this.hunspellDict.misspelled(w)) continue;
                return false;
            }
        }
        return hasIgnoredWord;
    }

    protected boolean isQuotedCompound(AnalyzedSentence analyzedSentence, int idx, String token) {
        if (idx > 3 && token.startsWith("-")) {
            return StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 1].getToken(), (CharSequence[])new CharSequence[]{"\u201c", "\""}) && StringUtils.equalsAny((CharSequence)analyzedSentence.getTokens()[idx - 3].getToken(), (CharSequence[])new CharSequence[]{"\u201e", "\""});
        }
        return false;
    }

    protected void addProhibitedWords(List<String> words) {
        if (words.size() == 1 && words.get(0).endsWith(".*")) {
            this.wordStartsToBeProhibited.add(words.get(0).substring(0, words.get(0).length() - 2));
        } else {
            super.addProhibitedWords(words);
        }
    }

    static {
        GermanSpellerRule.put("abschiednehmen", "Abschied nehmen");
        GermanSpellerRule.put("wars", (String w) -> Arrays.asList("war's", "war es"));
        GermanSpellerRule.put("[aA]wa", (String w) -> Arrays.asList("AWA", "ach was", "aber"));
        GermanSpellerRule.put("[aA]lsallerersten?s", (String w) -> Arrays.asList(w.replaceFirst("lsallerersten?s", "ls allererstes"), w.replaceFirst("lsallerersten?s", "ls Allererstes")));
        GermanSpellerRule.putRepl("(an|auf|ein|zu)gehangen(e[mnrs]?)?$", "hangen", "h\u00e4ngt");
        GermanSpellerRule.putRepl("[oO]key", "ey$", "ay");
        GermanSpellerRule.put("packet", "Paket");
        GermanSpellerRule.put("Allalei", "Allerlei");
        GermanSpellerRule.put("geupdate[dt]$", "upgedatet");
        GermanSpellerRule.put("gefaked", "gefakt");
        GermanSpellerRule.put("[pP]roblemhaft(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("haft", "behaftet"), w.replaceFirst("haft", "atisch")));
        GermanSpellerRule.put("rosane[mnrs]?$", (String w) -> Arrays.asList("rosa", w.replaceFirst("^rosan", "rosafarben")));
        GermanSpellerRule.put("Erbung", (String w) -> Arrays.asList("Vererbung", "Erbschaft"));
        GermanSpellerRule.put("Energiesparung", (String w) -> Arrays.asList("Energieeinsparung", "Energieersparnis"));
        GermanSpellerRule.put("Abbrechung", "Abbruch");
        GermanSpellerRule.put("Abbrechungen", (String w) -> Arrays.asList("Abbr\u00fcche", "Abbr\u00fcchen"));
        GermanSpellerRule.put("Urteilung", (String w) -> Arrays.asList("Urteil", "Verurteilung"));
        GermanSpellerRule.put("allm\u00f6glichen?", (String w) -> Arrays.asList("alle m\u00f6glichen", "alle m\u00f6gliche"));
        GermanSpellerRule.put("Krankenhausen", (String w) -> Arrays.asList("Krankenh\u00e4usern", "Krankenh\u00e4user"));
        GermanSpellerRule.put("vorr?auss?etzlich", (String w) -> Arrays.asList("voraussichtlich", "vorausgesetzt"));
        GermanSpellerRule.put("nichtmals", (String w) -> Arrays.asList("nicht mal", "nicht einmal"));
        GermanSpellerRule.put("eingepeilt", "angepeilt");
        GermanSpellerRule.put("gekukt", "geguckt");
        GermanSpellerRule.put("\u00fcberhaut", "\u00fcberhaupt");
        GermanSpellerRule.put("nacher", "nachher");
        GermanSpellerRule.put("jeztz", "jetzt");
        GermanSpellerRule.put("[wW]ah?rscheindlichkeit", "Wahrscheinlichkeit");
        GermanSpellerRule.put("Hijab", "Hidsch\u0101b");
        GermanSpellerRule.putRepl("for?melar(en?)?", "for?me", "Formu");
        GermanSpellerRule.putRepl("n\u00e4ste[mnrs]?$", "^n\u00e4s", "n\u00e4chs");
        GermanSpellerRule.putRepl("Erdogans?$", "^Erdogan", "Erdo\u011fan");
        GermanSpellerRule.put("Germanistiker[ns]", "Germanisten");
        GermanSpellerRule.putRepl("Germanistikerin(nen)?", "Germanistiker", "Germanist");
        GermanSpellerRule.putRepl("[eE]rh\u00f6herung(en)?", "[eE]rh\u00f6herung", "Erh\u00f6hung");
        GermanSpellerRule.putRepl("[vV]orallendingen", "orallendingen", "or allen Dingen");
        GermanSpellerRule.putRepl("[aA]ufjedenfall", "jedenfall$", " jeden Fall");
        GermanSpellerRule.putRepl("^funk?z[ou]nier.+", "funk?z[ou]nier", "funktionier");
        GermanSpellerRule.putRepl("[wW]\u00f6ruber", "\u00f6ru", "or\u00fc");
        GermanSpellerRule.putRepl("[lL]einensamens?", "[lL]einen", "Lein");
        GermanSpellerRule.putRepl("Feinleiner[ns]?", "Feinlei", "Fineli");
        GermanSpellerRule.putRepl("Oldheimer[ns]?", "he", "t");
        GermanSpellerRule.putRepl("unternehmensl[u\u00fc]stig(e[mnrs]?)?", "mensl[u\u00fc]st", "mungslust");
        GermanSpellerRule.putRepl("proff?ess?ional(e[mnrs]?)?", "ff?ess?ional", "fessionell");
        GermanSpellerRule.putRepl("zuverl\u00e4sslich(e[mnrs]?)?", "lich", "ig");
        GermanSpellerRule.putRepl("fluoreszenzierend(e[mnrs]?)?", "zen", "");
        GermanSpellerRule.putRepl("revalierend(e[mnrs]?)?", "^reval", "rivalis");
        GermanSpellerRule.putRepl("verh\u00e4uft(e[mnrs]?)?", "^ver", "ge");
        GermanSpellerRule.putRepl("st\u00fcrmig(e[mnrs]?)?", "mig", "misch");
        GermanSpellerRule.putRepl("gr\u00f6\u00dfeste[mnrs]?", "\u00dfes", "\u00df");
        GermanSpellerRule.putRepl("naheste[mnrs]?", "nahe", "n\u00e4ch");
        GermanSpellerRule.putRepl("gesundlich(e[mnrs]?)?", "lich", "heitlich");
        GermanSpellerRule.putRepl("eckel(e|t(en?)?|st)?", "^eck", "ek");
        GermanSpellerRule.putRepl("unhervorgesehen(e[mnrs]?)?", "hervor", "vorher");
        GermanSpellerRule.putRepl("entt?euscht(e[mnrs]?)?", "entt?eusch", "entt\u00e4usch");
        GermanSpellerRule.putRepl("Ph\u00e4hlen?", "^Ph", "Pf");
        GermanSpellerRule.putRepl("Kattermesser[ns]?", "Ka", "Cu");
        GermanSpellerRule.putRepl("gehe?rr?t(e[mnrs]?)?", "he?rr?", "ehr");
        GermanSpellerRule.putRepl("gehrter?", "^ge", "gee");
        GermanSpellerRule.putRepl("[nN]amenhaft(e[mnrs]?)?", "amen", "am");
        GermanSpellerRule.putRepl("hom(o?e|\u00f6)ophatisch(e[mnrs]?)?", "hom(o?e|\u00f6)ophat", "hom\u00f6opath");
        GermanSpellerRule.putRepl("Geschwindlichkeit(en)?", "lich", "ig");
        GermanSpellerRule.put("Investion", "Investition");
        GermanSpellerRule.put("Pakur", (String w) -> Arrays.asList("Parcours", "Parkuhr"));
        GermanSpellerRule.put("Erstsemesterin", (String w) -> Arrays.asList("Erstsemester", "Erstsemesters"));
        GermanSpellerRule.put("Erstsemesterinnen", (String w) -> Arrays.asList("Erstsemester", "Erstsemestern"));
        GermanSpellerRule.put("kreativlos(e[nmrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("kreativ", "fantasie"), w.replaceFirst("kreativ", "einfalls"), w.replaceFirst("kreativlos", "unkreativ"), w.replaceFirst("kreativlos", "uninspiriert")));
        GermanSpellerRule.put("Kreativlosigkeit", "Unkreativit\u00e4t");
        GermanSpellerRule.put("hinund?her", "hin und her");
        GermanSpellerRule.put("misverst\u00e4ndniss", "Missverst\u00e4ndnis");
        GermanSpellerRule.put("warheit", "Wahrheit");
        GermanSpellerRule.put("[pP]okemon", "Pok\u00e9mon");
        GermanSpellerRule.put("kreigt", "kriegt");
        GermanSpellerRule.put("Frit\u00f6se", "Fritteuse");
        GermanSpellerRule.put("unerkennlich", "unkenntlich");
        GermanSpellerRule.put("r\u00fcckg[\u00e4e]nglich", "r\u00fcckg\u00e4ngig");
        GermanSpellerRule.put("em?men[sz]", "immens");
        GermanSpellerRule.put("verhing", "verh\u00e4ngte");
        GermanSpellerRule.put("verhingen", "verh\u00e4ngten");
        GermanSpellerRule.put("fangte", "fing");
        GermanSpellerRule.put("fangten", "fingen");
        GermanSpellerRule.put("schlie[s\u00df]te", "schloss");
        GermanSpellerRule.put("schlie[s\u00df]ten", "schlossen");
        GermanSpellerRule.put("past", "passt");
        GermanSpellerRule.put("eingetragt", "eingetragen");
        GermanSpellerRule.put("getrunkt", "getrunken");
        GermanSpellerRule.put("ver\u00e4ht", "verr\u00e4t");
        GermanSpellerRule.put("helfte", "half");
        GermanSpellerRule.put("helften", "halfen");
        GermanSpellerRule.put("befehlte", "befahl");
        GermanSpellerRule.put("befehlten", "befahlen");
        GermanSpellerRule.put("l\u00fcgte", "log");
        GermanSpellerRule.put("l\u00fcgten", "logen");
        GermanSpellerRule.put("bratete", "briet");
        GermanSpellerRule.put("brateten", "brieten");
        GermanSpellerRule.put("gefahl", "gefiel");
        GermanSpellerRule.put("Komplexibilit\u00e4t", "Komplexit\u00e4t");
        GermanSpellerRule.put("abbonement", "Abonnement");
        GermanSpellerRule.put("perse", "per se");
        GermanSpellerRule.put("Schwitch", "Switch");
        GermanSpellerRule.put("[aA]nwesenzeiten", "Anwesenheitszeiten");
        GermanSpellerRule.put("[gG]eizigkeit", "Geiz");
        GermanSpellerRule.put("[fF]lei\u00dfigkeit", "Flei\u00df");
        GermanSpellerRule.put("[bB]equemheit", "Bequemlichkeit");
        GermanSpellerRule.put("[mM]issionarie?sie?rung", "Missionierung");
        GermanSpellerRule.put("[sS]chee?selonge?", "Chaiselongue");
        GermanSpellerRule.put("Re[kc]amiere", "R\u00e9cami\u00e8re");
        GermanSpellerRule.put("Singel", "Single");
        GermanSpellerRule.put("legen[td]lich", "lediglich");
        GermanSpellerRule.put("ein[ua]ndhalb", "eineinhalb");
        GermanSpellerRule.put("[mM]illion(en)?mal", (String w) -> Collections.singletonList(StringTools.uppercaseFirstChar((String)w.replaceFirst("mal", " Mal"))));
        GermanSpellerRule.put("Opelarena", "Opel Arena");
        GermanSpellerRule.put("Toll-Collect", "Toll Collect");
        GermanSpellerRule.put("[pP][qQ]-Formel", "p-q-Formel");
        GermanSpellerRule.put("desweitere?[nm]", "des Weiteren");
        GermanSpellerRule.put("handzuhaben", "zu handhaben");
        GermanSpellerRule.put("nachvollzuziehe?n", "nachzuvollziehen");
        GermanSpellerRule.put("[bB]ischen", "bisschen");
        GermanSpellerRule.put("Porto?folien", "Portfolios");
        GermanSpellerRule.put("[sS]chwie?ri?chkeiten", "Schwierigkeiten");
        GermanSpellerRule.put("[\u00fc\u00dc]bergrifflichkeiten", "\u00dcbergriffigkeiten");
        GermanSpellerRule.put("[aA]r?th?rie?th?is", "Arthritis");
        GermanSpellerRule.put("zugesand", "zugesandt");
        GermanSpellerRule.put("weibt", "wei\u00dft");
        GermanSpellerRule.put("instande?zusetzen", "instand zu setzen");
        GermanSpellerRule.put("Lia(si|is)onen", "Liaisons");
        GermanSpellerRule.put("[cC]asemana?ge?ment", "Case Management");
        GermanSpellerRule.put("[aA]nn?[ou]ll?ie?rung", "Annullierung");
        GermanSpellerRule.put("[sS]charm", "Charme");
        GermanSpellerRule.put("[zZ]auberlich(e[mnrs]?)?", (String w) -> Arrays.asList(w.replaceFirst("lich", "isch"), w.replaceFirst("lich", "haft")));
        GermanSpellerRule.putRepl("([uU]n)?proff?esionn?ell?(e[mnrs]?)?", "proff?esionn?ell?", "professionell");
        GermanSpellerRule.putRepl("[kK]inderlich(e[mnrs]?)?", "inder", "ind");
        GermanSpellerRule.putRepl("[wW]iedersprichs?t", "ieder", "ider");
        GermanSpellerRule.putRepl("[kK]\u00f6nntes", "es$", "est");
        GermanSpellerRule.putRepl("[aA]ssess?oare?s?", "[aA]ssess?oare?", "Accessoire");
        GermanSpellerRule.putRepl("indifiziert(e[mnrs]?)?", "ind", "ident");
        GermanSpellerRule.putRepl("dreite[mnrs]?", "dreit", "dritt");
        GermanSpellerRule.putRepl("verbl\u00fcte[mnrs]?", "bl\u00fc", "bl\u00fch");
        GermanSpellerRule.putRepl("Einzigste[mnrs]?", "zigst", "zig");
        GermanSpellerRule.putRepl("(aller)?einzigste[mnrs]?", "(aller)?einzigst", "einzig");
        GermanSpellerRule.putRepl("[iI]nterkurell(e[nmrs]?)?", "ku", "kultu");
        GermanSpellerRule.putRepl("[iI]ntersannt(e[mnrs]?)?", "sannt", "essant");
        GermanSpellerRule.putRepl("ubera(g|sch)end(e[nmrs]?)?", "uber", "\u00fcberr");
        GermanSpellerRule.putRepl("[wW]olt$", "lt", "llt");
        GermanSpellerRule.putRepl("[zZ]uende", "ue", "u E");
        GermanSpellerRule.putRepl("[iI]nb\u00e4lde", "nb", "n B");
        GermanSpellerRule.putRepl("[lL]etztenendes", "ene", "en E");
        GermanSpellerRule.putRepl("[nN]achwievor", "wievor", " wie vor");
        GermanSpellerRule.putRepl("[zZ]umbeispiel", "beispiel", " Beispiel");
        GermanSpellerRule.putRepl("[gG]ottseidank", "[gG]ottseidank", "Gott sei Dank");
        GermanSpellerRule.putRepl("[gG]rundauf", "[gG]rundauf", "Grund auf");
        GermanSpellerRule.putRepl("[aA]nsichtnach", "[aA]nsicht", "Ansicht ");
        GermanSpellerRule.putRepl("[uU]nswar", "swar", "d zwar");
        GermanSpellerRule.putRepl("[wW]aschte(s?t)?", "aschte", "usch");
        GermanSpellerRule.putRepl("[wW]aschten", "ascht", "usch");
        GermanSpellerRule.putRepl("Probiren?", "ir", "ier");
        GermanSpellerRule.putRepl("[gG]esetztreu(e[nmrs]?)?", "tz", "tzes");
        GermanSpellerRule.putRepl("[wW]ikich(e[nmrs]?)?", "k", "rkl");
        GermanSpellerRule.putRepl("[uU]naufbesichtigt(e[nmrs]?)?", "aufbe", "beauf");
        GermanSpellerRule.putRepl("[nN]utzvoll(e[nmrs]?)?", "utzvoll", "\u00fctzlich");
        GermanSpellerRule.putRepl("Lezte[mnrs]?", "Lez", "Letz");
        GermanSpellerRule.putRepl("Letze[mnrs]?", "Letz", "Letzt");
        GermanSpellerRule.putRepl("[nN]i[vw]os?", "[nN]i[vw]o", "Niveau");
        GermanSpellerRule.putRepl("[dD]illetant(en)?", "[dD]ille", "Dilet");
        GermanSpellerRule.putRepl("Makeups?", "up", "-up");
        GermanSpellerRule.putRepl("Add-?Ons?", "Add-?On", "Add-on");
        GermanSpellerRule.putRepl("Addons?", "on", "-on");
        GermanSpellerRule.putRepl("Internetkaffees?", "kaffee", "caf\u00e9");
        GermanSpellerRule.putRepl("[gG]ehorsamkeitsverweigerung(en)?", "[gG]ehorsamkeit", "Gehorsam");
        GermanSpellerRule.putRepl("[wW]ochende[ns]?", "[wW]ochend", "Wochenend");
        GermanSpellerRule.putRepl("[kK]ongratulier(en?|t(en?)?|st)", "[kK]on", "");
        GermanSpellerRule.putRepl("[wWkKdD]an$", "n$", "nn");
        GermanSpellerRule.putRepl("geh?neh?m[ie]gung(en)?", "geh?neh?m[ie]gung", "Genehmigung");
        GermanSpellerRule.putRepl("Korrigierung(en)?", "igierung", "ektur");
        GermanSpellerRule.putRepl("[kK]orregierung(en)?", "[kK]orregierung", "Korrektur");
        GermanSpellerRule.putRepl("[kK]orrie?girung(en)?", "[kK]orrie?girung", "Korrektur");
        GermanSpellerRule.putRepl("[nN]ocheimal", "eimal", " einmal");
        GermanSpellerRule.putRepl("[aA]benzu", "enzu", " und zu");
        GermanSpellerRule.putRepl("[kK]onflikation(en)?", "[kK]onfli", "Kompli");
        GermanSpellerRule.putRepl("[mM]itanader", "ana", "einan");
        GermanSpellerRule.putRepl("[mM]itenand", "enand", "einander");
        GermanSpellerRule.putRepl("Gelangenheitsbest\u00e4tigung(en)?", "heit", "");
        GermanSpellerRule.putRepl("[jJ]edwillige[mnrs]?", "willig", "wed");
        GermanSpellerRule.putRepl("[qQ]ualit\u00e4ts?bewu\u00dft(e[mnrs]?)?", "ts?bewu\u00dft", "tsbewusst");
        GermanSpellerRule.putRepl("[vV]oraussichtig(e[nmrs]?)?", "sichtig", "sichtlich");
        GermanSpellerRule.putRepl("[gG]leichrechtig(e[nmrs]?)?", "rechtig", "berechtigt");
        GermanSpellerRule.putRepl("[uU]nn\u00fctzlich(e[nmrs]?)?", "n\u00fctzlich", "n\u00fctz");
        GermanSpellerRule.putRepl("[uU]nzerbrechbar(e[nmrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("kolegen?", "ko", "Kol");
        GermanSpellerRule.putRepl("tableten?", "tablet", "Tablett");
        GermanSpellerRule.putRepl("verswinde(n|s?t)", "^vers", "versch");
        GermanSpellerRule.putRepl("unverantwortungsvoll(e[nmrs]?)?", "unverantwortungsvoll", "verantwortungslos");
        GermanSpellerRule.putRepl("[gG]erechtlichkeit", "[gG]erechtlich", "Gerechtig");
        GermanSpellerRule.putRepl("[zZ]uverl\u00e4sslichkeit", "lich", "ig");
        GermanSpellerRule.putRepl("[uU]nverzeilig(e[mnrs]?)?", "zeilig", "zeihlich");
        GermanSpellerRule.putRepl("[zZ]uk(ue?|\u00fc)nftlich(e[mnrs]?)?", "uk(ue?|\u00fc)nftlich", "uk\u00fcnftig");
        GermanSpellerRule.putRepl("[rR]eligi\u00f6sisch(e[nmrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[fF]olklorisch(e[nmrs]?)?", "isch", "istisch");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlsvoll(e[nmrs]?)?", "voll", "am");
        GermanSpellerRule.putRepl("Unstimmlichkeit(en)?", "lich", "ig");
        GermanSpellerRule.putRepl("Strebergartens?", "Stre", "Schre");
        GermanSpellerRule.putRepl("[hH]\u00e4hern(e[mnrs]?)?", "\u00e4hern", "\u00e4ren");
        GermanSpellerRule.putRepl("todesbedroh(end|lich)(e[nmrs]?)?", "todes", "lebens");
        GermanSpellerRule.putRepl("^[uU]nabsichtig(e[nmrs]?)?", "ig", "lich");
        GermanSpellerRule.putRepl("[aA]ntisemitistisch(e[mnrs]?)?", "tist", "t");
        GermanSpellerRule.putRepl("[uU]nvorsehbar(e[mnrs]?)?", "vor", "vorher");
        GermanSpellerRule.putRepl("([eE]r|[bB]e|unter|[aA]uf)?h\u00e4lst", "h\u00e4lst", "h\u00e4ltst");
        GermanSpellerRule.put("[wW]ohlf\u00fchlseins?", (String w) -> Arrays.asList("Wellness", w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlbefinden"), w.replaceFirst("[wW]ohlf\u00fchlsein", "Wohlf\u00fchlen")));
        GermanSpellerRule.putRepl("[sS]chmett?e?rling(s|en?)?", "[sS]chmett?e?rling", "Schmetterling");
        GermanSpellerRule.putRepl("^[eE]inlamie?nie?r(st|en?|(t(e[nmrs]?)?))?", "^einlamie?nie?r", "laminier");
        GermanSpellerRule.putRepl("[bB]ravur\u00f6s(e[nrms]?)?", "vur", "vour");
        GermanSpellerRule.putRepl("[aA]ss?ecoires?", "[aA]ss?ec", "Access");
        GermanSpellerRule.putRepl("[aA]ufwechse?lungsreich(er|st)?(e[nmrs]?)?", "ufwechse?lung", "bwechslung");
        GermanSpellerRule.putRepl("[iI]nordnung", "ordnung", " Ordnung");
        GermanSpellerRule.putRepl("[iI]mmoment", "moment", " Moment");
        GermanSpellerRule.putRepl("[hH]euteabend", "abend", " Abend");
        GermanSpellerRule.putRepl("[wW]ienerschnitzel[ns]?", "[wW]ieners", "Wiener S");
        GermanSpellerRule.putRepl("[sS]chwarzw\u00e4lderkirschtorten?", "[sS]chwarzw\u00e4lderk", "Schwarzw\u00e4lder K");
        GermanSpellerRule.putRepl("[kK]oxial(e[nmrs]?)?", "x", "ax");
        GermanSpellerRule.putRepl("([\u00fc\u00dc]ber|[uU]unter)durs?chnitt?lich(e[nmrs]?)?", "s?chnitt?", "chschnitt");
        GermanSpellerRule.putRepl("[dD]urs?chnitt?lich(e[nmrs]?)?", "s?chnitt?", "chschnitt");
        GermanSpellerRule.putRepl("[dD]urs?chnitts?", "s?chnitt", "chschnitt");
        GermanSpellerRule.putRepl("[sS]triktlich(e[mnrs]?)?", "lich", "");
        GermanSpellerRule.putRepl("[hH]\u00f6chstwahrlich(e[mnrs]?)?", "wahr", "wahrschein");
        GermanSpellerRule.putRepl("[oO]rganisativ(e[nmrs]?)?", "tiv", "torisch");
        GermanSpellerRule.putRepl("[kK]ontaktfreundlich(e[nmrs]?)?", "ndlich", "dig");
        GermanSpellerRule.putRepl("Helfer?s-Helfer[ns]?", "Helfer?s-H", "Helfersh");
        GermanSpellerRule.putRepl("[iI]ntell?igentsbestien?", "[iI]ntell?igents", "Intelligenz");
        GermanSpellerRule.putRepl("[aA]vantgardisch(e[mnrs]?)?", "gard", "gardist");
        GermanSpellerRule.putRepl("[gG]ewohnheitsbed\u00fcrftig(e[mnrs]?)?", "wohnheit", "w\u00f6hnung");
        GermanSpellerRule.putRepl("[eE]inf\u00fchlungsvoll(e[mnrs]?)?", "f\u00fchlungsvoll", "f\u00fchlsam");
        GermanSpellerRule.putRepl("[vV]erwant(e[mnrs]?)?", "want", "wandt");
        GermanSpellerRule.putRepl("[\u00e4\u00c4aAeE]rtzten?", "[\u00e4\u00c4aAeE]rt", "\u00c4r");
        GermanSpellerRule.putRepl("pdf-Datei(en)?", "pdf", "PDF");
        GermanSpellerRule.putRepl("rum\u00e4nern?", "rum\u00e4ner", "Rum\u00e4ne");
        GermanSpellerRule.putRepl("[vV]ersantdienstleister[ns]?", "[vV]ersant", "Versand");
        GermanSpellerRule.putRepl("[pP]atrolier(s?t|t?en?)", "atrolier", "atrouillier");
        GermanSpellerRule.putRepl("[pP]ropagandiert(e[mnrs]?)?", "and", "");
        GermanSpellerRule.putRepl("[pP]ropagandier(en|st)", "and", "");
        GermanSpellerRule.putRepl("k\u00e4nzel(n|s?t)", "k\u00e4nzel", "cancel");
        GermanSpellerRule.put("gek\u00e4nzelt", "gecancelt");
        GermanSpellerRule.put("aufgesteht", "aufgestanden");
        GermanSpellerRule.put("ganichts", "gar nichts");
        GermanSpellerRule.put("gesich", "Gesicht");
        GermanSpellerRule.put("glass", "Glas");
        GermanSpellerRule.put("muter", "Mutter");
        GermanSpellerRule.put("[pP]appa", "Papa");
        GermanSpellerRule.put("dier", "dir");
        GermanSpellerRule.put("Referenz-Nr", "Referenz-Nr.");
        GermanSpellerRule.put("Matrikelnr.", "Matrikel-Nr.");
        GermanSpellerRule.put("Rekrutings?prozess", "Recruitingprozess");
        GermanSpellerRule.put("sumarum", "summarum");
        GermanSpellerRule.put("\u00e4nderen", (String w) -> Arrays.asList("\u00e4ndern", "anderen"));
        GermanSpellerRule.put("wanderen", (String w) -> Arrays.asList("wandern", "Wanderern"));
        GermanSpellerRule.put("Dutzen", (String w) -> Arrays.asList("Duzen", "Dutzend"));
        GermanSpellerRule.put("patien", (String w) -> Arrays.asList("Partien", "Patient"));
        GermanSpellerRule.put("Teammitgliederinnen", (String w) -> Arrays.asList("Teammitgliedern", "Teammitglieder"));
        GermanSpellerRule.put("beidige[mnrs]?", (String w) -> Arrays.asList(w.replaceFirst("ig", ""), w.replaceFirst("beid", "beiderseit"), "beeidigen"));
        GermanSpellerRule.put("Wissbegierigkeit", (String w) -> Arrays.asList("Wissbegier", "Wissbegierde"));
        GermanSpellerRule.put("Nabend", "'n Abend");
        GermanSpellerRule.put("gie?bts", "gibt's");
        GermanSpellerRule.put("vs", "vs.");
        GermanSpellerRule.put("bissien", "bisschen");
        GermanSpellerRule.put("[kK]affeeteria", "Cafeteria");
        GermanSpellerRule.put("[kK]affeeterien", "Cafeterien");
        GermanSpellerRule.put("ber\u00fccksicht", "ber\u00fccksichtigt");
        GermanSpellerRule.put("nix", "nichts");
        GermanSpellerRule.put("must", "musst");
        GermanSpellerRule.put("kaffe", "Kaffee");
        GermanSpellerRule.put("zetel", "Zettel");
        GermanSpellerRule.put("wie?daholung", "Wiederholung");
        GermanSpellerRule.put("vie?d(er|a)sehen", "wiedersehen");
        GermanSpellerRule.put("pr[e\u00e4]ventiert", "verhindert");
        GermanSpellerRule.put("pr[e\u00e4]ventieren", "verhindern");
        GermanSpellerRule.put("zur?verf\u00fcgung", "zur Verf\u00fcgung");
        GermanSpellerRule.put("Verwahrlosigkeit", "Verwahrlosung");
        GermanSpellerRule.put("[oO]r?ganisazion", "Organisation");
        GermanSpellerRule.put("[oO]rganisative", "Organisation");
        GermanSpellerRule.put("Emall?iearbeit", "Emaillearbeit");
        GermanSpellerRule.put("[aA]petitt", "Appetit");
        GermanSpellerRule.put("bezuggenommen", "Bezug genommen");
        GermanSpellerRule.put("m\u00e4gt", "m\u00f6gt");
        GermanSpellerRule.put("frug", "fragte");
        GermanSpellerRule.put("ges\u00e4ht", "ges\u00e4t");
        GermanSpellerRule.put("verennt", "verrennt");
        GermanSpellerRule.put("\u00fcberrant", "\u00fcberrannt");
        GermanSpellerRule.put("Gallop", "Galopp");
        GermanSpellerRule.put("Stop", "Stopp");
        GermanSpellerRule.put("Schertz", "Scherz");
        GermanSpellerRule.put("dreiundhalb", "dreieinhalb");
        GermanSpellerRule.put("geschied", "geschieht");
        GermanSpellerRule.put("Aku", "Akku");
        GermanSpellerRule.put("Migrationspackt", "Migrationspakt");
        GermanSpellerRule.put("[zZ]ulaufror", "Zulaufrohr");
        GermanSpellerRule.put("[gG]ebrauchss?puhren", "Gebrauchsspuren");
        GermanSpellerRule.put("[pP]reisnachlassung", "Preisnachlass");
        GermanSpellerRule.put("[mM]edikamentation", "Medikation");
        GermanSpellerRule.put("n[ei]gliche", "Neglig\u00e9");
        GermanSpellerRule.put("palletten?", (String w) -> Arrays.asList(w.replaceFirst("pall", "Pal"), w.replaceFirst("pa", "Pai")));
        GermanSpellerRule.put("Ger\u00e4uch", (String w) -> Arrays.asList("Ger\u00e4usch", "Gestr\u00e4uch"));
        GermanSpellerRule.put("[sS]chull?igung", "Entschuldigung");
        GermanSpellerRule.put("Geerte", "geehrte");
        GermanSpellerRule.put("versichen", "versichern");
        GermanSpellerRule.put("hobb?ies", "Hobbys");
        GermanSpellerRule.put("Begierigkeiten", "Begehrlichkeiten");
        GermanSpellerRule.put("selblosigkeit", "Selbstlosigkeit");
        GermanSpellerRule.put("gestyled", "gestylt");
        GermanSpellerRule.put("umstimigkeiten", "Unstimmigkeiten");
        GermanSpellerRule.put("unann?\u00e4h?ml?ichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("unn?ann?ehmichkeiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("\u00fcbertr[\u00e4a]gte", "\u00fcbertrug");
        GermanSpellerRule.put("\u00fcbertr[\u00e4a]gten", "\u00fcbertrugen");
        GermanSpellerRule.putRepl("\u00fcbertr\u00e4gt(e[mnrs]?)?", "^\u00fcbertr\u00e4gt", "\u00fcbertragen");
        GermanSpellerRule.putRepl("[iI]nterresent(e[mnrs]?)?", "rresent", "ressant");
        GermanSpellerRule.putRepl("Simkartenleser[ns]?", "^Simkartenl", "SIM-Karten-L");
        GermanSpellerRule.putRepl("Hilfstmittel[ns]?", "^Hilfst", "Hilfs");
        GermanSpellerRule.putRepl("trationell(e[mnrs]?)?", "^tra", "tradi");
        GermanSpellerRule.putRepl("[bB]erreichs?", "^[bB]er", "Be");
        GermanSpellerRule.putRepl("[fF]uscher[ns]?", "^[fF]u", "Pfu");
        GermanSpellerRule.putRepl("[uU]nausweichbar(e[mnrs]?)?", "bar", "lich");
        GermanSpellerRule.putRepl("ausgew\u00f6h?nlich(e[mnrs]?)?", "^ausgew\u00f6h?n", "au\u00dfergew\u00f6hn");
        GermanSpellerRule.putRepl("achsial(e[mnrs]?)?", "^achs", "ax");
        GermanSpellerRule.putRepl("famielen?", "^famiel", "Famili");
        GermanSpellerRule.putRepl("miter[ns]?", "^mi", "Mie");
        GermanSpellerRule.putRepl("besig(t(e[mnrs]?)?|en?)", "sig", "sieg");
        GermanSpellerRule.putRepl("[vV]erziehr(t(e[mnrs]?)?|en?)", "ieh", "ie");
        GermanSpellerRule.putRepl("^[pP]iek(s?t|en?)", "iek", "ik");
        GermanSpellerRule.putRepl("[hH]eilei[td]s?", "[hH]eilei[td]", "Highlight");
        GermanSpellerRule.putRepl("[mM]atschscheiben?", "[mM]atschsch", "Mattsch");
        GermanSpellerRule.put("schafen?", (String w) -> Arrays.asList(w.replaceFirst("sch", "schl"), w.replaceFirst("af", "arf"), w.replaceFirst("af", "aff")));
        GermanSpellerRule.putRepl("[hH]ofen?", "of", "off");
        GermanSpellerRule.putRepl("[sS]ommerverien?", "[sS]ommerverien?", "Sommerferien");
        GermanSpellerRule.putRepl("[rR]ecourcen?", "[rR]ec", "Ress");
        GermanSpellerRule.putRepl("[fF]amm?ill?i?[a\u00e4]risch(e[mnrs]?)?", "amm?ill?i?[a\u00e4]risch", "amili\u00e4r");
        GermanSpellerRule.putRepl("Sim-Karten?", "^Sim", "SIM");
        GermanSpellerRule.putRepl("Spax-Schrauben?", "^Spax", "SPAX");
        GermanSpellerRule.putRepl("[aA]leine", "l", "ll");
        GermanSpellerRule.putRepl("Kaput", "t", "tt");
        GermanSpellerRule.putRepl("[fF]estell(s?t|en?)", "est", "estst");
        GermanSpellerRule.putRepl("(Baden-)?W\u00fcrtenbergs?", "W\u00fcrten", "W\u00fcrttem");
        GermanSpellerRule.putRepl("Betriebsratzimmer[ns]?", "rat", "rats");
        GermanSpellerRule.putRepl("Rechts?schreibungsfehler[ns]?", "Rechts?schreibungs", "Rechtschreib");
        GermanSpellerRule.putRepl("Open[aA]ir-Konzert(en?)?", "Open[aA]ir", "Open-Air");
        GermanSpellerRule.putRepl("Jugenschuhen?", "Jug", "Jung");
        GermanSpellerRule.putRepl("TODO-Listen?", "TODO", "To-do");
        GermanSpellerRule.putRepl("ausiehs?t", "aus", "auss");
        GermanSpellerRule.putRepl("unterbemittel(nd|t)(e[nmrs]?)?", "unterbemittel(nd|t)", "minderbemittelt");
        GermanSpellerRule.putRepl("[xX]te[mnrs]?", "te", "-te");
        GermanSpellerRule.putRepl("verheielt(e[mnrs]?)?", "heiel", "heil");
        GermanSpellerRule.putRepl("[rR]evolutionie?sier(s?t|en?)", "ie?s", "");
        GermanSpellerRule.putRepl("Kohleaustiegs?", "aus", "auss");
        GermanSpellerRule.putRepl("[jJ]urististisch(e[mnrs]?)?", "istist", "ist");
        GermanSpellerRule.putRepl("geh\u00e4ckelt(e[nmrs]?)?", "ck", "k");
        GermanSpellerRule.putRepl("deutsprachig(e[nmrs]?)?", "deut", "deutsch");
        GermanSpellerRule.putRepl("angesehend(st)?e[nmrs]?", "end", "en");
        GermanSpellerRule.putRepl("[iI]slamophobisch(e[mnrs]?)?", "isch", "");
        GermanSpellerRule.putRepl("[vV]erharkt(e[mnrs]?)?", "ar", "a");
        GermanSpellerRule.putRepl("[dD]es\u00f6fterer?[nm]", "\u00f6fterer?[nm]", " \u00d6fteren");
        GermanSpellerRule.putRepl("[dD]esweitere?[mn]", "weitere?[mn]", " Weiteren");
        GermanSpellerRule.putRepl("Einkaufstachen?", "ch", "sch");
        GermanSpellerRule.putRepl("Bortmesser[ns]?", "Bor", "Bro");
        GermanSpellerRule.putRepl("Makeupstylist(in(nen)?|en)?", "Makeups", "Make-up-S");
        GermanSpellerRule.putRepl("Fee?db\u00e4cks?", "Fee?db\u00e4ck", "Feedback");
        GermanSpellerRule.put("Rollade", (String w) -> Arrays.asList("Rollladen", "Roulade"));
        GermanSpellerRule.put("aufgew\u00e4gt", "aufgewogen");
        GermanSpellerRule.put("[rR]eflektion", "Reflexion");
        GermanSpellerRule.put("momentmal", "Moment mal");
        GermanSpellerRule.put("satzt", "Satz");
        GermanSpellerRule.put("B\u00fcff?(ee|\u00e9)", (String w) -> Arrays.asList("Buffet", "B\u00fcfett"));
        GermanSpellerRule.put("[fF]r\u00fchst\u00fccksb[u\u00fc]ff?(\u00e9|ee)", "Fr\u00fchst\u00fccksbuffet");
        GermanSpellerRule.put("[aA]lterego", "Alter Ego");
        GermanSpellerRule.put("Copyride", "Copyright");
        GermanSpellerRule.put("Analysierung", "Analyse");
        GermanSpellerRule.put("Exel", "Excel");
        GermanSpellerRule.put("Gl\u00fccklichkeit", "Gl\u00fcck");
        GermanSpellerRule.put("Begierigkeit", "Begierde");
        GermanSpellerRule.put("voralem", "vor allem");
        GermanSpellerRule.put("Unorganisation", (String w) -> Arrays.asList("Desorganisation", "Unorganisiertheit"));
        GermanSpellerRule.put("Cand(el|le)lightdinner", "Candle-Light-Dinner");
        GermanSpellerRule.put("wertgelegt", "Wert gelegt");
        GermanSpellerRule.put("Deluxe", "de luxe");
        GermanSpellerRule.put("antuhen", "antun");
        GermanSpellerRule.put("komen", "kommen");
        GermanSpellerRule.put("geni\u00dfen", "genie\u00dfen");
        GermanSpellerRule.put("Stationskrankenpflegerin", "Stationsschwester");
        GermanSpellerRule.put("[iI\u00fc\u00dcuU]b[ea]w[ae]isung", "\u00dcberweisung");
        GermanSpellerRule.put("[bB]oxhorn", "Bockshorn");
        GermanSpellerRule.put("[zZ]oolophie", "Zoophilie");
        GermanSpellerRule.put("Makieren", "Markieren");
        GermanSpellerRule.put("Altersheimer", "Alzheimer");
        GermanSpellerRule.put("gesen", "gesehen");
        GermanSpellerRule.put("Neugierigkeit", (String w) -> Arrays.asList("Neugier", "Neugierde"));
        GermanSpellerRule.put("[kK]onn?ekt?schen", "Connection");
        GermanSpellerRule.put("E-Maul", "E-Mail");
        GermanSpellerRule.put("E-Mauls", "E-Mails");
        GermanSpellerRule.put("E-Mal", "E-Mail");
        GermanSpellerRule.put("E-Mals", "E-Mails");
        GermanSpellerRule.put("[nN]ah?richt", "Nachricht");
        GermanSpellerRule.put("[nN]ah?richten", "Nachrichten");
        GermanSpellerRule.put("Getrixe", "Getrickse");
        GermanSpellerRule.put("Ausage", "Aussage");
        GermanSpellerRule.put("gelessen", "gelesen");
        GermanSpellerRule.put("Kanst", "Kannst");
        GermanSpellerRule.put("Unwohlbefinden", "Unwohlsein");
        GermanSpellerRule.put("leiwagen", "Leihwagen");
        GermanSpellerRule.put("krahn", "Kran");
        GermanSpellerRule.put("[hH]ifi", "Hi-Fi");
        GermanSpellerRule.put("chouch", "Couch");
        GermanSpellerRule.put("eh?rgeit?z", "Ehrgeiz");
        GermanSpellerRule.put("solltes", "solltest");
        GermanSpellerRule.put("geklabt", "geklappt");
        GermanSpellerRule.put("angefangt", "angefangen");
        GermanSpellerRule.put("beinh\u00e4lt", "beinhaltet");
        GermanSpellerRule.put("einhaltest", "einh\u00e4ltst");
        GermanSpellerRule.put("\u00fcbers\u00e4ht", "\u00fcbers\u00e4t");
        GermanSpellerRule.put("staats?angehoe?rigkeit", "Staatsangeh\u00f6rigkeit");
        GermanSpellerRule.put("[uU]nangeneh?mheiten", "Unannehmlichkeiten");
        GermanSpellerRule.put("Humuspaste", "Hummuspaste");
        GermanSpellerRule.put("afarung", "Erfahrung");
        GermanSpellerRule.put("bescheid?t", "Bescheid");
        GermanSpellerRule.put("[mM]iteillung", "Mitteilung");
        GermanSpellerRule.put("Revisionierung", "Revision");
        GermanSpellerRule.put("[eE]inf\u00fchlverm\u00f6gen", "Einf\u00fchlungsverm\u00f6gen");
        GermanSpellerRule.put("[sS]peziellisierung", "Spezialisierung");
        GermanSpellerRule.put("[cC]hangse", "Chance");
        GermanSpellerRule.put("untergangen", "untergegangen");
        GermanSpellerRule.put("geliegt", "gelegen");
        GermanSpellerRule.put("BluRay", "Blu-ray");
        GermanSpellerRule.put("Freiwilligerin", "Freiwillige");
        GermanSpellerRule.put("Mitgliederinnen", (String w) -> Arrays.asList("Mitglieder", "Mitgliedern"));
        GermanSpellerRule.put("Hautreinheiten", "Hautunreinheiten");
        GermanSpellerRule.put("Durf\u00fch?rung", "Durchf\u00fchrung");
        GermanSpellerRule.put("tuhen", "tun");
        GermanSpellerRule.put("tuhe", "tue");
        GermanSpellerRule.put("tip", "Tipp");
        GermanSpellerRule.put("ccm", "cm\u00b3");
        GermanSpellerRule.put("Kilimand?jaro", "Kilimandscharo");
        GermanSpellerRule.put("[hH]erausfor?dung", "Herausforderung");
        GermanSpellerRule.put("[bB]er\u00fccksichtung", "Ber\u00fccksichtigung");
        GermanSpellerRule.put("artzt?", "Arzt");
        GermanSpellerRule.put("[tT]h?elepath?ie", "Telepathie");
        GermanSpellerRule.put("Wi-?Fi-Dire[ck]t", "Wi-Fi Direct");
        GermanSpellerRule.put("gans", "ganz");
        GermanSpellerRule.put("Pearl-Harbou?r", "Pearl Harbor");
        GermanSpellerRule.put("[aA]utonomit\u00e4t", "Autonomie");
        GermanSpellerRule.put("[fF]r[u\u00fc]h?st[u\u00fc]c?k", "Fr\u00fchst\u00fcck");
        GermanSpellerRule.putRepl("(ge)?fr[u\u00fc]h?st[u\u00fc](c?k|g)t", "fr[u\u00fc]h?st[u\u00fc](c?k|g)t", "fr\u00fchst\u00fcckt");
        GermanSpellerRule.put("zucc?h?inis?", "Zucchini");
        GermanSpellerRule.put("[mM]itag", "Mittag");
        GermanSpellerRule.put("Lexion", "Lexikon");
        GermanSpellerRule.put("[mM]otorisation", "Motorisierung");
        GermanSpellerRule.put("[fF]ormalisation", "Formalisierung");
        GermanSpellerRule.put("ausprache", "Aussprache");
        GermanSpellerRule.put("[mM]enegment", "Management");
        GermanSpellerRule.put("[gG]ebrauspuren", "Gebrauchsspuren");
        GermanSpellerRule.put("viedeo", "Video");
        GermanSpellerRule.put("[hH]erstammung", "Abstammung");
        GermanSpellerRule.put("[iI]nstall?at\u00f6r", "Installateur");
        GermanSpellerRule.put("maletriert", "maltr\u00e4tiert");
        GermanSpellerRule.put("abgeschaffen", "abgeschafft");
        GermanSpellerRule.put("Verschiden", "Verschieden");
        GermanSpellerRule.put("Anschovis", "Anchovis");
        GermanSpellerRule.put("Bravur", "Bravour");
        GermanSpellerRule.put("Grisli", "Grizzly");
        GermanSpellerRule.put("Grislib\u00e4r", "Grizzlyb\u00e4r");
        GermanSpellerRule.put("Grislib\u00e4ren", "Grizzlyb\u00e4ren");
        GermanSpellerRule.put("Frott\u00e9", "Frottee");
        GermanSpellerRule.put("Joga", "Yoga");
        GermanSpellerRule.put("Kalvinismus", "Calvinismus");
        GermanSpellerRule.put("Kollier", "Collier");
        GermanSpellerRule.put("Kolliers", "Colliers");
        GermanSpellerRule.put("Ketschup", "Ketchup");
        GermanSpellerRule.put("Kommunikee", "Kommuniqu\u00e9");
        GermanSpellerRule.put("Negligee", "Neglig\u00e9");
        GermanSpellerRule.put("Nessess\u00e4r", "Necessaire");
        GermanSpellerRule.put("passee", "pass\u00e9");
        GermanSpellerRule.put("Varietee", "Variet\u00e9");
        GermanSpellerRule.put("Varietees", "Variet\u00e9s");
        GermanSpellerRule.put("Wandalismus", "Vandalismus");
        GermanSpellerRule.put("Campagne", "Kampagne");
        GermanSpellerRule.put("Campagnen", "Kampagnen");
        GermanSpellerRule.put("Jockei", "Jockey");
        GermanSpellerRule.put("Roulett", "Roulette");
        GermanSpellerRule.put("Mo-Di", "Mo.\u2013Di.");
        GermanSpellerRule.put("Mo-Mi", "Mo.\u2013Mi.");
        GermanSpellerRule.put("Mo-Do", "Mo.\u2013Do.");
        GermanSpellerRule.put("Mo-Fr", "Mo.\u2013Fr.");
        GermanSpellerRule.put("Mo-Sa", "Mo.\u2013Sa.");
        GermanSpellerRule.put("Mo-So", "Mo.\u2013So.");
        GermanSpellerRule.put("Di-Mi", "Di.\u2013Mi.");
        GermanSpellerRule.put("Di-Do", "Di.\u2013Do.");
        GermanSpellerRule.put("Di-Fr", "Di.\u2013Fr.");
        GermanSpellerRule.put("Di-Sa", "Di.\u2013Sa.");
        GermanSpellerRule.put("Di-So", "Di.\u2013So.");
        GermanSpellerRule.put("Mi-Do", "Mi.\u2013Do.");
        GermanSpellerRule.put("Mi-Fr", "Mi.\u2013Fr.");
        GermanSpellerRule.put("Mi-Sa", "Mi.\u2013Sa.");
        GermanSpellerRule.put("Mi-So", "Mi.\u2013So.");
        GermanSpellerRule.put("Do-Fr", "Do.\u2013Fr.");
        GermanSpellerRule.put("Do-Sa", "Do.\u2013Sa.");
        GermanSpellerRule.put("Do-So", "Do.\u2013So.");
        GermanSpellerRule.put("Fr-Sa", "Fr.\u2013Sa.");
        GermanSpellerRule.put("Fr-So", "Fr.\u2013So.");
        GermanSpellerRule.put("Sa-So", "Sa.\u2013So.");
        GermanSpellerRule.putRepl("[hH]ats", "ats", "at es");
        GermanSpellerRule.putRepl("wieviele?", "wieviel", "wie viel");
        splitter = GermanSpellerRule.getSplitter();
    }

    static class ExpandingReader
    extends BufferedReader {
        private final List<String> buffer = new ArrayList<String>();
        private final LineExpander lineExpander = new LineExpander();

        ExpandingReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            if (this.buffer.isEmpty()) {
                String line = super.readLine();
                if (line == null) {
                    return null;
                }
                this.buffer.addAll(this.lineExpander.expandLine(line));
            }
            return this.buffer.remove(0);
        }
    }
}

