/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class VerbAgreementRule
extends TextLevelRule {
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("die|welche").build(), new PatternTokenBuilder().tokenRegex(".*").build(), new PatternTokenBuilder().tokenRegex("mehr|weniger").build(), new PatternTokenBuilder().token("als").build(), new PatternTokenBuilder().tokenRegex("ich|du|e[rs]|sie").build()), Arrays.asList(new PatternTokenBuilder().token("wenn").build(), new PatternTokenBuilder().token("du").build(), new PatternTokenBuilder().token("anstelle").build()), Arrays.asList(new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().csToken("Du").build(), new PatternTokenBuilder().token("anbieten").matchInflectedForms().build()), Arrays.asList(new PatternTokenBuilder().token(",").build(), new PatternTokenBuilder().posRegex("VER:MOD:2:.*").build()), Arrays.asList(new PatternTokenBuilder().csToken("Soll").build(), new PatternTokenBuilder().token("ich").build()), Arrays.asList(new PatternTokenBuilder().csToken("Solltest").build(), new PatternTokenBuilder().token("du").build()), Arrays.asList(new PatternTokenBuilder().csToken("Sollte").build(), new PatternTokenBuilder().tokenRegex("er|sie").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().csToken("Bin").build()), Arrays.asList(new PatternTokenBuilder().token(",").build(), new PatternTokenBuilder().tokenRegex("bin|hast").build()), Arrays.asList(new PatternTokenBuilder().token("er").build(), new PatternTokenBuilder().posRegex("VER:.*").build(), new PatternTokenBuilder().token("wird").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("wie|als").build(), new PatternTokenBuilder().token("ich").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("ich").build(), new PatternTokenBuilder().pos("VER:INF:NON").build(), new PatternTokenBuilder().token("werde").build()), Arrays.asList(new PatternTokenBuilder().pos("VER:IMP:SIN:SFT").build(), new PatternTokenBuilder().token("du").build(), new PatternTokenBuilder().token("dich").build()), Arrays.asList(new PatternTokenBuilder().token("sei").build(), new PatternTokenBuilder().token("du").build(), new PatternTokenBuilder().token("selbst").build()), Arrays.asList(new PatternTokenBuilder().token("als").build(), new PatternTokenBuilder().token("ich").build(), new PatternTokenBuilder().posRegex("PA2:.*").build(), new PatternTokenBuilder().token("bin").build()), Arrays.asList(new PatternTokenBuilder().token("als").build(), new PatternTokenBuilder().tokenRegex("du|e[rs]|sie|ich").build(), new PatternTokenBuilder().token("sein").matchInflectedForms().build(), new PatternTokenBuilder().tokenRegex("[\\.,]").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("D[au]rf.*|Muss.*").build(), new PatternTokenBuilder().posRegex("PRO:PER:NOM:.+").build(), new PatternTokenBuilder().posRegex("VER:INF:.+").build(), new PatternTokenBuilder().pos("PKT").build(), new PatternTokenBuilder().tokenRegex("(?!die).+").build()), Arrays.asList(new PatternTokenBuilder().csToken("(").build(), new PatternTokenBuilder().posRegex("VER:2:SIN:.+").build(), new PatternTokenBuilder().csToken(")").build()), Arrays.asList(new PatternTokenBuilder().posRegex("VER:MOD:1:PLU:.+").build(), new PatternTokenBuilder().csToken("wir").build(), new PatternTokenBuilder().csToken("bitte").build()));
    private static final Set<String> BIN_IGNORE = new HashSet<String>(Arrays.asList("Suleiman", "Mohamed", "Muhammad", "Muhammed", "Mohammed", "Mohammad", "Mansour", "Qaboos", "Qabus", "Tamim", "Majid", "Salman", "Ghazi", "Mahathir", "Madschid", "Maktum", "al-Aziz", "Asis", "Numan", "Hussein", "Abdul", "Abdulla", "Abdullah", "Isa", "Osama", "Said", "Zayid", "Zayed", "Hamad", "Chalifa", "Raschid", "Turki", "/"));
    private static final Set<String> CONJUNCTIONS = new HashSet<String>(Arrays.asList("weil", "obwohl", "dass", "indem", "sodass"));
    private static final Set<String> QUOTATION_MARKS = new HashSet<String>(Arrays.asList("\"", "\u201e"));
    private final German language;

    public VerbAgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Ich <marker>bist</marker> \u00fcber die Entwicklung sehr froh."), Example.fixed((String)"Ich <marker>bin</marker> \u00fcber die Entwicklung sehr froh."));
    }

    public String getId() {
        return "DE_VERBAGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (nur 1. u. 2. Pers. od. m. Personalpronomen), z.B. 'Er bist (ist)'";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedSentence partialSentence;
            int idx = 0;
            AnalyzedTokenReadings[] tokens = sentence.getTokens();
            for (int i = 2; i < tokens.length; ++i) {
                if (!",".equals(tokens[i - 2].getToken()) || !CONJUNCTIONS.contains(tokens[i].getToken())) continue;
                partialSentence = new AnalyzedSentence(Arrays.copyOfRange(tokens, idx, i));
                ruleMatches.addAll(this.match(partialSentence, pos));
                idx = i;
            }
            partialSentence = new AnalyzedSentence(Arrays.copyOfRange(tokens, idx, tokens.length));
            ruleMatches.addAll(this.match(partialSentence, pos));
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private List<RuleMatch> match(AnalyzedSentence sentence, int pos) {
        BooleanAndFiniteVerb check;
        int plus1;
        AnalyzedTokenReadings finiteVerb = null;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (tokens.length < 4) {
            return ruleMatches;
        }
        int posIch = -1;
        int posDu = -1;
        int posEr = -1;
        int posWir = -1;
        int posVer1Sin = -1;
        int posVer2Sin = -1;
        int posVer1Plu = -1;
        int posPossibleVer1Sin = -1;
        int posPossibleVer2Sin = -1;
        int posPossibleVer3Sin = -1;
        int posPossibleVer1Plu = -1;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].isImmunized()) continue;
            String strToken = tokens[i].getToken().toLowerCase();
            switch (strToken = strToken.replace("\u201a", "")) {
                case "ich": {
                    posIch = i;
                    break;
                }
                case "du": {
                    posDu = i;
                    break;
                }
                case "er": {
                    posEr = i;
                    break;
                }
                case "wir": {
                    posWir = i;
                }
            }
            if (!tokens[i].hasPartialPosTag("VER") || !Character.isLowerCase(tokens[i].getToken().charAt(0)) && i != 1 && !this.isQuotationMark(tokens[i - 1])) continue;
            if (!(!this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "SIN") || strToken.equals("bin") && (BIN_IGNORE.contains(tokens[i - 1].getToken()) || tokens.length != i + 1 && tokens[i + 1].getToken().startsWith("Laden")))) {
                posVer1Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "2", "SIN") && !"Probst".equals(tokens[i].getToken())) {
                posVer2Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "PLU")) {
                posVer1Plu = i;
            }
            if (tokens[i].hasPartialPosTag(":1:SIN")) {
                posPossibleVer1Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":2:SIN")) {
                posPossibleVer2Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":3:SIN")) {
                posPossibleVer3Sin = i;
            }
            if (!tokens[i].hasPartialPosTag(":1:PLU")) continue;
            posPossibleVer1Plu = i;
        }
        if (posVer1Sin != -1 && posIch == -1 && !this.isQuotationMark(tokens[posVer1Sin - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Sin], pos, sentence));
        } else if (!(posIch <= 0 || this.isNear(posPossibleVer1Sin, posIch) || !tokens[posIch].getToken().equals("ich") && tokens[posIch].getStartPos() != 0 || this.isQuotationMark(tokens[posIch - 1]))) {
            plus1 = posIch + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posIch - 1], tokens[posIch + plus1], "1", "SIN", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || this.nextButOneIsModal(tokens, posIch) || "\u00e4u\u00dferst".equals(check.finiteVerb.getToken()))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posIch], check.finiteVerb, "1:SIN", pos, sentence));
            }
        }
        if (posVer2Sin != -1 && posDu == -1 && !this.isQuotationMark(tokens[posVer2Sin - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer2Sin], pos, sentence));
        } else if (posDu > 0 && !this.isNear(posPossibleVer2Sin, posDu) && (!this.isQuotationMark(tokens[posDu - 1]) || posDu < 3 || posDu > 1 && tokens[posDu - 2].getToken().equals(":"))) {
            plus1 = posDu + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posDu - 1], tokens[posDu + plus1], "2", "SIN", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || tokens[posDu + plus1].hasPosTagStartingWith("VER:1:SIN:KJ2") || tokens[posDu + plus1].hasPosTagStartingWith("ADJ:") && !tokens[posDu + plus1].hasPosTag("ADJ:PRD:GRU") || tokens[posDu - 1].hasPosTagStartingWith("VER:1:SIN:KJ2") || this.nextButOneIsModal(tokens, posDu))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posDu], check.finiteVerb, "2:SIN", pos, sentence));
            }
        }
        if (posEr > 0 && !this.isNear(posPossibleVer3Sin, posEr) && !this.isQuotationMark(tokens[posEr - 1])) {
            plus1 = posEr + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posEr - 1], tokens[posEr + plus1], "3", "SIN", finiteVerb);
            if (!(check.verbDoesMatchPersonAndNumber || this.nextButOneIsModal(tokens, posEr) || "\u00e4u\u00dferst".equals(check.finiteVerb.getToken()) || "regen".equals(check.finiteVerb.getToken()))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posEr], check.finiteVerb, "3:SIN", pos, sentence));
            }
        }
        if (posVer1Plu != -1 && posWir == -1 && !this.isQuotationMark(tokens[posVer1Plu - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Plu], pos, sentence));
        } else if (posWir > 0 && !this.isNear(posPossibleVer1Plu, posWir) && !this.isQuotationMark(tokens[posWir - 1])) {
            plus1 = posWir + 1 == tokens.length ? 0 : 1;
            check = this.verbDoesMatchPersonAndNumber(tokens[posWir - 1], tokens[posWir + plus1], "1", "PLU", finiteVerb);
            if (!check.verbDoesMatchPersonAndNumber && !this.nextButOneIsModal(tokens, posWir)) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posWir], check.finiteVerb, "1:PLU", pos, sentence));
            }
        }
        return ruleMatches;
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.language);
    }

    private boolean nextButOneIsModal(AnalyzedTokenReadings[] tokens, int pos) {
        return pos < tokens.length - 2 && tokens[pos + 2].hasPartialPosTag(":MOD:");
    }

    private boolean isNear(int a, int b) {
        return a != -1 && Math.abs(a - b) < 5;
    }

    private boolean isQuotationMark(AnalyzedTokenReadings token) {
        return QUOTATION_MARKS.contains(token.getToken());
    }

    private boolean hasUnambiguouslyPersonAndNumber(AnalyzedTokenReadings tokenReadings, String person, String number) {
        if (tokenReadings.getToken().length() == 0 || Character.isUpperCase(tokenReadings.getToken().charAt(0)) && tokenReadings.getStartPos() != 0 || !tokenReadings.hasPartialPosTag("VER")) {
            return false;
        }
        for (AnalyzedToken analyzedToken : tokenReadings) {
            String postag = analyzedToken.getPOSTag();
            if (postag == null || postag.endsWith("_END") || postag.contains(":" + person + ":" + number)) continue;
            return false;
        }
        return true;
    }

    private boolean isFiniteVerb(AnalyzedTokenReadings token) {
        if (token.getToken().length() == 0 || Character.isUpperCase(token.getToken().charAt(0)) && token.getStartPos() != 0 || !token.hasPartialPosTag("VER") || token.hasAnyPartialPosTag(new String[]{"PA2", "PRO:", "ZAL"}) || "einst".equals(token.getToken())) {
            return false;
        }
        return token.hasAnyPartialPosTag(new String[]{":1:", ":2:", ":3:"});
    }

    private BooleanAndFiniteVerb verbDoesMatchPersonAndNumber(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, String person, String number, AnalyzedTokenReadings finiteVerb) {
        if (StringUtils.equalsAny((CharSequence)token1.getToken(), (CharSequence[])new CharSequence[]{",", "und", "sowie"}) || StringUtils.equalsAny((CharSequence)token2.getToken(), (CharSequence[])new CharSequence[]{",", "und", "sowie"})) {
            return new BooleanAndFiniteVerb(true, finiteVerb);
        }
        boolean foundFiniteVerb = false;
        if (this.isFiniteVerb(token1)) {
            foundFiniteVerb = true;
            finiteVerb = token1;
            if (token1.hasPartialPosTag(":" + person + ":" + number)) {
                return new BooleanAndFiniteVerb(true, finiteVerb);
            }
        }
        if (this.isFiniteVerb(token2)) {
            foundFiniteVerb = true;
            finiteVerb = token2;
            if (token2.hasPartialPosTag(":" + person + ":" + number)) {
                return new BooleanAndFiniteVerb(true, finiteVerb);
            }
        }
        return new BooleanAndFiniteVerb(!foundFiniteVerb, finiteVerb);
    }

    private List<String> getVerbSuggestions(AnalyzedTokenReadings verb, String expectedVerbPOS, boolean toUppercase) {
        AnalyzedToken verbToken = new AnalyzedToken("", "", "");
        for (AnalyzedToken token : verb.getReadings()) {
            if (!token.getPOSTag().startsWith("VER:")) continue;
            verbToken = token;
            break;
        }
        try {
            String[] synthesized = this.language.getSynthesizer().synthesize(verbToken, "VER.*:" + expectedVerbPOS + ".*", true);
            HashSet<String> suggestionSet = new HashSet<String>(Arrays.asList(synthesized));
            ArrayList<String> suggestions = new ArrayList<String>(suggestionSet);
            if (toUppercase) {
                for (int i = 0; i < suggestions.size(); ++i) {
                    suggestions.set(i, StringTools.uppercaseFirstChar((String)((String)suggestions.get(i))));
                }
            }
            Collections.sort(suggestions);
            return suggestions;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getPronounSuggestions(AnalyzedTokenReadings verb, boolean toUppercase) {
        ArrayList<String> result = new ArrayList<String>();
        if (verb.hasPartialPosTag(":1:SIN")) {
            result.add("ich");
        }
        if (verb.hasPartialPosTag(":2:SIN")) {
            result.add("du");
        }
        if (verb.hasPartialPosTag(":3:SIN")) {
            result.add("er");
            result.add("sie");
            result.add("es");
        }
        if (verb.hasPartialPosTag(":1:PLU")) {
            result.add("wir");
        }
        if (verb.hasPartialPosTag(":2:PLU")) {
            result.add("ihr");
        }
        if (verb.hasPartialPosTag(":3:PLU") && !result.contains("sie")) {
            result.add("sie");
        }
        if (toUppercase) {
            for (int i = 0; i < result.size(); ++i) {
                result.set(i, StringTools.uppercaseFirstChar((String)((String)result.get(i))));
            }
        }
        return result;
    }

    private RuleMatch ruleMatchWrongVerb(AnalyzedTokenReadings token, int pos, AnalyzedSentence sentence) {
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt und Pr\u00e4dikat (" + token.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: 'Max bist' statt 'Max ist').";
        return new RuleMatch((Rule)this, sentence, pos + token.getStartPos(), pos + token.getEndPos(), msg);
    }

    private RuleMatch ruleMatchWrongVerbSubject(AnalyzedTokenReadings subject, AnalyzedTokenReadings verb, String expectedVerbPOS, int pos, AnalyzedSentence sentence) {
        RuleMatch ruleMatch;
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt (" + subject.getToken() + ") und Pr\u00e4dikat (" + verb.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: 'ich sind' statt 'ich bin').";
        ArrayList<String> suggestions = new ArrayList<String>();
        ArrayList<String> verbSuggestions = new ArrayList<String>();
        ArrayList<String> pronounSuggestions = new ArrayList<String>();
        if (subject.getStartPos() < verb.getStartPos()) {
            ruleMatch = new RuleMatch((Rule)this, sentence, pos + subject.getStartPos(), pos + verb.getStartPos() + verb.getToken().length(), msg);
            verbSuggestions.addAll(this.getVerbSuggestions(verb, expectedVerbPOS, false));
            for (String verbSuggestion : verbSuggestions) {
                suggestions.add(subject.getToken() + " " + verbSuggestion);
            }
            pronounSuggestions.addAll(this.getPronounSuggestions(verb, Character.isUpperCase(subject.getToken().charAt(0))));
            for (String pronounSuggestion : pronounSuggestions) {
                suggestions.add(pronounSuggestion + " " + verb.getToken());
            }
            ruleMatch.setSuggestedReplacements(suggestions);
        } else {
            ruleMatch = new RuleMatch((Rule)this, sentence, pos + verb.getStartPos(), pos + subject.getStartPos() + subject.getToken().length(), msg);
            verbSuggestions.addAll(this.getVerbSuggestions(verb, expectedVerbPOS, Character.isUpperCase(verb.getToken().charAt(0))));
            for (String verbSuggestion : verbSuggestions) {
                suggestions.add(verbSuggestion + " " + subject.getToken());
            }
            pronounSuggestions.addAll(this.getPronounSuggestions(verb, false));
            for (String pronounSuggestion : pronounSuggestions) {
                suggestions.add(verb.getToken() + " " + pronounSuggestion);
            }
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    static class BooleanAndFiniteVerb {
        boolean verbDoesMatchPersonAndNumber;
        AnalyzedTokenReadings finiteVerb;

        private BooleanAndFiniteVerb(boolean verbDoesMatchPersonAndNumber, AnalyzedTokenReadings finiteVerb) {
            this.verbDoesMatchPersonAndNumber = verbDoesMatchPersonAndNumber;
            this.finiteVerb = finiteVerb;
        }
    }
}

