/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.UserConfig;
import org.languagetool.rules.AbstractStyleRepeatedWordRule;
import org.languagetool.rules.Categories;

public class GermanStyleRepeatedWordRule
extends AbstractStyleRepeatedWordRule {
    public GermanStyleRepeatedWordRule(ResourceBundle messages, UserConfig userConfig) {
        super(messages, userConfig);
        super.setCategory(Categories.STYLE.getCategory(messages));
    }

    public String getId() {
        return "STYLE_REPEATED_WORD_RULE_DE";
    }

    public String getDescription() {
        return "Wiederholte Worte in aufeinanderfolgenden S\u00e4tzen";
    }

    protected String messageSameSentence() {
        return "Stilproblem: Das Wort wird bereits im selben Satz verwendet!";
    }

    protected String messageSentenceBefore() {
        return "Stilproblem: Das Wort wird bereits in einem vorhergehenden Satz verwendet!";
    }

    protected String messageSentenceAfter() {
        return "Stilproblem: Das Wort wird bereits in einem nachfolgenden Satz verwendet!";
    }

    private static boolean isUnknownWord(AnalyzedTokenReadings token) {
        return token.isPosTagUnknown() && token.getToken().length() > 2 && token.getToken().matches("^[A-Za-z\u00c4\u00d6\u00dc\u00e4\u00f6\u00fc\u00df]+$");
    }

    protected boolean isTokenToCheck(AnalyzedTokenReadings token) {
        return token.matchesPosTagRegex("(SUB|EIG|VER|ADJ):.*") && !token.matchesPosTagRegex("(PRO|ART|ADV|VER:(AUX|MOD)):.*") && !token.getToken().equals("Ich") || GermanStyleRepeatedWordRule.isUnknownWord(token);
    }

    protected boolean isTokenPair(AnalyzedTokenReadings[] tokens, int n, boolean before) {
        return before ? tokens[n - 2].matchesPosTagRegex("SUB:.*") && tokens[n - 1].matchesPosTagRegex("PRP:.*") && tokens[n].matchesPosTagRegex("SUB:.*") : tokens[n].matchesPosTagRegex("SUB:.*") && tokens[n + 1].matchesPosTagRegex("PRP:.*") && tokens[n + 2].matchesPosTagRegex("SUB:.*");
    }

    protected boolean isPartOfWord(String testTokenText, String tokenText) {
        return (testTokenText.startsWith(tokenText) || testTokenText.endsWith(tokenText) || tokenText.startsWith(testTokenText) || tokenText.endsWith(testTokenText)) && (testTokenText.length() == tokenText.length() || testTokenText.length() < tokenText.length() - 3 || testTokenText.length() > tokenText.length() + 3) || testTokenText.equals(tokenText + "s") || tokenText.equals(testTokenText + "s");
    }
}

