/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.Rule;
import org.languagetool.rules.de.OldSpellingRuleWithSuggestion;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;

class OldSpellingData {
    private final List<OldSpellingRuleWithSuggestion> spellingRules = new ArrayList<OldSpellingRuleWithSuggestion>();

    OldSpellingData(String ruleDesc) {
        String filePath = "/de/alt_neu.csv";
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(filePath);
             Scanner scanner = new Scanner(inputStream, "utf-8");){
            Language german = Languages.getLanguageForShortCode((String)"de");
            String message = "Diese Schreibweise war nur in der alten Rechtschreibung korrekt.";
            String shortMessage = "alte Rechtschreibung";
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.startsWith("#")) continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new RuntimeException("Unexpected format in file " + filePath + ": " + line);
                }
                String oldSpelling = parts[0];
                String newSpelling = parts[1];
                List<PatternToken> patternTokens = this.getTokens(oldSpelling, german);
                PatternRule rule = new PatternRule("OLD_SPELLING_INTERNAL", german, patternTokens, ruleDesc, message, shortMessage);
                this.spellingRules.add(new OldSpellingRuleWithSuggestion((Rule)rule, oldSpelling, newSpelling));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private List<PatternToken> getTokens(String oldSpelling, Language lang) {
        PatternTokenBuilder builder = new PatternTokenBuilder();
        String[] newSpellingTokens = oldSpelling.split(" ");
        ArrayList<PatternToken> patternTokens = new ArrayList<PatternToken>();
        for (String part : newSpellingTokens) {
            PatternToken token = this.isBaseform(oldSpelling, lang) ? builder.csToken(part).matchInflectedForms().build() : builder.csToken(part).build();
            patternTokens.add(token);
        }
        return patternTokens;
    }

    private boolean isBaseform(String term, Language lang) {
        try {
            AnalyzedTokenReadings lookup = ((GermanTagger)lang.getTagger()).lookup(term);
            if (lookup != null) {
                return lookup.hasLemma(term);
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<OldSpellingRuleWithSuggestion> get() {
        return this.spellingRules;
    }
}

