/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanTagger
extends BaseTagger {
    private static final Pattern IMPERATIVE_PATTERN = Pattern.compile("[iI](ch|hr)|[eE][rs]|[Ss]ie");
    private final ManualTagger removalTagger;
    private GermanCompoundTokenizer compoundTokenizer;

    public GermanTagger() {
        super("/de/german.dict");
        try (InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(this.getManualRemovalsFileName());){
            this.removalTagger = new ManualTagger(stream);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load manual tagger data from " + this.getManualAdditionsFileName(), e);
        }
    }

    private List<TaggedWord> addStem(List<TaggedWord> analyzedWordResults, String stem) {
        ArrayList<TaggedWord> result = new ArrayList<TaggedWord>();
        for (TaggedWord tw : analyzedWordResults) {
            String lemma = tw.getLemma();
            if (tw.getPosTag().matches("SUB.*") && stem.length() > 0 && stem.charAt(stem.length() - 1) != '-') {
                lemma = lemma.toLowerCase();
            }
            result.add(new TaggedWord(stem + lemma, tw.getPosTag()));
        }
        return result;
    }

    private String sanitizeWord(String word) {
        String result = word;
        if (!word.endsWith("-")) {
            String[] splitWord = word.split("-");
            String lastPart = splitWord.length > 1 && !splitWord[splitWord.length - 1].trim().equals("") ? splitWord[splitWord.length - 1] : word;
            List<String> compoundedWord = this.compoundTokenizer.tokenize(lastPart);
            List<TaggedWord> tagged = this.tag(lastPart = compoundedWord.size() > 1 ? StringTools.uppercaseFirstChar((String)compoundedWord.get(compoundedWord.size() - 1)) : compoundedWord.get(compoundedWord.size() - 1));
            if (tagged.size() > 0 && (tagged.get(0).getPosTag().matches("SUB.*|ADJ.*") || this.matchesUppercaseAdjective(lastPart))) {
                result = lastPart;
            }
        }
        return result;
    }

    public String getManualAdditionsFileName() {
        return "/de/added.txt";
    }

    public String getManualRemovalsFileName() {
        return "/de/removed.txt";
    }

    @Nullable
    public AnalyzedTokenReadings lookup(String word) throws IOException {
        List<AnalyzedTokenReadings> result = this.tag(Collections.singletonList(word), false);
        AnalyzedTokenReadings atr = result.get(0);
        if (atr.getAnalyzedToken(0).getPOSTag() == null) {
            return null;
        }
        return atr;
    }

    public List<TaggedWord> tag(String word) {
        return this.getWordTagger().tag(word);
    }

    private boolean matchesUppercaseAdjective(String unknownUppercaseToken) {
        List temp = this.getWordTagger().tag(StringTools.lowercaseFirstChar((String)unknownUppercaseToken));
        return temp.size() > 0 && ((TaggedWord)temp.get(0)).getPosTag().matches("ADJ.*");
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        return this.tag(sentenceTokens, true);
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens, boolean ignoreCase) throws IOException {
        this.initializeIfRequired();
        boolean firstWord = true;
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> readings = new ArrayList<AnalyzedToken>();
            List taggerTokens = this.getWordTagger().tag(word);
            if (firstWord && taggerTokens.isEmpty() && ignoreCase) {
                taggerTokens = this.getWordTagger().tag(word.toLowerCase());
                firstWord = word.matches("^\\W?$");
            } else if (pos == 0 && ignoreCase) {
                taggerTokens.addAll(this.getWordTagger().tag(word.toLowerCase()));
            }
            if (taggerTokens.size() > 0) {
                readings.addAll(this.getAnalyzedTokens(taggerTokens, word));
            } else if (!StringTools.isEmpty((String)word.trim())) {
                List<String> compoundParts = this.compoundTokenizer.tokenize(word);
                if (compoundParts.size() <= 1) {
                    List<AnalyzedToken> imperativeFormList = this.getImperativeForm(word, sentenceTokens, pos);
                    if (imperativeFormList != null && imperativeFormList.size() > 0) {
                        readings.addAll(imperativeFormList);
                    } else if (word.split(" ").length == 1 && !word.matches("[0-9].*")) {
                        String wordOrig = word;
                        word = this.sanitizeWord(word);
                        String wordStem = wordOrig.substring(0, wordOrig.length() - word.length());
                        List<String> compoundedWord = this.compoundTokenizer.tokenize(word);
                        word = compoundedWord.size() > 1 ? StringTools.uppercaseFirstChar((String)compoundedWord.get(compoundedWord.size() - 1)) : compoundedWord.get(compoundedWord.size() - 1);
                        List linkedTaggerTokens = this.addStem(this.getWordTagger().tag(word), wordStem);
                        if (wordOrig.contains("-") && linkedTaggerTokens.size() == 0 && this.matchesUppercaseAdjective(word)) {
                            word = StringTools.lowercaseFirstChar((String)word);
                            linkedTaggerTokens = this.getWordTagger().tag(word);
                        }
                        word = wordOrig;
                        boolean wordStartsUppercase = StringTools.startsWithUppercase((String)word);
                        if (linkedTaggerTokens.size() > 0) {
                            if (wordStartsUppercase) {
                                readings.addAll(this.getAnalyzedTokens(linkedTaggerTokens, word));
                            } else {
                                readings.addAll(this.getAnalyzedTokens(linkedTaggerTokens, word, compoundedWord));
                            }
                        } else {
                            readings.add(this.getNoInfoToken(word));
                        }
                    } else {
                        readings.add(this.getNoInfoToken(word));
                    }
                } else {
                    List partTaggerTokens;
                    String lastPart = compoundParts.get(compoundParts.size() - 1);
                    if (StringTools.startsWithUppercase((String)word)) {
                        lastPart = StringTools.uppercaseFirstChar((String)lastPart);
                    }
                    if ((partTaggerTokens = this.getWordTagger().tag(lastPart)).size() > 0) {
                        readings.addAll(this.getAnalyzedTokens(partTaggerTokens, word, compoundParts));
                    } else {
                        readings.add(this.getNoInfoToken(word));
                    }
                }
            } else {
                readings.add(this.getNoInfoToken(word));
            }
            tokenReadings.add(new AnalyzedTokenReadings(readings.toArray(new AnalyzedToken[readings.size()]), pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private List<AnalyzedToken> getImperativeForm(String word, List<String> sentenceTokens, int pos) {
        int idx = sentenceTokens.indexOf(word);
        String previousWord = "";
        while (--idx > -1 && (previousWord = sentenceTokens.get(idx)).matches("\\s+")) {
        }
        if (!(pos == 0 && sentenceTokens.size() > 1 || IMPERATIVE_PATTERN.matcher(previousWord).matches())) {
            return null;
        }
        String w = pos == 0 ? word.toLowerCase() : word;
        List taggedWithE = this.getWordTagger().tag(w + "e");
        for (TaggedWord tagged : taggedWithE) {
            if (!tagged.getPosTag().startsWith("VER:IMP:SIN:")) continue;
            if (this.removalTagger != null && this.removalTagger.tag(w).contains(tagged)) break;
            return this.getAnalyzedTokens(Arrays.asList(tagged), word);
        }
        return null;
    }

    private synchronized void initializeIfRequired() throws IOException {
        if (this.compoundTokenizer == null) {
            this.compoundTokenizer = new GermanCompoundTokenizer();
        }
    }

    private AnalyzedToken getNoInfoToken(String word) {
        return new AnalyzedToken(word, null, null);
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma()));
        }
        return result;
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word, List<String> compoundParts) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            List<String> allButLastPart = compoundParts.subList(0, compoundParts.size() - 1);
            StringBuilder lemma = new StringBuilder();
            int i = 0;
            for (String s : allButLastPart) {
                lemma.append(i == 0 ? s : StringTools.lowercaseFirstChar((String)s));
                ++i;
            }
            lemma.append(StringTools.lowercaseFirstChar((String)taggedWord.getLemma()));
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), lemma.toString()));
        }
        return result;
    }
}

