/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class GermanStyleRepeatedWordRule
extends TextLevelRule {
    private static final int MAX_TOKEN_TO_CHECK = 5;

    public GermanStyleRepeatedWordRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
    }

    public String getId() {
        return "GERMAN_STYLE_REPEATED_WORD_RULE";
    }

    public String getDescription() {
        return "Wiederholende Worte in aufeinanderfolgenden S\u00e4tzen";
    }

    private static boolean isTokenToCheck(AnalyzedTokenReadings token) {
        return token.matchesPosTagRegex("(SUB|EIG|VER|ADJ):.*") && !token.matchesPosTagRegex("ART:.*|ADV:.*|VER:(AUX|MOD):.*");
    }

    private static boolean isTokenPair(AnalyzedTokenReadings[] tokens, int n, boolean before) {
        return before ? tokens[n - 2].matchesPosTagRegex("SUB:.*") && tokens[n - 1].matchesPosTagRegex("PRP:.*") && tokens[n].matchesPosTagRegex("SUB:.*") : tokens[n].matchesPosTagRegex("SUB:.*") && tokens[n + 1].matchesPosTagRegex("PRP:.*") && tokens[n + 2].matchesPosTagRegex("SUB:.*");
    }

    private static boolean hasBreakToken(AnalyzedTokenReadings[] tokens) {
        for (int i = 0; i < tokens.length && i < 5; ++i) {
            if (!tokens[i].getToken().equals("-") && !tokens[i].getToken().equals("\u2014") && !tokens[i].getToken().equals("\u2013")) continue;
            return true;
        }
        return false;
    }

    private static boolean isTokenInSentence(AnalyzedTokenReadings testToken, AnalyzedTokenReadings[] tokens) {
        return GermanStyleRepeatedWordRule.isTokenInSentence(testToken, tokens, -1);
    }

    private static boolean isTokenInSentence(AnalyzedTokenReadings testToken, AnalyzedTokenReadings[] tokens, int notCheck) {
        if (testToken != null && tokens != null) {
            List readings = testToken.getReadings();
            if (readings.size() < 1) {
                return false;
            }
            String testBase = ((AnalyzedToken)readings.get(0)).getLemma();
            if (testBase == null) {
                return false;
            }
            for (int i = 0; i < tokens.length; ++i) {
                String base;
                if (i == notCheck || !GermanStyleRepeatedWordRule.isTokenToCheck(tokens[i]) || (readings = tokens[i].getReadings()).size() <= 0 || (base = ((AnalyzedToken)readings.get(0)).getLemma()) == null || !testBase.equals(base)) continue;
                if (notCheck >= 0) {
                    if (notCheck == i - 2) {
                        return !GermanStyleRepeatedWordRule.isTokenPair(tokens, i, true);
                    }
                    if (notCheck == i + 2) {
                        return !GermanStyleRepeatedWordRule.isTokenPair(tokens, i, false);
                    }
                    if ((notCheck == i + 1 || notCheck == i - 1) && testToken.getToken().equals(tokens[i].getToken())) {
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedTokenReadings[] tokens;
            AnalyzedSentence sentence = sentences.get(n);
            AnalyzedSentence lastSentence = null;
            AnalyzedSentence nextSentence = null;
            if (n > 0) {
                lastSentence = sentences.get(n - 1);
            }
            if (n < sentences.size() - 1) {
                nextSentence = sentences.get(n + 1);
            }
            if (!GermanStyleRepeatedWordRule.hasBreakToken(tokens = sentence.getTokensWithoutWhitespace())) {
                AnalyzedTokenReadings[] lastTokens = null;
                AnalyzedTokenReadings[] nextTokens = null;
                if (lastSentence != null) {
                    lastTokens = lastSentence.getTokensWithoutWhitespace();
                }
                if (nextSentence != null) {
                    nextTokens = nextSentence.getTokensWithoutWhitespace();
                }
                for (int i = 0; i < tokens.length; ++i) {
                    AnalyzedTokenReadings token = tokens[i];
                    if (!GermanStyleRepeatedWordRule.isTokenToCheck(token)) continue;
                    int isRepeated = 0;
                    if (GermanStyleRepeatedWordRule.isTokenInSentence(token, tokens, i)) {
                        isRepeated = 1;
                    }
                    if (isRepeated == 0 && lastTokens != null && GermanStyleRepeatedWordRule.isTokenInSentence(token, lastTokens)) {
                        isRepeated = 2;
                    }
                    if (isRepeated == 0 && nextTokens != null && GermanStyleRepeatedWordRule.isTokenInSentence(token, nextTokens)) {
                        isRepeated = 3;
                    }
                    if (isRepeated == 0) continue;
                    String msg = isRepeated == 1 ? "Stilproblem: Das Wort wird bereits im selben Satz verwendet!" : (isRepeated == 2 ? "Stilproblem: Das Wort wird bereits im vorhergehenden Satz verwendet!" : "Stilproblem: Das Wort wird bereits im nachfolgenden Satz verwendet!");
                    int startPos = pos + token.getStartPos();
                    int endPos = pos + token.getEndPos();
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, startPos, endPos, msg);
                    ruleMatches.add(ruleMatch);
                }
            }
            pos += sentence.getText().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

