/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class LongSentenceRule
extends org.languagetool.rules.LongSentenceRule {
    private static final int DEFAULT_MAX_WORDS = 40;
    private static final boolean DEFAULT_INACTIVE = true;

    public LongSentenceRule(ResourceBundle messages, int maxSentenceLength, boolean defaultActive) {
        super(messages);
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.addExamplePair(Example.wrong((String)"<marker>Dies ist ein Bandwurmsatz, der immer weiter geht, obwohl das kein guter Stil ist, den man eigentlich ber\u00fccksichtigen sollte, obwohl es auch andere Meinungen gibt, die aber in der Minderzahl sind, weil die meisten Autoren sich doch an die Stilvorgaben halten, wenn auch nicht alle, was aber letztendlich wiederum eine Sache des Geschmacks ist.</marker>"), Example.fixed((String)"<marker>Dies ist ein kurzer Satz.</marker>"));
        if (defaultActive) {
            this.setDefaultOn();
        }
        this.maxWords = maxSentenceLength;
    }

    public LongSentenceRule(ResourceBundle messages, int maxSentenceLength) {
        this(messages, maxSentenceLength, true);
    }

    public LongSentenceRule(ResourceBundle messages) {
        this(messages, 40, true);
        this.setDefaultOn();
    }

    public String getId() {
        int z1 = this.maxWords / 100;
        int z2 = (this.maxWords - z1 * 100) / 10;
        int z3 = this.maxWords - z1 * 100 - z2 * 10;
        char c1 = (char)(65 + z1);
        char c2 = (char)(65 + z2);
        char c3 = (char)(65 + z3);
        return "DE_TOO_LONG_SENTENCE_" + c1 + c2 + c3;
    }

    public String getDescription() {
        return "Sehr langer Satz (mehr als " + this.maxWords + " Worte)";
    }

    public String getMessage() {
        return "Dieser Satz ist sehr lang (mehr als " + this.maxWords + " Worte).";
    }
}

