/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.CaseRuleExceptions;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class CaseRule
extends GermanRule {
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|[0-9]+|(m{0,4}(cm|cd|d?c{0,3})(xc|xl|l?x{0,3})(ix|iv|v?i{0,3}))$");
    private static final Set<String> nounIndicators = new HashSet<String>();
    private static final String UPPERCASE_MESSAGE = "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben";
    private static final String LOWERCASE_MESSAGE = "Falls es sich um ein substantiviertes Verb handelt, wird es gro\u00dfgeschrieben.";
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(CaseRule.regex("Vereinigte[ns]?"), CaseRule.regex("Staaten|K\u00f6nigreiche?s?")), Arrays.asList(CaseRule.token("Den"), CaseRule.token("Haag")), Arrays.asList(CaseRule.token("Neues"), CaseRule.token("\\?")), Arrays.asList(CaseRule.token("Hin"), CaseRule.token("und"), CaseRule.token("Her")), Arrays.asList(CaseRule.token("Bares"), CaseRule.token("ist"), CaseRule.token("Wahres")), Arrays.asList(CaseRule.token("Auf"), CaseRule.token("und"), CaseRule.token("Ab")), Arrays.asList(CaseRule.token("Lug"), CaseRule.token("und"), CaseRule.token("Trug")), Arrays.asList(CaseRule.token("Zahl"), CaseRule.pos("UNKNOWN")), Arrays.asList(CaseRule.token(","), CaseRule.posRegex(".*ADJ.*|UNKNOWN"), CaseRule.regex("[\\.?!]")), Arrays.asList(CaseRule.token(","), CaseRule.regex("[md]eine?|du"), CaseRule.posRegex(".*ADJ.*|UNKNOWN"), CaseRule.regex("[\\.?!]")), Arrays.asList(CaseRule.posRegex(".*ADJ.*|UNKNOWN"), CaseRule.regex("Konstanten?")), Arrays.asList(CaseRule.token("das"), CaseRule.posRegex("PA2:.*"), CaseRule.posRegex("VER:AUX:.*")), Arrays.asList(CaseRule.posRegex("PRO:PER:.*|EIG:.*"), CaseRule.token("das"), CaseRule.posRegex("PA2:.*"), CaseRule.posRegex("VER:AUX:.*")), Arrays.asList(CaseRule.token("das"), CaseRule.posRegex("VER:.*"), CaseRule.posRegex("VER:AUX:.*"), CaseRule.pos("PKT")), Arrays.asList(CaseRule.token("Treu"), CaseRule.token("und"), CaseRule.token("Glauben")), Arrays.asList(CaseRule.token("Speis"), CaseRule.token("und"), CaseRule.token("Trank")), Arrays.asList(CaseRule.token("Sang"), CaseRule.token("und"), CaseRule.token("Klang")), Arrays.asList(CaseRule.regex("US-amerikanisch(e|er|es|en|em)?")), Arrays.asList(CaseRule.pos("VER:INF:NON"), CaseRule.pos("VER:MOD:2:PLU:PR\u00c4")), Arrays.asList(CaseRule.pos("UNKNOWN"), CaseRule.token("und"), CaseRule.posRegex("SUB:.*")), Arrays.asList(CaseRule.posRegex("VER:INF.*"), CaseRule.posRegex("VER:MOD:.*")), Arrays.asList(CaseRule.posRegex("VER:INF.*"), CaseRule.posRegex("VER:AUX:.:(SIN|PLU)(:KJ2)?")));
    private static final Set<String> sentenceStartExceptions;
    private static final Set<String> UNDEFINED_QUANTIFIERS;
    private static final Set<String> INTERROGATIVE_PARTICLES;
    private static final Set<String> POSSESSIVE_INDICATORS;
    private static final Set<String> exceptions;
    private static final Set<String> languages;
    private static final Set<String> myExceptionPhrases;
    private static final Set<String> substVerbenExceptions;
    private final GermanTagger tagger;
    private final German german;

    private static PatternToken token(String token) {
        return new PatternTokenBuilder().tokenRegex(token).build();
    }

    private static PatternToken regex(String regex) {
        return new PatternTokenBuilder().tokenRegex(regex).build();
    }

    private static PatternToken pos(String posTag) {
        return new PatternTokenBuilder().pos(posTag).build();
    }

    private static PatternToken posRegex(String posTag) {
        return new PatternTokenBuilder().posRegex(posTag).build();
    }

    public CaseRule(ResourceBundle messages, German german) {
        this.german = german;
        super.setCategory(Categories.CASING.getCategory(messages));
        this.tagger = (GermanTagger)german.getTagger();
        this.addExamplePair(Example.wrong((String)"<marker>Das laufen</marker> f\u00e4llt mir schwer."), Example.fixed((String)"<marker>Das Laufen</marker> f\u00e4llt mir schwer."));
    }

    public String getId() {
        return "DE_CASE";
    }

    public URL getUrl() {
        try {
            return new URL("http://www.canoo.net/services/GermanSpelling/Regeln/Gross-klein/index.html");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDescription() {
        return "Gro\u00dfschreibung von Nomen und substantivierten Verben";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        boolean prevTokenIsDas = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean isBaseform;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if (posToken != null && posToken.equals("SENT_START")) continue;
            if (i == 1) {
                if (!nounIndicators.contains(tokens[1].getToken().toLowerCase())) continue;
                prevTokenIsDas = true;
                continue;
            }
            if (i > 0 && this.isSalutation(tokens[i - 1].getToken())) continue;
            AnalyzedTokenReadings analyzedToken = tokens[i];
            String token = analyzedToken.getToken();
            this.markLowerCaseNounErrors(ruleMatches, tokens, i, analyzedToken);
            boolean bl = isBaseform = analyzedToken.getReadingsLength() >= 1 && analyzedToken.hasLemma(token);
            if ((analyzedToken.getAnalyzedToken(0).getPOSTag() == null || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.VERB)) && isBaseform) {
                boolean nextTokenIsPersonalOrReflexivePronoun = false;
                if (i < tokens.length - 1) {
                    AnalyzedTokenReadings nextToken = tokens[i + 1];
                    boolean bl2 = nextTokenIsPersonalOrReflexivePronoun = nextToken.hasPartialPosTag("PRO:PER") || nextToken.getToken().equals("sich") || nextToken.getToken().equals("Sie");
                    if (nextToken.isSentenceEnd() || nextToken.getToken().equals(",") || prevTokenIsDas && (nextToken.getToken().equals("nur") || nextToken.getToken().equals("sogar") || nextToken.getToken().equals("auch") || nextToken.getToken().equals("die") || nextToken.getToken().equals("alle") || nextToken.getToken().equals("viele") || nextToken.getToken().equals("zu")) || prevTokenIsDas && this.isFollowedByRelativeOrSubordinateClause(i, tokens)) continue;
                }
                if (this.isPrevProbablyRelativePronoun(tokens, i) || prevTokenIsDas && this.getTokensWithPartialPosTag(tokens, "VER").length == 1) continue;
                this.potentiallyAddLowercaseMatch(ruleMatches, tokens[i], prevTokenIsDas, token, nextTokenIsPersonalOrReflexivePronoun);
            }
            prevTokenIsDas = nounIndicators.contains(tokens[i].getToken().toLowerCase());
            if (this.hasNounReading(analyzedToken)) {
                boolean isPotentialError;
                boolean bl3 = isPotentialError = i > 1 && i < tokens.length - 3 && tokens[i + 1].getToken().equals(",") && INTERROGATIVE_PARTICLES.contains(tokens[i + 2].getToken()) && tokens[i - 1].hasPartialPosTag("VER:MOD:") && !tokens[i - 1].hasLemma("m\u00f6gen") && !tokens[i + 3].getToken().equals("zum");
                if (!isPotentialError) {
                    continue;
                }
            } else if (analyzedToken.hasPartialPosTag("SUB:") && i < tokens.length - 1 && Character.isLowerCase(tokens[i + 1].getToken().charAt(0)) && tokens[i + 1].matchesPosTagRegex("VER:[123]:.*")) continue;
            AnalyzedTokenReadings lowercaseReadings = this.tagger.lookup(token.toLowerCase());
            if (analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings == null || analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings != null && (lowercaseReadings.getAnalyzedToken(0).getPOSTag() == null || analyzedToken.getToken().endsWith("innen"))) continue;
            this.potentiallyAddUppercaseMatch(ruleMatches, tokens, i, analyzedToken, token, lowercaseReadings);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private AnalyzedTokenReadings[] getTokensWithPartialPosTag(AnalyzedTokenReadings[] tokens, String partialPosTag) {
        return (AnalyzedTokenReadings[])Arrays.stream(tokens).filter(token -> token.hasPartialPosTag(partialPosTag)).toArray(AnalyzedTokenReadings[]::new);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.german);
    }

    private void markLowerCaseNounErrors(List<RuleMatch> ruleMatches, AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings analyzedToken) throws IOException {
    }

    private boolean isPrevProbablyRelativePronoun(AnalyzedTokenReadings[] tokens, int i) {
        if (i >= 3) {
            AnalyzedTokenReadings prev1 = tokens[i - 1];
            AnalyzedTokenReadings prev2 = tokens[i - 2];
            AnalyzedTokenReadings prev3 = tokens[i - 3];
            if (prev1.getToken().equals("das") && prev2.getToken().equals(",") && prev3.matchesPosTagRegex("SUB:...:SIN:NEU")) {
                return true;
            }
        }
        return false;
    }

    private boolean isSalutation(String token) {
        return token.equals("Herr") || token.equals("Herrn") || token.equals("Frau");
    }

    private boolean hasNounReading(AnalyzedTokenReadings readings) {
        try {
            AnalyzedTokenReadings allReadings = this.tagger.lookup(readings.getToken());
            if (allReadings != null) {
                for (AnalyzedToken reading : allReadings) {
                    String posTag = reading.getPOSTag();
                    if (posTag == null || !posTag.contains("SUB:") || posTag.contains(":ADJ")) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not lookup " + readings.getToken(), e);
        }
        return false;
    }

    private void potentiallyAddLowercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings tokenReadings, boolean prevTokenIsDas, String token, boolean nextTokenIsPersonalOrReflexivePronoun) {
        if (prevTokenIsDas && !nextTokenIsPersonalOrReflexivePronoun && Character.isLowerCase(token.charAt(0)) && !substVerbenExceptions.contains(token) && tokenReadings.hasPartialPosTag("VER:INF") && !tokenReadings.isIgnoredBySpeller() && !tokenReadings.isImmunized()) {
            String fixedWord = StringTools.uppercaseFirstChar((String)tokenReadings.getToken());
            this.addRuleMatch(ruleMatches, LOWERCASE_MESSAGE, tokenReadings, fixedWord);
        }
    }

    private void potentiallyAddUppercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings analyzedToken, String token, AnalyzedTokenReadings lowercaseReadings) {
        if (!(!Character.isUpperCase(token.charAt(0)) || token.length() <= 1 || tokens[i].isIgnoredBySpeller() || tokens[i].isImmunized() || sentenceStartExceptions.contains(tokens[i - 1].getToken()) || exceptions.contains(token) || StringTools.isAllUppercase((String)token) || this.isLanguage(i, tokens, token) || this.isProbablyCity(i, tokens, token) || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PROPER_NOUN) || analyzedToken.isSentenceEnd() || this.isEllipsis(i, tokens) || this.isNumbering(i, tokens) || this.isNominalization(i, tokens, token, lowercaseReadings) || this.isAdverbAndNominalization(i, tokens) || this.isSpecialCase(i, tokens) || this.isAdjectiveAsNoun(i, tokens, lowercaseReadings) || this.isExceptionPhrase(i, tokens))) {
            String fixedWord = StringTools.lowercaseFirstChar((String)tokens[i].getToken());
            this.addRuleMatch(ruleMatches, UPPERCASE_MESSAGE, tokens[i], fixedWord);
        }
    }

    private void addRuleMatch(List<RuleMatch> ruleMatches, String msg, AnalyzedTokenReadings tokenReadings, String fixedWord) {
        RuleMatch ruleMatch = new RuleMatch((Rule)this, tokenReadings.getStartPos(), tokenReadings.getEndPos(), msg);
        ruleMatch.setSuggestedReplacement(fixedWord);
        ruleMatches.add(ruleMatch);
    }

    private boolean isNumbering(int i, AnalyzedTokenReadings[] tokens) {
        return !(i < 2 || !tokens[i - 1].getToken().equals(")") && !tokens[i - 1].getToken().equals("]") || !NUMERALS_EN.matcher(tokens[i - 2].getToken()).matches() || i > 3 && tokens[i - 3].getToken().equals("(") && tokens[i - 4].hasPartialPosTag("SUB:"));
    }

    private boolean isEllipsis(int i, AnalyzedTokenReadings[] tokens) {
        return (tokens[i - 1].getToken().equals("]") || tokens[i - 1].getToken().equals(")")) && (i == 4 && tokens[i - 2].getToken().equals("\u2026") || i == 6 && tokens[i - 2].getToken().equals("."));
    }

    private boolean isNominalization(int i, AnalyzedTokenReadings[] tokens, String token, AnalyzedTokenReadings lowercaseReadings) {
        AnalyzedTokenReadings nextReadings;
        AnalyzedTokenReadings analyzedTokenReadings = nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        if (StringTools.startsWithUppercase((String)token) && !this.isNumber(token) && !this.hasNounReading(nextReadings) && !token.matches("Alle[nm]")) {
            String prevTokenStr;
            if (lowercaseReadings != null && lowercaseReadings.hasPosTag("PRP:LOK+TMP+CAU:DAT+AKK")) {
                return false;
            }
            AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
            AnalyzedTokenReadings prevPrevToken = i >= 2 ? tokens[i - 2] : null;
            AnalyzedTokenReadings prevPrevPrevToken = i >= 3 ? tokens[i - 3] : null;
            String string = prevTokenStr = prevToken != null ? prevToken.getToken() : "";
            if (prevToken != null && ("und".equals(prevTokenStr) || "oder".equals(prevTokenStr) || "beziehungsweise".equals(prevTokenStr)) && prevPrevToken != null) {
                if (tokens[i].hasPartialPosTag("SUB") && tokens[i].hasPartialPosTag(":ADJ")) {
                    return true;
                }
                if (prevPrevToken.hasPartialPosTag("SUB") && !this.hasNounReading(nextReadings) && lowercaseReadings != null && lowercaseReadings.hasPartialPosTag("ADJ")) {
                    return true;
                }
            }
            return prevToken != null && ("irgendwas".equals(prevTokenStr) || "aufs".equals(prevTokenStr) || "als".equals(prevTokenStr) || this.isNumber(prevTokenStr)) || this.hasPartialTag(prevToken, "ART", "PRO:") && (prevToken.getReadings().size() != 1 || !prevToken.hasPartialPosTag("PRO:PER:NOM:")) && !prevToken.hasPartialPosTag(":STD") || this.hasPartialTag(prevPrevPrevToken, "ART") && this.hasPartialTag(prevPrevToken, "PRP") && this.hasPartialTag(prevToken, "SUB") || this.hasPartialTag(prevPrevToken, "PRO:", "PRP") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2", "PA1") || this.hasPartialTag(prevPrevPrevToken, "PRO:", "PRP") && this.hasPartialTag(prevPrevToken, "ADJ", "ADV") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2");
        }
        return false;
    }

    private boolean isNumber(String token) {
        try {
            if (token.matches("\\d+")) {
                return true;
            }
            AnalyzedTokenReadings lookup = this.tagger.lookup(StringTools.lowercaseFirstChar((String)token));
            return lookup != null && lookup.hasPosTag("ZAL");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAdverbAndNominalization(int i, AnalyzedTokenReadings[] tokens) {
        String prevPrevToken = i > 1 ? tokens[i - 2].getToken() : "";
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "das".equalsIgnoreCase(prevPrevToken) && this.hasPartialTag(prevToken, "ADV") && StringTools.startsWithUppercase((String)token) && !this.hasNounReading(nextReadings);
    }

    private boolean hasPartialTag(AnalyzedTokenReadings token, String ... posTags) {
        if (token != null) {
            for (String posTag : posTags) {
                if (!token.hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpecialCase(int i, AnalyzedTokenReadings[] tokens) {
        String prevToken = i > 1 ? tokens[i - 1].getToken() : "";
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "im".equalsIgnoreCase(prevToken) && "Allgemeinen".equals(token) && !this.hasNounReading(nextReadings);
    }

    private boolean isAdjectiveAsNoun(int i, AnalyzedTokenReadings[] tokens, AnalyzedTokenReadings lowercaseReadings) {
        boolean isPrevDeterminer;
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        AnalyzedTokenReadings prevLowercaseReadings = null;
        if (i > 1 && sentenceStartExceptions.contains(tokens[i - 2].getToken())) {
            try {
                prevLowercaseReadings = this.tagger.lookup(prevToken.getToken().toLowerCase());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        boolean isPossiblyFollowedByInfinitive = nextReadings != null && nextReadings.getToken().equals("zu");
        boolean isFollowedByInfinitive = nextReadings != null && !isPossiblyFollowedByInfinitive && nextReadings.hasPartialPosTag("EIZ");
        boolean isFollowedByPossessiveIndicator = nextReadings != null && POSSESSIVE_INDICATORS.contains(nextReadings.getToken());
        boolean isUndefQuantifier = prevToken != null && UNDEFINED_QUANTIFIERS.contains(prevToken.getToken().toLowerCase());
        boolean bl = isPrevDeterminer = prevToken != null && (this.hasPartialTag(prevToken, "ART", "PRP", "ZAL") || this.hasPartialTag(prevLowercaseReadings, "ART", "PRP", "ZAL")) && !prevToken.hasPartialPosTag(":STD");
        if (!(isPrevDeterminer || isUndefQuantifier || isPossiblyFollowedByInfinitive || isFollowedByInfinitive || isFollowedByPossessiveIndicator && this.hasPartialTag(lowercaseReadings, "ADJ", "VER") || prevToken != null && prevToken.hasPosTag("KON:UNT") && nextReadings != null && !this.hasNounReading(nextReadings) && !nextReadings.hasPosTag("KON:NEB"))) {
            AnalyzedTokenReadings prevPrevToken;
            AnalyzedTokenReadings analyzedTokenReadings = prevPrevToken = i > 1 && prevToken.hasPartialPosTag("ADJ") ? tokens[i - 2] : null;
            if (!this.hasPartialTag(prevPrevToken, "ART", "PRP", "ZAL")) {
                return false;
            }
        }
        for (AnalyzedToken reading : tokens[i].getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag != null && !posTag.contains("ADJ") || this.hasNounReading(nextReadings)) continue;
            return true;
        }
        return false;
    }

    private boolean isLanguage(int i, AnalyzedTokenReadings[] tokens, String token) {
        boolean maybeLanguage = languages.contains(token) || languages.contains(StringUtils.removeEnd((String)token, (String)"e")) || languages.contains(StringUtils.removeEnd((String)token, (String)"en"));
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return maybeLanguage && (nextReadings != null && !this.hasNounReading(nextReadings) || prevToken != null && prevToken.getToken().equals("auf"));
    }

    private boolean isProbablyCity(int i, AnalyzedTokenReadings[] tokens, String token) {
        boolean hasCityPrefix;
        boolean bl = hasCityPrefix = "Klein".equals(token) || "Gro\u00df".equals(token) || "Neu".equals(token);
        if (hasCityPrefix) {
            AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
            return nextReadings != null && (!nextReadings.isTagged() || nextReadings.hasPartialPosTag("EIG"));
        }
        return false;
    }

    private boolean isFollowedByRelativeOrSubordinateClause(int i, AnalyzedTokenReadings[] tokens) {
        if (i < tokens.length - 2) {
            return ",".equals(tokens[i + 1].getToken()) && (INTERROGATIVE_PARTICLES.contains(tokens[i + 2].getToken()) || tokens[i + 2].hasPartialPosTag("KON:UNT"));
        }
        return false;
    }

    private boolean isExceptionPhrase(int i, AnalyzedTokenReadings[] tokens) {
        for (String phrase : myExceptionPhrases) {
            String[] parts = phrase.split(" ");
            for (int j = 0; j < parts.length; ++j) {
                int startIndex;
                if (!tokens[i].getToken().matches(parts[j]) || !this.compareLists(tokens, startIndex = i - j, startIndex + parts.length - 1, parts)) continue;
                return true;
            }
        }
        return false;
    }

    boolean compareLists(AnalyzedTokenReadings[] tokens, int startIndex, int endIndex, String[] parts) {
        if (startIndex < 0) {
            return false;
        }
        int i = 0;
        for (int j = startIndex; j <= endIndex; ++j) {
            if (i >= parts.length || j >= tokens.length) {
                return false;
            }
            if (!tokens[j].getToken().matches(parts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void reset() {
    }

    static {
        nounIndicators.add("das");
        nounIndicators.add("sein");
        nounIndicators.add("mein");
        nounIndicators.add("dein");
        nounIndicators.add("euer");
        nounIndicators.add("unser");
        sentenceStartExceptions = new HashSet<String>();
        sentenceStartExceptions.add("(");
        sentenceStartExceptions.add(":");
        sentenceStartExceptions.add("\"");
        sentenceStartExceptions.add("'");
        sentenceStartExceptions.add("\u201e");
        sentenceStartExceptions.add("\u201c");
        sentenceStartExceptions.add("\u00ab");
        sentenceStartExceptions.add("\u00bb");
        sentenceStartExceptions.add(".");
        UNDEFINED_QUANTIFIERS = new HashSet<String>(Arrays.asList("viel", "nichts", "wenig", "zuviel"));
        INTERROGATIVE_PARTICLES = new HashSet<String>(Arrays.asList("was", "wodurch", "wof\u00fcr", "womit", "woran", "worauf", "woraus", "wovon", "wie"));
        POSSESSIVE_INDICATORS = new HashSet<String>(Arrays.asList("einer", "eines", "der", "des", "dieser", "dieses"));
        exceptions = new HashSet<String>(Arrays.asList("Auszubildende", "Auszubildender", "Gelehrte", "Gelehrter", "Vorstehende", "Vorstehender", "Mitwirkende", "Mitwirkender", "Mitwirkenden", "Selbstst\u00e4ndige", "Selbstst\u00e4ndiger", "Genaueres", "\u00c4u\u00dfersten", "Dienstreisender", "Verletzte", "Vermisste", "\u00c4u\u00dferes", "Abseits", "Besch\u00e4ftigter", "Besch\u00e4ftigte", "Besch\u00e4ftigten", "\u00dcblichen", "Bekannter", "Bekannte", "Tel", "Unschuldiger", "Vorgesetzter", "Abs", "Klappe", "Vorfahre", "Mittler", "Hr", "Schwarz", "Genese", "Rosa", "Auftrieb", "Zuschnitt", "Geschossen", "Vortrieb", "Abtrieb", "Gesandter", "Durchfahrt", "Durchgriff", "\u00dcberfahrt", "Zeche", "Sparte", "Sparten", "Heiliger", "Reisender", "Pest", "Schwinge", "Verlies", "Nachfolge", "Stift", "Belange", "Geistlicher", "Google", "Jenseits", "Abends", "Abgeordneter", "Abgeordnete", "Abgeordneten", "Angestellter", "Angestellte", "Angestellten", "Bankangestellter", "Bankangestellte", "Bankangestellten", "Liberaler", "Abriss", "Ahne", "\u00c4hnlichem", "\u00c4hnliches", "Allerlei", "Anklang", "Verlobter", "Anstrich", "Armes", "Aus", "Ausdr\u00fccke", "Ausw\u00fcchsen", "B\u00e4nde", "B\u00e4nden", "Beauftragter", "Belange", "besonderes", "Biss", "De", "Dr", "Durcheinander", "Eindr\u00fccke", "Erwachsener", "Familienangeh\u00f6rige", "Fl\u00f6\u00dfe", "Folgendes", "Fort", "Fra\u00df", "F\u00fcr", "Gen\u00fcge", "Gl\u00e4ubiger", "Goldener", "Guten", "Hechte", "Herz\u00f6ge", "Herz\u00f6gen", "Hinfahrt", "Hundert", "Ihnen", "Ihr", "Ihre", "Ihrem", "Ihren", "Ihrer", "Ihres", "Infrarot", "Jenseits", "Jugendlicher", "J\u00fcnger", "Klaue", "Konditional", "Kr\u00e4he", "Kurzem", "Landwirtschaft", "Langem", "L\u00e4ngerem", "Le", "Letzt", "Letzt", "Letztere", "Letzterer", "Letzteres", "Link", "Links", "L\u00f6hne", "Luden", "Mitfahrt", "Mr", "Mrd", "Mrs", "Nachfrage", "Nachts", "N\u00e4hte", "N\u00e4hten", "Neuem", "Nr", "Nutze", "Obdachloser", "Oder", "Ohrfeige", "Patsche", "Pfiffe", "Pfiffen", "Prof", "Puste", "Sachverst\u00e4ndiger", "Sankt", "Schaulustige", "Scheine", "Schei\u00dfe", "Schuft", "Schufte", "Schuld", "Schw\u00e4rme", "Schwarzes", "Sie", "Spitz", "St", "Stereotyp", "St\u00f6re", "Tausend", "Toter", "tun", "\u00dcbrigen", "Unvorhergesehenes", "Verantwortlicher", "Verlass", "Verwandter", "Vielfaches", "Vorsitzender", "Fraktionsvorsitzender", "Weitem", "Weiteres", "Wicht", "Wichtiges", "Wider", "Wild", "Zeche", "Zusage", "Zwinge", "Terti\u00e4r", "Erster", "Zweiter", "Dritter", "Vierter", "F\u00fcnfter", "Sechster", "Siebter", "Achter", "Neunter", "Erste", "Zweite", "Dritte", "Vierte", "F\u00fcnfte", "Sechste", "Siebte", "Achte", "Neunte", "Dein", "Deine", "Deinem", "Deinen", "Deiner", "Deines", "Dich", "Dir", "Du", "Euch", "Euer", "Eure", "Eurem", "Euren", "Eures"));
        languages = new HashSet<String>();
        languages.add("Angels\u00e4chsisch");
        languages.add("Afrikanisch");
        languages.add("Albanisch");
        languages.add("Altarabisch");
        languages.add("Altchinesisch");
        languages.add("Altgriechisch");
        languages.add("Althochdeutsch");
        languages.add("Altpersisch");
        languages.add("Amerikanisch");
        languages.add("Arabisch");
        languages.add("Armenisch");
        languages.add("Bairisch");
        languages.add("Baskisch");
        languages.add("Bengalisch");
        languages.add("Bulgarisch");
        languages.add("Chinesisch");
        languages.add("D\u00e4nisch");
        languages.add("Deutsch");
        languages.add("Englisch");
        languages.add("Estnisch");
        languages.add("Finnisch");
        languages.add("Franz\u00f6sisch");
        languages.add("Fr\u00fchneuhochdeutsch");
        languages.add("Germanisch");
        languages.add("Georgisch");
        languages.add("Griechisch");
        languages.add("Hebr\u00e4isch");
        languages.add("Hocharabisch");
        languages.add("Hochchinesisch");
        languages.add("Hochdeutsch");
        languages.add("Holl\u00e4ndisch");
        languages.add("Indonesisch");
        languages.add("Isl\u00e4ndisch");
        languages.add("Italienisch");
        languages.add("Japanisch");
        languages.add("Jiddisch");
        languages.add("Jugoslawisch");
        languages.add("Kantonesisch");
        languages.add("Katalanisch");
        languages.add("Koreanisch");
        languages.add("Kroatisch");
        languages.add("Lateinisch");
        languages.add("Lettisch");
        languages.add("Litauisch");
        languages.add("Luxemburgisch");
        languages.add("Mittelhochdeutsch");
        languages.add("Mongolisch");
        languages.add("Neuhochdeutsch");
        languages.add("Niederl\u00e4ndisch");
        languages.add("Norwegisch");
        languages.add("Persisch");
        languages.add("Plattdeutsch");
        languages.add("Polnisch");
        languages.add("Portugiesisch");
        languages.add("R\u00e4toromanisch");
        languages.add("Rum\u00e4nisch");
        languages.add("Russisch");
        languages.add("S\u00e4chsisch");
        languages.add("Schw\u00e4bisch");
        languages.add("Schwedisch");
        languages.add("Schweizerisch");
        languages.add("Serbisch");
        languages.add("Serbokroatisch");
        languages.add("Slawisch");
        languages.add("Slowakisch");
        languages.add("Slowenisch");
        languages.add("Spanisch");
        languages.add("Tamilisch");
        languages.add("Tibetisch");
        languages.add("Tschechisch");
        languages.add("Tschetschenisch");
        languages.add("T\u00fcrkisch");
        languages.add("Turkmenisch");
        languages.add("Uigurisch");
        languages.add("Ukrainisch");
        languages.add("Ungarisch");
        languages.add("Usbekisch");
        languages.add("Vietnamesisch");
        languages.add("Walisisch");
        languages.add("Wei\u00dfrussisch");
        myExceptionPhrases = CaseRuleExceptions.getExceptions();
        substVerbenExceptions = new HashSet<String>();
        substVerbenExceptions.add("hinziehen");
        substVerbenExceptions.add("helfen");
        substVerbenExceptions.add("lassen");
        substVerbenExceptions.add("passieren");
        substVerbenExceptions.add("machen");
        substVerbenExceptions.add("haben");
        substVerbenExceptions.add("passiert");
        substVerbenExceptions.add("beschr\u00e4nkt");
        substVerbenExceptions.add("wiederholt");
        substVerbenExceptions.add("scheinen");
        substVerbenExceptions.add("klar");
        substVerbenExceptions.add("hei\u00dfen");
        substVerbenExceptions.add("einen");
        substVerbenExceptions.add("geh\u00f6ren");
        substVerbenExceptions.add("bedeutet");
        substVerbenExceptions.add("erm\u00f6glicht");
        substVerbenExceptions.add("funktioniert");
        substVerbenExceptions.add("sollen");
        substVerbenExceptions.add("werden");
        substVerbenExceptions.add("d\u00fcrfen");
        substVerbenExceptions.add("m\u00fcssen");
        substVerbenExceptions.add("so");
        substVerbenExceptions.add("ist");
        substVerbenExceptions.add("k\u00f6nnen");
        substVerbenExceptions.add("mein");
        substVerbenExceptions.add("sein");
        substVerbenExceptions.add("muss");
        substVerbenExceptions.add("mu\u00df");
        substVerbenExceptions.add("wollen");
        substVerbenExceptions.add("habe");
        substVerbenExceptions.add("ein");
        substVerbenExceptions.add("tun");
        substVerbenExceptions.add("best\u00e4tigt");
        substVerbenExceptions.add("best\u00e4tigte");
        substVerbenExceptions.add("best\u00e4tigten");
        substVerbenExceptions.add("bekommen");
        substVerbenExceptions.add("sauer");
        substVerbenExceptions.add("bedeuten");
    }
}

