/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenBuilder;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;
import org.languagetool.tools.StringTools;

public class VerbAgreementRule
extends GermanRule {
    private static final List<List<PatternToken>> ANTI_PATTERNS = Arrays.asList(Arrays.asList(new PatternTokenBuilder().tokenRegex("die|welche").build(), new PatternTokenBuilder().tokenRegex(".*").build(), new PatternTokenBuilder().tokenRegex("mehr|weniger").build(), new PatternTokenBuilder().token("als").build(), new PatternTokenBuilder().tokenRegex("ich|du|er|sie|es").build()), Arrays.asList(new PatternTokenBuilder().token("wenn").build(), new PatternTokenBuilder().token("du").build(), new PatternTokenBuilder().token("anstelle").build()), Arrays.asList(new PatternTokenBuilder().token("das").build(), new PatternTokenBuilder().token("Du").build(), new PatternTokenBuilder().tokenRegex("anbieten|anbot").build()), Arrays.asList(new PatternTokenBuilder().token(",").build(), new PatternTokenBuilder().posRegex("VER:MOD:2:.*").build()), Arrays.asList(new PatternTokenBuilder().csToken("Soll").build(), new PatternTokenBuilder().token("ich").build()), Arrays.asList(new PatternTokenBuilder().pos("SENT_START").build(), new PatternTokenBuilder().csToken("Bin").build()), Arrays.asList(new PatternTokenBuilder().token(",").build(), new PatternTokenBuilder().tokenRegex("bin|hast").build()), Arrays.asList(new PatternTokenBuilder().token("er").build(), new PatternTokenBuilder().posRegex("VER:.*").build(), new PatternTokenBuilder().token("wird").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("wie|als").build(), new PatternTokenBuilder().token("ich").build()), Arrays.asList(new PatternTokenBuilder().tokenRegex("ich").build(), new PatternTokenBuilder().pos("VER:INF:NON").build(), new PatternTokenBuilder().token("werde").build()), Arrays.asList(new PatternTokenBuilder().pos("VER:IMP:SIN:SFT").build(), new PatternTokenBuilder().token("du").build(), new PatternTokenBuilder().token("dich").build()), Arrays.asList(new PatternTokenBuilder().token("sei").build(), new PatternTokenBuilder().token("du").build(), new PatternTokenBuilder().token("selbst").build()), Arrays.asList(new PatternTokenBuilder().token("als").build(), new PatternTokenBuilder().token("ich").build(), new PatternTokenBuilder().posRegex("PA2:.*").build(), new PatternTokenBuilder().token("bin").build()));
    private static final Set<String> BIN_IGNORE = new HashSet<String>(Arrays.asList("Suleiman", "Mohamed", "Muhammad", "Muhammed", "Mohammed", "Mohammad", "Mansour", "Qaboos", "Qabus", "Tamim", "Majid", "Salman", "Ghazi", "Mahathir", "Madschid", "Maktum", "al-Aziz", "Asis", "Numan", "Hussein", "Abdul", "Abdulla", "Abdullah", "Isa", "Osama", "Said", "Zayid", "Zayed", "Hamad", "Chalifa", "Raschid", "Turki", "/"));
    private static final Set<String> QUOTATION_MARKS = new HashSet<String>(Arrays.asList("\"", "\u201e"));
    private final German language;
    private AnalyzedTokenReadings finiteVerb;

    public VerbAgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        super.setCategory(Categories.GRAMMAR.getCategory(messages));
        this.addExamplePair(Example.wrong((String)"Ich <marker>bist</marker> \u00fcber die Entwicklung sehr froh."), Example.fixed((String)"Ich <marker>bin</marker> \u00fcber die Entwicklung sehr froh."));
    }

    public String getId() {
        return "DE_VERBAGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (nur 1. u. 2. Pers. od. m. Personalpronomen), z.B. 'Er bist (ist)'";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        int plus1;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (tokens.length < 4) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int posIch = -1;
        int posDu = -1;
        int posEr = -1;
        int posWir = -1;
        int posVer1Sin = -1;
        int posVer2Sin = -1;
        int posVer1Plu = -1;
        int posPossibleVer1Sin = -1;
        int posPossibleVer2Sin = -1;
        int posPossibleVer3Sin = -1;
        int posPossibleVer1Plu = -1;
        for (int i = 1; i < tokens.length; ++i) {
            if (tokens[i].isImmunized()) continue;
            String strToken = tokens[i].getToken().toLowerCase();
            switch (strToken = strToken.replace("\u201a", "")) {
                case "ich": {
                    posIch = i;
                    break;
                }
                case "du": {
                    posDu = i;
                    break;
                }
                case "er": {
                    posEr = i;
                    break;
                }
                case "wir": {
                    posWir = i;
                }
            }
            if (!tokens[i].hasPartialPosTag("VER") || !Character.isLowerCase(tokens[i].getToken().charAt(0)) && i != 1) continue;
            if (!(!this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "SIN") || strToken.equals("bin") && (BIN_IGNORE.contains(tokens[i - 1].getToken()) || tokens.length != i + 1 && tokens[i + 1].getToken().startsWith("Laden")))) {
                posVer1Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "2", "SIN") && !"Probst".equals(tokens[i].getToken())) {
                posVer2Sin = i;
            } else if (this.hasUnambiguouslyPersonAndNumber(tokens[i], "1", "PLU")) {
                posVer1Plu = i;
            }
            if (tokens[i].hasPartialPosTag(":1:SIN")) {
                posPossibleVer1Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":2:SIN")) {
                posPossibleVer2Sin = i;
            }
            if (tokens[i].hasPartialPosTag(":3:SIN")) {
                posPossibleVer3Sin = i;
            }
            if (!tokens[i].hasPartialPosTag(":1:PLU")) continue;
            posPossibleVer1Plu = i;
        }
        if (posVer1Sin != -1 && posIch == -1 && !this.isQuotationMark(tokens[posVer1Sin - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Sin]));
        } else if (!(posIch <= 0 || this.isNear(posPossibleVer1Sin, posIch) || !tokens[posIch].getToken().equals("ich") && tokens[posIch].getStartPos() != 0 || this.isQuotationMark(tokens[posIch - 1]))) {
            int n = plus1 = posIch + 1 == tokens.length ? 0 : 1;
            if (!(this.verbDoesMatchPersonAndNumber(tokens[posIch - 1], tokens[posIch + plus1], "1", "SIN") || this.nextButOneIsModal(tokens, posIch) || "\u00e4u\u00dferst".equals(this.finiteVerb.getToken()))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posIch], this.finiteVerb, "1:SIN"));
            }
        }
        if (posVer2Sin != -1 && posDu == -1 && !this.isQuotationMark(tokens[posVer2Sin - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer2Sin]));
        } else if (posDu > 0 && !this.isNear(posPossibleVer2Sin, posDu) && !this.isQuotationMark(tokens[posDu - 1])) {
            int n = plus1 = posDu + 1 == tokens.length ? 0 : 1;
            if (!(this.verbDoesMatchPersonAndNumber(tokens[posDu - 1], tokens[posDu + plus1], "2", "SIN") || tokens[posDu + plus1].hasPartialPosTag("VER:1:SIN:KJ2") || tokens[posDu + plus1].hasPartialPosTag("ADJ:") || tokens[posDu - 1].hasPartialPosTag("VER:1:SIN:KJ2") || this.nextButOneIsModal(tokens, posDu))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posDu], this.finiteVerb, "2:SIN"));
            }
        }
        if (posEr > 0 && !this.isNear(posPossibleVer3Sin, posEr) && !this.isQuotationMark(tokens[posEr - 1])) {
            int n = plus1 = posEr + 1 == tokens.length ? 0 : 1;
            if (!(this.verbDoesMatchPersonAndNumber(tokens[posEr - 1], tokens[posEr + plus1], "3", "SIN") || this.nextButOneIsModal(tokens, posEr) || "\u00e4u\u00dferst".equals(this.finiteVerb.getToken()) || "regen".equals(this.finiteVerb.getToken()))) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posEr], this.finiteVerb, "3:SIN"));
            }
        }
        if (posVer1Plu != -1 && posWir == -1 && !this.isQuotationMark(tokens[posVer1Plu - 1])) {
            ruleMatches.add(this.ruleMatchWrongVerb(tokens[posVer1Plu]));
        } else if (posWir > 0 && !this.isNear(posPossibleVer1Plu, posWir) && !this.isQuotationMark(tokens[posWir - 1])) {
            int n = plus1 = posWir + 1 == tokens.length ? 0 : 1;
            if (!this.verbDoesMatchPersonAndNumber(tokens[posWir - 1], tokens[posWir + plus1], "1", "PLU") && !this.nextButOneIsModal(tokens, posWir)) {
                ruleMatches.add(this.ruleMatchWrongVerbSubject(tokens[posWir], this.finiteVerb, "1:PLU"));
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public List<DisambiguationPatternRule> getAntiPatterns() {
        return this.makeAntiPatterns(ANTI_PATTERNS, this.language);
    }

    private boolean nextButOneIsModal(AnalyzedTokenReadings[] tokens, int pos) {
        return pos < tokens.length - 2 && tokens[pos + 2].hasPartialPosTag(":MOD:");
    }

    private boolean isNear(int a, int b) {
        return Math.abs(a - b) < 5 && a != -1;
    }

    private boolean isQuotationMark(AnalyzedTokenReadings token) {
        return QUOTATION_MARKS.contains(token.getToken());
    }

    private boolean hasUnambiguouslyPersonAndNumber(AnalyzedTokenReadings tokenReadings, String person, String number) {
        if (tokenReadings.getToken().length() == 0 || Character.isUpperCase(tokenReadings.getToken().charAt(0)) && tokenReadings.getStartPos() != 0 || !tokenReadings.hasPartialPosTag("VER")) {
            return false;
        }
        for (AnalyzedToken analyzedToken : tokenReadings) {
            String postag = analyzedToken.getPOSTag();
            if (postag == null || postag.contains("_END") || postag.contains(":" + person + ":" + number)) continue;
            return false;
        }
        return true;
    }

    private boolean isFiniteVerb(AnalyzedTokenReadings token) {
        if (token.getToken().length() == 0 || Character.isUpperCase(token.getToken().charAt(0)) && token.getStartPos() != 0 || !token.hasPartialPosTag("VER") || token.hasPartialPosTag("PA2") || token.hasPartialPosTag("PRO:") || token.hasPartialPosTag("ZAL") || "einst".equals(token.getToken())) {
            return false;
        }
        return token.hasPartialPosTag(":1:") || token.hasPartialPosTag(":2:") || token.hasPartialPosTag(":3:");
    }

    private boolean verbDoesMatchPersonAndNumber(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, String person, String number) {
        String token1Str = token1.getToken();
        String token2Str = token2.getToken();
        if (token1Str.equals(",") || token1Str.equals("und") || token1Str.equals("sowie") || token2Str.equals(",") || token2Str.equals("und") || token2Str.equals("sowie")) {
            return true;
        }
        boolean foundFiniteVerb = false;
        if (this.isFiniteVerb(token1)) {
            foundFiniteVerb = true;
            this.finiteVerb = token1;
            if (token1.hasPartialPosTag(":" + person + ":" + number)) {
                return true;
            }
        }
        if (this.isFiniteVerb(token2)) {
            foundFiniteVerb = true;
            this.finiteVerb = token2;
            if (token2.hasPartialPosTag(":" + person + ":" + number)) {
                return true;
            }
        }
        return !foundFiniteVerb;
    }

    private List<String> getVerbSuggestions(AnalyzedTokenReadings verb, String expectedVerbPOS, boolean toUppercase) {
        AnalyzedToken verbToken = new AnalyzedToken("", "", "");
        for (AnalyzedToken token : verb.getReadings()) {
            if (!token.getPOSTag().startsWith("VER:")) continue;
            verbToken = token;
            break;
        }
        try {
            String[] synthesized = this.language.getSynthesizer().synthesize(verbToken, "VER.*:" + expectedVerbPOS + ".*", true);
            HashSet<String> suggestionSet = new HashSet<String>(Arrays.asList(synthesized));
            ArrayList<String> suggestions = new ArrayList<String>(suggestionSet);
            if (toUppercase) {
                for (int i = 0; i < suggestions.size(); ++i) {
                    suggestions.set(i, StringTools.uppercaseFirstChar((String)((String)suggestions.get(i))));
                }
            }
            Collections.sort(suggestions);
            return suggestions;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getPronounSuggestions(AnalyzedTokenReadings verb, boolean toUppercase) {
        ArrayList<String> result = new ArrayList<String>();
        if (verb.hasPartialPosTag(":1:SIN")) {
            result.add("ich");
        }
        if (verb.hasPartialPosTag(":2:SIN")) {
            result.add("du");
        }
        if (verb.hasPartialPosTag(":3:SIN")) {
            result.add("er");
            result.add("sie");
            result.add("es");
        }
        if (verb.hasPartialPosTag(":1:PLU")) {
            result.add("wir");
        }
        if (verb.hasPartialPosTag(":2:PLU")) {
            result.add("ihr");
        }
        if (verb.hasPartialPosTag(":3:PLU") && !result.contains("sie")) {
            result.add("sie");
        }
        if (toUppercase) {
            for (int i = 0; i < result.size(); ++i) {
                result.set(i, StringTools.uppercaseFirstChar((String)((String)result.get(i))));
            }
        }
        return result;
    }

    private RuleMatch ruleMatchWrongVerb(AnalyzedTokenReadings token) {
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt und Pr\u00e4dikat (" + token.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: 'Max bist' statt 'Max ist').";
        return new RuleMatch((Rule)this, token.getStartPos(), token.getEndPos(), msg);
    }

    private RuleMatch ruleMatchWrongVerbSubject(AnalyzedTokenReadings subject, AnalyzedTokenReadings verb, String expectedVerbPOS) {
        RuleMatch ruleMatch;
        String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Subjekt (" + subject.getToken() + ") und Pr\u00e4dikat (" + verb.getToken() + ") bez\u00fcglich Person oder Numerus (Einzahl, Mehrzahl - Beispiel: 'ich sind' statt 'ich bin').";
        ArrayList<String> suggestions = new ArrayList<String>();
        ArrayList<String> verbSuggestions = new ArrayList<String>();
        ArrayList<String> pronounSuggestions = new ArrayList<String>();
        if (subject.getStartPos() < verb.getStartPos()) {
            ruleMatch = new RuleMatch((Rule)this, subject.getStartPos(), verb.getStartPos() + verb.getToken().length(), msg);
            verbSuggestions.addAll(this.getVerbSuggestions(verb, expectedVerbPOS, false));
            for (String verbSuggestion : verbSuggestions) {
                suggestions.add(subject.getToken() + " " + verbSuggestion);
            }
            pronounSuggestions.addAll(this.getPronounSuggestions(verb, Character.isUpperCase(subject.getToken().charAt(0))));
            for (String pronounSuggestion : pronounSuggestions) {
                suggestions.add(pronounSuggestion + " " + verb.getToken());
            }
            ruleMatch.setSuggestedReplacements(suggestions);
        } else {
            ruleMatch = new RuleMatch((Rule)this, verb.getStartPos(), subject.getStartPos() + subject.getToken().length(), msg);
            verbSuggestions.addAll(this.getVerbSuggestions(verb, expectedVerbPOS, Character.isUpperCase(verb.getToken().charAt(0))));
            for (String verbSuggestion : verbSuggestions) {
                suggestions.add(verbSuggestion + " " + subject.getToken());
            }
            pronounSuggestions.addAll(this.getPronounSuggestions(verb, false));
            for (String pronounSuggestion : pronounSuggestions) {
                suggestions.add(verb.getToken() + " " + pronounSuggestion);
            }
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    public void reset() {
        this.finiteVerb = null;
    }
}

