/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import de.danielnaber.jwordsplitter.GermanWordSplitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.WordUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.German;
import org.languagetool.rules.Example;
import org.languagetool.rules.de.LineExpander;
import org.languagetool.rules.spelling.hunspell.CompoundAwareHunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanSpellerRule
extends CompoundAwareHunspellRule {
    public static final String RULE_ID = "GERMAN_SPELLER_RULE";
    private static final int MAX_EDIT_DISTANCE = 2;
    private static final int SUGGESTION_MIN_LENGTH = 2;
    private static final List<Replacement> REPL = Arrays.asList(new Replacement("f", "ph"), new Replacement("ph", "f"), new Replacement("\u00df", "ss"), new Replacement("ss", "\u00df"), new Replacement("s", "ss"), new Replacement("ss", "s"), new Replacement("i", "ie"), new Replacement("ie", "i"), new Replacement("ee", "e"), new Replacement("o", "oh"), new Replacement("oh", "o"), new Replacement("a", "ah"), new Replacement("ah", "a"), new Replacement("e", "eh"), new Replacement("eh", "e"), new Replacement("ae", "\u00e4"), new Replacement("oe", "\u00f6"), new Replacement("ue", "\u00fc"), new Replacement("Ae", "\u00c4"), new Replacement("Oe", "\u00d6"), new Replacement("Ue", "\u00dc"), new Replacement("d", "t"), new Replacement("t", "d"), new Replacement("th", "t"), new Replacement("t", "th"), new Replacement("r", "rh"), new Replacement("ch", "k"), new Replacement("k", "ch"), new Replacement("F", "Ph"), new Replacement("Ph", "F"));
    private final LineExpander lineExpander = new LineExpander();
    private final GermanCompoundTokenizer compoundTokenizer;
    private final GermanWordSplitter splitter;
    private final Synthesizer synthesizer;
    private final Tagger tagger;

    public GermanSpellerRule(ResourceBundle messages, German language) {
        super(messages, (Language)language, language.getNonStrictCompoundSplitter(), GermanSpellerRule.getSpeller(language));
        this.addExamplePair(Example.wrong((String)"LanguageTool kann mehr als eine <marker>nromale</marker> Rechtschreibpr\u00fcfung."), Example.fixed((String)"LanguageTool kann mehr als eine <marker>normale</marker> Rechtschreibpr\u00fcfung."));
        this.compoundTokenizer = language.getStrictCompoundTokenizer();
        this.tagger = language.getTagger();
        this.synthesizer = language.getSynthesizer();
        try {
            this.splitter = new GermanWordSplitter(false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init() throws IOException {
        super.init();
        String pattern = "(" + this.nonWordPattern.pattern() + "|(?<=\\d)\\-|\\-(?=\\d+))";
        this.nonWordPattern = Pattern.compile(pattern);
        this.needsInit = false;
    }

    public String getId() {
        return RULE_ID;
    }

    public List<String> getCandidates(String word) {
        ArrayList<String> suggestions = new ArrayList<String>();
        List partList = this.splitter.getAllSplits(word);
        ArrayList candidates = new ArrayList();
        for (List parts : partList) {
            candidates.addAll(super.getCandidates(parts));
        }
        suggestions.addAll(candidates);
        return suggestions;
    }

    protected boolean isProhibited(String word) {
        return word.startsWith("Standart-") || super.isProhibited(word);
    }

    protected void addIgnoreWords(String origLine, Set<String> wordsToBeIgnored) {
        String line = this.language.getShortNameWithCountryAndVariant().equals("de-CH") ? origLine.replace("\u00df", "ss") : origLine;
        wordsToBeIgnored.addAll(this.expandLine(line));
    }

    protected List<String> expandLine(String line) {
        return this.lineExpander.expandLine(line);
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static MorfologikMultiSpeller getSpeller(Language language) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void filterForLanguage(List<String> suggestions) {
        if (this.language.getShortNameWithCountryAndVariant().equals("de-CH")) {
            for (int i = 0; i < suggestions.size(); ++i) {
                String s = suggestions.get(i);
                suggestions.set(i, s.replace("\u00df", "ss"));
            }
        }
        Iterator<String> iterator = suggestions.iterator();
        while (iterator.hasNext()) {
            String suggestion = iterator.next();
            if (suggestion.length() <= 1 || !suggestion.startsWith("-")) continue;
            iterator.remove();
        }
    }

    protected List<String> sortSuggestionByQuality(String misspelling, List<String> suggestions) {
        List<String> sorted1 = this.sortByReplacements(misspelling, suggestions);
        List<String> sorted2 = this.sortByCase(misspelling, sorted1);
        return sorted2;
    }

    protected boolean ignoreWord(List<String> words, int idx) throws IOException {
        boolean ignore = super.ignoreWord(words, idx);
        boolean ignoreUncapitalizedWord = !ignore && idx == 0 && super.ignoreWord(WordUtils.uncapitalize((String)words.get(0)));
        boolean ignoreByHyphen = false;
        boolean ignoreHyphenatedCompound = false;
        if (!ignore && !ignoreUncapitalizedWord && words.get(idx).contains("-")) {
            ignoreByHyphen = words.get(idx).endsWith("-") && this.ignoreByHangingHyphen(words, idx);
            ignoreHyphenatedCompound = !ignoreByHyphen && this.ignoreCompoundWithIgnoredWord(words.get(idx));
        }
        return ignore || ignoreUncapitalizedWord || ignoreByHyphen || ignoreHyphenatedCompound;
    }

    protected List<String> getAdditionalTopSuggestions(List<String> suggestions, String word) throws IOException {
        String[] words;
        String ucWord;
        String w = word.replaceFirst("\\.$", "");
        if ("unzwar".equals(w)) {
            return Collections.singletonList("und zwar");
        }
        if ("desweiteren".equals(w)) {
            return Collections.singletonList("des Weiteren");
        }
        if ("wieviel".equals(w)) {
            return Collections.singletonList("wie viel");
        }
        if ("wieviele".equals(w)) {
            return Collections.singletonList("wie viele");
        }
        if ("wievielen".equals(w)) {
            return Collections.singletonList("wie vielen");
        }
        if ("vorteilen".equals(w)) {
            return Collections.singletonList("Vorteilen");
        }
        if ("Trons".equals(w)) {
            return Collections.singletonList("Trance");
        }
        if ("einzigste".equals(w)) {
            return Collections.singletonList("einzige");
        }
        if (word.endsWith("standart")) {
            return Collections.singletonList(word.replaceFirst("standart$", "standard"));
        }
        if (word.endsWith("standarts")) {
            return Collections.singletonList(word.replaceFirst("standarts$", "standards"));
        }
        if (word.equals("Rolladen")) {
            return Collections.singletonList("Rollladen");
        }
        if (word.equals("Ma\u00dfname")) {
            return Collections.singletonList("Ma\u00dfnahme");
        }
        if (word.equals("Ma\u00dfnamen")) {
            return Collections.singletonList("Ma\u00dfnahmen");
        }
        if (word.equals("nanten")) {
            return Collections.singletonList("nannten");
        }
        if (!(StringTools.startsWithUppercase((String)word) || suggestions.contains(ucWord = StringTools.uppercaseFirstChar((String)word)) || this.hunspellDict.misspelled(ucWord))) {
            return Collections.singletonList(ucWord);
        }
        String verbSuggestion = this.getPastTenseVerbSuggestion(word);
        if (verbSuggestion != null) {
            return Collections.singletonList(verbSuggestion);
        }
        String participleSuggestion = this.getParticipleSuggestion(word);
        if (participleSuggestion != null) {
            return Collections.singletonList(participleSuggestion);
        }
        if (suggestions.isEmpty() && word.contains("-") && (words = word.split("-")).length > 1) {
            ArrayList<List<String>> suggestionLists = new ArrayList<List<String>>(words.length);
            int startAt = 0;
            int stopAt = words.length;
            if (super.ignoreWord(words[0] + "-" + words[1])) {
                startAt = 2;
                suggestionLists.add(Collections.singletonList(words[0] + "-" + words[1]));
            }
            if (super.ignoreWord(words[words.length - 2] + "-" + words[words.length - 1])) {
                stopAt = words.length - 2;
            }
            for (int idx = startAt; idx < stopAt; ++idx) {
                if (super.ignoreWord(words[idx])) {
                    suggestionLists.add(Collections.singletonList(words[idx]));
                    continue;
                }
                if (this.hunspellDict.misspelled(words[idx])) {
                    List<String> list = this.sortSuggestionByQuality(words[idx], super.getSuggestions(words[idx]));
                    suggestionLists.add(list);
                    continue;
                }
                suggestionLists.add(Collections.singletonList(words[idx]));
            }
            if (stopAt < words.length - 1) {
                suggestionLists.add(Collections.singletonList(words[words.length - 2] + "-" + words[words.length - 1]));
            }
            ArrayList<String> additionalSuggestions = (ArrayList<String>)suggestionLists.get(0);
            for (int idx = 1; idx < suggestionLists.size(); ++idx) {
                List suggestionList = (List)suggestionLists.get(idx);
                ArrayList<String> newList = new ArrayList<String>(additionalSuggestions.size() * suggestionList.size());
                for (String additionalSuggestion : additionalSuggestions) {
                    for (String aSuggestionList : suggestionList) {
                        newList.add(additionalSuggestion + "-" + aSuggestionList);
                    }
                }
                additionalSuggestions = newList;
            }
            return additionalSuggestions;
        }
        return Collections.emptyList();
    }

    @Nullable
    private String getPastTenseVerbSuggestion(String word) {
        if (word.endsWith("e")) {
            String wordStem = word.replaceFirst("e$", "");
            try {
                AnalyzedToken token;
                String[] forms;
                String lemma = this.baseForThirdPersonSingularVerb(wordStem);
                if (lemma != null && (forms = this.synthesizer.synthesize(token = new AnalyzedToken(lemma, null, lemma), "VER:3:SIN:PRT:.*", true)).length > 0) {
                    return forms[0];
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String baseForThirdPersonSingularVerb(String word) throws IOException {
        List readings = this.tagger.tag(Collections.singletonList(word));
        for (AnalyzedTokenReadings reading : readings) {
            if (!reading.hasPartialPosTag("VER:3:SIN:")) continue;
            return ((AnalyzedToken)reading.getReadings().get(0)).getLemma();
        }
        return null;
    }

    @Nullable
    private String getParticipleSuggestion(String word) {
        if (word.startsWith("ge") && word.endsWith("t")) {
            String baseform = word.replaceFirst("^ge", "").replaceFirst("t$", "en");
            try {
                String participle = this.getParticipleForBaseform(baseform);
                if (participle != null) {
                    return participle;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Nullable
    private String getParticipleForBaseform(String baseform) throws IOException {
        AnalyzedToken token = new AnalyzedToken(baseform, null, baseform);
        String[] forms = this.synthesizer.synthesize(token, "VER:PA2:.*", true);
        if (forms.length > 0 && !this.hunspellDict.misspelled(forms[0])) {
            return forms[0];
        }
        return null;
    }

    private boolean ignoreByHangingHyphen(List<String> words, int idx) {
        boolean isCompound;
        String word = words.get(idx);
        String nextWord = this.getWordAfterEnumerationOrNull(words, idx);
        boolean bl = isCompound = nextWord != null && this.compoundTokenizer.tokenize(nextWord).size() > 1;
        if (isCompound) {
            return !this.hunspellDict.misspelled(word.replaceFirst("-$", ""));
        }
        return false;
    }

    @Nullable
    private String getWordAfterEnumerationOrNull(List<String> words, int idx) {
        for (int i = idx; i < words.size(); ++i) {
            boolean inEnumeration;
            String word = words.get(i);
            boolean bl = inEnumeration = ",".equals(word) || "und".equals(word) || "oder".equals(word) || word.trim().isEmpty() || word.endsWith("-");
            if (inEnumeration) continue;
            return word;
        }
        return null;
    }

    private boolean ignoreCompoundWithIgnoredWord(String word) throws IOException {
        String[] words = word.split("-");
        if (words.length < 2) {
            return false;
        }
        boolean hasIgnoredWord = false;
        ArrayList<Object> toSpellCheck = new ArrayList<Object>(3);
        String stripFirst = word.substring(words[0].length() + 1);
        String stripLast = word.substring(0, word.length() - words[words.length - 1].length() - 1);
        if (super.ignoreWord(stripFirst)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[0])) {
                toSpellCheck.add(words[0]);
            }
        } else if (super.ignoreWord(stripLast)) {
            hasIgnoredWord = true;
            if (!super.ignoreWord(words[words.length - 1])) {
                toSpellCheck.add(words[words.length - 1]);
            }
        } else {
            for (String word1 : words) {
                if (!super.ignoreWord(word1)) continue;
                toSpellCheck.add(word1);
                hasIgnoredWord = true;
            }
        }
        if (hasIgnoredWord) {
            for (String string : toSpellCheck) {
                if (!this.hunspellDict.misspelled(string)) continue;
                return false;
            }
        }
        return hasIgnoredWord;
    }

    private List<String> sortByReplacements(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String suggestion : suggestions) {
            boolean moveSuggestionToTop = false;
            for (Replacement replacement : REPL) {
                String modifiedMisspelling = misspelling.replace(replacement.key, replacement.value);
                boolean equalsAfterReplacement = modifiedMisspelling.equals(suggestion);
                if (!equalsAfterReplacement) continue;
                moveSuggestionToTop = true;
                break;
            }
            if (this.ignoreSuggestion(suggestion)) continue;
            if (moveSuggestionToTop) {
                result.add(0, suggestion);
                continue;
            }
            result.add(suggestion);
        }
        return result;
    }

    private List<String> sortByCase(String misspelling, List<String> suggestions) {
        ArrayList<String> result = new ArrayList<String>();
        for (String suggestion : suggestions) {
            if (misspelling.equalsIgnoreCase(suggestion)) {
                result.add(0, suggestion);
                continue;
            }
            result.add(suggestion);
        }
        return result;
    }

    private boolean ignoreSuggestion(String suggestion) {
        String[] parts = suggestion.split(" ");
        if (parts.length > 1) {
            for (String part : parts) {
                if (part.length() >= 2) continue;
                return true;
            }
        }
        return false;
    }

    static class ExpandingReader
    extends BufferedReader {
        private final List<String> buffer = new ArrayList<String>();
        private final LineExpander lineExpander = new LineExpander();

        ExpandingReader(Reader in) {
            super(in);
        }

        @Override
        public String readLine() throws IOException {
            if (this.buffer.size() > 0) {
                return this.buffer.remove(0);
            }
            String line = super.readLine();
            if (line == null) {
                return null;
            }
            this.buffer.addAll(this.lineExpander.expandLine(line));
            return this.buffer.remove(0);
        }
    }

    private static class Replacement {
        final String key;
        final String value;

        private Replacement(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }
}

