/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ArrayList;
import java.util.List;

class LineExpander {
    LineExpander() {
    }

    List<String> expandLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        if (!line.startsWith("#") && line.contains("/")) {
            String[] parts = line.split("/");
            if (parts.length != 2) {
                throw new RuntimeException("Unexpected line format, expected at most one slash: " + line);
            }
            String word = parts[0];
            String suffix = parts[1];
            result.add(word);
            for (int i = 0; i < suffix.length(); ++i) {
                char c = suffix.charAt(i);
                if (c == 'S') {
                    result.add(word + "s");
                    continue;
                }
                if (c == 'N') {
                    result.add(word + "n");
                    continue;
                }
                if (c == 'A') {
                    result.add(word + "e");
                    result.add(word + "er");
                    result.add(word + "es");
                    result.add(word + "en");
                    result.add(word + "em");
                    continue;
                }
                throw new RuntimeException("Unknown suffix: " + suffix + " in line: " + line);
            }
        } else {
            result.add(line);
        }
        return result;
    }
}

