/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.language.German;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.tagging.de.GermanTagger;

public class SubjectVerbAgreementRule
extends GermanRule {
    private static final ChunkTag NPS = new ChunkTag("NPS");
    private static final ChunkTag NPP = new ChunkTag("NPP");
    private static final ChunkTag PP = new ChunkTag("PP");
    private static final List<String> QUESTION_PRONOUNS = Arrays.asList("wie");
    private static final List<String> CURRENCIES = Arrays.asList("Dollar", "Euro", "Yen");
    private final GermanTagger tagger = (GermanTagger)new German().getTagger();

    public SubjectVerbAgreementRule(ResourceBundle messages) {
        super.setCategory(new Category(messages.getString("category_grammar")));
    }

    public String getId() {
        return "DE_SUBJECT_VERB_AGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Subjekt und Pr\u00e4dikat (unvollst\u00e4ndig)";
    }

    public URL getUrl() {
        try {
            return new URL("http://www.canoo.net/services/OnlineGrammar/Wort/Verb/Numerus-Person/ProblemNum.html");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch pluralMatch;
            AnalyzedTokenReadings token = tokens[i];
            String tokenStr = token.getToken();
            RuleMatch singularMatch = this.getSingularMatchOrNull(tokens, i, token, tokenStr);
            if (singularMatch != null) {
                ruleMatches.add(singularMatch);
            }
            if ((pluralMatch = this.getPluralMatchOrNull(tokens, i, token, tokenStr)) == null) continue;
            ruleMatches.add(pluralMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    private RuleMatch getSingularMatchOrNull(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings token, String tokenStr) throws IOException {
        if (tokenStr.equals("ist") || tokenStr.equals("war")) {
            boolean match;
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            AnalyzedTokenReadings nextToken = i + 1 < tokens.length ? tokens[i + 1] : null;
            List prevChunkTags = prevToken.getChunkTags();
            boolean bl = match = prevChunkTags.contains(NPP) && !prevChunkTags.contains(PP) && !prevToken.getToken().equals("Uhr") && !this.isCurrency(prevToken) && (nextToken == null || !nextToken.getToken().equals("es")) && this.prevChunkIsNominative(tokens, i - 1) && !this.hasUnknownTokenToTheLeft(tokens, i) && !this.hasQuestionPronounToTheLeft(tokens, i - 1) && !this.containsRegexToTheLeft("wer", tokens, i - 1) && !this.containsRegexToTheLeft("(?i)alle[nr]?", tokens, i - 1) && !this.containsRegexToTheLeft("(?i)jede[rs]?", tokens, i - 1) && !this.containsRegexToTheLeft("(?i)manche[nrs]?", tokens, i - 1) && !this.containsOnlyInfinitivesToTheLeft(tokens, i - 1);
            if (match) {
                String message = "Bitte pr\u00fcfen, ob hier <suggestion>" + (tokenStr.equals("ist") ? "sind" : "waren") + "</suggestion> stehen sollte.";
                return new RuleMatch((Rule)this, token.getStartPos(), token.getEndPos(), message);
            }
        }
        return null;
    }

    @Nullable
    private RuleMatch getPluralMatchOrNull(AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings token, String tokenStr) {
        if (tokenStr.equals("sind") || tokenStr.equals("waren")) {
            boolean match;
            AnalyzedTokenReadings prevToken = tokens[i - 1];
            List prevChunkTags = prevToken.getChunkTags();
            boolean bl = match = prevChunkTags.contains(NPS) && !prevChunkTags.contains(NPP) && !prevChunkTags.contains(PP) && !this.isCurrency(prevToken) && this.prevChunkIsNominative(tokens, i - 1) && !this.hasUnknownTokenToTheLeft(tokens, i) && !this.hasUnknownTokenToTheRight(tokens, i + 1) && !this.isFollowedByNominativePlural(tokens, i + 1);
            if (match) {
                String message = "Bitte pr\u00fcfen, ob hier <suggestion>" + (tokenStr.equals("sind") ? "ist" : "war") + "</suggestion> stehen sollte.";
                return new RuleMatch((Rule)this, token.getStartPos(), token.getEndPos(), message);
            }
        }
        return null;
    }

    private boolean isCurrency(AnalyzedTokenReadings token) {
        return CURRENCIES.contains(token.getToken());
    }

    boolean prevChunkIsNominative(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            AnalyzedTokenReadings token = tokens[i];
            List chunkTags = token.getChunkTags();
            if (chunkTags.contains(NPS) || chunkTags.contains(NPP)) {
                if (!token.hasPartialPosTag("NOM")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean hasUnknownTokenToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        return this.hasUnknownTokenAt(tokens, 0, startPos);
    }

    private boolean hasUnknownTokenToTheRight(AnalyzedTokenReadings[] tokens, int startPos) {
        return this.hasUnknownTokenAt(tokens, startPos, tokens.length - 1);
    }

    private boolean hasUnknownTokenAt(AnalyzedTokenReadings[] tokens, int startPos, int endPos) {
        if (endPos < startPos) {
            throw new RuntimeException("endPos < startPos: " + endPos + " < " + startPos);
        }
        for (int i = startPos; i < endPos; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            for (AnalyzedToken analyzedToken : token.getReadings()) {
                if (!analyzedToken.hasNoTag()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasQuestionPronounToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i > 0; --i) {
            AnalyzedTokenReadings token = tokens[i];
            if (!QUESTION_PRONOUNS.contains(token.getToken().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private boolean containsRegexToTheLeft(String regex, AnalyzedTokenReadings[] tokens, int startPos) {
        Pattern p = Pattern.compile(regex);
        for (int i = startPos; i > 0; --i) {
            String token = tokens[i].getToken();
            if (!p.matcher(token).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean containsOnlyInfinitivesToTheLeft(AnalyzedTokenReadings[] tokens, int startPos) throws IOException {
        int infinitives = 0;
        for (int i = startPos; i > 0; --i) {
            String token = tokens[i].getToken();
            if (!tokens[i].hasPartialPosTag("SUB:")) continue;
            AnalyzedTokenReadings lookup = this.tagger.lookup(token.toLowerCase());
            if (lookup != null && lookup.hasPartialPosTag("VER:INF:")) {
                ++infinitives;
                continue;
            }
            return false;
        }
        return infinitives >= 2;
    }

    boolean isFollowedByNominativePlural(AnalyzedTokenReadings[] tokens, int startPos) {
        for (int i = startPos; i < tokens.length; ++i) {
            AnalyzedTokenReadings token = tokens[i];
            if (!token.hasPartialPosTag("SUB") && !token.hasPartialPosTag("PRO") || !token.hasPartialPosTag("NOM:PLU") && !token.getChunkTags().contains(new ChunkTag("NPP"))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
    }
}

