/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Category;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tools.StringTools;

public class CaseRule
extends GermanRule {
    private static final Pattern NUMERALS_EN = Pattern.compile("[a-z]|[0-9]+|(m{0,4}(cm|cd|d?c{0,3})(xc|xl|l?x{0,3})(ix|iv|v?i{0,3}))$");
    private static final Set<String> nounIndicators = new HashSet<String>();
    private static final Set<String> sentenceStartExceptions;
    private static final Set<String> exceptions;
    private static final Set<String> languages;
    private static final Set<String> myExceptionPhrases;
    private static final Set<String> substVerbenExceptions;
    private final GermanTagger tagger;

    public CaseRule(ResourceBundle messages, German german) {
        super.setCategory(new Category(messages.getString("category_case")));
        this.tagger = (GermanTagger)german.getTagger();
        this.addExamplePair(Example.wrong((String)"<marker>Das laufen</marker> f\u00e4llt mir schwer."), Example.fixed((String)"<marker>Das Laufen</marker> f\u00e4llt mir schwer."));
    }

    public String getId() {
        return "DE_CASE";
    }

    public String getDescription() {
        return "Gro\u00dfschreibung von Nomen und substantivierten Verben";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        boolean prevTokenIsDas = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean isBaseform;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if (posToken != null && posToken.equals("SENT_START")) continue;
            if (i == 1) {
                if (!nounIndicators.contains(tokens[1].getToken().toLowerCase())) continue;
                prevTokenIsDas = true;
                continue;
            }
            if (i > 0 && this.isSalutation(tokens[i - 1].getToken())) continue;
            AnalyzedTokenReadings analyzedToken = tokens[i];
            String token = analyzedToken.getToken();
            boolean bl = isBaseform = analyzedToken.getReadingsLength() >= 1 && analyzedToken.hasLemma(token);
            if ((analyzedToken.getAnalyzedToken(0).getPOSTag() == null || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.VERB)) && isBaseform) {
                boolean nextTokenIsPersonalPronoun = false;
                if (i < tokens.length - 1) {
                    boolean bl2 = nextTokenIsPersonalPronoun = tokens[i + 1].hasPartialPosTag("PRO:PER") || tokens[i + 1].getToken().equals("Sie");
                    if (tokens[i + 1].hasLemma("lassen") || tokens[i + 1].isSentenceEnd()) continue;
                }
                if (this.isPrevProbablyRelativePronoun(tokens, i)) continue;
                this.potentiallyAddLowercaseMatch(ruleMatches, tokens[i], prevTokenIsDas, token, nextTokenIsPersonalPronoun);
            }
            prevTokenIsDas = nounIndicators.contains(tokens[i].getToken().toLowerCase());
            if (this.hasNounReading(analyzedToken)) continue;
            AnalyzedTokenReadings lowercaseReadings = this.tagger.lookup(token.toLowerCase());
            if (analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings == null || analyzedToken.getAnalyzedToken(0).getPOSTag() == null && lowercaseReadings != null && lowercaseReadings.getAnalyzedToken(0).getPOSTag() == null) continue;
            this.potentiallyAddUppercaseMatch(ruleMatches, tokens, i, analyzedToken, token);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isPrevProbablyRelativePronoun(AnalyzedTokenReadings[] tokens, int i) {
        if (i >= 3) {
            AnalyzedTokenReadings prev1 = tokens[i - 1];
            AnalyzedTokenReadings prev2 = tokens[i - 2];
            AnalyzedTokenReadings prev3 = tokens[i - 3];
            if (prev1.getToken().equals("das") && prev2.getToken().equals(",") && prev3.matchesPosTagRegex("SUB:...:SIN:NEU")) {
                return true;
            }
        }
        return false;
    }

    private boolean isSalutation(String token) {
        return token.equals("Herr") || token.equals("Herrn") || token.equals("Frau");
    }

    private boolean hasNounReading(AnalyzedTokenReadings readings) {
        try {
            AnalyzedTokenReadings allReadings = this.tagger.lookup(readings.getToken());
            if (allReadings != null) {
                for (AnalyzedToken reading : allReadings) {
                    String posTag = reading.getPOSTag();
                    if (posTag == null || !posTag.contains("SUB:") || posTag.contains(":ADJ")) continue;
                    return true;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not lookup " + readings.getToken(), e);
        }
        return false;
    }

    private void potentiallyAddLowercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings tokenReadings, boolean prevTokenIsDas, String token, boolean nextTokenIsPersonalPronoun) {
        if (prevTokenIsDas && !nextTokenIsPersonalPronoun && Character.isLowerCase(token.charAt(0)) && !substVerbenExceptions.contains(token) && tokenReadings.hasPartialPosTag("VER:INF") && !tokenReadings.isIgnoredBySpeller()) {
            String msg = "Substantivierte Verben werden gro\u00dfgeschrieben.";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokenReadings.getStartPos(), tokenReadings.getStartPos() + token.length(), "Substantivierte Verben werden gro\u00dfgeschrieben.");
            String word = tokenReadings.getToken();
            String fixedWord = StringTools.uppercaseFirstChar((String)word);
            ruleMatch.setSuggestedReplacement(fixedWord);
            ruleMatches.add(ruleMatch);
        }
    }

    private void potentiallyAddUppercaseMatch(List<RuleMatch> ruleMatches, AnalyzedTokenReadings[] tokens, int i, AnalyzedTokenReadings analyzedToken, String token) {
        if (!(!Character.isUpperCase(token.charAt(0)) || token.length() <= 1 || tokens[i].isIgnoredBySpeller() || sentenceStartExceptions.contains(tokens[i - 1].getToken()) || exceptions.contains(token) || StringTools.isAllUppercase((String)token) || this.isLanguage(i, tokens) || this.isProbablyCity(i, tokens) || GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PROPER_NOUN) || analyzedToken.isSentenceEnd() || this.isEllipsis(i, tokens) || this.isNumbering(i, tokens) || this.isNominalization(i, tokens) || this.isAdverbAndNominalization(i, tokens) || this.isSpecialCase(i, tokens) || this.isAdjectiveAsNoun(i, tokens) || this.isExceptionPhrase(i, tokens))) {
            String msg = "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getStartPos() + token.length(), "Au\u00dfer am Satzanfang werden nur Nomen und Eigennamen gro\u00dfgeschrieben");
            String word = tokens[i].getToken();
            String fixedWord = Character.toLowerCase(word.charAt(0)) + word.substring(1);
            ruleMatch.setSuggestedReplacement(fixedWord);
            ruleMatches.add(ruleMatch);
        }
    }

    private boolean isNumbering(int i, AnalyzedTokenReadings[] tokens) {
        return i >= 2 && (tokens[i - 1].getToken().equals(")") || tokens[i - 1].getToken().equals("]")) && NUMERALS_EN.matcher(tokens[i - 2].getToken()).matches();
    }

    private boolean isEllipsis(int i, AnalyzedTokenReadings[] tokens) {
        return (tokens[i - 1].getToken().equals("]") || tokens[i - 1].getToken().equals(")")) && (i == 4 && tokens[i - 2].getToken().equals("\u2026") || i == 6 && tokens[i - 2].getToken().equals("."));
    }

    private boolean isNominalization(int i, AnalyzedTokenReadings[] tokens) {
        AnalyzedTokenReadings nextReadings;
        String token = tokens[i].getToken();
        AnalyzedTokenReadings analyzedTokenReadings = nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        if (StringTools.startsWithUppercase((String)token) && !this.isNumber(token) && !this.hasNounReading(nextReadings) && !token.matches("Alle[nm]")) {
            AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
            AnalyzedTokenReadings prevPrevToken = i >= 2 ? tokens[i - 2] : null;
            AnalyzedTokenReadings prevPrevPrevToken = i >= 3 ? tokens[i - 3] : null;
            return prevToken != null && ("irgendwas".equals(prevToken.getToken()) || "aufs".equals(prevToken.getToken())) || this.hasPartialTag(prevToken, "PRO") || this.hasPartialTag(prevPrevToken, "PRO", "PRP") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2") || this.hasPartialTag(prevPrevPrevToken, "PRO", "PRP") && this.hasPartialTag(prevPrevToken, "ADJ", "ADV") && this.hasPartialTag(prevToken, "ADJ", "ADV", "PA2");
        }
        return false;
    }

    private boolean isNumber(String token) {
        try {
            AnalyzedTokenReadings lookup = this.tagger.lookup(StringTools.lowercaseFirstChar((String)token));
            return lookup != null && lookup.hasPosTag("ZAL");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isAdverbAndNominalization(int i, AnalyzedTokenReadings[] tokens) {
        String prevPrevToken = i > 1 ? tokens[i - 2].getToken() : "";
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "das".equalsIgnoreCase(prevPrevToken) && this.hasPartialTag(prevToken, "ADV") && StringTools.startsWithUppercase((String)token) && !this.hasNounReading(nextReadings);
    }

    private boolean hasPartialTag(AnalyzedTokenReadings token, String ... posTags) {
        if (token != null) {
            for (String posTag : posTags) {
                if (!token.hasPartialPosTag(posTag)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSpecialCase(int i, AnalyzedTokenReadings[] tokens) {
        String prevToken = i > 1 ? tokens[i - 1].getToken() : "";
        String token = tokens[i].getToken();
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return "im".equalsIgnoreCase(prevToken) && "Allgemeinen".equals(token) && !this.hasNounReading(nextReadings);
    }

    private boolean isAdjectiveAsNoun(int i, AnalyzedTokenReadings[] tokens) {
        boolean isPrevDeterminer;
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        boolean bl = isPrevDeterminer = prevToken != null && (prevToken.hasPartialPosTag("ART") || prevToken.hasPartialPosTag("PRP"));
        if (!isPrevDeterminer) {
            return false;
        }
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        for (AnalyzedToken reading : tokens[i].getReadings()) {
            String posTag = reading.getPOSTag();
            if (posTag == null || !posTag.contains(":ADJ") || this.hasNounReading(nextReadings)) continue;
            return true;
        }
        return false;
    }

    private boolean isLanguage(int i, AnalyzedTokenReadings[] tokens) {
        String token = tokens[i].getToken();
        boolean maybeLanguage = languages.contains(token) || languages.contains(token.replaceFirst("e$", "")) || languages.contains(token.replaceFirst("en$", ""));
        AnalyzedTokenReadings prevToken = i > 0 ? tokens[i - 1] : null;
        AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
        return maybeLanguage && (nextReadings != null && !this.hasNounReading(nextReadings) || prevToken != null && prevToken.getToken().equals("auf"));
    }

    private boolean isProbablyCity(int i, AnalyzedTokenReadings[] tokens) {
        boolean hasCityPrefix;
        String token = tokens[i].getToken();
        boolean bl = hasCityPrefix = "Klein".equals(token) || "Gro\u00df".equals(token) || "Neu".equals(token);
        if (hasCityPrefix) {
            AnalyzedTokenReadings nextReadings = i < tokens.length - 1 ? tokens[i + 1] : null;
            return nextReadings != null && (!nextReadings.isTagged() || nextReadings.hasPartialPosTag("EIG"));
        }
        return false;
    }

    private boolean isExceptionPhrase(int i, AnalyzedTokenReadings[] tokens) {
        for (String exc : myExceptionPhrases) {
            String[] parts = exc.split(" ");
            for (int j = 0; j < parts.length; ++j) {
                int startIndex;
                if (!parts[j].equals(tokens[i].getToken()) || !this.compareLists(tokens, startIndex = i - j, startIndex + parts.length - 1, parts)) continue;
                return true;
            }
        }
        return false;
    }

    boolean compareLists(AnalyzedTokenReadings[] tokens, int startIndex, int endIndex, String[] parts) {
        if (startIndex < 0) {
            return false;
        }
        int i = 0;
        for (int j = startIndex; j <= endIndex; ++j) {
            if (i >= parts.length || j >= tokens.length) {
                return false;
            }
            if (!tokens[j].getToken().equals(parts[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void reset() {
    }

    static {
        nounIndicators.add("das");
        nounIndicators.add("sein");
        nounIndicators.add("mein");
        nounIndicators.add("dein");
        nounIndicators.add("euer");
        nounIndicators.add("unser");
        sentenceStartExceptions = new HashSet<String>();
        sentenceStartExceptions.add("(");
        sentenceStartExceptions.add(":");
        sentenceStartExceptions.add("\"");
        sentenceStartExceptions.add("'");
        sentenceStartExceptions.add("\u201e");
        sentenceStartExceptions.add("\u201c");
        sentenceStartExceptions.add("\u00ab");
        sentenceStartExceptions.add("\u00bb");
        sentenceStartExceptions.add(".");
        exceptions = new HashSet<String>(Arrays.asList("Verletzte", "Vermisste", "\u00c4u\u00dferes", "Abseits", "Besch\u00e4ftigter", "Besch\u00e4ftigte", "Besch\u00e4ftigten", "\u00dcblichen", "Bekannter", "Bekannte", "Tel", "Unschuldiger", "Vorgesetzter", "Abs", "Klappe", "Vorfahre", "Mittler", "Hr", "Schwarz", "Genese", "Rosa", "Auftrieb", "Zuschnitt", "Geschossen", "Vortrieb", "Abtrieb", "Gesandter", "Durchfahrt", "Durchgriff", "\u00dcberfahrt", "Zeche", "Sparte", "Sparten", "Heiliger", "Reisender", "Hochdeutsch", "Pest", "Schwinge", "Verlies", "Nachfolge", "Stift", "Belange", "Geistlicher", "Jenseits", "Abends", "Abgeordneter", "Angestellter", "Liberaler", "Abriss", "Ahne", "\u00c4hnlichem", "\u00c4hnliches", "Allerlei", "Anklang", "Anstrich", "Armes", "Aus", "Ausdr\u00fccke", "Ausw\u00fcchsen", "B\u00e4nde", "B\u00e4nden", "Beauftragter", "Belange", "besonderes", "Biss", "De", "Dr", "Durcheinander", "Eindr\u00fccke", "Erwachsener", "Fl\u00f6\u00dfe", "Folgendes", "Fort", "Fra\u00df", "F\u00fcr", "Gen\u00fcge", "Gl\u00e4ubiger", "Goldener", "Guten", "Hechte", "Herz\u00f6ge", "Herz\u00f6gen", "Hinfahrt", "Hundert", "Ihnen", "Ihr", "Ihre", "Ihrem", "Ihren", "Ihrer", "Ihres", "Infrarot", "Jenseits", "Jugendlicher", "J\u00fcnger", "Klaue", "Kleine", "Konditional", "Kr\u00e4he", "Kurzem", "Landwirtschaft", "Langem", "L\u00e4ngerem", "Las", "Le", "Letzt", "Letzt", "Letztere", "Letzterer", "Letzteres", "Link", "Links", "L\u00f6hne", "Luden", "Mitfahrt", "Mr", "Mrd", "Mrs", "Nachfrage", "Nachts", "N\u00e4hte", "N\u00e4hten", "Neuem", "Nr", "Nutze", "Obdachloser", "Oder", "Patsche", "Pfiffe", "Pfiffen", "Prof", "Puste", "Sachverst\u00e4ndiger", "Sankt", "Scheine", "Schei\u00dfe", "Schuft", "Schufte", "Schuld", "Schw\u00e4rme", "Schwarzes", "Sie", "Spitz", "St", "Stereotyp", "St\u00f6re", "Tausend", "Toter", "tun", "\u00dcbrigen", "Unvorhergesehenes", "Verantwortlicher", "Verwandter", "Vielfaches", "Vorsitzender", "Fraktionsvorsitzender", "Weitem", "Weiteres", "Wicht", "Wichtiges", "Wider", "Wild", "Zeche", "Zusage", "Zwinge", "Terti\u00e4r", "Erster", "Zweiter", "Dritter", "Vierter", "F\u00fcnfter", "Sechster", "Siebter", "Achter", "Neunter", "Erste", "Zweite", "Dritte", "Vierte", "F\u00fcnfte", "Sechste", "Siebte", "Achte", "Neunte", "Dein", "Deine", "Deinem", "Deinen", "Deiner", "Deines", "Dich", "Dir", "Du", "Euch", "Euer", "Eure", "Eurem", "Euren", "Eures"));
        languages = new HashSet<String>();
        languages.add("Afrikanisch");
        languages.add("Altarabisch");
        languages.add("Altchinesisch");
        languages.add("Altgriechisch");
        languages.add("Althochdeutsch");
        languages.add("Altpersisch");
        languages.add("Amerikanisch");
        languages.add("Arabisch");
        languages.add("Chinesisch");
        languages.add("D\u00e4nisch");
        languages.add("Deutsch");
        languages.add("Englisch");
        languages.add("Finnisch");
        languages.add("Franz\u00f6sisch");
        languages.add("Fr\u00fchneuhochdeutsch");
        languages.add("Germanisch");
        languages.add("Griechisch");
        languages.add("Hocharabisch");
        languages.add("Hochchinesisch");
        languages.add("Hochdeutsch");
        languages.add("Holl\u00e4ndisch");
        languages.add("Italienisch");
        languages.add("Japanisch");
        languages.add("Jiddisch");
        languages.add("Jugoslawisch");
        languages.add("Koreanisch");
        languages.add("Kroatisch");
        languages.add("Lateinisch");
        languages.add("Luxemburgisch");
        languages.add("Mittelhochdeutsch");
        languages.add("Neuhochdeutsch");
        languages.add("Niederl\u00e4ndisch");
        languages.add("Norwegisch");
        languages.add("Persisch");
        languages.add("Polnisch");
        languages.add("Portugiesisch");
        languages.add("Russisch");
        languages.add("Schwedisch");
        languages.add("Schweizerisch");
        languages.add("Serbisch");
        languages.add("Serbokroatisch");
        languages.add("Slawisch");
        languages.add("Spanisch");
        languages.add("Tschechisch");
        languages.add("T\u00fcrkisch");
        languages.add("Ukrainisch");
        languages.add("Ungarisch");
        languages.add("Wei\u00dfrussisch");
        myExceptionPhrases = new HashSet<String>();
        myExceptionPhrases.add("Gleicher unter Gleichen");
        myExceptionPhrases.add("Jung und Alt");
        myExceptionPhrases.add("Arabische Halbinsel");
        myExceptionPhrases.add("Arabischen Halbinsel");
        myExceptionPhrases.add("Naher Osten");
        myExceptionPhrases.add("Nahen Osten");
        myExceptionPhrases.add("Mittlerer Osten");
        myExceptionPhrases.add("Mittleren Osten");
        myExceptionPhrases.add("Ferne Osten");
        myExceptionPhrases.add("Fernen Osten");
        myExceptionPhrases.add("Ferner Osten");
        myExceptionPhrases.add("Europ\u00e4ische Union");
        myExceptionPhrases.add("Europ\u00e4ischen Union");
        myExceptionPhrases.add("Russische F\u00f6deration");
        myExceptionPhrases.add("Russischen F\u00f6deration");
        myExceptionPhrases.add("Internationaler W\u00e4hrungsfonds");
        myExceptionPhrases.add("Internationale W\u00e4hrungsfonds");
        myExceptionPhrases.add("Internationalen W\u00e4hrungsfonds");
        myExceptionPhrases.add("Japanische Meer");
        myExceptionPhrases.add("Japanisches Meer");
        myExceptionPhrases.add("Japanischen Meer");
        myExceptionPhrases.add("Japanische Alpen");
        myExceptionPhrases.add("Japanischen Alpen");
        myExceptionPhrases.add("Chinesische Mauer");
        myExceptionPhrases.add("Chinesischen Mauer");
        myExceptionPhrases.add("Franz\u00f6sische Revolution");
        myExceptionPhrases.add("Franz\u00f6sischen Revolution");
        myExceptionPhrases.add("S\u00fcddeutsche Zeitung");
        myExceptionPhrases.add("S\u00fcddeutschen Zeitung");
        myExceptionPhrases.add("nichts Wichtigeres");
        myExceptionPhrases.add("nichts Sch\u00f6neres");
        myExceptionPhrases.add("ohne Wenn und Aber");
        myExceptionPhrases.add("Gro\u00dfe Koalition");
        myExceptionPhrases.add("Gro\u00dfen Koalition");
        myExceptionPhrases.add("Alexander der Gro\u00dfe");
        myExceptionPhrases.add("Gro\u00dfer B\u00e4r");
        myExceptionPhrases.add("Gro\u00dfe B\u00e4r");
        myExceptionPhrases.add("im Gro\u00dfen und Ganzen");
        myExceptionPhrases.add("Im Gro\u00dfen und Ganzen");
        myExceptionPhrases.add("im Guten wie im Schlechten");
        myExceptionPhrases.add("Im Guten wie im Schlechten");
        myExceptionPhrases.add("Russisches Reich");
        myExceptionPhrases.add("Russischen Reich");
        myExceptionPhrases.add("Russischen Reichs");
        myExceptionPhrases.add("Russischen Reiches");
        myExceptionPhrases.add("Tel Aviv");
        myExceptionPhrases.add("Drei\u00dfigj\u00e4hrige Krieg");
        myExceptionPhrases.add("Drei\u00dfigj\u00e4hrigen Kriegs");
        myExceptionPhrases.add("Drei\u00dfigj\u00e4hrigen Krieges");
        myExceptionPhrases.add("Erster Weltkrieg");
        myExceptionPhrases.add("Ersten Weltkriegs");
        myExceptionPhrases.add("Ersten Weltkrieg");
        myExceptionPhrases.add("Ersten Weltkrieges");
        myExceptionPhrases.add("Erstem Weltkrieg");
        myExceptionPhrases.add("Zweiter Weltkrieg");
        myExceptionPhrases.add("Zweiten Weltkrieg");
        myExceptionPhrases.add("Zweiten Weltkriegs");
        myExceptionPhrases.add("Zweiten Weltkrieges");
        myExceptionPhrases.add("Zweitem Weltkrieg");
        myExceptionPhrases.add("Vielfaches");
        myExceptionPhrases.add("Ausw\u00e4rtiges Amt");
        myExceptionPhrases.add("Ausw\u00e4rtigen Amt");
        myExceptionPhrases.add("Ausw\u00e4rtigen Amts");
        myExceptionPhrases.add("Ausw\u00e4rtigen Amtes");
        myExceptionPhrases.add("B\u00fcrgerliches Gesetzbuch");
        myExceptionPhrases.add("B\u00fcrgerlichen Gesetzbuch");
        myExceptionPhrases.add("B\u00fcrgerlichen Gesetzbuchs");
        myExceptionPhrases.add("B\u00fcrgerlichen Gesetzbuches");
        myExceptionPhrases.add("Haute Couture");
        myExceptionPhrases.add("aus dem Nichts");
        myExceptionPhrases.add("Kleiner B\u00e4r");
        myExceptionPhrases.add("Zehn Gebote");
        myExceptionPhrases.add("Heiliges R\u00f6misches Reich");
        myExceptionPhrases.add("Heilige R\u00f6mische Reich");
        myExceptionPhrases.add("R\u00f6mische Reich Deutscher Nation");
        myExceptionPhrases.add("ein absolutes Muss");
        myExceptionPhrases.add("ein Muss");
        myExceptionPhrases.add("nichts Neues");
        myExceptionPhrases.add("etwas Neues");
        myExceptionPhrases.add("kaum Neues");
        myExceptionPhrases.add("wenig Neues");
        myExceptionPhrases.add("viel Neues");
        myExceptionPhrases.add("Vereinigte Staaten");
        myExceptionPhrases.add("Vereinigten Staaten");
        myExceptionPhrases.add("Vereinten Nationen");
        myExceptionPhrases.add("im Weiteren");
        myExceptionPhrases.add("Im Weiteren");
        myExceptionPhrases.add("Roter Riese");
        myExceptionPhrases.add("Roten Riesen");
        myExceptionPhrases.add("als Erstes");
        myExceptionPhrases.add("Als Erstes");
        myExceptionPhrases.add("Pazifische Ozean");
        myExceptionPhrases.add("Pazifischer Ozean");
        myExceptionPhrases.add("Pazifischen Ozeans");
        myExceptionPhrases.add("Pazifischen Ozean");
        myExceptionPhrases.add("Atlantische Ozean");
        myExceptionPhrases.add("Atlantischer Ozean");
        myExceptionPhrases.add("Atlantischen Ozeans");
        myExceptionPhrases.add("Atlantischen Ozean");
        myExceptionPhrases.add("Indische Ozean");
        myExceptionPhrases.add("Indischer Ozean");
        myExceptionPhrases.add("Indischen Ozeans");
        myExceptionPhrases.add("Indischen Ozean");
        myExceptionPhrases.add("Arktische Ozean");
        myExceptionPhrases.add("Arktischer Ozean");
        myExceptionPhrases.add("Arktische Ozeans");
        myExceptionPhrases.add("Arktischen Ozean");
        myExceptionPhrases.add("Oberster Gerichtshof");
        myExceptionPhrases.add("Oberste Gerichtshof");
        myExceptionPhrases.add("Obersten Gerichtshof");
        myExceptionPhrases.add("Obersten Gerichtshofs");
        myExceptionPhrases.add("Rote Karte");
        myExceptionPhrases.add("Roten Karte");
        myExceptionPhrases.add("Roten Karten");
        myExceptionPhrases.add("Gelbe Karte");
        myExceptionPhrases.add("Gelben Karte");
        myExceptionPhrases.add("Gelben Karten");
        myExceptionPhrases.add("Rote Kreuz");
        myExceptionPhrases.add("Rotes Kreuz");
        myExceptionPhrases.add("Roten Kreuz");
        myExceptionPhrases.add("Roten Kreuzes");
        myExceptionPhrases.add("Kalte Krieg");
        myExceptionPhrases.add("Kalter Krieg");
        myExceptionPhrases.add("Kalten Krieg");
        myExceptionPhrases.add("Kalten Krieges");
        myExceptionPhrases.add("Vereinigtes K\u00f6nigreich");
        myExceptionPhrases.add("Vereinigte K\u00f6nigreich");
        myExceptionPhrases.add("Vereinigten K\u00f6nigreich");
        myExceptionPhrases.add("Vereinigten K\u00f6nigreichs");
        myExceptionPhrases.add("Vereinigten K\u00f6nigreiches");
        myExceptionPhrases.add("Olympische Spiele");
        myExceptionPhrases.add("Olympischen Spiele");
        myExceptionPhrases.add("Olympischen Spielen");
        myExceptionPhrases.add("S\u00e4chsischer Schweiz");
        myExceptionPhrases.add("S\u00e4chsische Schweiz");
        myExceptionPhrases.add("S\u00e4chsischen Schweiz");
        myExceptionPhrases.add("Europ\u00e4ische Gemeinschaft");
        myExceptionPhrases.add("Europ\u00e4ischer Gemeinschaft");
        myExceptionPhrases.add("Europ\u00e4ischen Gemeinschaft");
        myExceptionPhrases.add("Dritte Welt");
        myExceptionPhrases.add("Dritten Welt");
        myExceptionPhrases.add("R\u00f6misches Reich");
        myExceptionPhrases.add("R\u00f6mischen Reich");
        myExceptionPhrases.add("R\u00f6mischen Reichs");
        myExceptionPhrases.add("R\u00f6mischen Reiches");
        substVerbenExceptions = new HashSet<String>();
        substVerbenExceptions.add("hinziehen");
        substVerbenExceptions.add("helfen");
        substVerbenExceptions.add("lassen");
        substVerbenExceptions.add("passieren");
        substVerbenExceptions.add("machen");
        substVerbenExceptions.add("haben");
        substVerbenExceptions.add("passiert");
        substVerbenExceptions.add("beschr\u00e4nkt");
        substVerbenExceptions.add("wiederholt");
        substVerbenExceptions.add("scheinen");
        substVerbenExceptions.add("klar");
        substVerbenExceptions.add("hei\u00dfen");
        substVerbenExceptions.add("einen");
        substVerbenExceptions.add("geh\u00f6ren");
        substVerbenExceptions.add("bedeutet");
        substVerbenExceptions.add("erm\u00f6glicht");
        substVerbenExceptions.add("funktioniert");
        substVerbenExceptions.add("sollen");
        substVerbenExceptions.add("werden");
        substVerbenExceptions.add("d\u00fcrfen");
        substVerbenExceptions.add("m\u00fcssen");
        substVerbenExceptions.add("so");
        substVerbenExceptions.add("ist");
        substVerbenExceptions.add("k\u00f6nnen");
        substVerbenExceptions.add("mein");
        substVerbenExceptions.add("sein");
        substVerbenExceptions.add("muss");
        substVerbenExceptions.add("mu\u00df");
        substVerbenExceptions.add("wollen");
        substVerbenExceptions.add("habe");
        substVerbenExceptions.add("ein");
        substVerbenExceptions.add("tun");
        substVerbenExceptions.add("best\u00e4tigt");
        substVerbenExceptions.add("best\u00e4tigte");
        substVerbenExceptions.add("best\u00e4tigten");
        substVerbenExceptions.add("bekommen");
        substVerbenExceptions.add("sauer");
    }
}

