/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.tagging.BaseTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanTagger
extends BaseTagger {
    private GermanCompoundTokenizer compoundTokenizer;

    public String getFileName() {
        return "/de/german.dict";
    }

    public String getManualAdditionsFileName() {
        return "/de/added.txt";
    }

    public AnalyzedTokenReadings lookup(String word) throws IOException {
        List<AnalyzedTokenReadings> result = this.tag(Collections.singletonList(word), false);
        AnalyzedTokenReadings atr = result.get(0);
        if (atr.getAnalyzedToken(0).getPOSTag() == null) {
            return null;
        }
        return atr;
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        return this.tag(sentenceTokens, true);
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens, boolean ignoreCase) throws IOException {
        this.initializeIfRequired();
        boolean firstWord = true;
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
            List taggerTokens = this.getWordTagger().tag(word);
            if (firstWord && taggerTokens.size() == 0 && ignoreCase) {
                taggerTokens = this.getWordTagger().tag(word.toLowerCase());
                firstWord = false;
            }
            if (taggerTokens.size() > 0) {
                l.addAll(this.getAnalyzedTokens(taggerTokens, word));
            } else if (!StringTools.isEmpty((String)word.trim())) {
                List<String> compoundParts = this.compoundTokenizer.tokenize(word);
                if (compoundParts.size() <= 1) {
                    l.add(this.getNoInfoToken(word));
                } else {
                    List partTaggerTokens;
                    String lastPart = compoundParts.get(compoundParts.size() - 1);
                    if (StringTools.startsWithUppercase((String)word)) {
                        lastPart = StringTools.uppercaseFirstChar((String)lastPart);
                    }
                    if ((partTaggerTokens = this.getWordTagger().tag(lastPart)).size() > 0) {
                        l.addAll(this.getAnalyzedTokens(partTaggerTokens, word, compoundParts));
                    } else {
                        l.add(this.getNoInfoToken(word));
                    }
                }
            } else {
                l.add(this.getNoInfoToken(word));
            }
            tokenReadings.add(new AnalyzedTokenReadings(l.toArray(new AnalyzedToken[l.size()]), pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private synchronized void initializeIfRequired() throws IOException {
        if (this.compoundTokenizer == null) {
            this.compoundTokenizer = new GermanCompoundTokenizer();
        }
    }

    private AnalyzedToken getNoInfoToken(String word) {
        return new AnalyzedToken(word, null, null);
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), taggedWord.getLemma()));
        }
        return result;
    }

    private List<AnalyzedToken> getAnalyzedTokens(List<TaggedWord> taggedWords, String word, List<String> compoundParts) {
        ArrayList<AnalyzedToken> result = new ArrayList<AnalyzedToken>();
        for (TaggedWord taggedWord : taggedWords) {
            List<String> allButLastPart = compoundParts.subList(0, compoundParts.size() - 1);
            String lemma = StringTools.listToString(allButLastPart, (String)"") + StringTools.lowercaseFirstChar((String)taggedWord.getLemma());
            result.add(new AnalyzedToken(word, taggedWord.getPosTag(), lemma));
        }
        return result;
    }
}

