/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.German;
import org.languagetool.rules.Category;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.AgreementSuggestor;
import org.languagetool.rules.de.GermanHelper;
import org.languagetool.rules.de.GermanRule;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.de.GermanToken;
import org.languagetool.tools.StringTools;

public class AgreementRule
extends GermanRule {
    private final German language;
    private static final String[] ADJ_READINGS = new String[]{"ADJ:NOM:SIN:MAS:GRU", "ADJ:NOM:SIN:NEU:GRU", "ADJ:NOM:SIN:FEM:GRU", "ADJ:GEN:SIN:MAS:GRU", "ADJ:GEN:SIN:NEU:GRU", "ADJ:GEN:SIN:FEM:GRU", "ADJ:DAT:SIN:MAS:GRU", "ADJ:DAT:SIN:NEU:GRU", "ADJ:DAT:SIN:FEM:GRU", "ADJ:AKK:SIN:MAS:GRU", "ADJ:AKK:SIN:NEU:GRU", "ADJ:AKK:SIN:FEM:GRU", "ADJ:NOM:PLU:MAS:GRU", "ADJ:NOM:PLU:NEU:GRU", "ADJ:NOM:PLU:FEM:GRU", "ADJ:GEN:PLU:MAS:GRU", "ADJ:GEN:PLU:NEU:GRU", "ADJ:GEN:PLU:FEM:GRU", "ADJ:DAT:PLU:MAS:GRU", "ADJ:DAT:PLU:NEU:GRU", "ADJ:DAT:PLU:FEM:GRU", "ADJ:AKK:PLU:MAS:GRU", "ADJ:AKK:PLU:NEU:GRU", "ADJ:AKK:PLU:FEM:GRU"};
    private static final Set<String> ER_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("Alter", "Kinder", "Rinder"));
    private static final Set<String> VIELE_WENIGE_LOWERCASE = new HashSet<String>(Arrays.asList("viele", "vieler", "wenige", "weniger", "einige", "einiger", "mehrerer", "mehrere"));
    private static final Set<String> REL_PRONOUN = new HashSet<String>();
    private static final Set<String> PREPOSITIONS;
    private static final Set<String> PRONOUNS_TO_BE_IGNORED;
    private static final Set<String> NOUNS_TO_BE_IGNORED;

    public AgreementRule(ResourceBundle messages, German language) {
        this.language = language;
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_grammar")));
        }
        this.addExamplePair(Example.wrong((String)"<marker>Der Haus</marker> wurde letztes Jahr gebaut."), Example.fixed((String)"<marker>Das Haus</marker> wurde letztes Jahr gebaut"));
    }

    public String getId() {
        return "DE_AGREEMENT";
    }

    public String getDescription() {
        return "Kongruenz von Nominalphrasen (unvollst\u00e4ndig!), z.B. 'mein kleiner(kleines) Haus'";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 0; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            boolean followingParticiple;
            String posToken = tokens[i].getAnalyzedToken(0).getPOSTag();
            if (posToken != null && posToken.equals("SENT_START")) continue;
            AnalyzedTokenReadings tokenReadings = tokens[i];
            boolean relevantPronoun = this.isRelevantPronoun(tokens, i);
            boolean ignore = this.couldBeRelativeClause(tokens, i);
            if (i > 0) {
                String prevToken = tokens[i - 1].getToken().toLowerCase();
                if ((tokens[i].getToken().equals("eine") || tokens[i].getToken().equals("einen")) && (prevToken.equals("der") || prevToken.equals("die") || prevToken.equals("das") || prevToken.equals("des") || prevToken.equals("dieses"))) {
                    ignore = true;
                }
            }
            if (tokenReadings.getToken().equals("nichts") || tokenReadings.getToken().equals("alles") || tokenReadings.getToken().equals("dies")) {
                ignore = true;
            }
            boolean detAbbrev = i < tokens.length - 2 && tokens[i + 1].getToken().equals("Art") && tokens[i + 2].getToken().equals(".");
            boolean detAdjAbbrev = i < tokens.length - 3 && tokens[i + 2].getToken().equals("Art") && tokens[i + 3].getToken().equals(".");
            boolean bl = followingParticiple = i < tokens.length - 3 && tokens[i + 2].hasPartialPosTag("PA1");
            if (detAbbrev || detAdjAbbrev || followingParticiple) {
                ignore = true;
            }
            if (!GermanHelper.hasReadingOfType(tokenReadings, GermanToken.POSType.DETERMINER) && !relevantPronoun || ignore) continue;
            int tokenPos = i + 1;
            if (tokenPos >= tokens.length) break;
            AnalyzedTokenReadings nextToken = tokens[tokenPos];
            if (this.isNonPredicativeAdjective(nextToken = this.maybeAddAdjectiveReadings(nextToken, tokens, tokenPos)) || this.isParticiple(nextToken)) {
                tokenPos = i + 2;
                if (tokenPos >= tokens.length) break;
                if (!GermanHelper.hasReadingOfType(tokens[tokenPos], GermanToken.POSType.NOMEN) || i >= 2 && GermanHelper.hasReadingOfType(tokens[i - 2], GermanToken.POSType.ADJEKTIV) && "als".equals(tokens[i - 1].getToken()) && "das".equals(tokens[i].getToken()) || (ruleMatch = this.checkDetAdjNounAgreement(tokens[i], nextToken, tokens[i + 2])) == null) continue;
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!GermanHelper.hasReadingOfType(nextToken, GermanToken.POSType.NOMEN) || (ruleMatch = this.checkDetNounAgreement(tokens[i], tokens[i + 1])) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean isNonPredicativeAdjective(AnalyzedTokenReadings tokensReadings) {
        for (AnalyzedToken reading : tokensReadings.getReadings()) {
            AnalyzedGermanToken germanReading = new AnalyzedGermanToken(reading);
            if (germanReading.getType() != GermanToken.POSType.ADJEKTIV || germanReading.getPOSTag().contains("PRD")) continue;
            return true;
        }
        return false;
    }

    private boolean isParticiple(AnalyzedTokenReadings tokensReadings) {
        for (AnalyzedToken reading : tokensReadings.getReadings()) {
            AnalyzedGermanToken germanReading = new AnalyzedGermanToken(reading);
            if (germanReading.getType() != GermanToken.POSType.PARTIZIP) continue;
            return true;
        }
        return false;
    }

    private boolean isRelevantPronoun(AnalyzedTokenReadings[] tokens, int pos) {
        AnalyzedTokenReadings analyzedToken = tokens[pos];
        boolean relevantPronoun = GermanHelper.hasReadingOfType(analyzedToken, GermanToken.POSType.PRONOMEN);
        String token = tokens[pos].getToken();
        if (pos > 0 && tokens[pos - 1].getToken().equalsIgnoreCase("vor") && tokens[pos].getToken().equalsIgnoreCase("allem")) {
            relevantPronoun = false;
        } else if (PRONOUNS_TO_BE_IGNORED.contains(token.toLowerCase())) {
            relevantPronoun = false;
        }
        return relevantPronoun;
    }

    private AnalyzedTokenReadings maybeAddAdjectiveReadings(AnalyzedTokenReadings nextToken, AnalyzedTokenReadings[] tokens, int tokenPos) {
        String nextTerm = nextToken.getToken();
        if (nextTerm.endsWith("er") && tokens.length > tokenPos + 1 && !ER_TO_BE_IGNORED.contains(nextTerm)) {
            AnalyzedTokenReadings nextNextToken = tokens[tokenPos + 1];
            GermanTagger tagger = (GermanTagger)this.language.getTagger();
            try {
                AnalyzedTokenReadings nextATR = tagger.lookup(nextTerm.substring(0, nextTerm.length() - 2));
                AnalyzedTokenReadings nextNextATR = tagger.lookup(nextNextToken.getToken());
                if ("M\u00fcnchner".equals(nextTerm) || nextATR != null && (GermanHelper.hasReadingOfType(nextATR, GermanToken.POSType.PROPER_NOUN) || GermanHelper.hasReadingOfType(nextATR, GermanToken.POSType.NOMEN) && nextNextATR != null && GermanHelper.hasReadingOfType(nextNextATR, GermanToken.POSType.NOMEN))) {
                    AnalyzedToken[] adjReadings = new AnalyzedToken[ADJ_READINGS.length];
                    for (int j = 0; j < ADJ_READINGS.length; ++j) {
                        adjReadings[j] = new AnalyzedToken(nextTerm, ADJ_READINGS[j], null);
                    }
                    nextToken = new AnalyzedTokenReadings(adjReadings, nextToken.getStartPos());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return nextToken;
    }

    private boolean couldBeRelativeClause(AnalyzedTokenReadings[] tokens, int pos) {
        boolean relPronoun;
        boolean comma;
        if (pos >= 1) {
            comma = tokens[pos - 1].getToken().equals(",");
            String term = tokens[pos].getToken().toLowerCase();
            relPronoun = REL_PRONOUN.contains(term);
            if (comma && relPronoun) {
                return true;
            }
        }
        if (pos >= 2) {
            comma = tokens[pos - 2].getToken().equals(",");
            String term1 = tokens[pos - 1].getToken().toLowerCase();
            String term2 = tokens[pos].getToken().toLowerCase();
            boolean prep = PREPOSITIONS.contains(term1);
            relPronoun = REL_PRONOUN.contains(term2);
            return comma && prep && relPronoun;
        }
        return false;
    }

    private RuleMatch checkDetNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        if (NOUNS_TO_BE_IGNORED.contains(token2.getToken())) {
            return null;
        }
        Set<String> set1 = this.getAgreementCategories(token1);
        if (set1 == null) {
            return null;
        }
        Set<String> set2 = this.getAgreementCategories(token2);
        if (set2 == null) {
            return null;
        }
        set1.retainAll(set2);
        RuleMatch ruleMatch = null;
        if (set1.size() == 0 && !this.isException(token1, token2)) {
            List<String> errorCategories = this.getCategoriesCausingError(token1, token2);
            String errorDetails = errorCategories.size() > 0 ? StringTools.listToString(errorCategories, (String)" und ") : "Kasus, Genus oder Numerus";
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel und Nomen bez\u00fcglich " + errorDetails + ".";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich " + errorDetails;
            ruleMatch = new RuleMatch((Rule)this, token1.getStartPos(), token2.getStartPos() + token2.getToken().length(), msg, shortMsg);
            AgreementSuggestor suggestor = new AgreementSuggestor(this.language.getSynthesizer(), token1, token2);
            List<String> suggestions = suggestor.getSuggestions();
            ruleMatch.setSuggestedReplacements(suggestions);
        }
        return ruleMatch;
    }

    private boolean isException(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        String phrase = token1.getToken() + " " + token2.getToken();
        return "allen Grund".equals(phrase);
    }

    private List<String> getCategoriesCausingError(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2) {
        ArrayList<String> categories = new ArrayList<String>();
        List<GrammarCategory> categoriesToCheck = Arrays.asList(GrammarCategory.KASUS, GrammarCategory.GENUS, GrammarCategory.NUMERUS);
        for (GrammarCategory category : categoriesToCheck) {
            if (!this.agreementWithCategoryRelaxation(token1, token2, category)) continue;
            categories.add(category.displayName);
        }
        return categories;
    }

    private RuleMatch checkDetAdjNounAgreement(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3) {
        Set<String> set = this.retainCommonCategories(token1, token2, token3, null);
        RuleMatch ruleMatch = null;
        if (set.size() == 0) {
            String msg = "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel, Adjektiv und Nomen bez\u00fcglich Kasus, Numerus oder Genus. Beispiel: 'mein kleiner Haus' statt 'mein kleines Haus'";
            String shortMsg = "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich Kasus, Numerus oder Genus";
            ruleMatch = new RuleMatch((Rule)this, token1.getStartPos(), token3.getStartPos() + token3.getToken().length(), "M\u00f6glicherweise fehlende grammatische \u00dcbereinstimmung zwischen Artikel, Adjektiv und Nomen bez\u00fcglich Kasus, Numerus oder Genus. Beispiel: 'mein kleiner Haus' statt 'mein kleines Haus'", "M\u00f6glicherweise keine \u00dcbereinstimmung bez\u00fcglich Kasus, Numerus oder Genus");
        }
        return ruleMatch;
    }

    private boolean agreementWithCategoryRelaxation(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, GrammarCategory categoryToRelax) {
        Set<GrammarCategory> categoryToRelaxSet = categoryToRelax != null ? Collections.singleton(categoryToRelax) : Collections.emptySet();
        Set<String> set1 = this.getAgreementCategories(token1, categoryToRelaxSet, true);
        if (set1 == null) {
            return true;
        }
        Set<String> set2 = this.getAgreementCategories(token2, categoryToRelaxSet, true);
        if (set2 == null) {
            return true;
        }
        set1.retainAll(set2);
        return set1.size() > 0;
    }

    private Set<String> retainCommonCategories(AnalyzedTokenReadings token1, AnalyzedTokenReadings token2, AnalyzedTokenReadings token3, GrammarCategory categoryToRelax) {
        Set<GrammarCategory> categoryToRelaxSet = categoryToRelax == null ? Collections.singleton(categoryToRelax) : Collections.emptySet();
        Set<String> set1 = this.getAgreementCategories(token1, categoryToRelaxSet, true);
        if (set1 == null) {
            return null;
        }
        boolean skipSol = !VIELE_WENIGE_LOWERCASE.contains(token1.getToken().toLowerCase());
        Set<String> set2 = this.getAgreementCategories(token2, categoryToRelaxSet, skipSol);
        if (set2 == null) {
            return null;
        }
        Set<String> set3 = this.getAgreementCategories(token3, categoryToRelaxSet, true);
        if (set3 == null) {
            return null;
        }
        set1.retainAll(set2);
        set1.retainAll(set3);
        return set1;
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken) {
        return this.getAgreementCategories(aToken, new HashSet<GrammarCategory>(), false);
    }

    private Set<String> getAgreementCategories(AnalyzedTokenReadings aToken, Set<GrammarCategory> omit, boolean skipSol) {
        HashSet<String> set = new HashSet<String>();
        List readings = aToken.getReadings();
        for (AnalyzedToken tmpReading : readings) {
            AnalyzedGermanToken reading;
            if (skipSol && tmpReading.getPOSTag() != null && tmpReading.getPOSTag().endsWith(":SOL") || (reading = new AnalyzedGermanToken(tmpReading)).getCasus() == null && reading.getNumerus() == null && reading.getGenus() == null) continue;
            if (reading.getGenus() == GermanToken.Genus.ALLGEMEIN && reading.getPOSTag() != null && !reading.getPOSTag().endsWith(":STV")) {
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.MASKULINUM, omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.FEMININUM, omit));
                set.add(this.makeString(reading.getCasus(), reading.getNumerus(), GermanToken.Genus.NEUTRUM, omit));
                continue;
            }
            set.add(this.makeString(reading.getCasus(), reading.getNumerus(), reading.getGenus(), omit));
        }
        return set;
    }

    private String makeString(GermanToken.Kasus casus, GermanToken.Numerus num, GermanToken.Genus gen, Set<GrammarCategory> omit) {
        ArrayList<String> l = new ArrayList<String>();
        if (casus != null && !omit.contains((Object)GrammarCategory.KASUS)) {
            l.add(casus.toString());
        }
        if (num != null && !omit.contains((Object)GrammarCategory.NUMERUS)) {
            l.add(num.toString());
        }
        if (gen != null && !omit.contains((Object)GrammarCategory.GENUS)) {
            l.add(gen.toString());
        }
        return StringTools.listToString(l, (String)"/");
    }

    public void reset() {
    }

    static {
        REL_PRONOUN.add("der");
        REL_PRONOUN.add("die");
        REL_PRONOUN.add("das");
        REL_PRONOUN.add("dessen");
        REL_PRONOUN.add("deren");
        REL_PRONOUN.add("dem");
        REL_PRONOUN.add("den");
        REL_PRONOUN.add("denen");
        REL_PRONOUN.add("welche");
        REL_PRONOUN.add("welcher");
        REL_PRONOUN.add("welchen");
        REL_PRONOUN.add("welchem");
        REL_PRONOUN.add("welches");
        PREPOSITIONS = new HashSet<String>();
        PREPOSITIONS.add("in");
        PREPOSITIONS.add("auf");
        PREPOSITIONS.add("an");
        PREPOSITIONS.add("ab");
        PREPOSITIONS.add("f\u00fcr");
        PREPOSITIONS.add("zu");
        PREPOSITIONS.add("bei");
        PREPOSITIONS.add("nach");
        PREPOSITIONS.add("\u00fcber");
        PREPOSITIONS.add("von");
        PREPOSITIONS.add("mit");
        PREPOSITIONS.add("durch");
        PRONOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("ich", "dir", "du", "er", "sie", "es", "wir", "mir", "uns", "ihnen", "euch", "ihm", "ihr", "ihn", "dessen", "deren", "denen", "sich", "unser", "aller", "man", "beide", "beiden", "beider", "wessen", "a", "alle", "etwas", "was", "wer", "jenen", "diejenigen", "jemand", "niemand"));
        NOUNS_TO_BE_IGNORED = new HashSet<String>(Arrays.asList("Prozent", "Gramm", "Kilogramm", "Uhr"));
    }

    private static enum GrammarCategory {
        KASUS("Kasus (Fall: Wer/Was, Wessen, Wem, Wen/Was - Beispiel: 'das Fahrrads' statt 'des Fahrrads')"),
        GENUS("Genus (m\u00e4nnlich, weiblich, s\u00e4chlich - Beispiel: 'der Fahrrad' statt 'das Fahrrad')"),
        NUMERUS("Numerus (Einzahl, Mehrzahl - Beispiel: 'das Fahrr\u00e4der' statt 'die Fahrr\u00e4der')");

        private final String displayName;

        private GrammarCategory(String displayName) {
            this.displayName = displayName;
        }
    }
}

