/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import de.abelssoft.wordtools.jwordsplitter.AbstractWordSplitter;
import de.abelssoft.wordtools.jwordsplitter.impl.GermanWordSplitter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.CaseRule;
import org.languagetool.rules.de.CompoundRule;
import org.languagetool.rules.de.DashRule;
import org.languagetool.rules.de.GermanDoublePunctuationRule;
import org.languagetool.rules.de.GermanWordRepeatBeginningRule;
import org.languagetool.rules.de.GermanWordRepeatRule;
import org.languagetool.rules.de.GermanWrongWordInContextRule;
import org.languagetool.rules.de.MissingVerbRule;
import org.languagetool.rules.de.VerbAgreementRule;
import org.languagetool.rules.de.WiederVsWiderRule;
import org.languagetool.rules.de.WordCoherencyRule;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.de.GermanRuleDisambiguator;
import org.languagetool.tokenizers.CompoundWordTokenizer;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;

public class German
extends Language {
    private Tagger tagger;
    private Synthesizer synthesizer;
    private SentenceTokenizer sentenceTokenizer;
    private Disambiguator disambiguator;
    private String name = "German";
    private CompoundWordTokenizer compoundTokenizer;
    private GermanCompoundTokenizer strictCompoundTokenizer;

    public Language getDefaultLanguageVariant() {
        return new GermanyGerman();
    }

    public final Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new GermanRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "de";
    }

    public String[] getCountries() {
        return new String[]{"LU", "LI", "BE"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\u201e", "\u00bb", "\u00ab"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\u201c", "\u00ab", "\u00bb"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tagger getTagger() {
        Tagger t = this.tagger;
        if (t == null) {
            German german = this;
            synchronized (german) {
                t = this.tagger;
                if (t == null) {
                    this.tagger = t = new GermanTagger();
                }
            }
        }
        return t;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new GermanSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jan Schreiber"), new Contributor("Markus Brenneis"), Contributors.DANIEL_NABER};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages), new GenericUnpairedBracketsRule(messages, (Language)this), new UppercaseSentenceStartRule(messages, (Language)this), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new GermanDoublePunctuationRule(messages), new MissingVerbRule(messages, this), new GermanWordRepeatRule(messages, this), new GermanWordRepeatBeginningRule(messages, this), new GermanWrongWordInContextRule(messages), new AgreementRule(messages, this), new CaseRule(messages, this), new CompoundRule(messages), new DashRule(messages), new VerbAgreementRule(messages, this), new WordCoherencyRule(messages), new WiederVsWiderRule(messages)});
    }

    public CompoundWordTokenizer getNonStrictCompoundSplitter() {
        if (this.compoundTokenizer == null) {
            try {
                GermanWordSplitter wordSplitter = new GermanWordSplitter(false);
                wordSplitter.setStrictMode(false);
                wordSplitter.setMinimumWordLength(3);
                this.compoundTokenizer = new CompoundWordTokenizer((AbstractWordSplitter)wordSplitter){
                    final /* synthetic */ AbstractWordSplitter val$wordSplitter;
                    {
                        this.val$wordSplitter = abstractWordSplitter;
                    }

                    public List<String> tokenize(String word) {
                        return new ArrayList<String>(this.val$wordSplitter.splitWord(word));
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Could not set up German compound splitter", e);
            }
        }
        return this.compoundTokenizer;
    }

    public GermanCompoundTokenizer getStrictCompoundTokenizer() {
        if (this.strictCompoundTokenizer == null) {
            try {
                this.strictCompoundTokenizer = new GermanCompoundTokenizer();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not set up strict German compound splitter", e);
            }
        }
        return this.strictCompoundTokenizer;
    }
}

