/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.language.GermanyGerman;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.GenericUnpairedBracketsRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.de.AgreementRule;
import org.languagetool.rules.de.CaseRule;
import org.languagetool.rules.de.CompoundRule;
import org.languagetool.rules.de.DashRule;
import org.languagetool.rules.de.GermanDoublePunctuationRule;
import org.languagetool.rules.de.GermanWordRepeatBeginningRule;
import org.languagetool.rules.de.GermanWordRepeatRule;
import org.languagetool.rules.de.GermanWrongWordInContextRule;
import org.languagetool.rules.de.VerbAgreementRule;
import org.languagetool.rules.de.WiederVsWiderRule;
import org.languagetool.rules.de.WordCoherencyRule;
import org.languagetool.synthesis.GermanSynthesizer;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.GermanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.de.GermanRuleDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class German
extends Language {
    private volatile Tagger tagger;
    private Synthesizer synthesizer;
    private SentenceTokenizer sentenceTokenizer;
    private Disambiguator disambiguator;
    private String name = "German";

    public Language getDefaultLanguageVariant() {
        return new GermanyGerman();
    }

    public final Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new GermanRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return "de";
    }

    public String[] getCountries() {
        return new String[]{"LU", "LI", "BE"};
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\u201e", "\u00bb", "\u00ab"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\u201c", "\u00ab", "\u00bb"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tagger getTagger() {
        Tagger t = this.tagger;
        if (t == null) {
            German german = this;
            synchronized (german) {
                t = this.tagger;
                if (t == null) {
                    this.tagger = t = new GermanTagger();
                }
            }
        }
        return t;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new GermanSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Jan Schreiber"), new Contributor("Markus Brenneis"), Contributors.DANIEL_NABER};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, GermanDoublePunctuationRule.class, GenericUnpairedBracketsRule.class, UppercaseSentenceStartRule.class, WhitespaceRule.class, SentenceWhitespaceRule.class, GermanWordRepeatRule.class, GermanWordRepeatBeginningRule.class, GermanWrongWordInContextRule.class, AgreementRule.class, CaseRule.class, CompoundRule.class, DashRule.class, VerbAgreementRule.class, WordCoherencyRule.class, WiederVsWiderRule.class);
    }
}

