/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class GermanWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADVERBS = new HashSet<String>();

    public GermanWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong((String)"Dann hatten wir Freizeit. Dann gab es Essen. <marker>Dann</marker> gingen wir schlafen."), Example.fixed((String)"Dann hatten wir Freizeit. Danach gab es Essen. <marker>Schlie\u00dflich</marker> gingen wir schlafen."));
    }

    public String getId() {
        return "GERMAN_WORD_REPEAT_BEGINNING_RULE";
    }

    protected boolean isAdverb(AnalyzedTokenReadings token) {
        return ADVERBS.contains(token.getToken());
    }

    static {
        ADVERBS.add("Auch");
        ADVERBS.add("Anschlie\u00dfend");
        ADVERBS.add("Au\u00dferdem");
        ADVERBS.add("Danach");
        ADVERBS.add("Dar\u00fcberhinaus");
        ADVERBS.add("Ferner");
        ADVERBS.add("Nebenher");
        ADVERBS.add("Nebenbei");
        ADVERBS.add("\u00dcberdies");
        ADVERBS.add("Weiterf\u00fchrend");
        ADVERBS.add("Zudem");
        ADVERBS.add("Zus\u00e4tzlich");
    }
}

