/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.de.GermanRule;

public class WordCoherencyRule
extends GermanRule {
    private static final String FILE_NAME = "/de/coherency.txt";
    private static final String FILE_ENCODING = "utf-8";
    private final Map<String, String> relevantWords;
    private Map<String, RuleMatch> shouldNotAppearWord = new HashMap<String, RuleMatch>();

    public WordCoherencyRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.relevantWords = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(FILE_NAME));
    }

    public String getId() {
        return "DE_WORD_COHERENCY";
    }

    public String getDescription() {
        return "Einheitliche Schreibweise f\u00fcr W\u00f6rter mit mehr als einer korrekten Schreibweise";
    }

    public RuleMatch[] match(AnalyzedSentence text) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokens();
        int pos = 0;
        for (AnalyzedTokenReadings tmpToken : tokens) {
            String token = tmpToken.getToken();
            if (!tmpToken.isWhitespace()) {
                String baseform;
                String origToken = token;
                List readings = tmpToken.getReadings();
                if (readings != null && readings.size() > 0 && (baseform = ((AnalyzedToken)readings.get(0)).getLemma()) != null) {
                    token = baseform;
                }
                if (this.shouldNotAppearWord.containsKey(token)) {
                    RuleMatch otherMatch = this.shouldNotAppearWord.get(token);
                    String otherSpelling = otherMatch.getMessage();
                    String msg = "'" + token + "' und '" + otherSpelling + "' sollten nicht gleichzeitig benutzt werden";
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, pos, pos + origToken.length(), msg);
                    ruleMatch.setSuggestedReplacement(otherSpelling);
                    ruleMatches.add(ruleMatch);
                } else if (this.relevantWords.containsKey(token)) {
                    String shouldNotAppear = this.relevantWords.get(token);
                    RuleMatch potentialRuleMatch = new RuleMatch((Rule)this, pos, pos + origToken.length(), token);
                    this.shouldNotAppearWord.put(shouldNotAppear, potentialRuleMatch);
                }
            }
            pos += tmpToken.getToken().length();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private Map<String, String> loadWords(InputStream file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(file, FILE_ENCODING);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 2) {
                    throw new IOException("Format error in file " + JLanguageTool.getDataBroker().getFromRulesDirAsUrl(FILE_NAME) + ", line: " + line);
                }
                map.put(parts[0], parts[1]);
                map.put(parts[1], parts[0]);
            }
        }
        return map;
    }

    public void reset() {
        this.shouldNotAppearWord = new HashMap<String, RuleMatch>();
    }
}

