/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.de;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import morfologik.stemming.IStemmer;
import morfologik.stemming.WordData;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.de.AnalyzedGermanToken;
import org.languagetool.tokenizers.de.GermanCompoundTokenizer;
import org.languagetool.tools.StringTools;

public class GermanTagger
implements Tagger {
    private static final String DICT_FILENAME = "/de/german.dict";
    private static final String USER_DICT_FILENAME = "/de/added.txt";
    private Dictionary dictionary;
    private ManualTagger manualTagger;
    private GermanCompoundTokenizer compoundTokenizer;

    protected void initialize() throws IOException {
        URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(DICT_FILENAME);
        this.dictionary = Dictionary.read((URL)url);
        this.manualTagger = new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream(USER_DICT_FILENAME));
        this.compoundTokenizer = new GermanCompoundTokenizer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeIfRequired() throws IOException {
        if (this.dictionary == null || this.manualTagger == null || this.compoundTokenizer == null) {
            GermanTagger germanTagger = this;
            synchronized (germanTagger) {
                if (this.dictionary == null || this.manualTagger == null || this.compoundTokenizer == null) {
                    this.initialize();
                }
            }
        }
    }

    public AnalyzedTokenReadings lookup(String word) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        words.add(word);
        List<AnalyzedTokenReadings> result = this.tag(words, false);
        AnalyzedTokenReadings atr = result.get(0);
        if (atr.getAnalyzedToken(0).getPOSTag() == null) {
            return null;
        }
        return atr;
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens) throws IOException {
        return this.tag(sentenceTokens, true);
    }

    public List<AnalyzedTokenReadings> tag(List<String> sentenceTokens, boolean ignoreCase) throws IOException {
        this.initializeIfRequired();
        boolean firstWord = true;
        ArrayList<AnalyzedTokenReadings> tokenReadings = new ArrayList<AnalyzedTokenReadings>();
        int pos = 0;
        DictionaryLookup morfologik = new DictionaryLookup(this.dictionary);
        for (String word : sentenceTokens) {
            ArrayList<AnalyzedGermanToken> l = new ArrayList<AnalyzedGermanToken>();
            String[] taggerTokens = this.lexiconLookup(word, (IStemmer)morfologik);
            if (firstWord && taggerTokens == null && ignoreCase) {
                taggerTokens = this.lexiconLookup(word.toLowerCase(), (IStemmer)morfologik);
                firstWord = false;
            }
            if (taggerTokens != null) {
                this.tagWord(taggerTokens, word, l);
            } else if (!StringTools.isEmpty((String)word.trim())) {
                List<String> compoundParts = this.compoundTokenizer.tokenize(word);
                if (compoundParts.size() <= 1) {
                    l.add(new AnalyzedGermanToken(word, null, null));
                } else {
                    String lastPart = compoundParts.get(compoundParts.size() - 1);
                    if (StringTools.startsWithUppercase((String)word)) {
                        lastPart = StringTools.uppercaseFirstChar((String)lastPart);
                    }
                    if ((taggerTokens = this.lexiconLookup(lastPart, (IStemmer)morfologik)) != null) {
                        this.tagWord(taggerTokens, word, l, compoundParts);
                    } else {
                        l.add(new AnalyzedGermanToken(word, null, null));
                    }
                }
            } else {
                l.add(new AnalyzedGermanToken(word, null, null));
            }
            tokenReadings.add(new AnalyzedTokenReadings((AnalyzedToken[])l.toArray(new AnalyzedGermanToken[l.size()]), pos));
            pos += word.length();
        }
        return tokenReadings;
    }

    private void tagWord(String[] taggerTokens, String word, List<AnalyzedGermanToken> l) {
        this.tagWord(taggerTokens, word, l, null);
    }

    private void tagWord(String[] taggerTokens, String word, List<AnalyzedGermanToken> l, List<String> compoundParts) {
        for (int i = 0; i < taggerTokens.length; i += 2) {
            if (compoundParts != null) {
                List<String> allButLastPart = compoundParts.subList(0, compoundParts.size() - 1);
                String lemma = StringTools.listToString(allButLastPart, (String)"") + StringTools.lowercaseFirstChar((String)taggerTokens[i]);
                l.add(new AnalyzedGermanToken(word, taggerTokens[i + 1], lemma));
                continue;
            }
            l.add(new AnalyzedGermanToken(word, taggerTokens[i + 1], taggerTokens[i]));
        }
    }

    private String[] lexiconLookup(String word, IStemmer morfologik) {
        try {
            String[] posTagsFromUserDict = this.manualTagger.lookup(word);
            List posTagsFromDict = morfologik.lookup((CharSequence)word);
            if (posTagsFromUserDict != null && !posTagsFromDict.isEmpty()) {
                String[] allPosTags = new String[posTagsFromUserDict.length + posTagsFromDict.size() * 2];
                int i = 0;
                for (WordData wd : posTagsFromDict) {
                    allPosTags[i] = wd.getStem().toString();
                    allPosTags[i + 1] = wd.getTag().toString();
                    i += 2;
                }
                System.arraycopy(posTagsFromUserDict, 0, allPosTags, posTagsFromDict.size() * 2, posTagsFromUserDict.length);
                return allPosTags;
            }
            if (posTagsFromUserDict == null && !posTagsFromDict.isEmpty()) {
                String[] allPosTags = new String[posTagsFromDict.size() * 2];
                int i = 0;
                for (WordData wd : posTagsFromDict) {
                    allPosTags[i] = wd.getStem().toString();
                    allPosTags[i + 1] = wd.getTag().toString();
                    i += 2;
                }
                return allPosTags;
            }
            return posTagsFromUserDict;
        }
        catch (Exception e) {
            throw new RuntimeException("Error looking up word '" + word + "'", e);
        }
    }

    public final AnalyzedTokenReadings createNullToken(String token, int startPos) {
        return new AnalyzedTokenReadings((AnalyzedToken)new AnalyzedGermanToken(token, null, null), startPos);
    }

    public AnalyzedToken createToken(String token, String posTag) {
        return new AnalyzedGermanToken(token, posTag);
    }
}

