/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.de;

import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.WordRepeatRule;

public class GermanWordRepeatRule
extends WordRepeatRule {
    private static final Pattern PREPOSITIONS = Pattern.compile("ab|an|auf|bei|f\u00fcr|in|mit|nach|ohne|\u00fcber|zu");

    public GermanWordRepeatRule(ResourceBundle messages, Language language) {
        super(messages, language);
    }

    public String getId() {
        return "GERMAN_WORD_REPEAT_RULE";
    }

    public boolean ignore(AnalyzedTokenReadings[] tokens, int position) {
        if (tokens[position - 1].getToken().length() == 3 && tokens[position - 1].getToken().charAt(0) == 'd') {
            if (position >= 2 && ",".equals(tokens[position - 2].getToken())) {
                return true;
            }
            return position >= 3 && ",".equals(tokens[position - 3].getToken()) && this.isPreposition(tokens[position - 2]);
        }
        return position != 2 && tokens[position - 1].getToken().equals("Sie") && tokens[position].getToken().equals("sie") || tokens[position - 1].getToken().equals("sie") && tokens[position].getToken().equals("Sie");
    }

    private boolean isPreposition(AnalyzedTokenReadings token) {
        return PREPOSITIONS.matcher(token.getToken()).matches();
    }
}

