/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class AnarASuggestionsFilter
extends RuleFilter {
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int initPos;
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (initPos = 0; initPos < tokens.length && (tokens[initPos].getStartPos() < match.getFromPos() || tokens[initPos].isSentenceStart()); ++initPos) {
        }
        String verbPostag = tokens[initPos].readingWithTagRegex("V.IP.*").getPOSTag();
        String lemma = tokens[initPos + 2].readingWithTagRegex("V.N.*").getLemma();
        AnalyzedToken at = new AnalyzedToken("", "", lemma);
        String newPostag = "V[MS]I[PF]" + verbPostag.substring(4, 8);
        Synthesizer synth = this.getSynthesizerFromRuleMatch(match);
        String[] synthForms = synth.synthesize(at, newPostag, true);
        if (synthForms.length == 0) {
            return null;
        }
        int adjustEndPos = 0;
        String[] result = PronomsFeblesHelper.getTwoNextPronouns(tokens, initPos + 3);
        String pronomsDarrere = result[0];
        adjustEndPos += Integer.valueOf(result[1]).intValue();
        ArrayList<Object> replacements = new ArrayList<Object>();
        for (String verb : synthForms) {
            Object suggestion = "";
            if (!pronomsDarrere.isEmpty()) {
                suggestion = PronomsFeblesHelper.transformDavant(pronomsDarrere, verb);
            }
            suggestion = (String)suggestion + verb;
            suggestion = StringTools.preserveCase((String)suggestion, (String)tokens[initPos].getToken());
            replacements.add(suggestion);
        }
        if (replacements.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[initPos].getStartPos(), tokens[initPos + 2 + adjustEndPos].getEndPos(), match.getMessage(), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(replacements);
        return ruleMatch;
    }

    private String getLanguageVariantCode(RuleMatch match) {
        PatternRule pr = (PatternRule)match.getRule();
        return pr.getLanguage().getShortCodeWithCountryAndVariant();
    }
}

