/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.ApostophationHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class ConvertToGenderAndNumberFilter
extends RuleFilter {
    private Pattern splitGenderNumber = Pattern.compile("(N.|A..|V.P..|D..|PX.)(.)(.)(.*)");
    private Pattern splitGenderNumberNoNoun = Pattern.compile("(A..|V.P..|D..|PX.)(.)(.)(.*)");
    private Pattern splitGenderNumberAdjective = Pattern.compile("(A..|V.P..|PX.)(.)(.)(.*)");

    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int posWord;
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        Synthesizer synth = this.getSynthesizerFromRuleMatch(match);
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        String desiredGenderStr = this.getOptional("gender", arguments, "");
        String desiredNumberStr = this.getOptional("number", arguments, "");
        String lemmaSelect = this.getRequired("lemmaSelect", arguments);
        boolean keepOriginal = this.getOptional("keepOriginal", arguments, "false").equalsIgnoreCase("true");
        AnalyzedToken atrNoun = tokens[posWord].readingWithTagRegex(lemmaSelect);
        String[] splitPostag = this.splitGenderAndNumber(atrNoun);
        if (desiredGenderStr.isEmpty()) {
            desiredGenderStr = splitPostag[2];
        }
        if (desiredNumberStr.isEmpty()) {
            desiredNumberStr = splitPostag[3];
        }
        int startPos = posWord;
        int endPos = posWord;
        ArrayList<String> suggestions = new ArrayList<String>();
        for (char genderCh : desiredGenderStr.toCharArray()) {
            for (char numberCh : desiredNumberStr.toCharArray()) {
                String desiredGender = String.valueOf(genderCh);
                String desiredNumber = String.valueOf(numberCh);
                StringBuilder suggestionBuilder = new StringBuilder();
                boolean ignoreThisSuggestion = false;
                if (!keepOriginal) {
                    String s = this.synthesizeWithGenderAndNumber(atrNoun, splitPostag, desiredGender, desiredNumber, synth);
                    if (s.isEmpty()) {
                        ignoreThisSuggestion = true;
                    }
                    suggestionBuilder.append(s);
                } else {
                    suggestionBuilder.append(atrNoun.getToken());
                }
                boolean stop = false;
                int i = posWord;
                String prepositionToAdd = "";
                boolean addDeterminer = false;
                StringBuilder conditionalAddedString = new StringBuilder();
                Object addTot = "";
                while (!stop && i > 1) {
                    AnalyzedToken atr = tokens[--i].readingWithTagRegex(this.splitGenderNumberNoNoun);
                    if (tokens[i].hasPosTag("_perfet") || tokens[i].hasPosTag("_GV_") || tokens[i].getChunkTags().contains(new ChunkTag("GV"))) {
                        atr = null;
                    }
                    if (atr != null) {
                        String s;
                        if (atr.getPOSTag().startsWith("DA")) {
                            addDeterminer = true;
                            startPos = i;
                            continue;
                        }
                        if (!addDeterminer) {
                            s = this.synthesizeWithGenderAndNumber(atr, this.splitGenderAndNumber(atr), desiredGender, desiredNumber, synth);
                            if (s.isEmpty()) {
                                ignoreThisSuggestion = true;
                            }
                            if (s.equals("bo")) {
                                s = "bon";
                            }
                            suggestionBuilder.insert(0, conditionalAddedString);
                            conditionalAddedString.setLength(0);
                            if (tokens[i + 1].isWhitespaceBefore()) {
                                suggestionBuilder.insert(0, " ");
                            }
                            suggestionBuilder.insert(0, s);
                            startPos = i;
                            if (!atr.getPOSTag().startsWith("D") || atr.getPOSTag().startsWith("DN")) continue;
                            stop = true;
                            continue;
                        }
                        if (atr.getLemma().equals("tot") && !(s = this.synthesizeWithGenderAndNumber(atr, this.splitGenderAndNumber(atr), desiredGender, desiredNumber, synth)).isEmpty()) {
                            addTot = s + " ";
                            startPos = i;
                        }
                        stop = true;
                        continue;
                    }
                    if (tokens[i].hasPosTag("SPS00") || tokens[i].hasPosTag("LOC_PREP")) {
                        if (addDeterminer) {
                            String preposition = tokens[i].getToken().toLowerCase();
                            if (preposition.equals("pe")) {
                                preposition = "per";
                            }
                            if (preposition.equals("d'")) {
                                preposition = "de";
                            }
                            if (preposition.equals("a") || preposition.equals("de") || preposition.equals("per")) {
                                prepositionToAdd = preposition;
                                startPos = i;
                            }
                        }
                        stop = true;
                        continue;
                    }
                    if (tokens[i].hasPosTag("_PUNCT_CONT") || tokens[i].hasPosTag("CC")) {
                        if (posWord - i == 1) {
                            stop = true;
                            continue;
                        }
                        conditionalAddedString.insert(0, tokens[i].getToken() + " ");
                        continue;
                    }
                    if (tokens[i].hasPosTag("RG")) {
                        conditionalAddedString.insert(0, tokens[i].getToken() + " ");
                        continue;
                    }
                    stop = true;
                }
                stop = false;
                i = posWord;
                conditionalAddedString.setLength(0);
                boolean isThereConjunction = false;
                while (!stop && i < tokens.length - 1) {
                    AnalyzedToken atr = tokens[++i].readingWithTagRegex(this.splitGenderNumberAdjective);
                    if (isThereConjunction && tokens[i].hasPosTagStartingWith("NC")) {
                        atr = null;
                    }
                    if (atr != null) {
                        String s = this.synthesizeWithGenderAndNumber(atr, this.splitGenderAndNumber(atr), desiredGender, desiredNumber, synth);
                        if (s.isEmpty()) {
                            ignoreThisSuggestion = true;
                        }
                        suggestionBuilder.append((CharSequence)conditionalAddedString);
                        conditionalAddedString.setLength(0);
                        suggestionBuilder.append(" " + s);
                        endPos = i;
                        continue;
                    }
                    if (tokens[i].hasPosTag("RG")) {
                        conditionalAddedString.append(" " + tokens[i].getToken());
                        continue;
                    }
                    if (tokens[i].hasPosTag("CC")) {
                        isThereConjunction = true;
                        conditionalAddedString.append(" " + tokens[i].getToken());
                        continue;
                    }
                    if (tokens[i].hasPosTag("_PUNCT_CONT")) {
                        conditionalAddedString.append(tokens[i].getToken());
                        continue;
                    }
                    stop = true;
                }
                if (addDeterminer) {
                    suggestionBuilder.insert(0, ApostophationHelper.getPrepositionAndDeterminer(suggestionBuilder.toString(), desiredGender + desiredNumber, prepositionToAdd));
                } else if (!prepositionToAdd.isEmpty()) {
                    suggestionBuilder.insert(0, prepositionToAdd + " ");
                }
                suggestionBuilder.insert(0, (String)addTot);
                String suggestion = StringTools.preserveCase((String)suggestionBuilder.toString(), (String)tokens[startPos].getToken());
                if (endPos == posWord && startPos == posWord && tokens[posWord].getToken().equals(suggestion) || ignoreThisSuggestion) continue;
                suggestions.add(suggestion);
            }
        }
        if (suggestions.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[startPos].getStartPos(), tokens[endPos].getEndPos(), match.getMessage(), match.getShortMessage());
        String originalStr = match.getSentence().getText().substring(tokens[startPos].getStartPos(), tokens[endPos].getEndPos());
        if (suggestions.contains(originalStr)) {
            return null;
        }
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(suggestions);
        return ruleMatch;
    }

    private String[] splitGenderAndNumber(AnalyzedToken atr) {
        String[] results = new String[4];
        Matcher matcherSplit = this.splitGenderNumber.matcher(atr.getPOSTag());
        if (matcherSplit.matches()) {
            results[0] = matcherSplit.group(1);
            results[1] = matcherSplit.group(4);
            String gender = matcherSplit.group(2);
            String number = matcherSplit.group(3);
            if (results[0].startsWith("V")) {
                results[2] = number;
                results[3] = gender;
            } else {
                results[2] = gender;
                results[3] = number;
            }
            return results;
        }
        return null;
    }

    private String synthesizeWithGenderAndNumber(AnalyzedToken atr, String[] splitPostag, String gender, String number, Synthesizer synth) throws IOException {
        String[] synhtesized;
        if (splitPostag[0].startsWith("V")) {
            String keepGender = gender;
            gender = number;
            number = keepGender;
        }
        String addGender = "C";
        if (splitPostag[0].startsWith("DA")) {
            addGender = "";
        }
        if ((synhtesized = synth.synthesize(atr, splitPostag[0] + "[" + gender + addGender + "][" + number + "N]" + splitPostag[1], true)).length > 0) {
            return synhtesized[0];
        }
        return "";
    }

    private AnalyzedToken getReadingWithPriority(AnalyzedTokenReadings token) {
        AnalyzedToken atr = token.readingWithTagRegex(this.splitGenderNumberNoNoun);
        if (atr != null) {
            return atr;
        }
        atr = token.readingWithTagRegex(this.splitGenderNumber);
        return atr;
    }
}

