/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.language.Contributor;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.ca.CatalanMultitokenSpeller;
import org.languagetool.rules.ca.CatalanUnpairedBracketsRule;
import org.languagetool.rules.ca.CatalanUnpairedExclamationMarksRule;
import org.languagetool.rules.ca.CatalanUnpairedQuestionMarksRule;
import org.languagetool.rules.ca.CatalanWordRepeatBeginningRule;
import org.languagetool.rules.ca.CatalanWordRepeatRule;
import org.languagetool.rules.ca.CatalanWrongWordInContextRule;
import org.languagetool.rules.ca.CheckCaseRule;
import org.languagetool.rules.ca.CompoundRule;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.ca.PronomFebleDuplicateRule;
import org.languagetool.rules.ca.ReplaceOperationNamesRule;
import org.languagetool.rules.ca.SimpleReplaceAdverbsMent;
import org.languagetool.rules.ca.SimpleReplaceAnglicism;
import org.languagetool.rules.ca.SimpleReplaceBalearicRule;
import org.languagetool.rules.ca.SimpleReplaceDNVColloquialRule;
import org.languagetool.rules.ca.SimpleReplaceDNVRule;
import org.languagetool.rules.ca.SimpleReplaceDNVSecondaryRule;
import org.languagetool.rules.ca.SimpleReplaceDiacriticsIEC;
import org.languagetool.rules.ca.SimpleReplaceMultiwordsRule;
import org.languagetool.rules.ca.SimpleReplaceRule;
import org.languagetool.rules.ca.SimpleReplaceVerbsRule;
import org.languagetool.rules.ca.WordCoherencyRule;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.multitoken.MultitokenSpeller;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ca.CatalanHybridDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ca.CatalanWordTokenizer;
import org.languagetool.tools.StringTools;

public class Catalan
extends Language {
    private static final String LANGUAGE_SHORT_CODE = "ca-ES";
    private static volatile Throwable instantiationTrace;
    private static final Pattern PATTERN_1;
    private static final Pattern PATTERN_2;
    private static final Pattern PATTERN_3;
    private static final Pattern CA_OLD_DIACRITICS;
    private static final Pattern CA_CONTRACTIONS;
    private static final Pattern CA_APOSTROPHES1;
    private static final Pattern CA_APOSTROPHES2;
    private static final Pattern CA_APOSTROPHES3;
    private static final Pattern CA_APOSTROPHES4;
    private static final Pattern CA_APOSTROPHES5;
    private static final Pattern CA_APOSTROPHES6;
    private static final Pattern CA_APOSTROPHES7;
    private static final Pattern POSSESSIUS_v;
    private static final Pattern POSSESSIUS_V;
    private static final Pattern CA_REMOVE_SPACES;
    private final List<String> spellerExceptions = Arrays.asList("San Juan", "Copa Am\u00e9rica", "Colecci\u00f3n Jumex", "Banco Santander", "San Marcos", "Santa Ana", "San Joaqu\u00edn", "Naguib Mahfouz", "Rosal\u00eda", "Aristide Maillol", "Alexia Putellas", "M\u00f3nica Randall", "Vicente Blasco Ib\u00e1\u00f1ez", "Copa Sudamericana", "S\u00e9rie A", "Banco Sabadell");

    public Catalan() {
        Throwable trace = instantiationTrace;
        if (trace != null) {
            throw new RuntimeException("Language was already instantiated, see the cause stacktrace below.", trace);
        }
        instantiationTrace = new Throwable();
    }

    protected Catalan(boolean fakeValue) {
    }

    @NotNull
    public static Catalan getInstance() {
        Language language = Objects.requireNonNull(Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE));
        if (language instanceof Catalan) {
            Catalan catalan = (Catalan)language;
            return catalan;
        }
        throw new RuntimeException("Catalan language expected, got " + language);
    }

    public String getName() {
        return "Catalan";
    }

    public String[] getCountries() {
        return new String[]{"ES"};
    }

    public String getShortCode() {
        return "ca";
    }

    public Language getDefaultLanguageVariant() {
        return Languages.getLanguageForShortCode((String)LANGUAGE_SHORT_CODE);
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ricard Roca"), new Contributor("Jaume Ortol\u00e0")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"A parer seu<marker> ,</marker> no era veritat."), Example.fixed((String)"A parer seu<marker>,</marker> no era veritat.")), new DoublePunctuationRule(messages), new CatalanUnpairedBracketsRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Preus de venda al p\u00fablic. <marker>han</marker> pujat molt."), Example.fixed((String)"Preus de venda al p\u00fablic. <marker>Han</marker> pujat molt.")), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 60), new CatalanWordRepeatRule(messages, this), new MorfologikCatalanSpellerRule(messages, this, userConfig, altLanguages), new CatalanUnpairedQuestionMarksRule(messages, this), new CatalanUnpairedExclamationMarksRule(messages, this), new CatalanWrongWordInContextRule(messages, this), new SimpleReplaceVerbsRule(messages, this), new SimpleReplaceBalearicRule(messages, this), new SimpleReplaceRule(messages, this), new SimpleReplaceMultiwordsRule(messages), new ReplaceOperationNamesRule(messages, this), new SimpleReplaceDiacriticsIEC(messages, this), new SimpleReplaceAnglicism(messages), new PronomFebleDuplicateRule(messages), new CheckCaseRule(messages, this), new SimpleReplaceAdverbsMent(messages), new CatalanWordRepeatBeginningRule(messages, this), new CompoundRule(messages, this, userConfig), new SimpleReplaceDNVRule(messages, this), new SimpleReplaceDNVColloquialRule(messages, this), new SimpleReplaceDNVSecondaryRule(messages, this), new WordCoherencyRule(messages), new PunctuationMarkAtParagraphEnd(messages, (Language)this)});
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return CatalanTagger.INSTANCE_CAT;
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return CatalanSynthesizer.INSTANCE_CAT;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public Disambiguator createDefaultDisambiguator() {
        return new CatalanHybridDisambiguator(this.getDefaultLanguageVariant());
    }

    public Tokenizer createDefaultWordTokenizer() {
        return CatalanWordTokenizer.INSTANCE;
    }

    public String getOpeningDoubleQuote() {
        return "\u00ab";
    }

    public String getClosingDoubleQuote() {
        return "\u00bb";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    public String toAdvancedTypography(String input) {
        String output = super.toAdvancedTypography(input);
        output = PATTERN_1.matcher(output).replaceAll("$1\u2019");
        output = PATTERN_2.matcher(output).replaceAll("$1\u2019" + this.getOpeningDoubleQuote());
        output = PATTERN_3.matcher(output).replaceAll("$1\u2019" + this.getOpeningSingleQuote());
        return output;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    protected int getDefaultRulePriorityForStyle() {
        return -50;
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "CONFUSIONS2": {
                return 80;
            }
            case "DEU_NI_DO": {
                return 80;
            }
            case "FER_LOGIN": {
                return 70;
            }
            case "L_OK": {
                return 70;
            }
            case "INCORRECT_EXPRESSIONS": {
                return 50;
            }
            case "PERSONATGES_FAMOSOS": {
                return 50;
            }
            case "CONEIXO_CONEC": {
                return 50;
            }
            case "COMETES_INCORRECTES": {
                return 50;
            }
            case "OFERTAR_OFERIR": {
                return 50;
            }
            case "DESDE_UN": {
                return 40;
            }
            case "MOTS_NO_SEPARATS": {
                return 40;
            }
            case "REPETEAD_ELEMENTS": {
                return 40;
            }
            case "ESPERANT_US_AGRADI": {
                return 40;
            }
            case "LO_NEUTRE": {
                return 40;
            }
            case "ESPAIS_SOBRANTS": {
                return 40;
            }
            case "PER_A_QUE_PERQUE": {
                return 40;
            }
            case "ELA_GEMINADA": {
                return 35;
            }
            case "CONFUSIONS_PRONOMS_FEBLES": {
                return 35;
            }
            case "COMMA_PERO1": {
                return 35;
            }
            case "CA_SPLIT_WORDS": {
                return 30;
            }
            case "PRONOMS_FEBLES_TEMPS_VERBAL": {
                return 35;
            }
            case "ET_AL": {
                return 30;
            }
            case "PRONOMS_FEBLES_COLLOQUIALS": {
                return 30;
            }
            case "CONCORDANCES_CASOS_PARTICULARS": {
                return 30;
            }
            case "GERUNDI_PERD_T": {
                return 30;
            }
            case "CONFUSIONS": {
                return 30;
            }
            case "PRONOMS_FEBLES_DARRERE_VERB": {
                return 30;
            }
            case "VERBS_NO_INCOATIUS": {
                return 30;
            }
            case "ARRIBAN_ARRIBANT": {
                return 30;
            }
            case "PUNT_LLETRA": {
                return 30;
            }
            case "REEMPRENDRE": {
                return 28;
            }
            case "INCORRECT_WORDS_IN_CONTEXT": {
                return 28;
            }
            case "PRONOMS_FEBLES_SOLTS2": {
                return 26;
            }
            case "ES_UNKNOWN": {
                return 25;
            }
            case "HAVER_SENSE_HAC": {
                return 25;
            }
            case "HA_A": {
                return 25;
            }
            case "PASSAT_PERIFRASTIC": {
                return 25;
            }
            case "CONFUSIONS_ACCENT": {
                return 20;
            }
            case "CONFUSIO_PASSAT_INFINITIU": {
                return 20;
            }
            case "DIACRITICS": {
                return 20;
            }
            case "CAP_GENS": {
                return 20;
            }
            case "MOTS_SENSE_GUIONETS": {
                return 20;
            }
            case "ORDINALS": {
                return 20;
            }
            case "SUPER": {
                return 20;
            }
            case "PRONOM_FEBLE_HI": {
                return 20;
            }
            case "HAVER_PARTICIPI_HAVER_IMPERSONAL": {
                return 15;
            }
            case "CONCORDANCES_NUMERALS_DUES": {
                return 10;
            }
            case "FALTA_CONDICIONAL": {
                return 10;
            }
            case "ACCENTUATION_CHECK": {
                return 10;
            }
            case "CONCORDANCA_GRIS": {
                return 10;
            }
            case "A_PER": {
                return 10;
            }
            case "CONCORDANCES_NUMERALS": {
                return 10;
            }
            case "COMMA_IJ": {
                return 10;
            }
            case "AVIS": {
                return 10;
            }
            case "CAP_ELS_CAP_ALS": {
                return 10;
            }
            case "CASING": {
                return 10;
            }
            case "DOS_ARTICLES": {
                return 10;
            }
            case "MOTS_GUIONET": {
                return 10;
            }
            case "SELS_EN_VA": {
                return 10;
            }
            case "CONCORDANCES_NOUNS_PRIORITY": {
                return 10;
            }
            case "PREFIXOS_SENSE_GUIONET_EN_DICCIONARI": {
                return 10;
            }
            case "ZERO_O": {
                return 10;
            }
            case "URL": {
                return 10;
            }
            case "CONCORDANCES_DET_NOM": {
                return 5;
            }
            case "CONCORDANCES_DET_ADJ": {
                return 5;
            }
            case "CONCORDANCES_DET_POSSESSIU": {
                return 5;
            }
            case "PASSAR_SE": {
                return 5;
            }
            case "DET_GN": {
                return 5;
            }
            case "SPELLING": {
                return 5;
            }
            case "APOSTROF_ANYS": {
                return 5;
            }
            case "VENIR_NO_REFLEXIU": {
                return 5;
            }
            case "DEUS_SEUS": {
                return 5;
            }
            case "SON_BONIC": {
                return 5;
            }
            case "ACCENTUACIO": {
                return 5;
            }
            case "FIDEUA": {
                return 5;
            }
            case "L_NO_APOSTROFA": {
                return 5;
            }
            case "L_D_N_NO_S_APOSTROFEN": {
                return 5;
            }
            case "CONTRACCIONS": {
                return 0;
            }
            case "CASING_START": {
                return -5;
            }
            case "CA_WORD_COHERENCY": {
                return -10;
            }
            case "CA_WORD_COHERENCY_VALENCIA": {
                return -10;
            }
            case "QUAN_PREPOSICIO": {
                return -10;
            }
            case "ARTICLE_TOPONIM_MIN": {
                return -10;
            }
            case "PEL_QUE": {
                return -10;
            }
            case "COMMA_LOCUTION": {
                return -10;
            }
            case "REGIONAL_VERBS": {
                return -10;
            }
            case "PRONOMS_FEBLES_SOLTS": {
                return -10;
            }
            case "CONCORDANCA_PRONOMS_CATCHALL": {
                return -10;
            }
            case "AGREEMENT_POSTPONED_ADJ": {
                return -15;
            }
            case "FALTA_COMA_FRASE_CONDICIONAL": {
                return -20;
            }
            case "ESPAIS_QUE_FALTEN_PUNTUACIO": {
                return -20;
            }
            case "VERBS_NOMSPROPIS": {
                return -20;
            }
            case "VERBS_PRONOMINALS": {
                return -25;
            }
            case "PORTO_LLEGINT": {
                return -30;
            }
            case "PORTA_UNA_HORA": {
                return -40;
            }
            case "REPETITIONS_STYLE": {
                return -50;
            }
            case "MUNDAR": {
                return -50;
            }
            case "NOMBRES_ROMANS": {
                return -90;
            }
            case "TASCAS_TASQUES": {
                return -97;
            }
            case "PREPOSICIONS_MINUSCULA": {
                return -97;
            }
            case "SUGGERIMENTS_LE": {
                return -97;
            }
            case "MORFOLOGIK_RULE_CA_ES": {
                return -100;
            }
            case "EXIGEIX_ACCENTUACIO_VALENCIANA": {
                return -120;
            }
            case "PHRASE_REPETITION": {
                return -150;
            }
            case "SUBSTANTIUS_JUNTS": {
                return -150;
            }
            case "REPETITION_ADJ_N_ADJ": {
                return -155;
            }
            case "FALTA_ELEMENT_ENTRE_VERBS": {
                return -200;
            }
            case "PUNT_FINAL": {
                return -200;
            }
            case "PUNCTUATION_PARAGRAPH_END": {
                return -200;
            }
            case "CA_END_PARAGRAPH_PUNCTUATION": {
                return -250;
            }
            case "DICENDI_QUE": {
                return -250;
            }
            case "UPPERCASE_SENTENCE_START": {
                return -500;
            }
            case "MAJUSCULA_IMPROBABLE": {
                return -500;
            }
            case "ELA_GEMINADA_WIKI": {
                return -500;
            }
        }
        if (id.startsWith("CA_MULTITOKEN_SPELLING")) {
            return -95;
        }
        if (id.startsWith("CA_SIMPLE_REPLACE_MULTIWORDS")) {
            return 70;
        }
        if (id.startsWith("CA_SIMPLE_REPLACE_ANGLICISM")) {
            return 65;
        }
        if (id.startsWith("CA_SIMPLE_REPLACE_BALEARIC")) {
            return 60;
        }
        if (id.startsWith("CA_SIMPLE_REPLACE_VERBS")) {
            return 28;
        }
        if (id.startsWith("CA_COMPOUNDS")) {
            return 50;
        }
        if (id.startsWith("CA_SIMPLE_REPLACE_DIACRITICS_IEC")) {
            return 0;
        }
        if (id.startsWith("CA_SIMPLE_REPLACE")) {
            return 30;
        }
        return super.getPriorityForId(id);
    }

    public boolean hasMinMatchesRules() {
        return true;
    }

    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikCatalanSpellerRule(messages, this, null, Collections.emptyList());
    }

    private RuleMatch adjustCatalanMatch(RuleMatch ruleMatch, Set<String> enabledRules) {
        String errorStr = ruleMatch.getOriginalErrorStr();
        List suggestedReplacements = ruleMatch.getSuggestedReplacements();
        ArrayList<SuggestedReplacement> newReplacements = new ArrayList<SuggestedReplacement>();
        for (String suggestedReplacement : suggestedReplacements) {
            SuggestedReplacement newSuggestedReplacement;
            Object newReplStr = suggestedReplacement;
            if (errorStr.length() > 2 && errorStr.endsWith("'") && !((String)newReplStr).endsWith("'") && !((String)newReplStr).endsWith("\u2019")) {
                newReplStr = (String)newReplStr + " ";
            }
            if (((String)newReplStr).equalsIgnoreCase("despr\u00e9s") || !enabledRules.contains("EXIGEIX_ACCENTUACIO_GENERAL") ? enabledRules.contains("EXIGEIX_ACCENTUACIO_VALENCIANA") && (((String)newReplStr).contains("\u00e8") && suggestedReplacements.contains(((String)newReplStr).replace("\u00e8", "\u00e9")) || ((String)newReplStr).contains("\u00c8") && suggestedReplacements.contains(((String)newReplStr).replace("\u00c8", "\u00c9"))) : ((String)newReplStr).contains("\u00e9") && suggestedReplacements.contains(((String)newReplStr).replace("\u00e9", "\u00e8")) || ((String)newReplStr).contains("\u00c9") && suggestedReplacements.contains(((String)newReplStr).replace("\u00c9", "\u00c8"))) continue;
            if (enabledRules.contains("APOSTROF_TIPOGRAFIC") && ((String)newReplStr).length() > 1) {
                newReplStr = ((String)newReplStr).replace("'", "\u2019");
            }
            if (enabledRules.contains("EXIGEIX_POSSESSIUS_U") && ((String)newReplStr).length() > 3) {
                Matcher m = POSSESSIUS_v.matcher((CharSequence)newReplStr);
                newReplStr = m.replaceAll("$1u$2");
                Matcher m2 = POSSESSIUS_V.matcher((CharSequence)newReplStr);
                newReplStr = m2.replaceAll("$1U$2");
                newReplStr = ((String)newReplStr).replace("feina", "faena");
                newReplStr = ((String)newReplStr).replace("feiner", "faener");
                newReplStr = ((String)newReplStr).replace("feinera", "faenera");
            }
            Matcher m5 = CA_OLD_DIACRITICS.matcher((CharSequence)newReplStr);
            if (!enabledRules.contains("DIACRITICS_TRADITIONAL_RULES") && m5.matches()) {
                newSuggestedReplacement = new SuggestedReplacement(suggestedReplacement);
                newSuggestedReplacement.setReplacement(this.removeOldDiacritics((String)newReplStr));
                if (newReplacements.contains(newSuggestedReplacement)) continue;
                newReplacements.add(newSuggestedReplacement);
                continue;
            }
            newSuggestedReplacement = new SuggestedReplacement(suggestedReplacement);
            newSuggestedReplacement.setReplacement((String)newReplStr);
            if (newReplacements.contains(newSuggestedReplacement)) continue;
            newReplacements.add(newSuggestedReplacement);
        }
        RuleMatch newRuleMatch = new RuleMatch(ruleMatch, newReplacements);
        return newRuleMatch;
    }

    private String removeOldDiacritics(String s) {
        return s.replace("d\u00f3na", "dona").replace("d\u00f3nes", "dones").replace("s\u00f3c", "soc").replace("v\u00e9nen", "venen").replace("v\u00e9ns", "v\u00e9ns").replace("f\u00f3ra", "fora").replace("D\u00f3na", "Dona").replace("D\u00f3nes", "Dones").replace("S\u00f3c", "Soc").replace("V\u00e9nen", "Venen").replace("V\u00e9ns", "Vens").replace("F\u00f3ra", "Fora");
    }

    public String adaptSuggestion(String s) {
        boolean capitalized = StringTools.isCapitalizedWord((String)s);
        Matcher m = CA_CONTRACTIONS.matcher(s);
        s = m.replaceAll("$1$2");
        Matcher m1 = CA_APOSTROPHES1.matcher(s);
        s = m1.replaceAll("$1");
        Matcher m2 = CA_APOSTROPHES2.matcher(s);
        s = m2.replaceAll("e$1 $2");
        Matcher m3 = CA_APOSTROPHES3.matcher(s);
        s = m3.replaceAll("$1'$2");
        Matcher m4 = CA_APOSTROPHES4.matcher(s);
        s = m4.replaceAll("$1'$2");
        Matcher m5 = CA_APOSTROPHES5.matcher(s);
        s = m5.replaceAll("$1$2");
        Matcher m6 = CA_APOSTROPHES6.matcher(s);
        s = m6.replaceAll("se'$1");
        Matcher m7 = CA_APOSTROPHES7.matcher(s);
        s = m7.replaceAll("$1 l'$2");
        Matcher m8 = CA_REMOVE_SPACES.matcher(s);
        s = m8.replaceAll("$1$2");
        if (capitalized) {
            s = StringTools.uppercaseFirstChar((String)s);
        }
        s = s.replace(" ,", ",");
        return s;
    }

    public List<String> prepareLineForSpeller(String line) {
        String[] parts = line.split("#");
        if (parts.length == 0) {
            return Arrays.asList(line);
        }
        String[] formTag = parts[0].split("[\t;]");
        String form = formTag[0].trim();
        if (this.spellerExceptions.contains(form)) {
            return Arrays.asList("");
        }
        if (formTag.length > 1) {
            String tag = formTag[1].trim();
            if (tag.startsWith("N") || tag.equals("_Latin_")) {
                return Arrays.asList(form);
            }
            return Arrays.asList("");
        }
        return Arrays.asList(line);
    }

    public MultitokenSpeller getMultitokenSpeller() {
        return CatalanMultitokenSpeller.INSTANCE;
    }

    public List<RuleMatch> filterRuleMatches(List<RuleMatch> ruleMatches, AnnotatedText text, Set<String> enabledRules) {
        ArrayList<RuleMatch> results = new ArrayList<RuleMatch>();
        for (int i = 0; i < ruleMatches.size(); ++i) {
            RuleMatch ruleMatch = ruleMatches.get(i);
            if ((ruleMatch.getRule().getFullId().equals("FALTA_ELEMENT_ENTRE_VERBS[3]") || ruleMatch.getRule().getFullId().equals("FALTA_ELEMENT_ENTRE_VERBS[4]")) && i + 1 < ruleMatches.size() && ruleMatches.get(i + 1).getFromPosSentence() > -1 && !ruleMatches.get(i + 1).getRule().getFullId().equals("FALTA_ELEMENT_ENTRE_VERBS[5]") && ruleMatches.get(i + 1).getFromPosSentence() - ruleMatch.getToPosSentence() < 20 || i > 0 && ruleMatch.getRule().getFullId().equals("FALTA_ELEMENT_ENTRE_VERBS[5]") && ruleMatches.get(i - 1).getRule().getId().equals("FALTA_ELEMENT_ENTRE_VERBS")) continue;
            results.add(this.adjustCatalanMatch(ruleMatch, enabledRules));
        }
        return results;
    }

    static {
        PATTERN_1 = Pattern.compile("(\\b[lmnstdLMNSTD])'");
        PATTERN_2 = Pattern.compile("(\\b[lmnstdLMNSTD])\u2019\"");
        PATTERN_3 = Pattern.compile("(\\b[lmnstdLMNSTD])\u2019'");
        CA_OLD_DIACRITICS = Pattern.compile(".*\\b(s\u00f3c|d\u00f3na|d\u00f3nes|v\u00e9nen|v\u00e9ns|f\u00f3ra)\\b.*", 66);
        CA_CONTRACTIONS = Pattern.compile("\\b([Aa]|[Dd]e) e(ls?)\\b");
        CA_APOSTROPHES1 = Pattern.compile("\\b([LDNSTMldnstm]['\u2019]) ");
        CA_APOSTROPHES2 = Pattern.compile("\\b([mtlsn])['\u2019]([^1haeiou\u00e1\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00faA-Z\u00c0\u00c8\u00c9\u00cd\u00d2\u00d3\u00da\u201c\u00ab\"])");
        CA_APOSTROPHES3 = Pattern.compile("\\be?([mtsldn])e? (h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa])", 66);
        CA_APOSTROPHES4 = Pattern.compile("\\b(l)a ([aeo\u00e0\u00fa\u00e8\u00e9\u00ed][^ ])", 66);
        CA_APOSTROPHES5 = Pattern.compile("\\b([mts]e) (['\u2019])", 66);
        CA_APOSTROPHES6 = Pattern.compile("\\bs'e(ns|ls)\\b", 66);
        CA_APOSTROPHES7 = Pattern.compile("\\b(de|a)l (h?[aeo\u00e0\u00fa\u00e8\u00e9\u00ed][^ ])", 66);
        POSSESSIUS_v = Pattern.compile("\\b([mtsMTS]e)v(a|es)\\b", 64);
        POSSESSIUS_V = Pattern.compile("\\b([MTS]E)V(A|ES)\\b", 64);
        CA_REMOVE_SPACES = Pattern.compile("\\b(a|de|pe) (ls? )", 66);
    }
}

