/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class PortarGerundiSuggestionsFilter
extends RuleFilter {
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        String[] synthForms3;
        int posWord;
        Synthesizer synth = this.getSynthesizerFromRuleMatch(match);
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        String newLemma = this.getOptional("newLemma", arguments, "");
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        AnalyzedToken atr1 = tokens[posWord].readingWithTagRegex("V.[IS].*");
        AnalyzedToken atr2 = tokens[posWord + 1].readingWithTagRegex("V.G.*");
        ArrayList<String> replacements = new ArrayList<String>();
        String lemma = newLemma.isEmpty() ? atr2.getLemma() : newLemma;
        String[] synthForms1 = synth.synthesize(new AnalyzedToken("", "", "haver"), "VA" + atr1.getPOSTag().substring(2), true);
        String[] synthForms2 = synth.synthesize(new AnalyzedToken("", "", lemma), "V.P..SM.", true);
        if (synthForms1 != null && synthForms2 != null) {
            for (String synthForm1 : synthForms1) {
                for (String synthForm2 : synthForms2) {
                    replacements.add(synthForm1 + " " + synthForm2);
                }
            }
        }
        if ((synthForms3 = synth.synthesize(new AnalyzedToken("", "", lemma), "V." + atr1.getPOSTag().substring(2), true)) != null) {
            replacements.add(synthForms3[0]);
        }
        if (replacements.isEmpty()) {
            return null;
        }
        String[] nextPronouns = PronomsFeblesHelper.getTwoNextPronouns(tokens, posWord + 2);
        String[] previousPronouns = PronomsFeblesHelper.getPreviousPronouns(tokens, posWord - 1);
        int correctStartIndex = 0;
        int correctEndIndex = 0;
        for (int i = 0; i < replacements.size(); ++i) {
            String pronounsSuggestion = "";
            if (!nextPronouns[0].isEmpty()) {
                pronounsSuggestion = PronomsFeblesHelper.transformDavant(nextPronouns[0], (String)replacements.get(i));
                correctEndIndex = Integer.parseInt(nextPronouns[1]);
            } else if (!previousPronouns[0].isEmpty()) {
                pronounsSuggestion = PronomsFeblesHelper.transformDavant(previousPronouns[0], (String)replacements.get(i));
                correctStartIndex = -Integer.parseInt(previousPronouns[1]);
            }
            replacements.set(i, StringTools.preserveCase((String)(pronounsSuggestion + (String)replacements.get(i)), (String)tokens[posWord + correctStartIndex].getToken()));
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[posWord + correctStartIndex].getStartPos(), tokens[posWord + 1 + correctEndIndex].getEndPos(), match.getMessage(), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(replacements);
        return ruleMatch;
    }
}

