/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.AbstractTextToNumberFilter;

public class TextToNumberFilter
extends AbstractTextToNumberFilter {
    protected boolean isComma(String s) {
        return s.equalsIgnoreCase("comma") || s.equalsIgnoreCase("coma");
    }

    protected boolean isPercentage(AnalyzedTokenReadings[] patternTokens, int i) {
        return patternTokens[i].getToken().equals("cent") && patternTokens[i - 1].getToken().toLowerCase().equals("per");
    }

    protected List<String> tokenize(String s) {
        return Arrays.asList(s.split("-"));
    }

    protected String formatResult(String s) {
        return s.replace('.', ',');
    }

    static {
        numbers.put("zero", Float.valueOf(0.0f));
        numbers.put("mig", Float.valueOf(0.5f));
        numbers.put("un", Float.valueOf(1.0f));
        numbers.put("u", Float.valueOf(1.0f));
        numbers.put("una", Float.valueOf(1.0f));
        numbers.put("dos", Float.valueOf(2.0f));
        numbers.put("dues", Float.valueOf(2.0f));
        numbers.put("tres", Float.valueOf(3.0f));
        numbers.put("quatre", Float.valueOf(4.0f));
        numbers.put("cinc", Float.valueOf(5.0f));
        numbers.put("sis", Float.valueOf(6.0f));
        numbers.put("set", Float.valueOf(7.0f));
        numbers.put("vuit", Float.valueOf(8.0f));
        numbers.put("huit", Float.valueOf(8.0f));
        numbers.put("nou", Float.valueOf(9.0f));
        numbers.put("deu", Float.valueOf(10.0f));
        numbers.put("onze", Float.valueOf(11.0f));
        numbers.put("dotze", Float.valueOf(12.0f));
        numbers.put("tretze", Float.valueOf(13.0f));
        numbers.put("catorze", Float.valueOf(14.0f));
        numbers.put("quinze", Float.valueOf(15.0f));
        numbers.put("setze", Float.valueOf(16.0f));
        numbers.put("disset", Float.valueOf(17.0f));
        numbers.put("desset", Float.valueOf(17.0f));
        numbers.put("d\u00e8sset", Float.valueOf(17.0f));
        numbers.put("divuit", Float.valueOf(18.0f));
        numbers.put("devuit", Float.valueOf(18.0f));
        numbers.put("d\u00edhuit", Float.valueOf(18.0f));
        numbers.put("dinou", Float.valueOf(19.0f));
        numbers.put("denou", Float.valueOf(19.0f));
        numbers.put("d\u00e8nou", Float.valueOf(19.0f));
        numbers.put("d\u00e8neu", Float.valueOf(19.0f));
        numbers.put("vint", Float.valueOf(20.0f));
        numbers.put("trenta", Float.valueOf(30.0f));
        numbers.put("quaranta", Float.valueOf(40.0f));
        numbers.put("cinquanta", Float.valueOf(50.0f));
        numbers.put("seixanta", Float.valueOf(60.0f));
        numbers.put("setanta", Float.valueOf(70.0f));
        numbers.put("vuitanta", Float.valueOf(80.0f));
        numbers.put("huitanta", Float.valueOf(80.0f));
        numbers.put("noranta", Float.valueOf(90.0f));
        multipliers.put("cent", Float.valueOf(100.0f));
        multipliers.put("cents", Float.valueOf(100.0f));
        multipliers.put("mil", Float.valueOf(1000.0f));
        multipliers.put("mili\u00f3", Float.valueOf(1000000.0f));
        multipliers.put("milions", Float.valueOf(1000000.0f));
        multipliers.put("bili\u00f3", Float.valueOf(1.0E13f));
        multipliers.put("bilions", Float.valueOf(1.0E13f));
        multipliers.put("trili\u00f3", Float.valueOf(1.0E19f));
        multipliers.put("trilions", Float.valueOf(1.0E19f));
    }
}

