/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tools.StringTools;

public class SynthesizeWithDeterminerFilter
extends RuleFilter {
    private static CatalanSynthesizer synth = CatalanSynthesizer.INSTANCE;
    private static Map<String, String> prepDet = new HashMap<String, String>();
    private List<String> genderNumberList = Arrays.asList("MS", "FS", "MP", "FP");
    private static Map<String, Pattern> genderNumberPatterns;
    private static final Pattern pMascYes;
    private static final Pattern pMascNo;
    private static final Pattern pFemYes;
    private static final Pattern pFemNo;

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        AnalyzedToken reading;
        String lemmaFromStr = this.getRequired("lemmaFrom", arguments);
        String lemmaSelect = this.getRequired("lemmaSelect", arguments);
        boolean synthAllForms = this.getOptional("synthAllForms", arguments, "false").equalsIgnoreCase("true");
        String prepositionFromStr = this.getOptional("prepositionFrom", arguments, "");
        int lemmaFrom = this.getPosition(lemmaFromStr, patternTokens, match);
        String preposition = "";
        if (StringUtils.isNumeric((CharSequence)prepositionFromStr)) {
            int prepositionFrom = this.getPosition(prepositionFromStr, patternTokens, match);
            preposition = patternTokens[prepositionFrom].getToken().substring(0, 1).toLowerCase();
        } else if (!prepositionFromStr.isEmpty()) {
            preposition = prepositionFromStr.substring(0, 1);
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        String originalWord = patternTokens[lemmaFrom].getToken();
        Pattern p = Pattern.compile(lemmaSelect);
        boolean isSentenceStart = this.isMatchAtSentenceStart(match.getSentence().getTokensWithoutWhitespace(), match);
        ArrayList<AnalyzedToken> potentialSuggestions = new ArrayList<AnalyzedToken>();
        AnalyzedToken originalAT = patternTokens[lemmaFrom].readingWithTagRegex(lemmaSelect);
        potentialSuggestions.add(originalAT);
        String secondGenderNumber = "";
        if (lemmaFrom - 1 > 0 && (reading = patternTokens[lemmaFrom - 1].readingWithTagRegex("D.*")) != null) {
            secondGenderNumber = reading.getPOSTag().substring(3, 5);
        }
        for (String tag : synth.getPossibleTags()) {
            String[] synthForms;
            Matcher m = p.matcher(tag);
            if (!m.matches()) continue;
            for (String synthForm : synthForms = synth.synthesize(originalAT, tag)) {
                AnalyzedToken at = new AnalyzedToken(synthForm, tag, originalAT.getLemma());
                if (!synthAllForms && !synthForm.equalsIgnoreCase(originalWord) || potentialSuggestions.contains(at)) continue;
                if (tag.contains(secondGenderNumber) || tag.contains(secondGenderNumber.substring(1, 2) + secondGenderNumber.substring(0, 1))) {
                    potentialSuggestions.add(1, at);
                    continue;
                }
                potentialSuggestions.add(at);
            }
        }
        for (AnalyzedToken potentialSuggestion : potentialSuggestions) {
            String form = potentialSuggestion.getToken();
            for (String genderNumber : this.genderNumberList) {
                String apos = "";
                if (genderNumber.equals("MS")) {
                    if (pMascYes.matcher(form).matches() && !pMascNo.matcher(form).matches()) {
                        apos = "apos";
                    }
                } else if (genderNumber.equals("FS") && pFemYes.matcher(form).matches() && !pFemNo.matcher(form).matches()) {
                    apos = "apos";
                }
                if (!genderNumberPatterns.get(genderNumber).matcher(potentialSuggestion.getPOSTag()).matches()) continue;
                String suggestion = prepDet.get(preposition + genderNumber + apos) + StringTools.preserveCase((String)form, (String)originalWord);
                if (isSentenceStart) {
                    suggestion = StringTools.uppercaseFirstChar((String)suggestion);
                }
                if (suggestions.contains(suggestion)) continue;
                suggestions.add(suggestion);
            }
        }
        match.addSuggestedReplacements(suggestions);
        return match;
    }

    static {
        prepDet.put("MS", "el ");
        prepDet.put("FS", "la ");
        prepDet.put("MP", "els ");
        prepDet.put("FP", "les ");
        prepDet.put("MSapos", "l'");
        prepDet.put("FSapos", "l'");
        prepDet.put("aMS", "al ");
        prepDet.put("aFS", "a la ");
        prepDet.put("aMP", "als ");
        prepDet.put("aFP", "a les ");
        prepDet.put("aMSapos", "a l'");
        prepDet.put("aFSapos", "a l'");
        prepDet.put("dMS", "del ");
        prepDet.put("dFS", "de la ");
        prepDet.put("dMP", "dels ");
        prepDet.put("dFP", "de les ");
        prepDet.put("dMSapos", "de l'");
        prepDet.put("dFSapos", "de l'");
        prepDet.put("pMS", "pel ");
        prepDet.put("pFS", "per la ");
        prepDet.put("pMP", "pels ");
        prepDet.put("pFP", "per les ");
        prepDet.put("pMSapos", "per l'");
        prepDet.put("pFSapos", "per l'");
        genderNumberPatterns = new HashMap<String, Pattern>();
        genderNumberPatterns.put("MS", Pattern.compile("(N|A.).[MC][SN].*|V.P.*SM."));
        genderNumberPatterns.put("FS", Pattern.compile("(N|A.).[FC][SN].*|V.P.*SF."));
        genderNumberPatterns.put("MP", Pattern.compile("(N|A.).[MC][PN].*|V.P.*PM."));
        genderNumberPatterns.put("FP", Pattern.compile("(N|A.).[FC][PN].*|V.P.*PF."));
        pMascYes = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 66);
        pMascNo = Pattern.compile("h?[ui][aeio\u00e0\u00e8\u00e9\u00f3\u00f2].+", 66);
        pFemYes = Pattern.compile("h?[aeo\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*|h?[ui][^aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa\u00fc\u00ef]+[aeiou][ns]?|urbs", 66);
        pFemNo = Pattern.compile("host|ira|inxa", 66);
    }
}

