/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.PronomsFeblesHelper;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tools.StringTools;

public class PortarTempsSuggestionsFilter
extends RuleFilter {
    private static CatalanSynthesizer synth = CatalanSynthesizer.INSTANCE;

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        String pronoms;
        String[] result;
        int i;
        int posWord;
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        StringBuilder suggestion = new StringBuilder();
        AnalyzedToken at = new AnalyzedToken("", "", "fer");
        String verbPostag = tokens[posWord].readingWithTagRegex("V.*").getPOSTag();
        String newPostag = verbPostag.substring(0, 4) + "[30][S0]." + verbPostag.substring(7, 8);
        String[] synthForms = synth.synthesize(at, newPostag, true, this.getLanguageVariantCode(match));
        if (synthForms.length == 0) {
            return null;
        }
        suggestion.append(synthForms[0]);
        for (i = posWord + 1; i < tokens.length && tokens[i].getChunkTags().contains(new ChunkTag("PTime")); ++i) {
            if (tokens[i].isWhitespaceBefore()) {
                suggestion.append(" ");
            }
            suggestion.append(tokens[i].getToken());
        }
        int lastTokenPos = i;
        if (lastTokenPos + 1 >= tokens.length) {
            return null;
        }
        int adjustEndPos = 0;
        AnalyzedTokenReadings lastToken = tokens[lastTokenPos];
        if (lastToken.getToken().equals("que")) {
            suggestion.append(" que");
        } else if (lastToken.hasPosTagStartingWith("VMG") || lastToken.hasPosTagStartingWith("VSG")) {
            suggestion.append(" que ");
            result = PronomsFeblesHelper.getTwoNextPronouns(tokens, lastTokenPos + 1);
            pronoms = result[0];
            adjustEndPos += Integer.valueOf(result[1]).intValue();
            AnalyzedToken at2 = new AnalyzedToken("", "", lastToken.readingWithTagRegex("V.G.*").getLemma());
            String[] synthForms2 = synth.synthesize(at2, "V.I" + verbPostag.substring(3, 8), true, this.getLanguageVariantCode(match));
            if (synthForms2.length == 0) {
                return null;
            }
            if (!pronoms.isEmpty()) {
                suggestion.append(PronomsFeblesHelper.transformDavant(pronoms, synthForms2[0]));
            }
            suggestion.append(synthForms2[0]);
        } else if (lastToken.getToken().equals("sense") && (tokens[lastTokenPos + 1].hasPosTagStartingWith("VSN") || tokens[lastTokenPos + 1].hasPosTagStartingWith("VMN"))) {
            suggestion.append(" que no ");
            ++adjustEndPos;
            result = PronomsFeblesHelper.getTwoNextPronouns(tokens, lastTokenPos + 2);
            pronoms = result[0];
            adjustEndPos += Integer.valueOf(result[1]).intValue();
            AnalyzedToken at2 = new AnalyzedToken("", "", tokens[lastTokenPos + 1].readingWithTagRegex("V.N.*").getLemma());
            String[] synthForms2 = synth.synthesize(at2, "V.I" + verbPostag.substring(3, 8), true, this.getLanguageVariantCode(match));
            if (synthForms2.length == 0) {
                return null;
            }
            if (!pronoms.isEmpty()) {
                suggestion.append(PronomsFeblesHelper.transformDavant(pronoms, synthForms2[0]));
            }
            suggestion.append(synthForms2[0]);
        } else if (lastToken.getToken().equals("aix\u00ed") || lastToken.getToken().equals("a") || lastToken.getToken().equals("en") || lastToken.getToken().equals("ac\u00ed") || lastToken.getToken().equals("aqu\u00ed") || lastToken.getToken().equals("ah\u00ed") || lastToken.getToken().equals("all\u00ed") || lastToken.getToken().equals("all\u00e0") || lastToken.getToken().equals("de") || lastToken.hasPosTagStartingWith("AQ") || lastToken.hasPosTagStartingWith("VMP")) {
            AnalyzedToken at2 = new AnalyzedToken("", "", "estar");
            String[] synthForms2 = synth.synthesize(at2, "V.I" + verbPostag.substring(3, 8), true, this.getLanguageVariantCode(match));
            if (synthForms2.length == 0) {
                return null;
            }
            suggestion.append(" que " + synthForms2[0]);
            --adjustEndPos;
        } else {
            return null;
        }
        String replacement = suggestion.toString();
        replacement = StringTools.preserveCase((String)replacement, (String)tokens[posWord].getToken());
        if (replacement.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[posWord].getStartPos(), tokens[lastTokenPos + adjustEndPos].getEndPos(), match.getMessage(), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacement(replacement);
        return ruleMatch;
    }

    private String getLanguageVariantCode(RuleMatch match) {
        PatternRule pr = (PatternRule)match.getRule();
        return pr.getLanguage().getShortCodeWithCountryAndVariant();
    }
}

