/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public class EndOfParagraphPunctuationRule
extends TextLevelRule {
    private String ruleMessage = "Falta un punt al final del par\u00e0graf.";
    private String shortMessage = "Puntuaci\u00f3";

    public EndOfParagraphPunctuationRule(ResourceBundle messages) {
        this.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.setDefaultTempOff();
    }

    public String getId() {
        return "CA_END_PARAGRAPH_PUNCTUATION";
    }

    public String getDescription() {
        return "Puntuaci\u00f3 al final del par\u00e0graf.";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        int sentencesInParagraph = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            int lastTokenPos = tokens.length - 1;
            AnalyzedTokenReadings lastToken = tokens[lastTokenPos];
            String lastTokenStr = lastToken.getToken();
            if (lastToken.hasPosTag("PARA_END")) {
                if (sentencesInParagraph > 0 && (!StringTools.isPunctuationMark((String)lastTokenStr) || lastTokenStr.equals(",") || lastTokenStr.equals(";"))) {
                    RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, pos + lastToken.getStartPos(), pos + lastToken.getEndPos(), this.ruleMessage, this.shortMessage);
                    if (!StringTools.isPunctuationMark((String)lastTokenStr)) {
                        ruleMatch.setSuggestedReplacement(lastTokenStr + ".");
                    } else {
                        ruleMatch.setSuggestedReplacement(".");
                    }
                    ruleMatches.add(ruleMatch);
                }
                sentencesInParagraph = 0;
            } else {
                ++sentencesInParagraph;
            }
            pos += sentence.getCorrectedTextLength();
        }
        return ruleMatches.toArray(new RuleMatch[0]);
    }

    public int minToCheckParagraph() {
        return 0;
    }
}

