/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tools.StringTools;

public class AdjustPronounsFilter
extends RuleFilter {
    Pattern pApostropheNeeded = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 2);
    private static CatalanSynthesizer synth = CatalanSynthesizer.INSTANCE;
    private static Map<String, String> addEnApostrophe = new HashMap<String, String>();
    private static Map<String, String> addEn;
    private static Map<String, String> removeReflexive;
    private static Map<String, String> addReflexiveVowel;
    private static Map<String, String> addReflexiveConsonant;
    private static Map<String, String> addReflexiveImperative;

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        int posWord;
        ArrayList<String> replacements = new ArrayList<String>();
        List<String> actions = Arrays.asList(this.getRequired("actions", arguments).split(","));
        String newLemma = this.getOptional("newLemma", arguments);
        AnalyzedTokenReadings[] tokens = match.getSentence().getTokensWithoutWhitespace();
        for (posWord = 0; posWord < tokens.length && (tokens[posWord].getStartPos() < match.getFromPos() || tokens[posWord].isSentenceStart()); ++posWord) {
        }
        int toLeft = 0;
        boolean done = false;
        String firstVerb = "";
        String firstVerbPersonaNumber = "";
        String firstVerbPersonaNumberImperative = "";
        String replacementVerb = "";
        int firstVerbPos = 0;
        boolean inPronouns = false;
        boolean firstVerbValid = false;
        while (!done && posWord - toLeft > 0) {
            AnalyzedTokenReadings currentTkn = tokens[posWord - toLeft];
            String currentTknStr = currentTkn.getToken();
            if (toLeft == 0 && newLemma != null) {
                AnalyzedToken at;
                String[] synthForms;
                ArrayList<String> postags = new ArrayList<String>();
                for (AnalyzedToken reading : currentTkn) {
                    if (reading.getPOSTag() == null || !reading.getPOSTag().startsWith("V")) continue;
                    postags.add(reading.getPOSTag());
                }
                String targetPostag = synth.getTargetPosTag(postags, "");
                if (!targetPostag.isEmpty() && (synthForms = synth.synthesize(at = new AnalyzedToken(currentTknStr, targetPostag, newLemma), targetPostag)) != null && synthForms.length > 0) {
                    replacementVerb = synthForms[0];
                }
            }
            boolean isVerb = currentTkn.hasPosTagStartingWith("V");
            boolean isPronoun = currentTkn.matchesPosTagRegex("P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
            if (isPronoun) {
                inPronouns = true;
            }
            if (isPronoun || isVerb && !inPronouns && !firstVerbValid || currentTknStr.equalsIgnoreCase("de") || currentTknStr.equalsIgnoreCase("d'")) {
                if (isVerb) {
                    firstVerb = currentTknStr;
                    firstVerbPos = toLeft;
                    firstVerbValid = currentTkn.matchesPosTagRegex("V.[SI].*");
                    if (firstVerbValid) {
                        firstVerbPersonaNumber = currentTkn.readingWithTagRegex("V.[SI].*").getPOSTag().substring(4, 6);
                    }
                    if (currentTkn.matchesPosTagRegex("V.M.*")) {
                        firstVerbPersonaNumberImperative = currentTkn.readingWithTagRegex("V.M.*").getPOSTag().substring(4, 6);
                    }
                }
                ++toLeft;
                continue;
            }
            done = true;
            if (toLeft <= 0) continue;
            --toLeft;
        }
        if (!firstVerbValid) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = posWord - toLeft; i < posWord - firstVerbPos; ++i) {
            sb.append(tokens[i].getToken());
            if (!tokens[i + 1].isWhitespaceBefore()) continue;
            sb.append(" ");
        }
        String pronounsStr = sb.toString().trim();
        sb = new StringBuilder();
        for (int i = posWord - firstVerbPos; i <= posWord; ++i) {
            if (i == posWord && !replacementVerb.isEmpty()) {
                sb.append(replacementVerb);
            } else {
                sb.append(tokens[i].getToken());
            }
            if (i + 1 >= tokens.length || !tokens[i + 1].isWhitespaceBefore()) continue;
            sb.append(" ");
        }
        String verbStr = sb.toString().trim();
        for (String action : actions) {
            String replacement = "";
            switch (action) {
                case "addPronounEn": {
                    replacement = this.doAddPronounEn(firstVerb, pronounsStr, verbStr);
                    break;
                }
                case "removePronounReflexive": {
                    replacement = this.doRemovePronounReflexive(firstVerb, pronounsStr, verbStr);
                    break;
                }
                case "replaceEmEn": {
                    replacement = this.doReplaceEmEn(firstVerb, pronounsStr, verbStr);
                    break;
                }
                case "addPronounReflexive": {
                    replacement = this.doAddPronounReflexive(firstVerb, pronounsStr, verbStr, firstVerbPersonaNumber);
                    break;
                }
                case "addPronounReflexiveImperative": {
                    replacement = this.doAddPronounReflexiveImperative(firstVerb, pronounsStr, verbStr, firstVerbPersonaNumberImperative);
                }
            }
            if (replacement.isEmpty()) continue;
            replacements.add(replacement);
        }
        if (replacements.isEmpty()) {
            return null;
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), tokens[posWord - toLeft].getStartPos(), match.getToPos(), match.getMessage(), match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(replacements);
        return ruleMatch;
    }

    private String doAddPronounEn(String firstVerb, String pronounsStr, String verbStr) {
        Map<String, String> transform;
        String replacement = "";
        String between = "";
        if (this.pApostropheNeeded.matcher(firstVerb).matches()) {
            transform = addEnApostrophe;
        } else {
            transform = addEn;
            between = " ";
        }
        String pronounsReplacement = transform.get(pronounsStr.toLowerCase());
        if (pronounsReplacement != null) {
            replacement = StringTools.preserveCase((String)pronounsReplacement, (String)(pronounsStr + between + verbStr).trim()) + between + verbStr.toLowerCase();
        }
        return replacement;
    }

    private String doRemovePronounReflexive(String firstVerb, String pronounsStr, String verbStr) {
        String replacement = "";
        String between = " ";
        String pronounsReplacement = removeReflexive.get(pronounsStr.toLowerCase());
        if (pronounsReplacement != null) {
            replacement = StringTools.preserveCase((String)(pronounsReplacement + between + verbStr), (String)pronounsStr).trim().replaceAll("' ", "'");
        }
        return replacement;
    }

    private String doAddPronounReflexive(String firstVerb, String pronounsStr, String verbStr, String firstVerbPersonaNumber) {
        String pronounToAdd = "";
        String replacement = "";
        if (pronounsStr.isEmpty() && (pronounToAdd = this.pApostropheNeeded.matcher(verbStr).matches() ? addReflexiveVowel.get(firstVerbPersonaNumber) : addReflexiveConsonant.get(firstVerbPersonaNumber)) != null) {
            replacement = StringTools.preserveCase((String)(pronounToAdd + verbStr), (String)verbStr).trim().replaceAll("' ", "'");
        }
        return replacement;
    }

    private String doAddPronounReflexiveImperative(String firstVerb, String pronounsStr, String verbStr, String firstVerbPersonaNumber) {
        String pronounToAdd = "";
        String replacement = "";
        if (pronounsStr.isEmpty() && (pronounToAdd = addReflexiveImperative.get(firstVerbPersonaNumber)) != null) {
            replacement = StringTools.preserveCase((String)(verbStr + pronounToAdd), (String)verbStr).trim();
        }
        return replacement;
    }

    private String doReplaceEmEn(String firstVerb, String pronounsStr, String verbStr) {
        String replacement = "";
        if (pronounsStr.equalsIgnoreCase("em")) {
            replacement = StringTools.preserveCase((String)"en", (String)pronounsStr) + " " + verbStr;
        }
        if (pronounsStr.equalsIgnoreCase("m'")) {
            replacement = StringTools.preserveCase((String)"n'", (String)pronounsStr) + verbStr;
        }
        if (pronounsStr.equalsIgnoreCase("m'hi")) {
            replacement = StringTools.preserveCase((String)"n'hi ", (String)pronounsStr) + verbStr;
        }
        return replacement;
    }

    static {
        addEnApostrophe.put("m'", "me n'");
        addEnApostrophe.put("t'", "te n'");
        addEnApostrophe.put("s'", "se n'");
        addEnApostrophe.put("ens", "ens n'");
        addEnApostrophe.put("us", "us n'");
        addEnApostrophe.put("vos", "vos n'");
        addEnApostrophe.put("li", "li n'");
        addEnApostrophe.put("els", "els n'");
        addEnApostrophe.put("se m'", "se me n'");
        addEnApostrophe.put("se t'", "se te n'");
        addEnApostrophe.put("se li", "se li n'");
        addEnApostrophe.put("se'ns", "se'ns n'");
        addEnApostrophe.put("se us", "se us n'");
        addEnApostrophe.put("se vos", "se vos n'");
        addEnApostrophe.put("se'ls", "se'ls n'");
        addEnApostrophe.put("hi", "n'hi ");
        addEnApostrophe.put("", "n'");
        addEn = new HashMap<String, String>();
        addEn.put("em", "me'n");
        addEn.put("et", "te'n");
        addEn.put("es", "se'n");
        addEn.put("se", "se'n");
        addEn.put("ens", "ens en");
        addEn.put("us", "us en");
        addEn.put("li", "li'n");
        addEn.put("els", "els en");
        addEn.put("se'm", "se me'n");
        addEn.put("se't", "se te'n");
        addEn.put("se li", "se li'n");
        addEn.put("se'ns", "se'ns en");
        addEn.put("se us", "se us en");
        addEn.put("se vos", "se vos en");
        addEn.put("se'ls", "se'ls en");
        addEn.put("hi", "n'hi");
        addEn.put("", "en");
        removeReflexive = new HashMap<String, String>();
        removeReflexive.put("em", "");
        removeReflexive.put("me", "");
        removeReflexive.put("m'", "");
        removeReflexive.put("et", "");
        removeReflexive.put("te", "");
        removeReflexive.put("t'", "");
        removeReflexive.put("es", "");
        removeReflexive.put("se", "");
        removeReflexive.put("s'", "");
        removeReflexive.put("ens", "");
        removeReflexive.put("us", "");
        removeReflexive.put("vos", "");
        removeReflexive.put("se'm", "em");
        removeReflexive.put("se m'", "m'");
        removeReflexive.put("se't", "et");
        removeReflexive.put("se t'", "t'");
        removeReflexive.put("se li", "li");
        removeReflexive.put("se'ns", "ens");
        removeReflexive.put("se us", "us");
        removeReflexive.put("se'ls", "els");
        addReflexiveVowel = new HashMap<String, String>();
        addReflexiveVowel.put("1S", "m'");
        addReflexiveVowel.put("2S", "t'");
        addReflexiveVowel.put("3S", "s'");
        addReflexiveVowel.put("1P", "ens ");
        addReflexiveVowel.put("2P", "us ");
        addReflexiveVowel.put("3P", "s'");
        addReflexiveConsonant = new HashMap<String, String>();
        addReflexiveConsonant.put("1S", "em ");
        addReflexiveConsonant.put("2S", "et ");
        addReflexiveConsonant.put("3S", "es ");
        addReflexiveConsonant.put("1P", "ens ");
        addReflexiveConsonant.put("2P", "us ");
        addReflexiveConsonant.put("3P", "es ");
        addReflexiveImperative = new HashMap<String, String>();
        addReflexiveImperative.put("2S", "'t");
        addReflexiveImperative.put("3S", "'s");
        addReflexiveImperative.put("1P", "-nos");
        addReflexiveImperative.put("2P", "-vos");
        addReflexiveImperative.put("3P", "-se");
    }
}

