/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;

public class SimpleReplaceDiacriticsIEC
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongWords = SimpleReplaceDiacriticsIEC.loadFromPath((String)"/ca/replace_diacritics_iec.txt");
    private static final Locale CA_LOCALE = new Locale("CA");

    public Map<String, List<String>> getWrongWords() {
        return wrongWords;
    }

    public SimpleReplaceDiacriticsIEC(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        super.setCategory(new Category(new CategoryId("DIACRITICS_IEC"), "Z) Accents diacr\u00edtics segons l'IEC"));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        super.setDefaultOn();
        this.setCheckLemmas(false);
        super.useSubRuleSpecificIds();
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_DIACRITICS_IEC";
    }

    public String getDescription() {
        return "Accents diacr\u00edtics segons les normes noves (2017): $match";
    }

    public String getShort() {
        return "Hi sobra l'accent.";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Hi sobra l'accent diacr\u00edtic (segons les normes noves; desactiveu la regla si voleu les normes tradicionals).";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    protected boolean isTokenException(AnalyzedTokenReadings atr) {
        return atr.hasPosTagStartingWith("NP");
    }
}

