/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.FindSuggestionsFilter;
import org.languagetool.rules.spelling.morfologik.MorfologikSpeller;
import org.languagetool.tools.StringTools;

public class FindSuggestionsEsFilter
extends FindSuggestionsFilter {
    Pattern pApostropheNeeded = Pattern.compile("h?[aeiou\u00e0\u00e8\u00e9\u00ed\u00f2\u00f3\u00fa].*", 2);

    public FindSuggestionsEsFilter() throws IOException {
        if (speller == null && JLanguageTool.getDataBroker().resourceExists("/ca/ca-ES.dict")) {
            speller = new MorfologikSpeller("/ca/ca-ES.dict");
        }
    }

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        int posWord;
        ArrayList<String> replacements = new ArrayList<String>();
        for (posWord = 0; posWord < patternTokens.length && (patternTokens[posWord].getStartPos() < match.getFromPos() || patternTokens[posWord].isSentenceStart()); ++posWord) {
        }
        AnalyzedTokenReadings atrWord = patternTokens[++posWord];
        List<String> suggestions = this.getSpellingSuggestions(atrWord);
        boolean usedEsAccent = false;
        boolean usedEs = false;
        if (suggestions.size() > 0) {
            block1: for (String suggestion : suggestions) {
                List analyzedSuggestions = this.getTagger().tag(Collections.singletonList(this.cleanSuggestion(suggestion)));
                Iterator iterator = analyzedSuggestions.iterator();
                while (iterator.hasNext()) {
                    Matcher m;
                    AnalyzedTokenReadings analyzedSuggestion = (AnalyzedTokenReadings)iterator.next();
                    if (replacements.size() >= 20) continue block1;
                    if (analyzedSuggestion.matchesPosTagRegex("NP.*|NC.[SN].*|A...[SN].|V.P..S..|V.[NG].*|RG|PX..S...")) {
                        replacements.add("\u00e9s " + analyzedSuggestion.getToken());
                        usedEsAccent = true;
                    }
                    if (!analyzedSuggestion.matchesPosTagRegex("V...3.*") || (m = this.pApostropheNeeded.matcher(analyzedSuggestion.getToken())).matches()) continue;
                    replacements.add("es " + analyzedSuggestion.getToken().toLowerCase());
                    usedEs = true;
                }
            }
        }
        if (replacements.isEmpty()) {
            return null;
        }
        ArrayList<String> definitiveReplacements = new ArrayList<String>();
        String firstCh = patternTokens[posWord - 1].getToken().substring(0, 1);
        if (firstCh.toUpperCase().equals(firstCh)) {
            for (String r : replacements) {
                definitiveReplacements.add(StringTools.uppercaseFirstChar((String)r));
            }
        } else {
            definitiveReplacements.addAll(replacements);
        }
        boolean isFirstEsAccent = patternTokens[posWord - 1].getToken().equalsIgnoreCase("\u00e9s");
        String message = match.getMessage();
        if (isFirstEsAccent && usedEsAccent && !usedEs) {
            return null;
        }
        if (usedEsAccent) {
            message = message + " \"\u00c9s\" (del v. 'ser') s'escriu amb accent.";
        }
        if (usedEs) {
            message = message + " \"Es\" (pronom) acompanya un verb en tercera persona.";
        }
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        ruleMatch.setSuggestedReplacements(definitiveReplacements);
        return ruleMatch;
    }
}

