/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public class CatalanUnpairedQuestionMarksRule
extends TextLevelRule {
    public CatalanUnpairedQuestionMarksRule(ResourceBundle messages, Language language) {
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setDefaultOff();
    }

    protected String getStartSymbol() {
        return "\u00bf";
    }

    protected String getEndSymbol() {
        return "?";
    }

    public int minToCheckParagraph() {
        return 1;
    }

    public String getId() {
        return "CA_UNPAIRED_QUESTION";
    }

    public String getDescription() {
        return "Exigeix signe d'interrogaci\u00f3 inicial";
    }

    public RuleMatch[] match(List<AnalyzedSentence> sentences) {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
            int needsInvQuestionMarkAt = this.hasTokenAtPos(this.getEndSymbol(), tokens);
            if (needsInvQuestionMarkAt > 1) {
                boolean hasInvQuestionMark = false;
                AnalyzedTokenReadings firstToken = null;
                for (int i = 0; i < tokens.length; ++i) {
                    if (firstToken == null && !tokens[i].isSentenceStart() && !StringTools.isPunctuationMark((String)tokens[i].getToken())) {
                        firstToken = tokens[i];
                    }
                    if (tokens[i].getToken().equals(this.getStartSymbol()) && i < needsInvQuestionMarkAt) {
                        hasInvQuestionMark = true;
                    }
                    if (!tokens[i].isSentenceEnd() && tokens[i].getToken().equals(this.getEndSymbol()) && i < needsInvQuestionMarkAt) {
                        firstToken = null;
                    }
                    if (i > 2 && i + 2 < tokens.length) {
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("CC") && tokens[i + 1].hasPosTag("SPS00") && (tokens[i + 2].hasPosTagStartingWith("PT") || tokens[i + 2].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("SPS00") && (tokens[i + 1].hasPosTagStartingWith("PT") || tokens[i + 1].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("CC") && (tokens[i + 1].hasPosTagStartingWith("PT") || tokens[i + 1].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && (tokens[i].hasPosTagStartingWith("PT") || tokens[i].hasPosTagStartingWith("DT"))) {
                            firstToken = tokens[i];
                        }
                        if (tokens[i - 1].getToken().equals(",") && tokens[i].hasPosTag("CC") && (tokens[i + 1].getToken().equals("no") || tokens[i + 1].getToken().equals("s\u00ed"))) {
                            firstToken = tokens[i];
                        }
                    }
                    if (i <= 2 || i >= tokens.length || !tokens[i - 1].getToken().equals(",") || !tokens[i].getToken().equals("no") && !tokens[i].getToken().equals("s\u00ed") && !tokens[i].getToken().equals("oi") && !tokens[i].getToken().equals("eh")) continue;
                    firstToken = tokens[i];
                }
                if (firstToken != null) {
                    String s = null;
                    if (needsInvQuestionMarkAt > 1 && !hasInvQuestionMark) {
                        s = this.getStartSymbol();
                    }
                    if (s != null) {
                        String message = "S\u00edmbol sense parella: Sembla que falta un '" + s + "'";
                        RuleMatch match = new RuleMatch((Rule)this, sentence, pos + firstToken.getStartPos(), pos + firstToken.getEndPos(), message);
                        match.setSuggestedReplacement(s + firstToken.getToken());
                        matches.add(match);
                    }
                }
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(matches);
    }

    private int hasTokenAtPos(String ch, AnalyzedTokenReadings[] tokens) {
        for (int i = tokens.length - 1; i > 0; --i) {
            if (!tokens[i].getToken().equals(ch)) continue;
            return i;
        }
        return -1;
    }
}

