/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.ca.CatalanSynthesizer;

public abstract class AbstractSimpleReplaceLemmasRule
extends AbstractSimpleReplaceRule {
    protected Map<String, List<String>> wrongLemmas = null;
    private static final Locale CA_LOCALE = new Locale("CA");
    private CatalanSynthesizer synth;

    public AbstractSimpleReplaceLemmasRule(ResourceBundle messages, Language language) throws IOException {
        super(messages);
        this.synth = (CatalanSynthesizer)language.getSynthesizer();
    }

    protected Map<String, List<String>> getWrongWords() {
        return this.wrongLemmas;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String originalLemma = null;
        for (int i = 1; i < tokens.length; ++i) {
            List<String> replacementLemmas = null;
            String replacePOSTag = null;
            boolean bRuleMatches = false;
            for (AnalyzedToken at : tokens[i].getReadings()) {
                if (!this.getWrongWords().containsKey(at.getLemma())) continue;
                replacementLemmas = this.getWrongWords().get(at.getLemma());
                replacePOSTag = at.getPOSTag();
                bRuleMatches = true;
                originalLemma = at.getLemma();
                break;
            }
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            if (replacementLemmas != null && replacePOSTag != null) {
                String[] synthesized = null;
                for (String replacementLemma : replacementLemmas) {
                    try {
                        synthesized = this.synth.synthesize(new AnalyzedToken(replacementLemma, replacePOSTag, replacementLemma), replacePOSTag);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Could not synthesize: " + replacementLemma + " with tag " + replacePOSTag, e);
                    }
                    if (synthesized.length == 0) {
                        try {
                            String replacePOSTag2 = replacePOSTag.replaceAll("[MFC]S", ".S").replaceAll("[MFC]P", ".P");
                            synthesized = this.synth.synthesize(new AnalyzedToken(replacementLemma, replacePOSTag, replacementLemma), replacePOSTag2);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Could not synthesize: " + replacementLemma + " with tag " + replacePOSTag, e);
                        }
                    }
                    if (synthesized.length == 0 && replacementLemma.length() > 1) {
                        possibleReplacements.add(replacementLemma);
                        continue;
                    }
                    possibleReplacements.addAll(Arrays.asList(synthesized));
                }
            }
            if (!bRuleMatches) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokens[i], possibleReplacements, sentence, originalLemma);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

