/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tools.StringTools;

public final class MorfologikCatalanSpellerRule
extends MorfologikSpellerRule {
    private String dictFilename;
    private static final String SPELLING_FILE = "/ca/spelling.txt";
    private static final Pattern PARTICULA_INICIAL = Pattern.compile("^(no|en|a|els?|als?|pels?|dels?|de|per|uns?|una|unes|la|les|[tms]eus?) (..+)$", 66);
    private static final Pattern PREFIX_AMB_ESPAI = Pattern.compile("^(eco|tele|anti|re|des|avant|auto|ex|extra|macro|mega|meta|micro|multi|mono|mini|post|retro|semi|super|trans|pro|g) (..+)|.+ s$", 66);
    private static final Pattern APOSTROF_INICI_VERBS = Pattern.compile("^([lnts])[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*)$", 66);
    private static final Pattern APOSTROF_INICI_VERBS_M = Pattern.compile("^(m)[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].*)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_SING = Pattern.compile("^([ld])[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa]...+)$", 66);
    private static final Pattern APOSTROF_INICI_NOM_PLURAL = Pattern.compile("^(d)[90]?(h?[aeiou\u00e0\u00e9\u00e8\u00ed\u00f2\u00f3\u00fa].+)$", 66);
    private static final Pattern APOSTROF_FINAL = Pattern.compile("^(...+[aei])[90]?(l|ls|m|ns|n|t)$", 66);
    private static final Pattern APOSTROF_FINAL_S = Pattern.compile("^(.+e)[90]?(s)$", 66);
    private static final Pattern GUIONET_FINAL = Pattern.compile("^([\\p{L}\u00b7]+)[\u2019']?(hi|ho|la|les|li|lo|los|me|ne|nos|se|te|vos)$", 66);
    private static final Pattern SPLIT_SUGGESTIONS = Pattern.compile("^(..+\\p{L}|en|de|del|al|dels|als|a|i|o|amb)(\\d+)$", 66);
    private static final Pattern MOVE_TO_SECOND_POS = Pattern.compile("^(.+'[nt])$", 66);
    private static final Pattern VERB_INDSUBJ = Pattern.compile("V.[SI].*");
    private static final Pattern VERB_INDSUBJ_M = Pattern.compile("V.[SI].[123]S.*|V.[SI].[23]P.*");
    private static final Pattern NOM_SING = Pattern.compile("V.[NG].*|V.P..S..|N..[SN].*|A...[SN].|PX..S...|DD..S.");
    private static final Pattern NOM_PLURAL = Pattern.compile("V.P..P..|N..[PN].*|A...[PN].|PX..P...|DD..P.");
    private static final Pattern VERB_INFGERIMP = Pattern.compile("V.[NGM].*");
    private static final Pattern VERB_INF = Pattern.compile("V.N.*");
    private static final Pattern ANY_TAG = Pattern.compile("[NVACPDRS].*");
    private CatalanTagger tagger;

    public MorfologikCatalanSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        super(messages, language, userConfig, altLanguages);
        this.setIgnoreTaggedWords();
        this.tagger = language.getVariant() != null ? CatalanTagger.INSTANCE_VAL : CatalanTagger.INSTANCE_CAT;
        this.dictFilename = "/ca/" + language.getShortCodeWithCountryAndVariant() + ".dict";
    }

    public String getFileName() {
        return this.dictFilename;
    }

    public String getSpellingFileName() {
        return SPELLING_FILE;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_CA_ES";
    }

    public boolean useInOffice() {
        return true;
    }

    protected List<SuggestedReplacement> orderSuggestions(List<SuggestedReplacement> suggestions, String word) {
        ArrayList<SuggestedReplacement> newSuggestions = new ArrayList<SuggestedReplacement>();
        String wordWithouDiacriticsString = StringTools.removeDiacritics((String)word);
        for (int i = 0; i < suggestions.size(); ++i) {
            Matcher m;
            String suggWithoutDiacritics;
            int posNewSugg;
            if (PREFIX_AMB_ESPAI.matcher(suggestions.get(i).getReplacement()).matches()) continue;
            for (posNewSugg = 0; newSuggestions.size() > posNewSugg && StringTools.removeDiacritics((String)((SuggestedReplacement)newSuggestions.get(posNewSugg)).getReplacement()).equalsIgnoreCase(wordWithouDiacriticsString); ++posNewSugg) {
            }
            Matcher matcher = PARTICULA_INICIAL.matcher(suggestions.get(i).getReplacement());
            if (matcher.matches()) {
                boolean isBalear;
                String newSuggestion = matcher.group(2);
                List<AnalyzedTokenReadings> atkn = this.tagger.tag(Arrays.asList(newSuggestion));
                boolean bl = isBalear = atkn.get(0).hasPosTag("VMIP1S0B") && !atkn.get(0).hasPosTagStartingWith("N");
                if (!isBalear) {
                    newSuggestions.add(posNewSugg, suggestions.get(i));
                    continue;
                }
            }
            if (word.equalsIgnoreCase(suggWithoutDiacritics = StringTools.removeDiacritics((String)suggestions.get(i).getReplacement()))) {
                newSuggestions.add(posNewSugg, suggestions.get(i));
                continue;
            }
            String cleanSuggestion = suggestions.get(i).getReplacement().replaceAll("'", "").replaceAll("-", "");
            if (i > 1 && suggestions.size() > 2 && cleanSuggestion.equalsIgnoreCase(word)) {
                if (posNewSugg == 0) {
                    posNewSugg = 1;
                }
                newSuggestions.add(posNewSugg, suggestions.get(i));
                continue;
            }
            if (i == 1 && (m = MOVE_TO_SECOND_POS.matcher(suggestions.get(0).getReplacement())).matches()) {
                newSuggestions.add(0, suggestions.get(i));
                continue;
            }
            newSuggestions.add(suggestions.get(i));
        }
        return newSuggestions;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        List<String> suggestionsList = suggestions.stream().map(SuggestedReplacement::getReplacement).collect(Collectors.toList());
        return SuggestedReplacement.convert(this.getAdditionalTopSuggestionsString(suggestionsList, word));
    }

    private List<String> getAdditionalTopSuggestionsString(List<String> suggestions, String word) throws IOException {
        String suggestion = "";
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_VERBS, VERB_INDSUBJ, 2, "'", true);
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_VERBS_M, VERB_INDSUBJ_M, 2, "'", true);
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_NOM_SING, NOM_SING, 2, "'", true);
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_INICI_NOM_PLURAL, NOM_PLURAL, 2, "'", true);
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_FINAL, VERB_INFGERIMP, 1, "'", true);
        suggestion = this.findSuggestion(suggestion, word, APOSTROF_FINAL_S, VERB_INF, 1, "'", true);
        suggestion = this.findSuggestion(suggestion, word, GUIONET_FINAL, VERB_INFGERIMP, 1, "-", true);
        if (!(suggestion = this.findSuggestion(suggestion, word, SPLIT_SUGGESTIONS, ANY_TAG, 1, " ", true)).isEmpty()) {
            return Collections.singletonList(suggestion);
        }
        return Collections.emptyList();
    }

    private String findSuggestion(String suggestion, String word, Pattern wordPattern, Pattern postagPattern, int suggestionPosition, String separator, boolean recursive) throws IOException {
        if (!suggestion.isEmpty()) {
            return suggestion;
        }
        Matcher matcher = wordPattern.matcher(word);
        if (matcher.matches()) {
            List moresugg;
            String newSuggestion = matcher.group(suggestionPosition);
            AnalyzedTokenReadings newatr = this.tagger.tag(Arrays.asList(newSuggestion)).get(0);
            if ((!newatr.hasPosTag("VMIP1S0B") || newSuggestion.equals("fer")) && this.matchPostagRegexp(newatr, postagPattern)) {
                return matcher.group(1) + separator + matcher.group(2);
            }
            if (recursive && (moresugg = this.speller1.getSuggestions(newSuggestion)).size() > 0) {
                String newWord = suggestionPosition == 1 ? (String)moresugg.get(0) + matcher.group(2) : matcher.group(1) + ((String)moresugg.get(0)).toLowerCase();
                return this.findSuggestion(suggestion, newWord, wordPattern, postagPattern, suggestionPosition, separator, false);
            }
        }
        return "";
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            return true;
        }
        return false;
    }
}

