/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.ca;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tokenizers.WordTokenizer;

public class CatalanWordTokenizer
extends WordTokenizer {
    private static final String PF = "(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)";
    private static final int maxPatterns = 11;
    private final Pattern[] patterns = new Pattern[11];
    private static final Pattern ELA_GEMINADA = Pattern.compile("([aeiou\u00e0\u00e9\u00e8\u00ed\u00f3\u00f2\u00fa\u00ef\u00fcAEIOU\u00c0\u00c8\u00c9\u00cd\u00d2\u00d3\u00da\u00cf\u00dc])l[.\u2022]l([aeiou\u00e0\u00e9\u00e8\u00ed\u00f3\u00f2\u00fa\u00ef\u00fc])", 64);
    private static final Pattern ELA_GEMINADA_UPPERCASE = Pattern.compile("([AEIOU\u00c0\u00c8\u00c9\u00cd\u00d2\u00d3\u00da\u00cf\u00dc])L[.\u2022]L([AEIOU\u00c0\u00c8\u00c9\u00cd\u00d2\u00d3\u00da\u00cf\u00dc])", 64);
    private static final Pattern APOSTROF_RECTE = Pattern.compile("([\\p{L}])'([\\p{L}\"\u2018\u201c\u00ab])", 66);
    private static final Pattern APOSTROF_RODO = Pattern.compile("([\\p{L}])\u2019([\\p{L}\"\u2018\u201c\u00ab])", 66);
    private static final Pattern APOSTROF_RECTE_1 = Pattern.compile("([dlDL])'(\\d[\\d\\s\\.,]?)", 66);
    private static final Pattern APOSTROF_RODO_1 = Pattern.compile("([dlDL])\u2019(\\d[\\d\\s\\.,]?)", 66);
    private static final Pattern NEARBY_HYPHENS = Pattern.compile("([\\p{L}])-([\\p{L}])-([\\p{L}])", 66);
    private static final Pattern HYPHENS = Pattern.compile("([\\p{L}])-([\\p{L}\\d])", 66);
    private static final Pattern DECIMAL_POINT = Pattern.compile("([\\d])\\.([\\d])", 66);
    private static final Pattern DECIMAL_COMMA = Pattern.compile("([\\d]),([\\d])", 66);
    private static final Pattern SPACE_DIGITS0 = Pattern.compile("([\\d]{4}) ", 66);
    private static final Pattern SPACE_DIGITS = Pattern.compile("([\\d]) ([\\d][\\d][\\d])", 66);
    private static final Pattern SPACE_DIGITS2 = Pattern.compile("([\\d]) ([\\d][\\d][\\d]) ([\\d][\\d][\\d])", 66);
    private static final Pattern HYPHEN_L = Pattern.compile("([\\p{L}]+)(-)([Ll]['\u2019])([\\p{L}]+)", 66);

    public CatalanWordTokenizer() {
        this.patterns[0] = Pattern.compile("^([lnmtsd]['\u2019])([^'\u2019\\-]*)$", 66);
        this.patterns[1] = Pattern.compile("^(qui-sap-lo|qui-sap-la|qui-sap-los|qui-sap-les)|(Castella)(-)(la)$", 66);
        this.patterns[2] = Pattern.compile("^([lnmtsd]['\u2019])(.{2,})(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[3] = Pattern.compile("^(.{2,})(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[4] = Pattern.compile("^([lnmtsd]['\u2019])(.{2,})(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[5] = Pattern.compile("^(.{2,})(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[6] = Pattern.compile("^([lnmtsd]['\u2019])(.{2,})(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[7] = Pattern.compile("^(.+[^wo])(['\u2019]en|['\u2019]hi|['\u2019]ho|['\u2019]l|['\u2019]ls|['\u2019]m|['\u2019]n|['\u2019]ns|['\u2019]s|['\u2019]t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[8] = Pattern.compile("^([lnmtsd]['\u2019])(.*)$", 66);
        this.patterns[9] = Pattern.compile("^(a|de|pe)(ls?)$", 66);
        this.patterns[10] = Pattern.compile("^(ca)(n)$", 66);
    }

    public List<String> tokenize(String text) {
        ArrayList<String> l = new ArrayList<String>();
        String auxText = text;
        Matcher matcher = ELA_GEMINADA.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001ELA_GEMINADA\u0001\u0001$2");
        matcher = ELA_GEMINADA_UPPERCASE.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001ELA_GEMINADA_UPPERCASE\u0001\u0001$2");
        matcher = APOSTROF_RECTE.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_APOS_RECTE\u0001\u0001$2");
        matcher = APOSTROF_RECTE_1.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_APOS_RECTE\u0001\u0001$2");
        matcher = APOSTROF_RODO.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_APOS_RODO\u0001\u0001$2");
        matcher = APOSTROF_RODO_1.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_APOS_RODO\u0001\u0001$2");
        matcher = NEARBY_HYPHENS.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_HYPHEN\u0001\u0001$2\u0001\u0001CA_HYPHEN\u0001\u0001$3");
        matcher = HYPHENS.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_HYPHEN\u0001\u0001$2");
        matcher = DECIMAL_POINT.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_DECIMALPOINT\u0001\u0001$2");
        matcher = DECIMAL_COMMA.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_DECIMALCOMMA\u0001\u0001$2");
        matcher = SPACE_DIGITS0.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_SPACE0\u0001\u0001");
        matcher = SPACE_DIGITS2.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_SPACE\u0001\u0001$2\u0001\u0001CA_SPACE\u0001\u0001$3");
        matcher = SPACE_DIGITS.matcher(auxText);
        auxText = matcher.replaceAll("$1\u0001\u0001CA_SPACE\u0001\u0001$2");
        auxText = auxText.replaceAll("\\u0001\\u0001CA_SPACE0\\u0001\\u0001", " ");
        StringTokenizer st = new StringTokenizer(auxText, " \u00a0\u115f\u1160\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u200c\u200d\u200e\u200f\u2012\u2013\u2014\u2015\u2022\u2500\u3161\u2713\u2028\u2029\u202a\u202b\u202c\u202d\u202e\u202f\u203c\u205f\u2060\u2061\u2062\u2063\u206a\u206b\u206c\u206d\u206e\u206f\u3000\u3164\ufeff\uffa0\ufff9\ufffa\ufffb\u2b9a\u2265\u2192\u21fe\u21c9\u21d2\u21e8\u21db|,.;()[]{}=*#\u2217+\u00d7\u00f7<>!?:~/\\\"'\u00ab\u00bb\u201e\u201d\u201c\u2018\u2019`\u00b4\u2026\u00bf\u00a1\t\n\r-\u2122\u00ae", true);
        while (st.hasMoreElements()) {
            String s = st.nextToken().replace("\u0001\u0001CA_APOS_RECTE\u0001\u0001", "'").replace("\u0001\u0001CA_APOS_RODO\u0001\u0001", "\u2019").replace("\u0001\u0001CA_HYPHEN\u0001\u0001", "-").replace("\u0001\u0001CA_DECIMALPOINT\u0001\u0001", ".").replace("\u0001\u0001CA_DECIMALCOMMA\u0001\u0001", ",").replace("\u0001\u0001CA_SPACE\u0001\u0001", " ").replace("\u0001\u0001ELA_GEMINADA\u0001\u0001", "l.l").replace("\u0001\u0001ELA_GEMINADA_UPPERCASE\u0001\u0001", "L.L");
            boolean matchFound = false;
            for (int j = 0; j < 11 && !matchFound; ++j) {
                matcher = this.patterns[j].matcher(s);
                matchFound = matcher.find();
            }
            if (matchFound) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String groupStr = matcher.group(i);
                    if (groupStr == null) continue;
                    l.addAll(this.wordsToAdd(groupStr));
                }
                continue;
            }
            l.addAll(this.wordsToAdd(s));
        }
        return this.joinEMailsAndUrls(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> wordsToAdd(String s) {
        ArrayList<String> l = new ArrayList<String>();
        CatalanWordTokenizer catalanWordTokenizer = this;
        synchronized (catalanWordTokenizer) {
            if (!s.isEmpty()) {
                if (!(s.contains("-") || s.endsWith("'") || s.endsWith("\u2019"))) {
                    l.add(s);
                } else if (CatalanTagger.INSTANCE_CAT.tag(Arrays.asList(s.replace("\u2019", "'"))).get(0).isTagged()) {
                    l.add(s);
                } else if (s.equalsIgnoreCase("mers-cov") || s.equalsIgnoreCase("mcgraw-hill") || s.equalsIgnoreCase("sars-cov-2") || s.equalsIgnoreCase("sars-cov") || s.equalsIgnoreCase("ph-metre") || s.equalsIgnoreCase("ph-metres")) {
                    l.add(s);
                } else if (CatalanTagger.INSTANCE_CAT.tag(Arrays.asList(s.replace("l-l", "l\u00b7l"))).get(0).isTagged()) {
                    l.add(s);
                } else if ((s.endsWith("'") || s.endsWith("\u2019")) && s.length() > 1) {
                    l.addAll(this.wordsToAdd(s.substring(0, s.length() - 1)));
                    l.add(s.substring(s.length() - 1));
                } else {
                    Matcher matcher = HYPHEN_L.matcher(s);
                    if (matcher.matches()) {
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            String groupStr = matcher.group(i);
                            l.addAll(this.wordsToAdd(groupStr));
                        }
                    } else {
                        StringTokenizer st2 = new StringTokenizer(s, "-", true);
                        while (st2.hasMoreElements()) {
                            l.add(st2.nextToken());
                        }
                    }
                }
            }
            return l;
        }
    }
}

