/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class PronomFebleDuplicateRule
extends Rule {
    private static final Pattern PRONOM_FEBLE = Pattern.compile("P0.{6}|PP3CN000|PP3NN000|PP3..A00|PP3CP000|PP3CSD00");
    private static final Pattern VERB_CONJUGAT = Pattern.compile("V.[IS].*");
    private static final Pattern INFINITIU = Pattern.compile("V.N.*");
    private static final Pattern PARTICIPI = Pattern.compile("V.P..SM.");
    private static final Pattern GERUNDI = Pattern.compile("V.G.*");
    private static final String[] ABANS_DE_GERUNDI = new String[]{"continuar", "seguir", "prosseguir", "anar", "estar"};
    private static final String[] ABANS_DE_INFINITIU = new String[]{"anar", "poder", "voler", "deure"};
    private static final String[] ABANS_DE_A = new String[]{"comen\u00e7ar", "tornar"};

    public String getId() {
        return "PRONOMS_FEBLES_DUPLICATS";
    }

    public String getDescription() {
        return "Pronoms febles duplicats";
    }

    public PronomFebleDuplicateRule(ResourceBundle messages) throws IOException {
        super.setCategory(new Category(new CategoryId("PRONOMS_FEBLES"), "Pronoms febles"));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.addExamplePair(Example.wrong((String)"<marker>S'ha de fer-se</marker>."), Example.fixed((String)"<marker>S'ha de fer</marker>."));
    }

    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String PFLemma = "";
        int initPos = -1;
        boolean isPrevInfinitive = false;
        for (int i = 1; i < tokens.length; ++i) {
            RuleMatch ruleMatch;
            if (PFLemma.isEmpty()) {
                PFLemma = this.getLemmaOfPronomFeble(tokens[i]);
                if (i > 1 && !tokens[i].isWhitespaceBefore()) {
                    PFLemma = "";
                    initPos = -1;
                    continue;
                }
                if (PFLemma.isEmpty()) continue;
                initPos = i;
                continue;
            }
            String PFLemma2 = this.getLemmaOfPronomFeble(tokens[i]);
            if (!tokens[i].isWhitespaceBefore() && PFLemma2.equals(PFLemma) && isPrevInfinitive) {
                int j;
                ruleMatch = new RuleMatch((Rule)this, sentence, tokens[initPos].getStartPos(), tokens[i].getEndPos(), "Pronom feble duplicat. Elimineu-ne un.", "Pronom feble duplicat");
                StringBuilder suggestion = new StringBuilder();
                for (j = initPos + 1; j <= i; ++j) {
                    if (j > initPos + 1 && tokens[j].isWhitespaceBefore()) {
                        suggestion.append(' ');
                    }
                    String strToAdd = tokens[j].getToken();
                    if (j == initPos + 1 && StringTools.isCapitalizedWord((String)tokens[initPos].getToken())) {
                        strToAdd = StringTools.uppercaseFirstChar((String)strToAdd);
                    }
                    suggestion.append(strToAdd);
                }
                ruleMatch.addSuggestedReplacement(suggestion.toString());
                suggestion = new StringBuilder();
                for (j = initPos; j <= i - 1; ++j) {
                    if (j > initPos && tokens[j].isWhitespaceBefore()) {
                        suggestion.append(' ');
                    }
                    suggestion.append(tokens[j].getToken());
                }
                ruleMatch.addSuggestedReplacement(suggestion.toString());
                ruleMatches.add(ruleMatch);
                continue;
            }
            if (!tokens[i].isWhitespaceBefore() && isPrevInfinitive && (PFLemma.equals("en") && PFLemma2.equals("hi") || PFLemma.equals("hi") && PFLemma2.equals("en"))) {
                ruleMatch = new RuleMatch((Rule)this, sentence, tokens[initPos].getStartPos(), tokens[i].getEndPos(), "Combinaci\u00f3 de pronoms febles probablement incorrecta", "Pronoms febles incorrectes");
                ruleMatches.add(ruleMatch);
                continue;
            }
            boolean bl = isPrevInfinitive = this.matchPostagRegexp(tokens[i], INFINITIU) || this.matchPostagRegexp(tokens[i], GERUNDI) && tokens[i - 1].hasAnyLemma(ABANS_DE_GERUNDI);
            if (this.keepChecking(tokens, i, initPos)) continue;
            PFLemma = "";
            initPos = -1;
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean keepChecking(AnalyzedTokenReadings[] tokens, int i, int initPos) {
        if (i == initPos + 1) {
            return this.matchPostagRegexp(tokens[i], VERB_CONJUGAT);
        }
        if (tokens[i].hasLemma("de")) {
            return tokens[i - 1].hasLemma("haver");
        }
        if (tokens[i].hasLemma("a")) {
            return tokens[i - 1].hasAnyLemma(ABANS_DE_A);
        }
        if (this.matchPostagRegexp(tokens[i], PARTICIPI)) {
            return tokens[i - 1].hasLemma("haver");
        }
        if (this.matchPostagRegexp(tokens[i], GERUNDI)) {
            return tokens[i - 1].hasAnyLemma(ABANS_DE_GERUNDI);
        }
        if (this.matchPostagRegexp(tokens[i], INFINITIU)) {
            return tokens[i - 1].hasAnyLemma(ABANS_DE_INFINITIU) || tokens[i - 1].hasLemma("de") || tokens[i - 1].hasLemma("a");
        }
        return false;
    }

    private String getLemmaOfPronomFeble(AnalyzedTokenReadings aToken) {
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = PRONOM_FEBLE.matcher(posTag)).matches()) continue;
            return analyzedToken.getLemma();
        }
        return "";
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null) {
                posTag = "UNKNOWN";
            }
            if (!(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }
}

