/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.language.Catalan;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tagging.ca.CatalanTagger;

public class FindSuggestionsFilter
extends RuleFilter {
    private static final CatalanTagger tagger = new CatalanTagger(new Catalan());
    private MorfologikCatalanSpellerRule morfologikRule;
    private final int MAX_SUGGESTIONS = 10;

    public FindSuggestionsFilter() throws IOException {
        ResourceBundle messages = JLanguageTool.getDataBroker().getResourceBundle("org.languagetool.MessagesBundle", new Locale("ca"));
        this.morfologikRule = new MorfologikCatalanSpellerRule(messages, new Catalan(), null, Collections.emptyList());
    }

    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        ArrayList<String> replacements = new ArrayList<String>();
        String wordFrom = this.getRequired("WordFrom", arguments);
        String desiredPostag = this.getRequired("DesiredPostag", arguments);
        if (wordFrom != null && desiredPostag != null) {
            int posWord = Integer.parseInt(wordFrom);
            if (posWord < 1 || posWord > patternTokens.length) {
                throw new IllegalArgumentException("FindSuggestionsFilter: Index out of bounds in " + match.getRule().getFullId() + ", PronounFrom: " + posWord);
            }
            AnalyzedTokenReadings atrWord = patternTokens[posWord - 1];
            AnalyzedTokenReadings[] auxPatternTokens = new AnalyzedTokenReadings[]{atrWord.isTagged() ? new AnalyzedTokenReadings(new AnalyzedToken(this.makeWrong(atrWord.getToken()), null, null)) : atrWord};
            AnalyzedSentence sentence = new AnalyzedSentence(auxPatternTokens);
            RuleMatch[] matches = this.morfologikRule.match(sentence);
            if (matches.length > 0) {
                List suggestions = matches[0].getSuggestedReplacements();
                List<AnalyzedTokenReadings> analyzedSuggestions = tagger.tag(suggestions);
                for (AnalyzedTokenReadings analyzedSuggestion : analyzedSuggestions) {
                    if (!analyzedSuggestion.matchesPosTagRegex(desiredPostag)) continue;
                    if (!replacements.contains(analyzedSuggestion.getToken()) && !replacements.contains(analyzedSuggestion.getToken().toLowerCase())) {
                        replacements.add(analyzedSuggestion.getToken());
                    }
                    if (replacements.size() < 10) continue;
                    break;
                }
            }
        }
        String message = match.getMessage();
        RuleMatch ruleMatch = new RuleMatch(match.getRule(), match.getSentence(), match.getFromPos(), match.getToPos(), message, match.getShortMessage());
        ruleMatch.setType(match.getType());
        ArrayList<String> definitiveReplacements = new ArrayList<String>();
        boolean replacementsUsed = false;
        block1: for (String s : match.getSuggestedReplacements()) {
            if (s.contains("{suggestion}")) {
                replacementsUsed = true;
                for (String s2 : replacements) {
                    if (definitiveReplacements.size() >= 10) continue block1;
                    definitiveReplacements.add(s.replace("{suggestion}", s2));
                }
                continue;
            }
            definitiveReplacements.add(s);
        }
        if (!replacementsUsed) {
            definitiveReplacements.addAll(replacements);
        }
        if (!definitiveReplacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(definitiveReplacements);
        }
        return ruleMatch;
    }

    private String makeWrong(String s) {
        if (s.contains("a")) {
            return s.replace("a", "\u00e4");
        }
        if (s.contains("e")) {
            return s.replace("e", "\u00eb");
        }
        if (s.contains("i")) {
            return s.replace("i", "\u00ef");
        }
        if (s.contains("o")) {
            return s.replace("o", "\u00f6");
        }
        if (s.contains("u")) {
            return s.replace("u", "\u00f9");
        }
        if (s.contains("\u00e0")) {
            return s.replace("\u00e0", "\u00e4");
        }
        if (s.contains("\u00e9")) {
            return s.replace("\u00e9", "\u00eb");
        }
        if (s.contains("\u00e8")) {
            return s.replace("\u00e8", "\u00eb");
        }
        if (s.contains("\u00ed")) {
            return s.replace("\u00ed", "\u00ec");
        }
        if (s.contains("\u00f3")) {
            return s.replace("\u00f3", "\u00f6");
        }
        if (s.contains("\u00f2")) {
            return s.replace("\u00f2", "\u00f6");
        }
        if (s.contains("\u00fa")) {
            return s.replace("\u00fa", "\u00f9");
        }
        return s + "-";
    }
}

