/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.language.Contributor;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.ca.AccentuationCheckRule;
import org.languagetool.rules.ca.CatalanUnpairedBracketsRule;
import org.languagetool.rules.ca.CatalanUnpairedExclamationMarksRule;
import org.languagetool.rules.ca.CatalanUnpairedQuestionMarksRule;
import org.languagetool.rules.ca.CatalanWordRepeatRule;
import org.languagetool.rules.ca.CatalanWrongWordInContextRule;
import org.languagetool.rules.ca.ComplexAdjectiveConcordanceRule;
import org.languagetool.rules.ca.MorfologikCatalanSpellerRule;
import org.languagetool.rules.ca.ReflexiveVerbsRule;
import org.languagetool.rules.ca.ReplaceOperationNamesRule;
import org.languagetool.rules.ca.SimpleReplaceBalearicRule;
import org.languagetool.rules.ca.SimpleReplaceDNVRule;
import org.languagetool.rules.ca.SimpleReplaceRule;
import org.languagetool.rules.ca.SimpleReplaceVerbsRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.ca.CatalanSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.ca.CatalanHybridDisambiguator;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.ca.CatalanWordTokenizer;

public class Catalan
extends Language {
    private static final Language DEFAULT_CATALAN = new Catalan();
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Tokenizer wordTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;

    public String getName() {
        return "Catalan";
    }

    public String[] getCountries() {
        return new String[]{"ES"};
    }

    public String getShortCode() {
        return "ca";
    }

    public Language getDefaultLanguageVariant() {
        return DEFAULT_CATALAN;
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Ricard Roca"), new Contributor("Jaume Ortol\u00e0")};
    }

    public List<Rule> getRelevantRules(ResourceBundle messages) throws IOException {
        return Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"A parer seu<marker> ,</marker> no era veritat."), Example.fixed((String)"A parer seu<marker>,</marker> no era veritat.")), new DoublePunctuationRule(messages), new CatalanUnpairedBracketsRule(messages, this), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"Preus de venda al p\u00fablic. <marker>han</marker> pujat molt."), Example.fixed((String)"Preus de venda al p\u00fablic. <marker>Han</marker> pujat molt.")), new MultipleWhitespaceRule(messages, (Language)this), new LongSentenceRule(messages), new CatalanWordRepeatRule(messages, this), new MorfologikCatalanSpellerRule(messages, this), new CatalanUnpairedQuestionMarksRule(messages, this), new CatalanUnpairedExclamationMarksRule(messages, this), new AccentuationCheckRule(messages), new ComplexAdjectiveConcordanceRule(messages), new CatalanWrongWordInContextRule(messages), new ReflexiveVerbsRule(messages), new SimpleReplaceVerbsRule(messages, this), new SimpleReplaceBalearicRule(messages), new SimpleReplaceRule(messages), new ReplaceOperationNamesRule(messages, this), new SimpleReplaceDNVRule(messages, this)});
    }

    public Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new CatalanTagger(this);
        }
        return this.tagger;
    }

    public Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new CatalanSynthesizer();
        }
        return this.synthesizer;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new CatalanHybridDisambiguator();
        }
        return this.disambiguator;
    }

    public Tokenizer getWordTokenizer() {
        if (this.wordTokenizer == null) {
            this.wordTokenizer = new CatalanWordTokenizer();
        }
        return this.wordTokenizer;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public int getPriorityForId(String id) {
        switch (id) {
            case "CA_SIMPLE_REPLACE_BALEARIC": {
                return 100;
            }
            case "CONFUSIONS_ACCENT": {
                return 20;
            }
            case "DIACRITICS": {
                return 20;
            }
            case "ACCENTUATION_CHECK": {
                return 10;
            }
            case "CONCORDANCES_DET_NOM": {
                return 5;
            }
            case "REGIONAL_VERBS": {
                return -10;
            }
            case "FALTA_ELEMENT_ENTRE_VERBS": {
                return -10;
            }
            case "FALTA_COMA_FRASE_CONDICIONAL": {
                return -20;
            }
            case "MUNDAR": {
                return -50;
            }
            case "MORFOLOGIK_RULE_CA_ES": {
                return -100;
            }
            case "NOMBRES_ROMANS": {
                return -400;
            }
            case "UPPERCASE_SENTENCE_START": {
                return -500;
            }
        }
        return 0;
    }
}

