/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.AbstractSimpleReplaceRule;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.synthesis.ca.CatalanSynthesizer;

public class SimpleReplaceDNVRule
extends AbstractSimpleReplaceRule {
    private static final Map<String, List<String>> wrongLemmas = SimpleReplaceDNVRule.load((String)"/ca/replace_dnv.txt");
    private static final Locale CA_LOCALE = new Locale("CA");
    private static final CatalanSynthesizer synth = new CatalanSynthesizer();

    protected Map<String, List<String>> getWrongWords() {
        return wrongLemmas;
    }

    public SimpleReplaceDNVRule(ResourceBundle messages) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        super.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.setIgnoreTaggedWords();
    }

    public final String getId() {
        return "CA_SIMPLE_REPLACE_DNV";
    }

    public String getDescription() {
        return "Detecta paraules admeses nom\u00e9s per l'AVL i proposa suggeriments de canvi";
    }

    public String getShort() {
        return "Paraula admesa nom\u00e9s pel DNV (AVL).";
    }

    public String getMessage(String tokenStr, List<String> replacements) {
        return "Paraula admesa pel DNV (AVL), per\u00f2 no per altres diccionaris.";
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Locale getLocale() {
        return CA_LOCALE;
    }

    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            List<String> replacementLemmas = null;
            String replacePOSTag = null;
            for (AnalyzedToken at : tokens[i].getReadings()) {
                if (!wrongLemmas.containsKey(at.getLemma())) continue;
                replacementLemmas = wrongLemmas.get(at.getLemma());
                replacePOSTag = at.getPOSTag();
                break;
            }
            if (replacementLemmas == null || replacePOSTag == null) continue;
            ArrayList<String> possibleReplacements = new ArrayList<String>();
            String[] synthesized = null;
            for (String replacementLemma : replacementLemmas) {
                try {
                    synthesized = synth.synthesize(new AnalyzedToken(replacementLemma, replacePOSTag, replacementLemma), replacePOSTag);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not synthesize: " + replacementLemma + " with tag " + replacePOSTag, e);
                }
                possibleReplacements.addAll(Arrays.asList(synthesized));
            }
            if (possibleReplacements.size() <= 0) continue;
            RuleMatch potentialRuleMatch = this.createRuleMatch(tokens[i], possibleReplacements);
            ruleMatches.add(potentialRuleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

