/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.util.Calendar;
import java.util.Locale;
import org.languagetool.rules.AbstractDateCheckFilter;

public class DateCheckFilter
extends AbstractDateCheckFilter {
    protected Calendar getCalendar() {
        return Calendar.getInstance(Locale.UK);
    }

    protected int getDayOfWeek(String dayStr) {
        String day = dayStr.toLowerCase();
        if (day.equals("dg") || day.equals("diumenge")) {
            return 1;
        }
        if (day.equals("dl") || day.equals("dilluns")) {
            return 2;
        }
        if (day.equals("dt") || day.equals("dimarts")) {
            return 3;
        }
        if (day.equals("dc") || day.equals("dimecres")) {
            return 4;
        }
        if (day.equals("dj") || day.equals("dijous")) {
            return 5;
        }
        if (day.equals("dv") || day.equals("divendres")) {
            return 6;
        }
        if (day.equals("ds") || day.equals("dissabte")) {
            return 7;
        }
        throw new RuntimeException("Could not find day of week for '" + dayStr + "'");
    }

    protected String getDayOfWeek(Calendar date) {
        String englishDay = date.getDisplayName(7, 2, Locale.UK);
        if (englishDay.equals("Sunday")) {
            return "diumenge";
        }
        if (englishDay.equals("Monday")) {
            return "dilluns";
        }
        if (englishDay.equals("Tuesday")) {
            return "dimarts";
        }
        if (englishDay.equals("Wednesday")) {
            return "dimecres";
        }
        if (englishDay.equals("Thursday")) {
            return "dijous";
        }
        if (englishDay.equals("Friday")) {
            return "divendres";
        }
        if (englishDay.equals("Saturday")) {
            return "dissabte";
        }
        return "";
    }

    protected int getMonth(String monthStr) {
        String mon = monthStr.toLowerCase();
        if (mon.startsWith("gen")) {
            return 1;
        }
        if (mon.startsWith("febr")) {
            return 2;
        }
        if (mon.startsWith("mar\u00e7")) {
            return 3;
        }
        if (mon.startsWith("abr")) {
            return 4;
        }
        if (mon.startsWith("maig")) {
            return 5;
        }
        if (mon.startsWith("juny")) {
            return 6;
        }
        if (mon.startsWith("jul")) {
            return 7;
        }
        if (mon.startsWith("ag")) {
            return 8;
        }
        if (mon.startsWith("set")) {
            return 9;
        }
        if (mon.startsWith("oct")) {
            return 10;
        }
        if (mon.startsWith("nov")) {
            return 11;
        }
        if (mon.startsWith("des")) {
            return 12;
        }
        throw new RuntimeException("Could not find month '" + monthStr + "'");
    }
}

