/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ca.CatalanRule;
import org.languagetool.tools.StringTools;

public class AccentuationCheckRule
extends CatalanRule {
    private static final String FILE_NAME = "/ca/verb_senseaccent_nom_ambaccent.txt";
    private static final String FILE_NAME2 = "/ca/verb_senseaccent_adj_ambaccent.txt";
    private static final String FILE_ENCODING = "utf-8";
    private static final Pattern PREPOSICIO_DE = Pattern.compile("de|d'|del|dels");
    private static final Pattern ARTICLE_EL_MS = Pattern.compile("el|l'|El|L'");
    private static final Pattern ARTICLE_EL_FS = Pattern.compile("la|l'|La|L'");
    private static final Pattern ARTICLE_EL_MP = Pattern.compile("els|Els");
    private static final Pattern ARTICLE_EL_FP = Pattern.compile("les|Les");
    private static final Pattern DETERMINANT = Pattern.compile("D[^R].*");
    private static final Pattern DETERMINANT_MS = Pattern.compile("D[^R].[MC][SN].*");
    private static final Pattern DETERMINANT_FS = Pattern.compile("D[^R].[FC][SN].*");
    private static final Pattern DETERMINANT_MP = Pattern.compile("D[^R].[MC][PN].*");
    private static final Pattern DETERMINANT_FP = Pattern.compile("D[^R].[FC][PN].*");
    private static final Pattern NOM_MS = Pattern.compile("NC[MC][SN].*");
    private static final Pattern NOM_FS = Pattern.compile("NC[FC][SN].*");
    private static final Pattern NOM_MP = Pattern.compile("NC[MC][PN].*");
    private static final Pattern NOM_FP = Pattern.compile("NC[FC][PN].*");
    private static final Pattern ADJECTIU_MS = Pattern.compile("AQ.[MC][SN].*|V.P..SM.?|PX.MS.*");
    private static final Pattern ADJECTIU_FS = Pattern.compile("AQ.[FC][SN].*|V.P..SF.?|PX.FS.*");
    private static final Pattern ADJECTIU_MP = Pattern.compile("AQ.[MC][PN].*|V.P..PM.?|PX.MP.*");
    private static final Pattern ADJECTIU_FP = Pattern.compile("AQ.[FC][PN].*|V.P..PF.?|PX.FP.*");
    private static final Pattern INFINITIU = Pattern.compile("V.N.*");
    private static final Pattern VERB_CONJUGAT = Pattern.compile("V.[^NGP].*|_GV_");
    private static final Pattern PARTICIPI_MS = Pattern.compile("V.P.*SM.?");
    private static final Pattern GRUP_VERBAL = Pattern.compile("_GV_");
    private static final Pattern VERB_3S = Pattern.compile("V...3S..?");
    private static final Pattern NOT_IN_PREV_TOKEN = Pattern.compile("VA.*|PP.*|P0.*|VSP.*");
    private static final Pattern BEFORE_ADJECTIVE_MS = Pattern.compile("SPS00|D[^R].[MC][SN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_FS = Pattern.compile("SPS00|D[^R].[FC][SN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_MP = Pattern.compile("SPS00|D[^R].[MC][PN].*|V.[^NGP].*|PX.*");
    private static final Pattern BEFORE_ADJECTIVE_FP = Pattern.compile("SPS00|D[^R].[FC][PN].*|V.[^NGP].*|PX.*");
    private static final Pattern GN = Pattern.compile(".*_GN_.*|<?/?N[CP].*");
    private static final Pattern EXCEPCIONS_DARRERE_DE = Pattern.compile("forma|manera|por|costat", 66);
    private static final Pattern LOCUCIONS = Pattern.compile(".*LOC.*");
    private static final Pattern PRONOM_FEBLE = Pattern.compile("P0.{6}|PP3CN000|PP3NN000|PP3CP000|PP3CSD00");
    private final Map<String, AnalyzedTokenReadings> relevantWords;
    private final Map<String, AnalyzedTokenReadings> relevantWords2;

    public AccentuationCheckRule(ResourceBundle messages) throws IOException {
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.relevantWords = this.loadWords(FILE_NAME);
        this.relevantWords2 = this.loadWords(FILE_NAME2);
    }

    public String getId() {
        return "ACCENTUATION_CHECK";
    }

    public String getDescription() {
        return "Comprova si la paraula ha de dur accent gr\u00e0fic.";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String token = i == 1 ? tokens[i].getToken().toLowerCase() : tokens[i].getToken();
            String prevToken = tokens[i - 1].getToken();
            String prevPrevToken = "";
            if (i > 2) {
                prevPrevToken = tokens[i - 2].getToken();
            }
            String nextToken = "";
            if (i < tokens.length - 1) {
                nextToken = tokens[i + 1].getToken();
            }
            String nextNextToken = "";
            if (i < tokens.length - 2) {
                nextNextToken = tokens[i + 2].getToken();
            }
            boolean isRelevantWord = false;
            boolean isRelevantWord2 = false;
            if (StringTools.isEmpty((String)token)) continue;
            if (this.relevantWords.containsKey(token)) {
                isRelevantWord = true;
            }
            if (this.relevantWords2.containsKey(token)) {
                isRelevantWord2 = true;
            }
            if (!isRelevantWord && !isRelevantWord2 || this.matchPostagRegexp(tokens[i - 1], PRONOM_FEBLE) && !prevToken.startsWith("'") && !prevToken.startsWith("-")) continue;
            String replacement = null;
            Matcher mPreposicioDE = PREPOSICIO_DE.matcher(nextToken);
            Matcher mExcepcionsDE = EXCEPCIONS_DARRERE_DE.matcher(nextNextToken);
            Matcher mArticleELMS = ARTICLE_EL_MS.matcher(prevToken);
            Matcher mArticleELFS = ARTICLE_EL_FS.matcher(prevToken);
            Matcher mArticleELMP = ARTICLE_EL_MP.matcher(prevToken);
            Matcher mArticleELFP = ARTICLE_EL_FP.matcher(prevToken);
            if (isRelevantWord && !this.matchPostagRegexp(tokens[i], GN)) {
                if (tokens[i - 1].hasPosTag("SPS00") && !tokens[i - 1].hasPosTag("RG") && !this.matchPostagRegexp(tokens[i - 1], DETERMINANT) && !this.matchPostagRegexp(tokens[i], INFINITIU)) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (this.matchPostagRegexp(tokens[i - 1], DETERMINANT_MS) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) && !token.equals("cantar") || this.matchPostagRegexp(tokens[i - 1], DETERMINANT_MP) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) || this.matchPostagRegexp(tokens[i - 1], DETERMINANT_FS) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) && !token.equals("venia") && !token.equals("tenia") && !token.equals("continua") && !token.equals("genera") && !token.equals("faria") || this.matchPostagRegexp(tokens[i - 1], DETERMINANT_FP) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP)) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (i > 2 && this.matchPostagRegexp(tokens[i - 2], VERB_CONJUGAT) && (this.matchPostagRegexp(tokens[i - 1], DETERMINANT_MS) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) || this.matchPostagRegexp(tokens[i - 1], DETERMINANT_MP) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) || this.matchPostagRegexp(tokens[i - 1], DETERMINANT_FS) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) || this.matchPostagRegexp(tokens[i - 1], DETERMINANT_FP) && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP))) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (i > 2 && this.matchPostagRegexp(tokens[i - 2], VERB_CONJUGAT) && (mArticleELMS.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) || mArticleELMP.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) || mArticleELFS.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) || mArticleELFP.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP))) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (!(this.matchPostagRegexp(tokens[i], PARTICIPI_MS) || token.equals("venia") || token.equals("venies") || token.equals("tenia") || token.equals("tenies") || token.equals("faria") || token.equals("faries") || token.equals("espero") || token.equals("continua") || token.equals("continues") || token.equals("cantar") || prevToken.equals("que") || prevToken.equals("qui") || prevToken.equals("qu\u00e8") || !mPreposicioDE.matches() || this.matchPostagRegexp(tokens[i - 1], NOT_IN_PREV_TOKEN) || this.matchPostagRegexp(tokens[i + 1], LOCUCIONS) || i >= tokens.length - 2 || this.matchPostagRegexp(tokens[i + 2], INFINITIU) || mExcepcionsDE.matches() || tokens[i - 1].hasPosTag("RG"))) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (!(token.equals("venia") || token.equals("venies") || token.equals("tenia") || token.equals("tenies") || token.equals("faria") || token.equals("faries") || token.equals("continua") || token.equals("continues") || token.equals("cantar") || token.equals("diferencia") || token.equals("diferencies") || token.equals("distancia") || token.equals("distancies") || !(mArticleELMS.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) || mArticleELFS.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) || mArticleELMP.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP)) && (!mArticleELFP.matches() || !this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP)) || !mPreposicioDE.matches())) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (!(token.equals("pronuncia") || token.equals("espero") || token.equals("pronuncies") || token.equals("venia") || token.equals("venies") || token.equals("tenia") || token.equals("tenies") || token.equals("continua") || token.equals("continues") || token.equals("faria") || token.equals("faries") || token.equals("genera") || token.equals("figuri") || i >= tokens.length - 1 || !(this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) && this.matchPostagRegexp(tokens[i + 1], ADJECTIU_MS) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) && this.matchPostagRegexp(tokens[i + 1], ADJECTIU_FS) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) && this.matchPostagRegexp(tokens[i + 1], ADJECTIU_MP)) && (!this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP) || !this.matchPostagRegexp(tokens[i + 1], ADJECTIU_FP)))) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MS) && !this.matchPostagRegexp(tokens[i], VERB_3S) && !this.matchPostagRegexp(tokens[i], GRUP_VERBAL) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FS) && !this.matchPostagRegexp(tokens[i], VERB_3S) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MP) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FP)) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (nextToken.equals("que") && i > 2 && (this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MS) && this.matchPostagRegexp(tokens[i - 2], DETERMINANT_MS) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FS) && this.matchPostagRegexp(tokens[i - 2], DETERMINANT_FS) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MP) && this.matchPostagRegexp(tokens[i - 2], DETERMINANT_MP) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FP) && this.matchPostagRegexp(tokens[i - 2], DETERMINANT_FP))) {
                    replacement = this.relevantWords.get(token).getToken();
                } else if (nextToken.equals("que") && (mArticleELMS.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) || mArticleELFS.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) || mArticleELMP.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) || mArticleELFP.matches() && this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP))) {
                    replacement = this.relevantWords.get(token).getToken();
                }
                if (!(token.equals("pronuncia") || token.equals("espero") || token.equals("pronuncies") || token.equals("venia") || token.equals("venies") || token.equals("tenia") || token.equals("tenies") || token.equals("continua") || token.equals("continues") || token.equals("faria") || token.equals("faries") || token.equals("genera") || token.equals("figuri") || i <= 2 || !tokens[i - 2].hasPosTag("SPS00") || tokens[i - 2].hasPosTag("RG") || !(this.matchPostagRegexp(this.relevantWords.get(token), NOM_MS) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MS) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_FS) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FS) || this.matchPostagRegexp(this.relevantWords.get(token), NOM_MP) && this.matchPostagRegexp(tokens[i - 1], ADJECTIU_MP)) && (!this.matchPostagRegexp(this.relevantWords.get(token), NOM_FP) || !this.matchPostagRegexp(tokens[i - 1], ADJECTIU_FP)))) {
                    replacement = this.relevantWords.get(token).getToken();
                }
            }
            if (isRelevantWord2 && !this.matchPostagRegexp(tokens[i], GN)) {
                if (this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_MS) && this.matchPostagRegexp(tokens[i - 1], NOM_MS) && !tokens[i - 1].hasPosTag("_GN_FS") && this.matchPostagRegexp(tokens[i], VERB_CONJUGAT) && !this.matchPostagRegexp(tokens[i], VERB_3S) || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_FS) && prevPrevToken.equalsIgnoreCase("de") && (prevToken.equals("manera") || prevToken.equals("forma")) || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_MP) && this.matchPostagRegexp(tokens[i - 1], NOM_MP) || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_FP) && this.matchPostagRegexp(tokens[i - 1], NOM_FP)) {
                    replacement = this.relevantWords2.get(token).getToken();
                } else if (i < tokens.length - 1 && !prevToken.equals("que") && !this.matchPostagRegexp(tokens[i - 1], NOT_IN_PREV_TOKEN) && (this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_MS) && this.matchPostagRegexp(tokens[i + 1], NOM_MS) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_MS) || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_FS) && this.matchPostagRegexp(tokens[i + 1], NOM_FS) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_FS) || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_MP) && this.matchPostagRegexp(tokens[i + 1], NOM_MP) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_MP) || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_FP) && this.matchPostagRegexp(tokens[i + 1], NOM_FP) && this.matchPostagRegexp(tokens[i - 1], BEFORE_ADJECTIVE_FP))) {
                    replacement = this.relevantWords2.get(token).getToken();
                } else if (i < tokens.length - 1 && (this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_MS) && this.matchPostagRegexp(tokens[i + 1], NOM_MS) && mArticleELMS.matches() || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_FS) && this.matchPostagRegexp(tokens[i + 1], NOM_FS) && mArticleELFS.matches() || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_MP) && this.matchPostagRegexp(tokens[i + 1], NOM_MP) && mArticleELMP.matches() || this.matchPostagRegexp(this.relevantWords2.get(token), ADJECTIU_FP) && this.matchPostagRegexp(tokens[i + 1], NOM_FP) && mArticleELFP.matches())) {
                    replacement = this.relevantWords2.get(token).getToken();
                }
            }
            if (replacement == null) continue;
            String msg = "Si \u00e9s un nom o un adjectiu, ha de portar accent.";
            RuleMatch ruleMatch = new RuleMatch((Rule)this, tokens[i].getStartPos(), tokens[i].getEndPos(), "Si \u00e9s un nom o un adjectiu, ha de portar accent.", "Falta un accent");
            ruleMatch.setSuggestedReplacement(replacement);
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private boolean matchPostagRegexp(AnalyzedTokenReadings aToken, Pattern pattern) {
        boolean matches = false;
        for (AnalyzedToken analyzedToken : aToken) {
            Matcher m;
            String posTag = analyzedToken.getPOSTag();
            if (posTag == null || !(m = pattern.matcher(posTag)).matches()) continue;
            matches = true;
            break;
        }
        return matches;
    }

    private Map<String, AnalyzedTokenReadings> loadWords(String fileName) throws IOException {
        HashMap<String, AnalyzedTokenReadings> map = new HashMap<String, AnalyzedTokenReadings>();
        InputStream inputStream = JLanguageTool.getDataBroker().getFromRulesDirAsStream(fileName);
        try (Scanner scanner = new Scanner(inputStream, FILE_ENCODING);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                String[] parts = line.split(";");
                if (parts.length != 3) {
                    throw new IOException("Format error in file " + fileName + ", line: " + line + ", " + "expected 3 semicolon-separated parts, got " + parts.length);
                }
                AnalyzedToken analyzedToken = new AnalyzedToken(parts[1], parts[2], null);
                map.put(parts[0], new AnalyzedTokenReadings(analyzedToken, 0));
            }
        }
        return map;
    }

    public void reset() {
    }
}

