/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tokenizers.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.tagging.ca.CatalanTagger;
import org.languagetool.tokenizers.WordTokenizer;

public class CatalanWordTokenizer
extends WordTokenizer {
    private static final String PF = "('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)";
    private int maxPatterns = 11;
    private Pattern[] patterns = new Pattern[this.maxPatterns];
    private CatalanTagger tagger = new CatalanTagger();
    private static final Pattern ELA_GEMINADA = Pattern.compile("([aeiou\u00e0\u00e9\u00e8\u00ed\u00f3\u00f2\u00fa\u00ef\u00fc])l[.\u2022-]l([aeiou\u00e0\u00e9\u00e8\u00ed\u00f3\u00f2\u00fa\u00ef\u00fc])", 66);
    private static final Pattern APOSTROPHE = Pattern.compile("([\\p{L}])['\u2019]([\\p{L}\"\u2018\u201c\u00ab])", 66);
    private static final Pattern APOSTROPHE_1 = Pattern.compile("([dlDL])['\u2019](\\d[\\d\\s\\.,]?)", 66);
    private static final Pattern NEARBY_HYPHENS = Pattern.compile("([\\p{L}])-([\\p{L}])-([\\p{L}])", 66);
    private static final Pattern HYPHENS = Pattern.compile("([\\p{L}])-([\\p{L}\\d])", 66);
    private static final Pattern DECIMAL_POINT = Pattern.compile("([\\d])\\.([\\d])", 66);
    private static final Pattern DECIMAL_COMMA = Pattern.compile("([\\d]),([\\d])", 66);
    private static final Pattern SPACE_DIGITS = Pattern.compile("([\\d]) ([\\d])", 66);

    public CatalanWordTokenizer() {
        this.patterns[0] = Pattern.compile("^([lnmtsd]')([^'\\-]*)$", 66);
        this.patterns[1] = Pattern.compile("^(qui-sap-lo|qui-sap-la|qui-sap-los|qui-sap-les)$", 66);
        this.patterns[2] = Pattern.compile("^([lnmtsd]')(.{2,})('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[3] = Pattern.compile("^(.{2,})('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[4] = Pattern.compile("^([lnmtsd]')(.{2,})('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[5] = Pattern.compile("^(.{2,})('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[6] = Pattern.compile("^([lnmtsd]')(.{2,})('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 66);
        this.patterns[7] = Pattern.compile("^(.+[^cbfhjkovwyzCBFHJKOVWYZ])('en|'hi|'ho|'l|'ls|'m|'n|'ns|'s|'t|-el|-els|-em|-en|-ens|-hi|-ho|-l|-la|-les|-li|-lo|-los|-m|-me|-n|-ne|-nos|-s|-se|-t|-te|-us|-vos)$", 64);
        this.patterns[8] = Pattern.compile("^([lnmtsd]')(.*)$", 66);
        this.patterns[9] = Pattern.compile("^(a|de|pe)(ls?)$", 66);
        this.patterns[10] = Pattern.compile("^(ca)(n)$", 66);
    }

    public List<String> tokenize(String text) {
        ArrayList<String> l = new ArrayList<String>();
        String auxText = text;
        Matcher matcher = ELA_GEMINADA.matcher(auxText);
        auxText = matcher.replaceAll("$1##ELA_GEMINADA##$2");
        matcher = APOSTROPHE.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_APOS##$2");
        matcher = APOSTROPHE_1.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_APOS##$2");
        matcher = NEARBY_HYPHENS.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_HYPHEN##$2##CA_HYPHEN##$3");
        matcher = HYPHENS.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_HYPHEN##$2");
        matcher = DECIMAL_POINT.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_DECIMALPOINT##$2");
        matcher = DECIMAL_COMMA.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_DECIMALCOMMA##$2");
        matcher = SPACE_DIGITS.matcher(auxText);
        auxText = matcher.replaceAll("$1##CA_SPACE##$2");
        StringTokenizer st = new StringTokenizer(auxText, " \u00a0\u115f\u1160\u1680\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u200c\u200d\u200e\u200f\u2013\u2014\u2015\u2022\u2028\u2029\u202a\u202b\u202c\u202d\u202e\u202f\u205f\u2060\u2061\u2062\u2063\u206a\u206b\u206c\u206d\u206e\u206f\u3000\u3164\ufeff\uffa0\ufff9\ufffa\ufffb,.;()[]{}<>!?:/\\\"'\u00ab\u00bb\u201e\u201d\u201c\u2018\u2019`\u00b4\u2026\u00bf\u00a1\t\n\r-", true);
        while (st.hasMoreElements()) {
            String s = st.nextToken().replace("##CA_APOS##", "'").replace("##CA_HYPHEN##", "-").replace("##CA_DECIMALPOINT##", ".").replace("##CA_DECIMALCOMMA##", ",").replace("##CA_SPACE##", " ").replace("##ELA_GEMINADA##", "l.l");
            boolean matchFound = false;
            for (int j = 0; j < this.maxPatterns && !matchFound; ++j) {
                matcher = this.patterns[j].matcher(s);
                matchFound = matcher.find();
            }
            if (matchFound) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String groupStr = matcher.group(i);
                    l.addAll(this.wordsToAdd(groupStr));
                }
                continue;
            }
            l.addAll(this.wordsToAdd(s));
        }
        return this.joinUrls(l);
    }

    private List<String> wordsToAdd(String s) {
        ArrayList<String> l = new ArrayList<String>();
        if (!s.contains("-") && !s.isEmpty()) {
            l.add(s);
        } else {
            try {
                if (this.tagger.existsWord(s)) {
                    l.add(s);
                } else {
                    StringTokenizer st2 = new StringTokenizer(s, "-", true);
                    while (st2.hasMoreElements()) {
                        l.add(st2.nextToken());
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return l;
    }
}

